(function(l, m, n) {
    (function(a) {
        if (typeof define === 'function' && define.amd) {
            define(['jquery'], a)
        } else if (jQuery && !jQuery.fn.sparkline) {
            a(jQuery)
        }
    }(function($) {
        'use strict';
        var k = {},
            getDefaults, createClass, SPFormat, clipval, quartile, normalizeValue, normalizeValues, remove, isNumber, all, sum, addCSS, ensureArray, formatNumber, RangeMap, MouseHandler, Tooltip, barHighlightMixin, line, bar, tristate, discrete, bullet, pie, box, defaultStyles, initStyles, VShape, VCanvas_base, VCanvas_canvas, VCanvas_vml, pending, shapeCount = 0;
        getDefaults = function() {
            return {
                common: {
                    type: 'line',
                    lineColor: '#00f',
                    fillColor: '#cdf',
                    defaultPixelsPerValue: 3,
                    width: 'auto',
                    height: 'auto',
                    composite: false,
                    tagValuesAttribute: 'values',
                    tagOptionsPrefix: 'spark',
                    enableTagOptions: true,
                    enableHighlight: true,
                    highlightLighten: 1.1,
                    tooltipSkipNull: true,
                    tooltipPrefix: '',
                    tooltipSuffix: '',
                    disableHiddenCheck: false,
                    numberFormatter: false,
                    numberDigitGroupCount: 3,
                    numberDigitGroupSep: ',',
                    numberDecimalMark: '.',
                    disableTooltips: false,
                    disableInteraction: false
                },
                line: {
                    spotColor: '#f80',
                    highlightSpotColor: '#5f5',
                    highlightLineColor: '#f22',
                    spotRadius: 1.5,
                    minSpotColor: '#f80',
                    maxSpotColor: '#f80',
                    lineWidth: 1,
                    normalRangeMin: n,
                    normalRangeMax: n,
                    normalRangeColor: '#ccc',
                    drawNormalOnTop: false,
                    chartRangeMin: n,
                    chartRangeMax: n,
                    chartRangeMinX: n,
                    chartRangeMaxX: n,
                    tooltipFormat: new SPFormat('<span style="color: {{color}}">&#9679;</span> {{prefix}}{{y}}{{suffix}}')
                },
                bar: {
                    barColor: '#3366cc',
                    negBarColor: '#f44',
                    stackedBarColor: ['#3366cc', '#dc3912', '#ff9900', '#109618', '#66aa00', '#dd4477', '#0099c6', '#990099'],
                    zeroColor: n,
                    nullColor: n,
                    zeroAxis: true,
                    barWidth: 4,
                    barSpacing: 1,
                    chartRangeMax: n,
                    chartRangeMin: n,
                    chartRangeClip: false,
                    colorMap: n,
                    tooltipFormat: new SPFormat('<span style="color: {{color}}">&#9679;</span> {{prefix}}{{value}}{{suffix}}')
                },
                tristate: {
                    barWidth: 4,
                    barSpacing: 1,
                    posBarColor: '#6f6',
                    negBarColor: '#f44',
                    zeroBarColor: '#999',
                    colorMap: {},
                    tooltipFormat: new SPFormat('<span style="color: {{color}}">&#9679;</span> {{value:map}}'),
                    tooltipValueLookups: {
                        map: {
                            '-1': 'Loss',
                            '0': 'Draw',
                            '1': 'Win'
                        }
                    }
                },
                discrete: {
                    lineHeight: 'auto',
                    thresholdColor: n,
                    thresholdValue: 0,
                    chartRangeMax: n,
                    chartRangeMin: n,
                    chartRangeClip: false,
                    tooltipFormat: new SPFormat('{{prefix}}{{value}}{{suffix}}')
                },
                bullet: {
                    targetColor: '#f33',
                    targetWidth: 3,
                    performanceColor: '#33f',
                    rangeColors: ['#d3dafe', '#a8b6ff', '#7f94ff'],
                    base: n,
                    tooltipFormat: new SPFormat('{{fieldkey:fields}} - {{value}}'),
                    tooltipValueLookups: {
                        fields: {
                            r: 'Range',
                            p: 'Performance',
                            t: 'Target'
                        }
                    }
                },
                pie: {
                    offset: 0,
                    sliceColors: ['#3366cc', '#dc3912', '#ff9900', '#109618', '#66aa00', '#dd4477', '#0099c6', '#990099'],
                    borderWidth: 0,
                    borderColor: '#000',
                    tooltipFormat: new SPFormat('<span style="color: {{color}}">&#9679;</span> {{value}} ({{percent.1}}%)')
                },
                box: {
                    raw: false,
                    boxLineColor: '#000',
                    boxFillColor: '#cdf',
                    whiskerColor: '#000',
                    outlierLineColor: '#333',
                    outlierFillColor: '#fff',
                    medianColor: '#f00',
                    showOutliers: true,
                    outlierIQR: 1.5,
                    spotRadius: 1.5,
                    target: n,
                    targetColor: '#4a2',
                    chartRangeMax: n,
                    chartRangeMin: n,
                    tooltipFormat: new SPFormat('{{field:fields}}: {{value}}'),
                    tooltipFormatFieldlistKey: 'field',
                    tooltipValueLookups: {
                        fields: {
                            lq: 'Lower Quartile',
                            med: 'Median',
                            uq: 'Upper Quartile',
                            lo: 'Left Outlier',
                            ro: 'Right Outlier',
                            lw: 'Left Whisker',
                            rw: 'Right Whisker'
                        }
                    }
                }
            }
        };
        defaultStyles = '.jqstooltip { ' + 'position: absolute;' + 'left: 0px;' + 'top: 0px;' + 'visibility: hidden;' + 'text-align: left;' + 'white-space: nowrap;' + 'z-index: 10000;' + '}' + '.jqsfield { ' + 'text-align: left;' + '}';
        createClass = function() {
            var a, args;
            a = function() {
                this.init.apply(this, arguments)
            };
            if (arguments.length > 1) {
                if (arguments[0]) {
                    a.prototype = $.extend(new arguments[0](), arguments[arguments.length - 1]);
                    a._super = arguments[0].prototype
                } else {
                    a.prototype = arguments[arguments.length - 1]
                }
                if (arguments.length > 2) {
                    args = Array.prototype.slice.call(arguments, 1, -1);
                    args.unshift(a.prototype);
                    $.extend.apply($, args)
                }
            } else {
                a.prototype = arguments[0]
            }
            a.prototype.cls = a;
            return a
        };
        $.SPFormatClass = SPFormat = createClass({
            fre: /\{\{([\w.]+?)(:(.+?))?\}\}/g,
            precre: /(\w+)\.(\d+)/,
            init: function(a, b) {
                this.format = a;
                this.fclass = b
            },
            render: function(b, c, d) {
                var e = this,
                    fields = b,
                    match, token, lookupkey, fieldvalue, prec;
                return this.format.replace(this.fre, function() {
                    var a;
                    token = arguments[1];
                    lookupkey = arguments[3];
                    match = e.precre.exec(token);
                    if (match) {
                        prec = match[2];
                        token = match[1]
                    } else {
                        prec = false
                    }
                    fieldvalue = fields[token];
                    if (fieldvalue === n) {
                        return ''
                    }
                    if (lookupkey && c && c[lookupkey]) {
                        a = c[lookupkey];
                        if (a.get) {
                            return c[lookupkey].get(fieldvalue) || fieldvalue
                        } else {
                            return c[lookupkey][fieldvalue] || fieldvalue
                        }
                    }
                    if (isNumber(fieldvalue)) {
                        if (d.get('numberFormatter')) {
                            fieldvalue = d.get('numberFormatter')(fieldvalue)
                        } else {
                            fieldvalue = formatNumber(fieldvalue, prec, d.get('numberDigitGroupCount'), d.get('numberDigitGroupSep'), d.get('numberDecimalMark'))
                        }
                    }
                    return fieldvalue
                })
            }
        });
        $.spformat = function(a, b) {
            return new SPFormat(a, b)
        };
        clipval = function(a, b, c) {
            if (a < b) {
                return b
            }
            if (a > c) {
                return c
            }
            return a
        };
        quartile = function(a, q) {
            var b;
            if (q === 2) {
                b = m.floor(a.length / 2);
                return a.length % 2 ? a[b] : (a[b - 1] + a[b]) / 2
            } else {
                if (a.length % 2) {
                    b = (a.length * q + q) / 4;
                    return b % 1 ? (a[m.floor(b)] + a[m.floor(b) - 1]) / 2 : a[b - 1]
                } else {
                    b = (a.length * q + 2) / 4;
                    return b % 1 ? (a[m.floor(b)] + a[m.floor(b) - 1]) / 2 : a[b - 1]
                }
            }
        };
        normalizeValue = function(a) {
            var b;
            switch (a) {
                case 'undefined':
                    a = n;
                    break;
                case 'null':
                    a = null;
                    break;
                case 'true':
                    a = true;
                    break;
                case 'false':
                    a = false;
                    break;
                default:
                    b = parseFloat(a);
                    if (a == b) {
                        a = b
                    }
            }
            return a
        };
        normalizeValues = function(a) {
            var i, result = [];
            for (i = a.length; i--;) {
                result[i] = normalizeValue(a[i])
            }
            return result
        };
        remove = function(a, b) {
            var i, vl, result = [];
            for (i = 0, vl = a.length; i < vl; i++) {
                if (a[i] !== b) {
                    result.push(a[i])
                }
            }
            return result
        };
        isNumber = function(a) {
            return !isNaN(parseFloat(a)) && isFinite(a)
        };
        formatNumber = function(a, b, c, d, e) {
            var p, i;
            a = (b === false ? parseFloat(a).toString() : a.toFixed(b)).split('');
            p = (p = $.inArray('.', a)) < 0 ? a.length : p;
            if (p < a.length) {
                a[p] = e
            }
            for (i = p - c; i > 0; i -= c) {
                a.splice(i, 0, d)
            }
            return a.join('')
        };
        all = function(a, b, c) {
            var i;
            for (i = b.length; i--;) {
                if (c && b[i] === null) continue;
                if (b[i] !== a) {
                    return false
                }
            }
            return true
        };
        sum = function(a) {
            var b = 0,
                i;
            for (i = a.length; i--;) {
                b += typeof a[i] === 'number' ? a[i] : 0
            }
            return b
        };
        ensureArray = function(a) {
            return $.isArray(a) ? a : [a]
        };
        addCSS = function(a) {
			/*
            var b;
            if (l.createStyleSheet) {
                l.createStyleSheet().cssText = a
            } else {
                b = l.createElement('style');
                b.type = 'text/css';
                l.getElementsByTagName('head')[0].appendChild(b);
                b[(typeof l.body.style.WebkitAppearance == 'string') ? 'innerText' : 'innerHTML'] = a
            }
			*/
        };
        $.fn.simpledraw = function(e, f, g, h) {
            var i, mhandler;
            if (g && (i = this.data('_jqs_vcanvas'))) {
                return i
            }
            if ($.fn.sparkline.canvas === false) {
                return false
            } else if ($.fn.sparkline.canvas === n) {
                var j = l.createElement('canvas');
                if (!!(j.getContext && j.getContext('2d'))) {
                    $.fn.sparkline.canvas = function(a, b, c, d) {
                        return new VCanvas_canvas(a, b, c, d)
                    }
                } else if (l.namespaces && !l.namespaces.v) {
                    l.namespaces.add('v', 'urn:schemas-microsoft-com:vml', '#default#VML');
                    $.fn.sparkline.canvas = function(a, b, c, d) {
                        return new VCanvas_vml(a, b, c)
                    }
                } else {
                    $.fn.sparkline.canvas = false;
                    return false
                }
            }
            if (e === n) {
                e = $(this).innerWidth()
            }
            if (f === n) {
                f = $(this).innerHeight()
            }
            i = $.fn.sparkline.canvas(e, f, this, h);
            mhandler = $(this).data('_jqs_mhandler');
            if (mhandler) {
                mhandler.registerCanvas(i)
            }
            return i
        };
        $.fn.cleardraw = function() {
            var a = this.data('_jqs_vcanvas');
            if (a) {
                a.reset()
            }
        };
        $.RangeMapClass = RangeMap = createClass({
            init: function(a) {
                var b, range, rangelist = [];
                for (b in a) {
                    if (a.hasOwnProperty(b) && typeof b === 'string' && b.indexOf(':') > -1) {
                        range = b.split(':');
                        range[0] = range[0].length === 0 ? -Infinity : parseFloat(range[0]);
                        range[1] = range[1].length === 0 ? Infinity : parseFloat(range[1]);
                        range[2] = a[b];
                        rangelist.push(range)
                    }
                }
                this.map = a;
                this.rangelist = rangelist || false
            },
            get: function(a) {
                var b = this.rangelist,
                    i, range, result;
                if ((result = this.map[a]) !== n) {
                    return result
                }
                if (b) {
                    for (i = b.length; i--;) {
                        range = b[i];
                        if (range[0] <= a && range[1] >= a) {
                            return range[2]
                        }
                    }
                }
                return n
            }
        });
        $.range_map = function(a) {
            return new RangeMap(a)
        };
        MouseHandler = createClass({
            init: function(a, b) {
                var c = $(a);
                this.$el = c;
                this.options = b;
                this.currentPageX = 0;
                this.currentPageY = 0;
                this.el = a;
                this.splist = [];
                this.tooltip = null;
                this.over = false;
                this.displayTooltips = !b.get('disableTooltips');
                this.highlightEnabled = !b.get('disableHighlight')
            },
            registerSparkline: function(a) {
                this.splist.push(a);
                if (this.over) {
                    this.updateDisplay()
                }
            },
            registerCanvas: function(a) {
                var b = $(a.canvas);
                this.canvas = a;
                this.$canvas = b;
                b.mouseenter($.proxy(this.mouseenter, this));
                b.mouseleave($.proxy(this.mouseleave, this));
                b.click($.proxy(this.mouseclick, this))
            },
            reset: function(a) {
                this.splist = [];
                if (this.tooltip && a) {
                    this.tooltip.remove();
                    this.tooltip = n
                }
            },
            mouseclick: function(e) {
                var a = $.Event('sparklineClick');
                a.originalEvent = e;
                a.sparklines = this.splist;
                this.$el.trigger(a)
            },
            mouseenter: function(e) {
                $(l.body).unbind('mousemove.jqs');
                $(l.body).bind('mousemove.jqs', $.proxy(this.mousemove, this));
                this.over = true;
                this.currentPageX = e.pageX;
                this.currentPageY = e.pageY;
                this.currentEl = e.target;
                if (!this.tooltip && this.displayTooltips) {
                    this.tooltip = new Tooltip(this.options);
                    this.tooltip.updatePosition(e.pageX, e.pageY)
                }
                this.updateDisplay()
            },
            mouseleave: function() {
                $(l.body).unbind('mousemove.jqs');
                var a = this.splist,
                    spcount = a.length,
                    needsRefresh = false,
                    sp, i;
                this.over = false;
                this.currentEl = null;
                if (this.tooltip) {
                    this.tooltip.remove();
                    this.tooltip = null
                }
                for (i = 0; i < spcount; i++) {
                    sp = a[i];
                    if (sp.clearRegionHighlight()) {
                        needsRefresh = true
                    }
                }
                if (needsRefresh) {
                    this.canvas.render()
                }
            },
            mousemove: function(e) {
                this.currentPageX = e.pageX;
                this.currentPageY = e.pageY;
                this.currentEl = e.target;
                if (this.tooltip) {
                    this.tooltip.updatePosition(e.pageX, e.pageY)
                }
                this.updateDisplay()
            },
            updateDisplay: function() {
                var a = this.splist,
                    spcount = a.length,
                    needsRefresh = false,
                    offset = this.$canvas.offset(),
                    localX = this.currentPageX - offset.left,
                    localY = this.currentPageY - offset.top,
                    tooltiphtml, sp, i, result, changeEvent;
                if (!this.over) {
                    return
                }
                for (i = 0; i < spcount; i++) {
                    sp = a[i];
                    result = sp.setRegionHighlight(this.currentEl, localX, localY);
                    if (result) {
                        needsRefresh = true
                    }
                }
                if (needsRefresh) {
                    changeEvent = $.Event('sparklineRegionChange');
                    changeEvent.sparklines = this.splist;
                    this.$el.trigger(changeEvent);
                    if (this.tooltip) {
                        tooltiphtml = '';
                        for (i = 0; i < spcount; i++) {
                            sp = a[i];
                            tooltiphtml += sp.getCurrentRegionTooltip()
                        }
                        this.tooltip.setContent(tooltiphtml)
                    }
                    if (!this.disableHighlight) {
                        this.canvas.render()
                    }
                }
                if (result === null) {
                    this.mouseleave()
                }
            }
        });
        Tooltip = createClass({
            sizeStyle: 'position: static !important;' + 'display: block !important;' + 'visibility: hidden !important;' + 'float: left !important;',
            init: function(a) {
                var b = a.get('tooltipClassname', 'jqstooltip'),
                    sizetipStyle = this.sizeStyle,
                    offset;
                this.container = a.get('tooltipContainer') || l.body;
                this.tooltipOffsetX = a.get('tooltipOffsetX', 10);
                this.tooltipOffsetY = a.get('tooltipOffsetY', 12);
                $('#jqssizetip').remove();
                $('#jqstooltip').remove();
                this.sizetip = $('<div/>', {
                    id: 'jqssizetip',
                    style: sizetipStyle,
                    'class': b
                });
                this.tooltip = $('<div/>', {
                    id: 'jqstooltip',
                    'class': b
                }).appendTo(this.container);
                offset = this.tooltip.offset();
                this.offsetLeft = offset.left;
                this.offsetTop = 0;
                this.hidden = true;
                $(window).unbind('resize.jqs scroll.jqs');
                $(window).bind('resize.jqs scroll.jqs', $.proxy(this.updateWindowDims, this));
                this.updateWindowDims()
            },
            updateWindowDims: function() {
                this.scrollTop = $(window).scrollTop();
                this.scrollLeft = $(window).scrollLeft();
                this.scrollRight = this.scrollLeft + $(window).width();
                this.updatePosition()
            },
            getSize: function(a) {
                this.sizetip.html(a).appendTo(this.container);
                this.width = this.sizetip.width() + 1;
                this.height = this.sizetip.height();
                this.sizetip.remove()
            },
            setContent: function(a) {
                if (!a) {
                    this.tooltip.css('visibility', 'hidden');
                    this.hidden = true;
                    return
                }
                this.getSize(a);
                this.tooltip.html(a).css({
                    'width': this.width,
                    'height': this.height,
                    'visibility': 'visible'
                });
                if (this.hidden) {
                    this.hidden = false;
                    this.updatePosition()
                }
            },
            updatePosition: function(x, y) {
                if (x === n) {
                    if (this.mousex === n) {
                        return
                    }
                    x = this.mousex - this.offsetLeft;
                    y = this.mousey - this.offsetTop
                } else {
                    this.mousex = x = x - this.offsetLeft;
                    this.mousey = y = y - this.offsetTop
                }
                if (!this.height || !this.width || this.hidden) {
                    return
                }
                y -= this.height + this.tooltipOffsetY;
                x += this.tooltipOffsetX;
                if (y < this.scrollTop) {
                    y = this.scrollTop
                }
                if (x < this.scrollLeft) {
                    x = this.scrollLeft
                } else if (x + this.width > this.scrollRight) {
                    x = this.scrollRight - this.width
                }
                this.tooltip.css({
                    'left': x,
                    'top': y
                })
            },
            remove: function() {
                this.tooltip.remove();
                this.sizetip.remove();
                this.sizetip = this.tooltip = n;
                $(window).unbind('resize.jqs scroll.jqs')
            }
        });
        initStyles = function() {
            addCSS(defaultStyles)
        };
        $(initStyles);
        pending = [];
        $.fn.sparkline = function(c, d) {
            return this.each(function() {
                var b = new $.fn.sparkline.options(this, d),
                    $this = $(this),
                    render, i;
                render = function() {
                    var a, width, height, tmp, mhandler, sp, vals;
                    if (c === 'html' || c === n) {
                        vals = this.getAttribute(b.get('tagValuesAttribute'));
                        if (vals === n || vals === null) {
                            vals = $this.html()
                        }
                        a = vals.replace(/(^\s*<!--)|(-->\s*$)|\s+/g, '').split(',')
                    } else {
                        a = c
                    }
                    width = b.get('width') === 'auto' ? a.length * b.get('defaultPixelsPerValue') : b.get('width');
                    if (b.get('height') === 'auto') {
                        if (!b.get('composite') || !$.data(this, '_jqs_vcanvas')) {
                            tmp = l.createElement('span');
                            tmp.innerHTML = 'a';
                            $this.html(tmp);
                            height = $(tmp).innerHeight() || $(tmp).height();
                            $(tmp).remove();
                            tmp = null
                        }
                    } else {
                        height = b.get('height')
                    }
                    if (!b.get('disableInteraction')) {
                        mhandler = $.data(this, '_jqs_mhandler');
                        if (!mhandler) {
                            mhandler = new MouseHandler(this, b);
                            $.data(this, '_jqs_mhandler', mhandler)
                        } else if (!b.get('composite')) {
                            mhandler.reset()
                        }
                    } else {
                        mhandler = false
                    }
                    if (b.get('composite') && !$.data(this, '_jqs_vcanvas')) {
                        if (!$.data(this, '_jqs_errnotify')) {
                            alert('Attempted to attach a composite sparkline to an element with no existing sparkline');
                            $.data(this, '_jqs_errnotify', true)
                        }
                        return
                    }
                    sp = new $.fn.sparkline[b.get('type')](this, a, b, width, height);
                    sp.render();
                    if (mhandler) {
                        mhandler.registerSparkline(sp)
                    }
                };
                if (($(this).html() && !b.get('disableHiddenCheck') && $(this).is(':hidden')) || !$(this).parents('body').length) {
                    if (!b.get('composite') && $.data(this, '_jqs_pending')) {
                        for (i = pending.length; i; i--) {
                            if (pending[i - 1][0] == this) {
                                pending.splice(i - 1, 1)
                            }
                        }
                    }
                    pending.push([this, render]);
                    $.data(this, '_jqs_pending', true)
                } else {
                    render.call(this)
                }
            })
        };
        $.fn.sparkline.defaults = getDefaults();
        $.sparkline_display_visible = function() {
            var a, i, pl;
            var b = [];
            for (i = 0, pl = pending.length; i < pl; i++) {
                a = pending[i][0];
                if ($(a).is(':visible') && !$(a).parents().is(':hidden')) {
                    pending[i][1].call(a);
                    $.data(pending[i][0], '_jqs_pending', false);
                    b.push(i)
                } else if (!$(a).closest('html').length && !$.data(a, '_jqs_pending')) {
                    $.data(pending[i][0], '_jqs_pending', false);
                    b.push(i)
                }
            }
            for (i = b.length; i; i--) {
                pending.splice(b[i - 1], 1)
            }
        };
        $.fn.sparkline.options = createClass({
            init: function(a, b) {
                var c, defaults, base, tagOptionType;
                this.userOptions = b = b || {};
                this.tag = a;
                this.tagValCache = {};
                defaults = $.fn.sparkline.defaults;
                base = defaults.common;
                this.tagOptionsPrefix = b.enableTagOptions && (b.tagOptionsPrefix || base.tagOptionsPrefix);
                tagOptionType = this.getTagSetting('type');
                if (tagOptionType === k) {
                    c = defaults[b.type || base.type]
                } else {
                    c = defaults[tagOptionType]
                }
                this.mergedOptions = $.extend({}, base, c, b)
            },
            getTagSetting: function(a) {
                var b = this.tagOptionsPrefix,
                    val, i, pairs, keyval;
                if (b === false || b === n) {
                    return k
                }
                if (this.tagValCache.hasOwnProperty(a)) {
                    val = this.tagValCache.key
                } else {
                    val = this.tag.getAttribute(b + a);
                    if (val === n || val === null) {
                        val = k
                    } else if (val.substr(0, 1) === '[') {
                        val = val.substr(1, val.length - 2).split(',');
                        for (i = val.length; i--;) {
                            val[i] = normalizeValue(val[i].replace(/(^\s*)|(\s*$)/g, ''))
                        }
                    } else if (val.substr(0, 1) === '{') {
                        pairs = val.substr(1, val.length - 2).split(',');
                        val = {};
                        for (i = pairs.length; i--;) {
                            keyval = pairs[i].split(':', 2);
                            val[keyval[0].replace(/(^\s*)|(\s*$)/g, '')] = normalizeValue(keyval[1].replace(/(^\s*)|(\s*$)/g, ''))
                        }
                    } else {
                        val = normalizeValue(val)
                    }
                    this.tagValCache.key = val
                }
                return val
            },
            get: function(a, b) {
                var c = this.getTagSetting(a),
                    result;
                if (c !== k) {
                    return c
                }
                return (result = this.mergedOptions[a]) === n ? b : result
            }
        });
        $.fn.sparkline._base = createClass({
            disabled: false,
            init: function(a, b, c, d, e) {
                this.el = a;
                this.$el = $(a);
                this.values = b;
                this.options = c;
                this.width = d;
                this.height = e;
                this.currentRegion = n
            },
            initTarget: function() {
                var a = !this.options.get('disableInteraction');
                if (!(this.target = this.$el.simpledraw(this.width, this.height, this.options.get('composite'), a))) {
                    this.disabled = true
                } else {
                    this.canvasWidth = this.target.pixelWidth;
                    this.canvasHeight = this.target.pixelHeight
                }
            },
            render: function() {
                if (this.disabled) {
                    this.el.innerHTML = '';
                    return false
                }
                return true
            },
            getRegion: function(x, y) {},
            setRegionHighlight: function(a, x, y) {
                var b = this.currentRegion,
                    highlightEnabled = !this.options.get('disableHighlight'),
                    newRegion;
                if (x > this.canvasWidth || y > this.canvasHeight || x < 0 || y < 0) {
                    return null
                }
                newRegion = this.getRegion(a, x, y);
                if (b !== newRegion) {
                    if (b !== n && highlightEnabled) {
                        this.removeHighlight()
                    }
                    this.currentRegion = newRegion;
                    if (newRegion !== n && highlightEnabled) {
                        this.renderHighlight()
                    }
                    return true
                }
                return false
            },
            clearRegionHighlight: function() {
                if (this.currentRegion !== n) {
                    this.removeHighlight();
                    this.currentRegion = n;
                    return true
                }
                return false
            },
            renderHighlight: function() {
                this.changeHighlight(true)
            },
            removeHighlight: function() {
                this.changeHighlight(false)
            },
            changeHighlight: function(a) {},
            getCurrentRegionTooltip: function() {
                var a = this.options,
                    header = '',
                    entries = [],
                    fields, formats, formatlen, fclass, text, i, showFields, showFieldsKey, newFields, fv, formatter, format, fieldlen, j;
                if (this.currentRegion === n) {
                    return ''
                }
                fields = this.getCurrentRegionFields();
                formatter = a.get('tooltipFormatter');
                if (formatter) {
                    return formatter(this, a, fields)
                }
                if (a.get('tooltipChartTitle')) {
                    header += '<div class="jqs jqstitle">' + a.get('tooltipChartTitle') + '</div>\n'
                }
                formats = this.options.get('tooltipFormat');
                if (!formats) {
                    return ''
                }
                if (!$.isArray(formats)) {
                    formats = [formats]
                }
                if (!$.isArray(fields)) {
                    fields = [fields]
                }
                showFields = this.options.get('tooltipFormatFieldlist');
                showFieldsKey = this.options.get('tooltipFormatFieldlistKey');
                if (showFields && showFieldsKey) {
                    newFields = [];
                    for (i = fields.length; i--;) {
                        fv = fields[i][showFieldsKey];
                        if ((j = $.inArray(fv, showFields)) != -1) {
                            newFields[j] = fields[i]
                        }
                    }
                    fields = newFields
                }
                formatlen = formats.length;
                fieldlen = fields.length;
                for (i = 0; i < formatlen; i++) {
                    format = formats[i];
                    if (typeof format === 'string') {
                        format = new SPFormat(format)
                    }
                    fclass = format.fclass || 'jqsfield';
                    for (j = 0; j < fieldlen; j++) {
                        if (!fields[j].isNull || !a.get('tooltipSkipNull')) {
                            $.extend(fields[j], {
                                prefix: a.get('tooltipPrefix'),
                                suffix: a.get('tooltipSuffix')
                            });
                            text = format.render(fields[j], a.get('tooltipValueLookups'), a);
                            entries.push('<div class="' + fclass + '">' + text + '</div>')
                        }
                    }
                }
                if (entries.length) {
                    return header + entries.join('\n')
                }
                return ''
            },
            getCurrentRegionFields: function() {},
            calcHighlightColor: function(a, b) {
                var c = b.get('highlightColor'),
                    lighten = b.get('highlightLighten'),
                    parse, mult, rgbnew, i;
                if (c) {
                    return c
                }
                if (lighten) {
                    parse = /^#([0-9a-f])([0-9a-f])([0-9a-f])$/i.exec(a) || /^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i.exec(a);
                    if (parse) {
                        rgbnew = [];
                        mult = a.length === 4 ? 16 : 1;
                        for (i = 0; i < 3; i++) {
                            rgbnew[i] = clipval(m.round(parseInt(parse[i + 1], 16) * mult * lighten), 0, 255)
                        }
                        return 'rgb(' + rgbnew.join(',') + ')'
                    }
                }
                return a
            }
        });
        barHighlightMixin = {
            changeHighlight: function(b) {
                var c = this.currentRegion,
                    target = this.target,
                    shapeids = this.regionShapes[c],
                    newShapes;
                if (shapeids) {
                    newShapes = this.renderRegion(c, b);
                    if ($.isArray(newShapes) || $.isArray(shapeids)) {
                        target.replaceWithShapes(shapeids, newShapes);
                        this.regionShapes[c] = $.map(newShapes, function(a) {
                            return a.id
                        })
                    } else {
                        target.replaceWithShape(shapeids, newShapes);
                        this.regionShapes[c] = newShapes.id
                    }
                }
            },
            render: function() {
                var a = this.values,
                    target = this.target,
                    regionShapes = this.regionShapes,
                    shapes, ids, i, j;
                if (!this.cls._super.render.call(this)) {
                    return
                }
                for (i = a.length; i--;) {
                    shapes = this.renderRegion(i);
                    if (shapes) {
                        if ($.isArray(shapes)) {
                            ids = [];
                            for (j = shapes.length; j--;) {
                                shapes[j].append();
                                ids.push(shapes[j].id)
                            }
                            regionShapes[i] = ids
                        } else {
                            shapes.append();
                            regionShapes[i] = shapes.id
                        }
                    } else {
                        regionShapes[i] = null
                    }
                }
                target.render()
            }
        };
        $.fn.sparkline.line = line = createClass($.fn.sparkline._base, {
            type: 'line',
            init: function(a, b, c, d, e) {
                line._super.init.call(this, a, b, c, d, e);
                this.vertices = [];
                this.regionMap = [];
                this.xvalues = [];
                this.yvalues = [];
                this.yminmax = [];
                this.hightlightSpotId = null;
                this.lastShapeId = null;
                this.initTarget()
            },
            getRegion: function(a, x, y) {
                var i, regionMap = this.regionMap;
                for (i = regionMap.length; i--;) {
                    if (regionMap[i] !== null && x >= regionMap[i][0] && x <= regionMap[i][1]) {
                        return regionMap[i][2]
                    }
                }
                return n
            },
            getCurrentRegionFields: function() {
                var a = this.currentRegion;
                return {
                    isNull: this.yvalues[a] === null,
                    x: this.xvalues[a],
                    y: this.yvalues[a],
                    color: this.options.get('lineColor'),
                    fillColor: this.options.get('fillColor'),
                    offset: a
                }
            },
            renderHighlight: function() {
                var a = this.currentRegion,
                    target = this.target,
                    vertex = this.vertices[a],
                    options = this.options,
                    spotRadius = options.get('spotRadius'),
                    highlightSpotColor = options.get('highlightSpotColor'),
                    highlightLineColor = options.get('highlightLineColor'),
                    highlightSpot, highlightLine;
                if (!vertex) {
                    return
                }
                if (spotRadius && highlightSpotColor) {
                    highlightSpot = target.drawCircle(vertex[0], vertex[1], spotRadius, n, highlightSpotColor);
                    this.highlightSpotId = highlightSpot.id;
                    target.insertAfterShape(this.lastShapeId, highlightSpot)
                }
                if (highlightLineColor) {
                    highlightLine = target.drawLine(vertex[0], this.canvasTop, vertex[0], this.canvasTop + this.canvasHeight, highlightLineColor);
                    this.highlightLineId = highlightLine.id;
                    target.insertAfterShape(this.lastShapeId, highlightLine)
                }
            },
            removeHighlight: function() {
                var a = this.target;
                if (this.highlightSpotId) {
                    a.removeShapeId(this.highlightSpotId);
                    this.highlightSpotId = null
                }
                if (this.highlightLineId) {
                    a.removeShapeId(this.highlightLineId);
                    this.highlightLineId = null
                }
            },
            scanValues: function() {
                var a = this.values,
                    valcount = a.length,
                    xvalues = this.xvalues,
                    yvalues = this.yvalues,
                    yminmax = this.yminmax,
                    i, val, isStr, isArray, sp;
                for (i = 0; i < valcount; i++) {
                    val = a[i];
                    isStr = typeof(a[i]) === 'string';
                    isArray = typeof(a[i]) === 'object' && a[i] instanceof Array;
                    sp = isStr && a[i].split(':');
                    if (isStr && sp.length === 2) {
                        xvalues.push(Number(sp[0]));
                        yvalues.push(Number(sp[1]));
                        yminmax.push(Number(sp[1]))
                    } else if (isArray) {
                        xvalues.push(val[0]);
                        yvalues.push(val[1]);
                        yminmax.push(val[1])
                    } else {
                        xvalues.push(i);
                        if (a[i] === null || a[i] === 'null') {
                            yvalues.push(null)
                        } else {
                            yvalues.push(Number(val));
                            yminmax.push(Number(val))
                        }
                    }
                }
                if (this.options.get('xvalues')) {
                    xvalues = this.options.get('xvalues')
                }
                this.maxy = this.maxyorg = m.max.apply(m, yminmax);
                this.miny = this.minyorg = m.min.apply(m, yminmax);
                this.maxx = m.max.apply(m, xvalues);
                this.minx = m.min.apply(m, xvalues);
                this.xvalues = xvalues;
                this.yvalues = yvalues;
                this.yminmax = yminmax
            },
            processRangeOptions: function() {
                var a = this.options,
                    normalRangeMin = a.get('normalRangeMin'),
                    normalRangeMax = a.get('normalRangeMax');
                if (normalRangeMin !== n) {
                    if (normalRangeMin < this.miny) {
                        this.miny = normalRangeMin
                    }
                    if (normalRangeMax > this.maxy) {
                        this.maxy = normalRangeMax
                    }
                }
                if (a.get('chartRangeMin') !== n && (a.get('chartRangeClip') || a.get('chartRangeMin') < this.miny)) {
                    this.miny = a.get('chartRangeMin')
                }
                if (a.get('chartRangeMax') !== n && (a.get('chartRangeClip') || a.get('chartRangeMax') > this.maxy)) {
                    this.maxy = a.get('chartRangeMax')
                }
                if (a.get('chartRangeMinX') !== n && (a.get('chartRangeClipX') || a.get('chartRangeMinX') < this.minx)) {
                    this.minx = a.get('chartRangeMinX')
                }
                if (a.get('chartRangeMaxX') !== n && (a.get('chartRangeClipX') || a.get('chartRangeMaxX') > this.maxx)) {
                    this.maxx = a.get('chartRangeMaxX')
                }
            },
            drawNormalRange: function(a, b, c, d, e) {
                var f = this.options.get('normalRangeMin'),
                    normalRangeMax = this.options.get('normalRangeMax'),
                    ytop = b + m.round(c - (c * ((normalRangeMax - this.miny) / e))),
                    height = m.round((c * (normalRangeMax - f)) / e);
                this.target.drawRect(a, ytop, d, height, n, this.options.get('normalRangeColor')).append()
            },
            render: function() {
                var a = this.options,
                    target = this.target,
                    canvasWidth = this.canvasWidth,
                    canvasHeight = this.canvasHeight,
                    vertices = this.vertices,
                    spotRadius = a.get('spotRadius'),
                    regionMap = this.regionMap,
                    rangex, rangey, yvallast, canvasTop, canvasLeft, vertex, path, paths, x, y, xnext, xpos, xposnext, last, next, yvalcount, lineShapes, fillShapes, plen, valueSpots, hlSpotsEnabled, color, xvalues, yvalues, i;
                if (!line._super.render.call(this)) {
                    return
                }
                this.scanValues();
                this.processRangeOptions();
                xvalues = this.xvalues;
                yvalues = this.yvalues;
                if (!this.yminmax.length || this.yvalues.length < 2) {
                    return
                }
                canvasTop = canvasLeft = 0;
                rangex = this.maxx - this.minx === 0 ? 1 : this.maxx - this.minx;
                rangey = this.maxy - this.miny === 0 ? 1 : this.maxy - this.miny;
                yvallast = this.yvalues.length - 1;
                if (spotRadius && (canvasWidth < (spotRadius * 4) || canvasHeight < (spotRadius * 4))) {
                    spotRadius = 0
                }
                if (spotRadius) {
                    hlSpotsEnabled = a.get('highlightSpotColor') && !a.get('disableInteraction');
                    if (hlSpotsEnabled || a.get('minSpotColor') || (a.get('spotColor') && yvalues[yvallast] === this.miny)) {
                        canvasHeight -= m.ceil(spotRadius)
                    }
                    if (hlSpotsEnabled || a.get('maxSpotColor') || (a.get('spotColor') && yvalues[yvallast] === this.maxy)) {
                        canvasHeight -= m.ceil(spotRadius);
                        canvasTop += m.ceil(spotRadius)
                    }
                    if (hlSpotsEnabled || ((a.get('minSpotColor') || a.get('maxSpotColor')) && (yvalues[0] === this.miny || yvalues[0] === this.maxy))) {
                        canvasLeft += m.ceil(spotRadius);
                        canvasWidth -= m.ceil(spotRadius)
                    }
                    if (hlSpotsEnabled || a.get('spotColor') || (a.get('minSpotColor') || a.get('maxSpotColor') && (yvalues[yvallast] === this.miny || yvalues[yvallast] === this.maxy))) {
                        canvasWidth -= m.ceil(spotRadius)
                    }
                }
                canvasHeight--;
                if (a.get('normalRangeMin') !== n && !a.get('drawNormalOnTop')) {
                    this.drawNormalRange(canvasLeft, canvasTop, canvasHeight, canvasWidth, rangey)
                }
                path = [];
                paths = [path];
                last = next = null;
                yvalcount = yvalues.length;
                for (i = 0; i < yvalcount; i++) {
                    x = xvalues[i];
                    xnext = xvalues[i + 1];
                    y = yvalues[i];
                    xpos = canvasLeft + m.round((x - this.minx) * (canvasWidth / rangex));
                    xposnext = i < yvalcount - 1 ? canvasLeft + m.round((xnext - this.minx) * (canvasWidth / rangex)) : canvasWidth;
                    next = xpos + ((xposnext - xpos) / 2);
                    regionMap[i] = [last || 0, next, i];
                    last = next;
                    if (y === null) {
                        if (i) {
                            if (yvalues[i - 1] !== null) {
                                path = [];
                                paths.push(path)
                            }
                            vertices.push(null)
                        }
                    } else {
                        if (y < this.miny) {
                            y = this.miny
                        }
                        if (y > this.maxy) {
                            y = this.maxy
                        }
                        if (!path.length) {
                            path.push([xpos, canvasTop + canvasHeight])
                        }
                        vertex = [xpos, canvasTop + m.round(canvasHeight - (canvasHeight * ((y - this.miny) / rangey)))];
                        path.push(vertex);
                        vertices.push(vertex)
                    }
                }
                lineShapes = [];
                fillShapes = [];
                plen = paths.length;
                for (i = 0; i < plen; i++) {
                    path = paths[i];
                    if (path.length) {
                        if (a.get('fillColor')) {
                            path.push([path[path.length - 1][0], (canvasTop + canvasHeight)]);
                            fillShapes.push(path.slice(0));
                            path.pop()
                        }
                        if (path.length > 2) {
                            path[0] = [path[0][0], path[1][1]]
                        }
                        lineShapes.push(path)
                    }
                }
                plen = fillShapes.length;
                for (i = 0; i < plen; i++) {
                    target.drawShape(fillShapes[i], a.get('fillColor'), a.get('fillColor')).append()
                }
                if (a.get('normalRangeMin') !== n && a.get('drawNormalOnTop')) {
                    this.drawNormalRange(canvasLeft, canvasTop, canvasHeight, canvasWidth, rangey)
                }
                plen = lineShapes.length;
                for (i = 0; i < plen; i++) {
                    target.drawShape(lineShapes[i], a.get('lineColor'), n, a.get('lineWidth')).append()
                }
                if (spotRadius && a.get('valueSpots')) {
                    valueSpots = a.get('valueSpots');
                    if (valueSpots.get === n) {
                        valueSpots = new RangeMap(valueSpots)
                    }
                    for (i = 0; i < yvalcount; i++) {
                        color = valueSpots.get(yvalues[i]);
                        if (color) {
                            target.drawCircle(canvasLeft + m.round((xvalues[i] - this.minx) * (canvasWidth / rangex)), canvasTop + m.round(canvasHeight - (canvasHeight * ((yvalues[i] - this.miny) / rangey))), spotRadius, n, color).append()
                        }
                    }
                }
                if (spotRadius && a.get('spotColor') && yvalues[yvallast] !== null) {
                    target.drawCircle(canvasLeft + m.round((xvalues[xvalues.length - 1] - this.minx) * (canvasWidth / rangex)), canvasTop + m.round(canvasHeight - (canvasHeight * ((yvalues[yvallast] - this.miny) / rangey))), spotRadius, n, a.get('spotColor')).append()
                }
                if (this.maxy !== this.minyorg) {
                    if (spotRadius && a.get('minSpotColor')) {
                        x = xvalues[$.inArray(this.minyorg, yvalues)];
                        target.drawCircle(canvasLeft + m.round((x - this.minx) * (canvasWidth / rangex)), canvasTop + m.round(canvasHeight - (canvasHeight * ((this.minyorg - this.miny) / rangey))), spotRadius, n, a.get('minSpotColor')).append()
                    }
                    if (spotRadius && a.get('maxSpotColor')) {
                        x = xvalues[$.inArray(this.maxyorg, yvalues)];
                        target.drawCircle(canvasLeft + m.round((x - this.minx) * (canvasWidth / rangex)), canvasTop + m.round(canvasHeight - (canvasHeight * ((this.maxyorg - this.miny) / rangey))), spotRadius, n, a.get('maxSpotColor')).append()
                    }
                }
                this.lastShapeId = target.getLastShapeId();
                this.canvasTop = canvasTop;
                target.render()
            }
        });
        $.fn.sparkline.bar = bar = createClass($.fn.sparkline._base, barHighlightMixin, {
            type: 'bar',
            init: function(a, b, c, d, e) {
                var f = parseInt(c.get('barWidth'), 10),
                    barSpacing = parseInt(c.get('barSpacing'), 10),
                    chartRangeMin = c.get('chartRangeMin'),
                    chartRangeMax = c.get('chartRangeMax'),
                    chartRangeClip = c.get('chartRangeClip'),
                    stackMin = Infinity,
                    stackMax = -Infinity,
                    isStackString, groupMin, groupMax, stackRanges, numValues, i, vlen, range, zeroAxis, xaxisOffset, min, max, clipMin, clipMax, stacked, vlist, j, slen, svals, val, yoffset, yMaxCalc, canvasHeightEf;
                bar._super.init.call(this, a, b, c, d, e);
                for (i = 0, vlen = b.length; i < vlen; i++) {
                    val = b[i];
                    isStackString = typeof(val) === 'string' && val.indexOf(':') > -1;
                    if (isStackString || $.isArray(val)) {
                        stacked = true;
                        if (isStackString) {
                            val = b[i] = normalizeValues(val.split(':'))
                        }
                        val = remove(val, null);
                        groupMin = m.min.apply(m, val);
                        groupMax = m.max.apply(m, val);
                        if (groupMin < stackMin) {
                            stackMin = groupMin
                        }
                        if (groupMax > stackMax) {
                            stackMax = groupMax
                        }
                    }
                }
                this.stacked = stacked;
                this.regionShapes = {};
                this.barWidth = f;
                this.barSpacing = barSpacing;
                this.totalBarWidth = f + barSpacing;
                this.width = d = (b.length * f) + ((b.length - 1) * barSpacing);
                this.initTarget();
                if (chartRangeClip) {
                    clipMin = chartRangeMin === n ? -Infinity : chartRangeMin;
                    clipMax = chartRangeMax === n ? Infinity : chartRangeMax
                }
                numValues = [];
                stackRanges = stacked ? [] : numValues;
                var g = [];
                var h = [];
                for (i = 0, vlen = b.length; i < vlen; i++) {
                    if (stacked) {
                        vlist = b[i];
                        b[i] = svals = [];
                        g[i] = 0;
                        stackRanges[i] = h[i] = 0;
                        for (j = 0, slen = vlist.length; j < slen; j++) {
                            val = svals[j] = chartRangeClip ? clipval(vlist[j], clipMin, clipMax) : vlist[j];
                            if (val !== null) {
                                if (val > 0) {
                                    g[i] += val
                                }
                                if (stackMin < 0 && stackMax > 0) {
                                    if (val < 0) {
                                        h[i] += m.abs(val)
                                    } else {
                                        stackRanges[i] += val
                                    }
                                } else {
                                    stackRanges[i] += m.abs(val - (val < 0 ? stackMax : stackMin))
                                }
                                numValues.push(val)
                            }
                        }
                    } else {
                        val = chartRangeClip ? clipval(b[i], clipMin, clipMax) : b[i];
                        val = b[i] = normalizeValue(val);
                        if (val !== null) {
                            numValues.push(val)
                        }
                    }
                }
                this.max = max = m.max.apply(m, numValues);
                this.min = min = m.min.apply(m, numValues);
                this.stackMax = stackMax = stacked ? m.max.apply(m, g) : max;
                this.stackMin = stackMin = stacked ? m.min.apply(m, numValues) : min;
                if (c.get('chartRangeMin') !== n && (c.get('chartRangeClip') || c.get('chartRangeMin') < min)) {
                    min = c.get('chartRangeMin')
                }
                if (c.get('chartRangeMax') !== n && (c.get('chartRangeClip') || c.get('chartRangeMax') > max)) {
                    max = c.get('chartRangeMax')
                }
                this.zeroAxis = zeroAxis = c.get('zeroAxis', true);
                if (min <= 0 && max >= 0 && zeroAxis) {
                    xaxisOffset = 0
                } else if (zeroAxis == false) {
                    xaxisOffset = min
                } else if (min > 0) {
                    xaxisOffset = min
                } else {
                    xaxisOffset = max
                }
                this.xaxisOffset = xaxisOffset;
                range = stacked ? (m.max.apply(m, stackRanges) + m.max.apply(m, h)) : max - min;
                this.canvasHeightEf = (zeroAxis && min < 0) ? this.canvasHeight - 2 : this.canvasHeight - 1;
                if (min < xaxisOffset) {
                    yMaxCalc = (stacked && max >= 0) ? stackMax : max;
                    yoffset = (yMaxCalc - xaxisOffset) / range * this.canvasHeight;
                    if (yoffset !== m.ceil(yoffset)) {
                        this.canvasHeightEf -= 2;
                        yoffset = m.ceil(yoffset)
                    }
                } else {
                    yoffset = this.canvasHeight
                }
                this.yoffset = yoffset;
                if ($.isArray(c.get('colorMap'))) {
                    this.colorMapByIndex = c.get('colorMap');
                    this.colorMapByValue = null
                } else {
                    this.colorMapByIndex = null;
                    this.colorMapByValue = c.get('colorMap');
                    if (this.colorMapByValue && this.colorMapByValue.get === n) {
                        this.colorMapByValue = new RangeMap(this.colorMapByValue)
                    }
                }
                this.range = range
            },
            getRegion: function(a, x, y) {
                var b = m.floor(x / this.totalBarWidth);
                return (b < 0 || b >= this.values.length) ? n : b
            },
            getCurrentRegionFields: function() {
                var a = this.currentRegion,
                    values = ensureArray(this.values[a]),
                    result = [],
                    value, i;
                for (i = values.length; i--;) {
                    value = values[i];
                    result.push({
                        isNull: value === null,
                        value: value,
                        color: this.calcColor(i, value, a),
                        offset: a
                    })
                }
                return result
            },
            calcColor: function(a, b, c) {
                var d = this.colorMapByIndex,
                    colorMapByValue = this.colorMapByValue,
                    options = this.options,
                    color, newColor;
                if (this.stacked) {
                    color = options.get('stackedBarColor')
                } else {
                    color = (b < 0) ? options.get('negBarColor') : options.get('barColor')
                }
                if (b === 0 && options.get('zeroColor') !== n) {
                    color = options.get('zeroColor')
                }
                if (colorMapByValue && (newColor = colorMapByValue.get(b))) {
                    color = newColor
                } else if (d && d.length > c) {
                    color = d[c]
                }
                return $.isArray(color) ? color[a % color.length] : color
            },
            renderRegion: function(a, b) {
                var c = this.values[a],
                    options = this.options,
                    xaxisOffset = this.xaxisOffset,
                    result = [],
                    range = this.range,
                    stacked = this.stacked,
                    target = this.target,
                    x = a * this.totalBarWidth,
                    canvasHeightEf = this.canvasHeightEf,
                    yoffset = this.yoffset,
                    y, height, color, isNull, yoffsetNeg, i, valcount, val, minPlotted, allMin;
                c = $.isArray(c) ? c : [c];
                valcount = c.length;
                val = c[0];
                isNull = all(null, c);
                allMin = all(xaxisOffset, c, true);
                if (isNull) {
                    if (options.get('nullColor')) {
                        color = b ? options.get('nullColor') : this.calcHighlightColor(options.get('nullColor'), options);
                        y = (yoffset > 0) ? yoffset - 1 : yoffset;
                        return target.drawRect(x, y, this.barWidth - 1, 0, color, color)
                    } else {
                        return n
                    }
                }
                yoffsetNeg = yoffset;
                for (i = 0; i < valcount; i++) {
                    val = c[i];
                    if (stacked && val === xaxisOffset) {
                        if (!allMin || minPlotted) {
                            continue
                        }
                        minPlotted = true
                    }
                    if (range > 0) {
                        height = m.floor(canvasHeightEf * ((m.abs(val - xaxisOffset) / range))) + 1
                    } else {
                        height = 1
                    }
                    if (val < xaxisOffset || (val === xaxisOffset && yoffset === 0)) {
                        y = yoffsetNeg;
                        yoffsetNeg += height
                    } else {
                        y = yoffset - height;
                        yoffset -= height
                    }
                    color = this.calcColor(i, val, a);
                    if (b) {
                        color = this.calcHighlightColor(color, options)
                    }
                    result.push(target.drawRect(x, y, this.barWidth - 1, height - 1, color, color))
                }
                if (result.length === 1) {
                    return result[0]
                }
                return result
            }
        });
        $.fn.sparkline.tristate = tristate = createClass($.fn.sparkline._base, barHighlightMixin, {
            type: 'tristate',
            init: function(a, b, c, d, e) {
                var f = parseInt(c.get('barWidth'), 10),
                    barSpacing = parseInt(c.get('barSpacing'), 10);
                tristate._super.init.call(this, a, b, c, d, e);
                this.regionShapes = {};
                this.barWidth = f;
                this.barSpacing = barSpacing;
                this.totalBarWidth = f + barSpacing;
                this.values = $.map(b, Number);
                this.width = d = (b.length * f) + ((b.length - 1) * barSpacing);
                if ($.isArray(c.get('colorMap'))) {
                    this.colorMapByIndex = c.get('colorMap');
                    this.colorMapByValue = null
                } else {
                    this.colorMapByIndex = null;
                    this.colorMapByValue = c.get('colorMap');
                    if (this.colorMapByValue && this.colorMapByValue.get === n) {
                        this.colorMapByValue = new RangeMap(this.colorMapByValue)
                    }
                }
                this.initTarget()
            },
            getRegion: function(a, x, y) {
                return m.floor(x / this.totalBarWidth)
            },
            getCurrentRegionFields: function() {
                var a = this.currentRegion;
                return {
                    isNull: this.values[a] === n,
                    value: this.values[a],
                    color: this.calcColor(this.values[a], a),
                    offset: a
                }
            },
            calcColor: function(a, b) {
                var c = this.values,
                    options = this.options,
                    colorMapByIndex = this.colorMapByIndex,
                    colorMapByValue = this.colorMapByValue,
                    color, newColor;
                if (colorMapByValue && (newColor = colorMapByValue.get(a))) {
                    color = newColor
                } else if (colorMapByIndex && colorMapByIndex.length > b) {
                    color = colorMapByIndex[b]
                } else if (c[b] < 0) {
                    color = options.get('negBarColor')
                } else if (c[b] > 0) {
                    color = options.get('posBarColor')
                } else {
                    color = options.get('zeroBarColor')
                }
                return color
            },
            renderRegion: function(a, b) {
                var c = this.values,
                    options = this.options,
                    target = this.target,
                    canvasHeight, height, halfHeight, x, y, color;
                canvasHeight = target.pixelHeight;
                halfHeight = m.round(canvasHeight / 2);
                x = a * this.totalBarWidth;
                if (c[a] < 0) {
                    y = halfHeight;
                    height = halfHeight - 1
                } else if (c[a] > 0) {
                    y = 0;
                    height = halfHeight - 1
                } else {
                    y = halfHeight - 1;
                    height = 2
                }
                color = this.calcColor(c[a], a);
                if (color === null) {
                    return
                }
                if (b) {
                    color = this.calcHighlightColor(color, options)
                }
                return target.drawRect(x, y, this.barWidth - 1, height - 1, color, color)
            }
        });
        $.fn.sparkline.discrete = discrete = createClass($.fn.sparkline._base, barHighlightMixin, {
            type: 'discrete',
            init: function(a, b, c, d, e) {
                discrete._super.init.call(this, a, b, c, d, e);
                this.regionShapes = {};
                this.values = b = $.map(b, Number);
                this.min = m.min.apply(m, b);
                this.max = m.max.apply(m, b);
                this.range = this.max - this.min;
                this.width = d = c.get('width') === 'auto' ? b.length * 2 : this.width;
                this.interval = m.floor(d / b.length);
                this.itemWidth = d / b.length;
                if (c.get('chartRangeMin') !== n && (c.get('chartRangeClip') || c.get('chartRangeMin') < this.min)) {
                    this.min = c.get('chartRangeMin')
                }
                if (c.get('chartRangeMax') !== n && (c.get('chartRangeClip') || c.get('chartRangeMax') > this.max)) {
                    this.max = c.get('chartRangeMax')
                }
                this.initTarget();
                if (this.target) {
                    this.lineHeight = c.get('lineHeight') === 'auto' ? m.round(this.canvasHeight * 0.3) : c.get('lineHeight')
                }
            },
            getRegion: function(a, x, y) {
                return m.floor(x / this.itemWidth)
            },
            getCurrentRegionFields: function() {
                var a = this.currentRegion;
                return {
                    isNull: this.values[a] === n,
                    value: this.values[a],
                    offset: a
                }
            },
            renderRegion: function(a, b) {
                var c = this.values,
                    options = this.options,
                    min = this.min,
                    max = this.max,
                    range = this.range,
                    interval = this.interval,
                    target = this.target,
                    canvasHeight = this.canvasHeight,
                    lineHeight = this.lineHeight,
                    pheight = canvasHeight - lineHeight,
                    ytop, val, color, x;
                val = clipval(c[a], min, max);
                x = a * interval;
                ytop = m.round(pheight - pheight * ((val - min) / range));
                color = (options.get('thresholdColor') && val < options.get('thresholdValue')) ? options.get('thresholdColor') : options.get('lineColor');
                if (b) {
                    color = this.calcHighlightColor(color, options)
                }
                return target.drawLine(x, ytop, x, ytop + lineHeight, color)
            }
        });
        $.fn.sparkline.bullet = bullet = createClass($.fn.sparkline._base, {
            type: 'bullet',
            init: function(a, b, c, d, e) {
                var f, max, vals;
                bullet._super.init.call(this, a, b, c, d, e);
                this.values = b = normalizeValues(b);
                vals = b.slice();
                vals[0] = vals[0] === null ? vals[2] : vals[0];
                vals[1] = b[1] === null ? vals[2] : vals[1];
                f = m.min.apply(m, b);
                max = m.max.apply(m, b);
                if (c.get('base') === n) {
                    f = f < 0 ? f : 0
                } else {
                    f = c.get('base')
                }
                this.min = f;
                this.max = max;
                this.range = max - f;
                this.shapes = {};
                this.valueShapes = {};
                this.regiondata = {};
                this.width = d = c.get('width') === 'auto' ? '4.0em' : d;
                this.target = this.$el.simpledraw(d, e, c.get('composite'));
                if (!b.length) {
                    this.disabled = true
                }
                this.initTarget()
            },
            getRegion: function(a, x, y) {
                var b = this.target.getShapeAt(a, x, y);
                return (b !== n && this.shapes[b] !== n) ? this.shapes[b] : n
            },
            getCurrentRegionFields: function() {
                var a = this.currentRegion;
                return {
                    fieldkey: a.substr(0, 1),
                    value: this.values[a.substr(1)],
                    region: a
                }
            },
            changeHighlight: function(a) {
                var b = this.currentRegion,
                    shapeid = this.valueShapes[b],
                    shape;
                delete this.shapes[shapeid];
                switch (b.substr(0, 1)) {
                    case 'r':
                        shape = this.renderRange(b.substr(1), a);
                        break;
                    case 'p':
                        shape = this.renderPerformance(a);
                        break;
                    case 't':
                        shape = this.renderTarget(a);
                        break
                }
                this.valueShapes[b] = shape.id;
                this.shapes[shape.id] = b;
                this.target.replaceWithShape(shapeid, shape)
            },
            renderRange: function(a, b) {
                var c = this.values[a],
                    rangewidth = m.round(this.canvasWidth * ((c - this.min) / this.range)),
                    color = this.options.get('rangeColors')[a - 2];
                if (b) {
                    color = this.calcHighlightColor(color, this.options)
                }
                return this.target.drawRect(0, 0, rangewidth - 1, this.canvasHeight - 1, color, color)
            },
            renderPerformance: function(a) {
                var b = this.values[1],
                    perfwidth = m.round(this.canvasWidth * ((b - this.min) / this.range)),
                    color = this.options.get('performanceColor');
                if (a) {
                    color = this.calcHighlightColor(color, this.options)
                }
                return this.target.drawRect(0, m.round(this.canvasHeight * 0.3), perfwidth - 1, m.round(this.canvasHeight * 0.4) - 1, color, color)
            },
            renderTarget: function(a) {
                var b = this.values[0],
                    x = m.round(this.canvasWidth * ((b - this.min) / this.range) - (this.options.get('targetWidth') / 2)),
                    targettop = m.round(this.canvasHeight * 0.10),
                    targetheight = this.canvasHeight - (targettop * 2),
                    color = this.options.get('targetColor');
                if (a) {
                    color = this.calcHighlightColor(color, this.options)
                }
                return this.target.drawRect(x, targettop, this.options.get('targetWidth') - 1, targetheight - 1, color, color)
            },
            render: function() {
                var a = this.values.length,
                    target = this.target,
                    i, shape;
                if (!bullet._super.render.call(this)) {
                    return
                }
                for (i = 2; i < a; i++) {
                    shape = this.renderRange(i).append();
                    this.shapes[shape.id] = 'r' + i;
                    this.valueShapes['r' + i] = shape.id
                }
                if (this.values[1] !== null) {
                    shape = this.renderPerformance().append();
                    this.shapes[shape.id] = 'p1';
                    this.valueShapes.p1 = shape.id
                }
                if (this.values[0] !== null) {
                    shape = this.renderTarget().append();
                    this.shapes[shape.id] = 't0';
                    this.valueShapes.t0 = shape.id
                }
                target.render()
            }
        });
        $.fn.sparkline.pie = pie = createClass($.fn.sparkline._base, {
            type: 'pie',
            init: function(a, b, c, d, e) {
                var f = 0,
                    i;
                pie._super.init.call(this, a, b, c, d, e);
                this.shapes = {};
                this.valueShapes = {};
                this.values = b = $.map(b, Number);
                if (c.get('width') === 'auto') {
                    this.width = this.height
                }
                if (b.length > 0) {
                    for (i = b.length; i--;) {
                        f += b[i]
                    }
                }
                this.total = f;
                this.initTarget();
                this.radius = m.floor(m.min(this.canvasWidth, this.canvasHeight) / 2)
            },
            getRegion: function(a, x, y) {
                var b = this.target.getShapeAt(a, x, y);
                return (b !== n && this.shapes[b] !== n) ? this.shapes[b] : n
            },
            getCurrentRegionFields: function() {
                var a = this.currentRegion;
                return {
                    isNull: this.values[a] === n,
                    value: this.values[a],
                    percent: this.values[a] / this.total * 100,
                    color: this.options.get('sliceColors')[a % this.options.get('sliceColors').length],
                    offset: a
                }
            },
            changeHighlight: function(a) {
                var b = this.currentRegion,
                    newslice = this.renderSlice(b, a),
                    shapeid = this.valueShapes[b];
                delete this.shapes[shapeid];
                this.target.replaceWithShape(shapeid, newslice);
                this.valueShapes[b] = newslice.id;
                this.shapes[newslice.id] = b
            },
            renderSlice: function(a, b) {
                var c = this.target,
                    options = this.options,
                    radius = this.radius,
                    borderWidth = options.get('borderWidth'),
                    offset = options.get('offset'),
                    circle = 2 * m.PI,
                    values = this.values,
                    total = this.total,
                    next = offset ? (2 * m.PI) * (offset / 360) : 0,
                    start, end, i, vlen, color;
                vlen = values.length;
                for (i = 0; i < vlen; i++) {
                    start = next;
                    end = next;
                    if (total > 0) {
                        end = next + (circle * (values[i] / total))
                    }
                    if (a === i) {
                        color = options.get('sliceColors')[i % options.get('sliceColors').length];
                        if (b) {
                            color = this.calcHighlightColor(color, options)
                        }
                        return c.drawPieSlice(radius, radius, radius - borderWidth, start, end, n, color)
                    }
                    next = end
                }
            },
            render: function() {
                var a = this.target,
                    values = this.values,
                    options = this.options,
                    radius = this.radius,
                    borderWidth = options.get('borderWidth'),
                    shape, i;
                if (!pie._super.render.call(this)) {
                    return
                }
                if (borderWidth) {
                    a.drawCircle(radius, radius, m.floor(radius - (borderWidth / 2)), options.get('borderColor'), n, borderWidth).append()
                }
                for (i = values.length; i--;) {
                    if (values[i]) {
                        shape = this.renderSlice(i).append();
                        this.valueShapes[i] = shape.id;
                        this.shapes[shape.id] = i
                    }
                }
                a.render()
            }
        });
        $.fn.sparkline.box = box = createClass($.fn.sparkline._base, {
            type: 'box',
            init: function(a, b, c, d, e) {
                box._super.init.call(this, a, b, c, d, e);
                this.values = $.map(b, Number);
                this.width = c.get('width') === 'auto' ? '4.0em' : d;
                this.initTarget();
                if (!this.values.length) {
                    this.disabled = 1
                }
            },
            getRegion: function() {
                return 1
            },
            getCurrentRegionFields: function() {
                var a = [{
                    field: 'lq',
                    value: this.quartiles[0]
                }, {
                    field: 'med',
                    value: this.quartiles[1]
                }, {
                    field: 'uq',
                    value: this.quartiles[2]
                }];
                if (this.loutlier !== n) {
                    a.push({
                        field: 'lo',
                        value: this.loutlier
                    })
                }
                if (this.routlier !== n) {
                    a.push({
                        field: 'ro',
                        value: this.routlier
                    })
                }
                if (this.lwhisker !== n) {
                    a.push({
                        field: 'lw',
                        value: this.lwhisker
                    })
                }
                if (this.rwhisker !== n) {
                    a.push({
                        field: 'rw',
                        value: this.rwhisker
                    })
                }
                return a
            },
            render: function() {
                var c = this.target,
                    values = this.values,
                    vlen = values.length,
                    options = this.options,
                    canvasWidth = this.canvasWidth,
                    canvasHeight = this.canvasHeight,
                    minValue = options.get('chartRangeMin') === n ? m.min.apply(m, values) : options.get('chartRangeMin'),
                    maxValue = options.get('chartRangeMax') === n ? m.max.apply(m, values) : options.get('chartRangeMax'),
                    canvasLeft = 0,
                    lwhisker, loutlier, iqr, q1, q2, q3, rwhisker, routlier, i, size, unitSize;
                if (!box._super.render.call(this)) {
                    return
                }
                if (options.get('raw')) {
                    if (options.get('showOutliers') && values.length > 5) {
                        loutlier = values[0];
                        lwhisker = values[1];
                        q1 = values[2];
                        q2 = values[3];
                        q3 = values[4];
                        rwhisker = values[5];
                        routlier = values[6]
                    } else {
                        lwhisker = values[0];
                        q1 = values[1];
                        q2 = values[2];
                        q3 = values[3];
                        rwhisker = values[4]
                    }
                } else {
                    values.sort(function(a, b) {
                        return a - b
                    });
                    q1 = quartile(values, 1);
                    q2 = quartile(values, 2);
                    q3 = quartile(values, 3);
                    iqr = q3 - q1;
                    if (options.get('showOutliers')) {
                        lwhisker = rwhisker = n;
                        for (i = 0; i < vlen; i++) {
                            if (lwhisker === n && values[i] > q1 - (iqr * options.get('outlierIQR'))) {
                                lwhisker = values[i]
                            }
                            if (values[i] < q3 + (iqr * options.get('outlierIQR'))) {
                                rwhisker = values[i]
                            }
                        }
                        loutlier = values[0];
                        routlier = values[vlen - 1]
                    } else {
                        lwhisker = values[0];
                        rwhisker = values[vlen - 1]
                    }
                }
                this.quartiles = [q1, q2, q3];
                this.lwhisker = lwhisker;
                this.rwhisker = rwhisker;
                this.loutlier = loutlier;
                this.routlier = routlier;
                unitSize = canvasWidth / (maxValue - minValue + 1);
                if (options.get('showOutliers')) {
                    canvasLeft = m.ceil(options.get('spotRadius'));
                    canvasWidth -= 2 * m.ceil(options.get('spotRadius'));
                    unitSize = canvasWidth / (maxValue - minValue + 1);
                    if (loutlier < lwhisker) {
                        c.drawCircle((loutlier - minValue) * unitSize + canvasLeft, canvasHeight / 2, options.get('spotRadius'), options.get('outlierLineColor'), options.get('outlierFillColor')).append()
                    }
                    if (routlier > rwhisker) {
                        c.drawCircle((routlier - minValue) * unitSize + canvasLeft, canvasHeight / 2, options.get('spotRadius'), options.get('outlierLineColor'), options.get('outlierFillColor')).append()
                    }
                }
                c.drawRect(m.round((q1 - minValue) * unitSize + canvasLeft), m.round(canvasHeight * 0.1), m.round((q3 - q1) * unitSize), m.round(canvasHeight * 0.8), options.get('boxLineColor'), options.get('boxFillColor')).append();
                c.drawLine(m.round((lwhisker - minValue) * unitSize + canvasLeft), m.round(canvasHeight / 2), m.round((q1 - minValue) * unitSize + canvasLeft), m.round(canvasHeight / 2), options.get('lineColor')).append();
                c.drawLine(m.round((lwhisker - minValue) * unitSize + canvasLeft), m.round(canvasHeight / 4), m.round((lwhisker - minValue) * unitSize + canvasLeft), m.round(canvasHeight - canvasHeight / 4), options.get('whiskerColor')).append();
                c.drawLine(m.round((rwhisker - minValue) * unitSize + canvasLeft), m.round(canvasHeight / 2), m.round((q3 - minValue) * unitSize + canvasLeft), m.round(canvasHeight / 2), options.get('lineColor')).append();
                c.drawLine(m.round((rwhisker - minValue) * unitSize + canvasLeft), m.round(canvasHeight / 4), m.round((rwhisker - minValue) * unitSize + canvasLeft), m.round(canvasHeight - canvasHeight / 4), options.get('whiskerColor')).append();
                c.drawLine(m.round((q2 - minValue) * unitSize + canvasLeft), m.round(canvasHeight * 0.1), m.round((q2 - minValue) * unitSize + canvasLeft), m.round(canvasHeight * 0.9), options.get('medianColor')).append();
                if (options.get('target')) {
                    size = m.ceil(options.get('spotRadius'));
                    c.drawLine(m.round((options.get('target') - minValue) * unitSize + canvasLeft), m.round((canvasHeight / 2) - size), m.round((options.get('target') - minValue) * unitSize + canvasLeft), m.round((canvasHeight / 2) + size), options.get('targetColor')).append();
                    c.drawLine(m.round((options.get('target') - minValue) * unitSize + canvasLeft - size), m.round(canvasHeight / 2), m.round((options.get('target') - minValue) * unitSize + canvasLeft + size), m.round(canvasHeight / 2), options.get('targetColor')).append()
                }
                c.render()
            }
        });
        VShape = createClass({
            init: function(a, b, c, d) {
                this.target = a;
                this.id = b;
                this.type = c;
                this.args = d
            },
            append: function() {
                this.target.appendShape(this);
                return this
            }
        });
        VCanvas_base = createClass({
            _pxregex: /(\d+)(px)?\s*$/i,
            init: function(a, b, c) {
                if (!a) {
                    return
                }
                this.width = a;
                this.height = b;
                this.target = c;
                this.lastShapeId = null;
                if (c[0]) {
                    c = c[0]
                }
                $.data(c, '_jqs_vcanvas', this)
            },
            drawLine: function(a, b, c, d, e, f) {
                return this.drawShape([
                    [a, b],
                    [c, d]
                ], e, f)
            },
            drawShape: function(a, b, c, d) {
                return this._genShape('Shape', [a, b, c, d])
            },
            drawCircle: function(x, y, a, b, c, d) {
                return this._genShape('Circle', [x, y, a, b, c, d])
            },
            drawPieSlice: function(x, y, a, b, c, d, e) {
                return this._genShape('PieSlice', [x, y, a, b, c, d, e])
            },
            drawRect: function(x, y, a, b, c, d) {
                return this._genShape('Rect', [x, y, a, b, c, d])
            },
            getElement: function() {
                return this.canvas
            },
            getLastShapeId: function() {
                return this.lastShapeId
            },
            reset: function() {
                alert('reset not implemented')
            },
            _insert: function(a, b) {
                $(b).html(a)
            },
            _calculatePixelDims: function(a, b, c) {
                var d;
                d = this._pxregex.exec(b);
                if (d) {
                    this.pixelHeight = d[1]
                } else {
                    this.pixelHeight = $(c).height()
                }
                d = this._pxregex.exec(a);
                if (d) {
                    this.pixelWidth = d[1]
                } else {
                    this.pixelWidth = $(c).width()
                }
            },
            _genShape: function(a, b) {
                var c = shapeCount++;
                b.unshift(c);
                return new VShape(this, c, a, b)
            },
            appendShape: function(a) {
                alert('appendShape not implemented')
            },
            replaceWithShape: function(a, b) {
                alert('replaceWithShape not implemented')
            },
            insertAfterShape: function(a, b) {
                alert('insertAfterShape not implemented')
            },
            removeShapeId: function(a) {
                alert('removeShapeId not implemented')
            },
            getShapeAt: function(a, x, y) {
                alert('getShapeAt not implemented')
            },
            render: function() {
                alert('render not implemented')
            }
        });
        VCanvas_canvas = createClass(VCanvas_base, {
            init: function(a, b, c, d) {
                VCanvas_canvas._super.init.call(this, a, b, c);
                this.canvas = l.createElement('canvas');
                if (c[0]) {
                    c = c[0]
                }
                $.data(c, '_jqs_vcanvas', this);
                $(this.canvas).css({
                    display: 'inline-block',
                    width: a,
                    height: b,
                    verticalAlign: 'top'
                });
                this._insert(this.canvas, c);
                this._calculatePixelDims(a, b, this.canvas);
                this.canvas.width = this.pixelWidth;
                this.canvas.height = this.pixelHeight;
                this.interact = d;
                this.shapes = {};
                this.shapeseq = [];
                this.currentTargetShapeId = n;
                $(this.canvas).css({
                    width: this.pixelWidth,
                    height: this.pixelHeight
                })
            },
            _getContext: function(a, b, c) {
                var d = this.canvas.getContext('2d');
                if (a !== n) {
                    d.strokeStyle = a
                }
                d.lineWidth = c === n ? 1 : c;
                if (b !== n) {
                    d.fillStyle = b
                }
                return d
            },
            reset: function() {
                var a = this._getContext();
                a.clearRect(0, 0, this.pixelWidth, this.pixelHeight);
                this.shapes = {};
                this.shapeseq = [];
                this.currentTargetShapeId = n
            },
            _drawShape: function(a, b, c, d, e) {
                var f = this._getContext(c, d, e),
                    i, plen;
                f.beginPath();
                f.moveTo(b[0][0] + 0.5, b[0][1] + 0.5);
                for (i = 1, plen = b.length; i < plen; i++) {
                    f.lineTo(b[i][0] + 0.5, b[i][1] + 0.5)
                }
                if (c !== n) {
                    f.stroke()
                }
                if (d !== n) {
                    f.fill()
                }
                if (this.targetX !== n && this.targetY !== n && f.isPointInPath(this.targetX, this.targetY)) {
                    this.currentTargetShapeId = a
                }
            },
            _drawCircle: function(a, x, y, b, c, d, e) {
                var f = this._getContext(c, d, e);
                f.beginPath();
                f.arc(x, y, b, 0, 2 * m.PI, false);
                if (this.targetX !== n && this.targetY !== n && f.isPointInPath(this.targetX, this.targetY)) {
                    this.currentTargetShapeId = a
                }
                if (c !== n) {
                    f.stroke()
                }
                if (d !== n) {
                    f.fill()
                }
            },
            _drawPieSlice: function(a, x, y, b, c, d, e, f) {
                var g = this._getContext(e, f);
                g.beginPath();
                g.moveTo(x, y);
                g.arc(x, y, b, c, d, false);
                g.lineTo(x, y);
                g.closePath();
                if (e !== n) {
                    g.stroke()
                }
                if (f) {
                    g.fill()
                }
                if (this.targetX !== n && this.targetY !== n && g.isPointInPath(this.targetX, this.targetY)) {
                    this.currentTargetShapeId = a
                }
            },
            _drawRect: function(a, x, y, b, c, d, e) {
                return this._drawShape(a, [
                    [x, y],
                    [x + b, y],
                    [x + b, y + c],
                    [x, y + c],
                    [x, y]
                ], d, e)
            },
            appendShape: function(a) {
                this.shapes[a.id] = a;
                this.shapeseq.push(a.id);
                this.lastShapeId = a.id;
                return a.id
            },
            replaceWithShape: function(a, b) {
                var c = this.shapeseq,
                    i;
                this.shapes[b.id] = b;
                for (i = c.length; i--;) {
                    if (c[i] == a) {
                        c[i] = b.id
                    }
                }
                delete this.shapes[a]
            },
            replaceWithShapes: function(a, b) {
                var c = this.shapeseq,
                    shapemap = {},
                    sid, i, first;
                for (i = a.length; i--;) {
                    shapemap[a[i]] = true
                }
                for (i = c.length; i--;) {
                    sid = c[i];
                    if (shapemap[sid]) {
                        c.splice(i, 1);
                        delete this.shapes[sid];
                        first = i
                    }
                }
                for (i = b.length; i--;) {
                    c.splice(first, 0, b[i].id);
                    this.shapes[b[i].id] = b[i]
                }
            },
            insertAfterShape: function(a, b) {
                var c = this.shapeseq,
                    i;
                for (i = c.length; i--;) {
                    if (c[i] === a) {
                        c.splice(i + 1, 0, b.id);
                        this.shapes[b.id] = b;
                        return
                    }
                }
            },
            removeShapeId: function(a) {
                var b = this.shapeseq,
                    i;
                for (i = b.length; i--;) {
                    if (b[i] === a) {
                        b.splice(i, 1);
                        break
                    }
                }
                delete this.shapes[a]
            },
            getShapeAt: function(a, x, y) {
                this.targetX = x;
                this.targetY = y;
                this.render();
                return this.currentTargetShapeId
            },
            render: function() {
                var a = this.shapeseq,
                    shapes = this.shapes,
                    shapeCount = a.length,
                    context = this._getContext(),
                    shapeid, shape, i;
                context.clearRect(0, 0, this.pixelWidth, this.pixelHeight);
                for (i = 0; i < shapeCount; i++) {
                    shapeid = a[i];
                    shape = shapes[shapeid];
                    this['_draw' + shape.type].apply(this, shape.args)
                }
                if (!this.interact) {
                    this.shapes = {};
                    this.shapeseq = []
                }
            }
        });
        VCanvas_vml = createClass(VCanvas_base, {
            init: function(a, b, c) {
                var d;
                VCanvas_vml._super.init.call(this, a, b, c);
                if (c[0]) {
                    c = c[0]
                }
                $.data(c, '_jqs_vcanvas', this);
                this.canvas = l.createElement('span');
                $(this.canvas).css({
                    display: 'inline-block',
                    position: 'relative',
                    overflow: 'hidden',
                    width: a,
                    height: b,
                    margin: '0px',
                    padding: '0px',
                    verticalAlign: 'top'
                });
                this._insert(this.canvas, c);
                this._calculatePixelDims(a, b, this.canvas);
                this.canvas.width = this.pixelWidth;
                this.canvas.height = this.pixelHeight;
                d = '<v:group coordorigin="0 0" coordsize="' + this.pixelWidth + ' ' + this.pixelHeight + '"' + ' style="position:absolute;top:0;left:0;width:' + this.pixelWidth + 'px;height=' + this.pixelHeight + 'px;"></v:group>';
                this.canvas.insertAdjacentHTML('beforeEnd', d);
                this.group = $(this.canvas).children()[0];
                this.rendered = false;
                this.prerender = ''
            },
            _drawShape: function(a, b, c, d, e) {
                var f = [],
                    initial, stroke, fill, closed, vel, plen, i;
                for (i = 0, plen = b.length; i < plen; i++) {
                    f[i] = '' + (b[i][0]) + ',' + (b[i][1])
                }
                initial = f.splice(0, 1);
                e = e === n ? 1 : e;
                stroke = c === n ? ' stroked="false" ' : ' strokeWeight="' + e + 'px" strokeColor="' + c + '" ';
                fill = d === n ? ' filled="false"' : ' fillColor="' + d + '" filled="true" ';
                closed = f[0] === f[f.length - 1] ? 'x ' : '';
                vel = '<v:shape coordorigin="0 0" coordsize="' + this.pixelWidth + ' ' + this.pixelHeight + '" ' + ' id="jqsshape' + a + '" ' + stroke + fill + ' style="position:absolute;left:0px;top:0px;height:' + this.pixelHeight + 'px;width:' + this.pixelWidth + 'px;padding:0px;margin:0px;" ' + ' path="m ' + initial + ' l ' + f.join(', ') + ' ' + closed + 'e">' + ' </v:shape>';
                return vel
            },
            _drawCircle: function(a, x, y, b, c, d, e) {
                var f, fill, vel;
                x -= b;
                y -= b;
                f = c === n ? ' stroked="false" ' : ' strokeWeight="' + e + 'px" strokeColor="' + c + '" ';
                fill = d === n ? ' filled="false"' : ' fillColor="' + d + '" filled="true" ';
                vel = '<v:oval ' + ' id="jqsshape' + a + '" ' + f + fill + ' style="position:absolute;top:' + y + 'px; left:' + x + 'px; width:' + (b * 2) + 'px; height:' + (b * 2) + 'px"></v:oval>';
                return vel
            },
            _drawPieSlice: function(a, x, y, b, c, d, e, f) {
                var g, startx, starty, endx, endy, stroke, fill, vel;
                if (c === d) {
                    return ''
                }
                if ((d - c) === (2 * m.PI)) {
                    c = 0.0;
                    d = (2 * m.PI)
                }
                startx = x + m.round(m.cos(c) * b);
                starty = y + m.round(m.sin(c) * b);
                endx = x + m.round(m.cos(d) * b);
                endy = y + m.round(m.sin(d) * b);
                if (startx === endx && starty === endy) {
                    if ((d - c) < m.PI) {
                        return ''
                    }
                    startx = endx = x + b;
                    starty = endy = y
                }
                if (startx === endx && starty === endy && (d - c) < m.PI) {
                    return ''
                }
                g = [x - b, y - b, x + b, y + b, startx, starty, endx, endy];
                stroke = e === n ? ' stroked="false" ' : ' strokeWeight="1px" strokeColor="' + e + '" ';
                fill = f === n ? ' filled="false"' : ' fillColor="' + f + '" filled="true" ';
                vel = '<v:shape coordorigin="0 0" coordsize="' + this.pixelWidth + ' ' + this.pixelHeight + '" ' + ' id="jqsshape' + a + '" ' + stroke + fill + ' style="position:absolute;left:0px;top:0px;height:' + this.pixelHeight + 'px;width:' + this.pixelWidth + 'px;padding:0px;margin:0px;" ' + ' path="m ' + x + ',' + y + ' wa ' + g.join(', ') + ' x e">' + ' </v:shape>';
                return vel
            },
            _drawRect: function(a, x, y, b, c, d, e) {
                return this._drawShape(a, [
                    [x, y],
                    [x, y + c],
                    [x + b, y + c],
                    [x + b, y],
                    [x, y]
                ], d, e)
            },
            reset: function() {
                this.group.innerHTML = ''
            },
            appendShape: function(a) {
                var b = this['_draw' + a.type].apply(this, a.args);
                if (this.rendered) {
                    this.group.insertAdjacentHTML('beforeEnd', b)
                } else {
                    this.prerender += b
                }
                this.lastShapeId = a.id;
                return a.id
            },
            replaceWithShape: function(a, b) {
                var c = $('#jqsshape' + a),
                    vel = this['_draw' + b.type].apply(this, b.args);
                c[0].outerHTML = vel
            },
            replaceWithShapes: function(a, b) {
                var c = $('#jqsshape' + a[0]),
                    replace = '',
                    slen = b.length,
                    i;
                for (i = 0; i < slen; i++) {
                    replace += this['_draw' + b[i].type].apply(this, b[i].args)
                }
                c[0].outerHTML = replace;
                for (i = 1; i < a.length; i++) {
                    $('#jqsshape' + a[i]).remove()
                }
            },
            insertAfterShape: function(a, b) {
                var c = $('#jqsshape' + a),
                    vel = this['_draw' + b.type].apply(this, b.args);
                c[0].insertAdjacentHTML('afterEnd', vel)
            },
            removeShapeId: function(a) {
                var b = $('#jqsshape' + a);
                this.group.removeChild(b[0])
            },
            getShapeAt: function(a, x, y) {
                var b = a.id.substr(8);
                return b
            },
            render: function() {
                if (!this.rendered) {
                    this.group.innerHTML = this.prerender;
                    this.rendered = true
                }
            }
        })
    }))
}(document, Math));