-- ================================================================
--
-- @version $Id: structure.sql 2023-02-01 11:12:05 gewa $
-- @package Car Dealer Pro
-- @copyright 2023. wojoscripts.com
--
-- ================================================================
-- Database structure
-- ================================================================

--
-- Table structure for table `activity`
--
DROP TABLE IF EXISTS `activity`;
CREATE TABLE IF NOT EXISTS `activity` (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` bigint(11) UNSIGNED NOT NULL DEFAULT '0',
  `type` varchar(30) DEFAULT NULL,
  `listing_id` bigint(11) UNSIGNED NOT NULL DEFAULT '0',
  `title` varchar(200) DEFAULT NULL,
  `username` varchar(50) DEFAULT NULL,
  `fname` varchar(100) DEFAULT NULL,
  `lname` varchar(100) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `uid` (`user_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `admins`
--
DROP TABLE IF EXISTS `admins`;
CREATE TABLE IF NOT EXISTS `admins` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `username` varchar(20) NOT NULL,
  `fname` varchar(50) NOT NULL,
  `lname` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `lastip` varchar(48) DEFAULT NULL,
  `hash` varchar(70) NOT NULL DEFAULT '0',
  `about` text,
  `usertype` varchar(20) NOT NULL DEFAULT 'staff',
  `lastlogin` timestamp NULL DEFAULT NULL,
  `avatar` varchar(60) DEFAULT NULL,
  `token` varchar(40) NOT NULL DEFAULT '0',
  `userlevel` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` enum ('y','n','b','t') NOT NULL DEFAULT 'n',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `advert`
--
DROP TABLE IF EXISTS `advert`;
CREATE TABLE IF NOT EXISTS `advert` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `cart`
--
DROP TABLE IF EXISTS `cart`;
CREATE TABLE IF NOT EXISTS `cart` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `membership_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `coupon_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `tax` decimal(13, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `totaltax` decimal(13, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `coupon` decimal(13, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `total` decimal(13, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `originalprice` decimal(13, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `totalprice` decimal(13, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `cart_id` varchar(100) DEFAULT NULL,
  `order_id` varchar(100) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_membership` (`membership_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `categories`
--
DROP TABLE IF EXISTS `categories`;
CREATE TABLE IF NOT EXISTS `categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(120) NOT NULL,
  `slug` varchar(120) DEFAULT NULL,
  `image` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_slug` (`slug`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `categories`
--
DROP TABLE IF EXISTS `categories`;
CREATE TABLE IF NOT EXISTS `categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(120) NOT NULL,
  `slug` varchar(120) DEFAULT NULL,
  `image` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_slug` (`slug`)
  ) ENGINE = MyISAM AUTO_INCREMENT = 10 DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `categories`
--
INSERT INTO `categories` (`id`, `name`, `slug`, `image`)
VALUES (1, 'Wagon', 'wagon', 'wagon.png'),
       (2, 'Luxury Car', 'luxury-car', 'luxury-car.png'),
       (3, 'Sports Car', 'sports-car', 'sports-car.png'),
       (4, 'Sport Utility Vehicle', 'sport-utility-vehicle', 'sport-utility-vehicle.png'),
       (5, 'Van', 'van', 'van.png'),
       (6, 'Pickup Truck', 'pickup-truck', 'pickup-truck.png'),
       (7, 'Coupe', 'coupe', 'coupe.png'),
       (8, 'Sedan', 'sedan', 'sedan.png');

--
-- Table structure for table `compare`
--
DROP TABLE IF EXISTS `compare`;
CREATE TABLE IF NOT EXISTS `compare` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `item_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_user` (`user_id`),
  KEY `idx_product` (`item_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `conditions`
--
DROP TABLE IF EXISTS `conditions`;
CREATE TABLE IF NOT EXISTS `conditions` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `conditions`
--
INSERT INTO `conditions` (`id`, `name`)
VALUES (1, 'New'),
       (2, 'Used');

--
-- Table structure for table `countries`
--
DROP TABLE IF EXISTS `countries`;
CREATE TABLE IF NOT EXISTS `countries` (
  `id` smallint(6) DEFAULT NULL,
  `abbr` varchar(6) DEFAULT NULL,
  `name` varchar(210) DEFAULT NULL,
  `active` tinyint(1) DEFAULT NULL,
  `home` tinyint(1) DEFAULT NULL,
  `vat` decimal(7, 0) DEFAULT NULL,
  `sorting` smallint(6) DEFAULT NULL,
  KEY `idx` (`abbr`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `countries`
--
INSERT INTO `countries` (`id`, `abbr`, `name`, `active`, `home`, `vat`, `sorting`)
VALUES (1, 'AF', 'Afghanistan', 1, NULL, '10', 0),
       (2, 'AL', 'Albania', 1, NULL, '0', 0),
       (3, 'DZ', 'Algeria', 1, NULL, '0', 0),
       (4, 'AS', 'American Samoa', 1, NULL, '0', 0),
       (5, 'AD', 'Andorra', 1, NULL, '0', 0),
       (6, 'AO', 'Angola', 1, NULL, '0', 0),
       (7, 'AI', 'Anguilla', 1, NULL, '0', 0),
       (8, 'AQ', 'Antarctica', 1, NULL, '0', 0),
       (9, 'AG', 'Antigua and Barbuda', 1, NULL, '0', 0),
       (10, 'AR', 'Argentina', 1, NULL, '0', 0),
       (11, 'AM', 'Armenia', 1, NULL, '0', 0),
       (12, 'AW', 'Aruba', 1, NULL, '0', 0),
       (13, 'AU', 'Australia', 1, NULL, '0', 0),
       (14, 'AT', 'Austria', 1, NULL, '0', 0),
       (15, 'AZ', 'Azerbaijan', 1, NULL, '0', 0),
       (16, 'BS', 'Bahamas', 1, NULL, '0', 0),
       (17, 'BH', 'Bahrain', 1, NULL, '0', 0),
       (18, 'BD', 'Bangladesh', 1, NULL, '0', 0),
       (19, 'BB', 'Barbados', 1, NULL, '0', 0),
       (20, 'BY', 'Belarus', 1, NULL, '0', 0),
       (21, 'BE', 'Belgium', 1, NULL, '0', 0),
       (22, 'BZ', 'Belize', 1, NULL, '0', 0),
       (23, 'BJ', 'Benin', 1, NULL, '0', 0),
       (24, 'BM', 'Bermuda', 1, NULL, '0', 0),
       (25, 'BT', 'Bhutan', 1, NULL, '0', 0),
       (26, 'BO', 'Bolivia', 1, NULL, '0', 0),
       (27, 'BA', 'Bosnia and Herzegowina', 1, NULL, '0', 0),
       (28, 'BW', 'Botswana', 1, NULL, '0', 0),
       (29, 'BV', 'Bouvet Island', 1, NULL, '0', 0),
       (30, 'BR', 'Brazil', 1, NULL, '0', 0),
       (31, 'IO', 'British Indian Ocean Territory', 1, NULL, '0', 0),
       (32, 'VG', 'British Virgin Islands', 1, NULL, '0', 0),
       (33, 'BN', 'Brunei Darussalam', 1, NULL, '0', 0),
       (34, 'BG', 'Bulgaria', 1, NULL, '0', 0),
       (35, 'BF', 'Burkina Faso', 1, NULL, '0', 0),
       (36, 'BI', 'Burundi', 1, NULL, '0', 0),
       (37, 'KH', 'Cambodia', 1, NULL, '0', 0),
       (38, 'CM', 'Cameroon', 1, NULL, '0', 0),
       (39, 'CA', 'Canada', 1, 1, '13', 1000),
       (40, 'CV', 'Cape Verde', 1, NULL, '0', 0),
       (41, 'KY', 'Cayman Islands', 1, NULL, '0', 0),
       (42, 'CF', 'Central African Republic', 1, NULL, '0', 0),
       (43, 'TD', 'Chad', 1, NULL, '0', 0),
       (44, 'CL', 'Chile', 1, NULL, '0', 0),
       (45, 'CN', 'China', 1, NULL, '0', 0),
       (46, 'CX', 'Christmas Island', 1, NULL, '0', 0),
       (47, 'CC', 'Cocos (Keeling) Islands', 1, NULL, '0', 0),
       (48, 'CO', 'Colombia', 1, NULL, '0', 0),
       (49, 'KM', 'Comoros', 1, NULL, '0', 0),
       (50, 'CG', 'Congo', 1, NULL, '0', 0),
       (51, 'CK', 'Cook Islands', 1, NULL, '0', 0),
       (52, 'CR', 'Costa Rica', 1, NULL, '0', 0),
       (53, 'CI', 'Cote D&#39;ivoire', 1, NULL, '0', 0),
       (54, 'HR', 'Croatia', 1, NULL, '0', 0),
       (55, 'CU', 'Cuba', 1, NULL, '0', 0),
       (56, 'CY', 'Cyprus', 1, NULL, '0', 0),
       (57, 'CZ', 'Czech Republic', 1, NULL, '0', 0),
       (58, 'DK', 'Denmark', 1, NULL, '0', 0),
       (59, 'DJ', 'Djibouti', 1, NULL, '0', 0),
       (60, 'DM', 'Dominica', 1, NULL, '0', 0),
       (61, 'DO', 'Dominican Republic', 1, NULL, '0', 0),
       (62, 'TP', 'East Timor', 1, NULL, '0', 0),
       (63, 'EC', 'Ecuador', 1, NULL, '0', 0),
       (64, 'EG', 'Egypt', 1, NULL, '0', 0),
       (65, 'SV', 'El Salvador', 1, NULL, '0', 0),
       (66, 'GQ', 'Equatorial Guinea', 1, NULL, '0', 0),
       (67, 'ER', 'Eritrea', 1, NULL, '0', 0),
       (68, 'EE', 'Estonia', 1, NULL, '0', 0),
       (69, 'ET', 'Ethiopia', 1, NULL, '0', 0),
       (70, 'FK', 'Falkland Islands (Malvinas)', 1, NULL, '0', 0),
       (71, 'FO', 'Faroe Islands', 1, NULL, '0', 0),
       (72, 'FJ', 'Fiji', 1, NULL, '0', 0),
       (73, 'FI', 'Finland', 1, NULL, '0', 0),
       (74, 'FR', 'France', 1, NULL, '0', 0),
       (75, 'GF', 'French Guiana', 1, NULL, '0', 0),
       (76, 'PF', 'French Polynesia', 1, NULL, '0', 0),
       (77, 'TF', 'French Southern Territories', 1, NULL, '0', 0),
       (78, 'GA', 'Gabon', 1, NULL, '0', 0),
       (79, 'GM', 'Gambia', 1, NULL, '0', 0),
       (80, 'GE', 'Georgia', 1, NULL, '0', 0),
       (81, 'DE', 'Germany', 1, NULL, '0', 0),
       (82, 'GH', 'Ghana', 1, NULL, '0', 0),
       (83, 'GI', 'Gibraltar', 1, NULL, '0', 0),
       (84, 'GR', 'Greece', 1, NULL, '0', 0),
       (85, 'GL', 'Greenland', 1, NULL, '0', 0),
       (86, 'GD', 'Grenada', 1, NULL, '0', 0),
       (87, 'GP', 'Guadeloupe', 1, NULL, '0', 0),
       (88, 'GU', 'Guam', 1, NULL, '0', 0),
       (89, 'GT', 'Guatemala', 1, NULL, '0', 0),
       (90, 'GN', 'Guinea', 1, NULL, '0', 0),
       (91, 'GW', 'Guinea-Bissau', 1, NULL, '0', 0),
       (92, 'GY', 'Guyana', 1, NULL, '0', 0),
       (93, 'HT', 'Haiti', 1, NULL, '0', 0),
       (94, 'HM', 'Heard and McDonald Islands', 1, NULL, '0', 0),
       (95, 'HN', 'Honduras', 1, NULL, '0', 0),
       (96, 'HK', 'Hong Kong', 1, NULL, '0', 0),
       (97, 'HU', 'Hungary', 1, NULL, '0', 0),
       (98, 'IS', 'Iceland', 1, NULL, '0', 0),
       (99, 'IN', 'India', 1, NULL, '0', 0),
       (100, 'ID', 'Indonesia', 1, NULL, '0', 0),
       (101, 'IQ', 'Iraq', 1, NULL, '0', 0),
       (102, 'IE', 'Ireland', 1, NULL, '0', 0),
       (103, 'IR', 'Islamic Republic of Iran', 1, NULL, '0', 0),
       (104, 'IL', 'Israel', 1, NULL, '0', 0),
       (105, 'IT', 'Italy', 1, NULL, '0', 0),
       (106, 'JM', 'Jamaica', 1, NULL, '0', 0),
       (107, 'JP', 'Japan', 1, NULL, '0', 0),
       (108, 'JO', 'Jordan', 1, NULL, '0', 0),
       (109, 'KZ', 'Kazakhstan', 1, NULL, '0', 0),
       (110, 'KE', 'Kenya', 1, NULL, '0', 0),
       (111, 'KI', 'Kiribati', 1, NULL, '0', 0),
       (112, 'KP', 'Korea, Dem. Peoples Rep of', 1, NULL, '0', 0),
       (113, 'KR', 'Korea, Republic of', 1, NULL, '0', 0),
       (114, 'KW', 'Kuwait', 1, NULL, '0', 0),
       (115, 'KG', 'Kyrgyzstan', 1, NULL, '0', 0),
       (116, 'LA', 'Laos', 1, NULL, '0', 0),
       (117, 'LV', 'Latvia', 1, NULL, '0', 0),
       (118, 'LB', 'Lebanon', 1, NULL, '0', 0),
       (119, 'LS', 'Lesotho', 1, NULL, '0', 0),
       (120, 'LR', 'Liberia', 1, NULL, '0', 0),
       (121, 'LY', 'Libyan Arab Jamahiriya', 1, NULL, '0', 0),
       (122, 'LI', 'Liechtenstein', 1, NULL, '0', 0),
       (123, 'LT', 'Lithuania', 1, NULL, '0', 0),
       (124, 'LU', 'Luxembourg', 1, NULL, '0', 0),
       (125, 'MO', 'Macau', 1, NULL, '0', 0),
       (126, 'MK', 'Macedonia', 1, NULL, '0', 0),
       (127, 'MG', 'Madagascar', 1, NULL, '0', 0),
       (128, 'MW', 'Malawi', 1, NULL, '0', 0),
       (129, 'MY', 'Malaysia', 1, NULL, '0', 0),
       (130, 'MV', 'Maldives', 1, NULL, '0', 0),
       (131, 'ML', 'Mali', 1, NULL, '0', 0),
       (132, 'MT', 'Malta', 1, NULL, '0', 0),
       (133, 'MH', 'Marshall Islands', 1, NULL, '0', 0),
       (134, 'MQ', 'Martinique', 1, NULL, '0', 0),
       (135, 'MR', 'Mauritania', 1, NULL, '0', 0),
       (136, 'MU', 'Mauritius', 1, NULL, '0', 0),
       (137, 'YT', 'Mayotte', 1, NULL, '0', 0),
       (138, 'MX', 'Mexico', 1, NULL, '0', 0),
       (139, 'FM', 'Micronesia', 1, NULL, '0', 0),
       (140, 'MD', 'Moldova, Republic of', 1, NULL, '0', 0),
       (141, 'MC', 'Monaco', 1, NULL, '0', 0),
       (142, 'MN', 'Mongolia', 1, NULL, '0', 0),
       (143, 'MS', 'Montserrat', 1, NULL, '0', 0),
       (144, 'MA', 'Morocco', 1, NULL, '0', 0),
       (145, 'MZ', 'Mozambique', 1, NULL, '0', 0),
       (146, 'MM', 'Myanmar', 1, NULL, '0', 0),
       (147, 'NA', 'Namibia', 1, NULL, '0', 0),
       (148, 'NR', 'Nauru', 1, NULL, '0', 0),
       (149, 'NP', 'Nepal', 1, NULL, '0', 0),
       (150, 'NL', 'Netherlands', 1, NULL, '0', 0),
       (151, 'AN', 'Netherlands Antilles', 1, NULL, '0', 0),
       (152, 'NC', 'New Caledonia', 1, NULL, '0', 0),
       (153, 'NZ', 'New Zealand', 1, NULL, '0', 0),
       (154, 'NI', 'Nicaragua', 1, NULL, '0', 0),
       (155, 'NE', 'Niger', 1, NULL, '0', 0),
       (156, 'NG', 'Nigeria', 1, NULL, '0', 0),
       (157, 'NU', 'Niue', 1, NULL, '0', 0),
       (158, 'NF', 'Norfolk Island', 1, NULL, '0', 0),
       (159, 'MP', 'Northern Mariana Islands', 1, NULL, '0', 0),
       (160, 'NO', 'Norway', 1, NULL, '0', 0),
       (161, 'OM', 'Oman', 1, NULL, '0', 0),
       (162, 'PK', 'Pakistan', 1, NULL, '0', 0),
       (163, 'PW', 'Palau', 1, NULL, '0', 0),
       (164, 'PA', 'Panama', 1, NULL, '0', 0),
       (165, 'PG', 'Papua New Guinea', 1, NULL, '0', 0),
       (166, 'PY', 'Paraguay', 1, NULL, '0', 0),
       (167, 'PE', 'Peru', 1, NULL, '0', 0),
       (168, 'PH', 'Philippines', 1, NULL, '0', 0),
       (169, 'PN', 'Pitcairn', 1, NULL, '0', 0),
       (170, 'PL', 'Poland', 1, NULL, '0', 0),
       (171, 'PT', 'Portugal', 1, NULL, '0', 0),
       (172, 'PR', 'Puerto Rico', 1, NULL, '0', 0),
       (173, 'QA', 'Qatar', 1, NULL, '0', 0),
       (174, 'RE', 'Reunion', 1, NULL, '0', 0),
       (175, 'RO', 'Romania', 1, NULL, '0', 0),
       (176, 'RU', 'Russian Federation', 1, NULL, '0', 0),
       (177, 'RW', 'Rwanda', 1, NULL, '0', 0),
       (178, 'LC', 'Saint Lucia', 1, NULL, '0', 0),
       (179, 'WS', 'Samoa', 1, NULL, '0', 0),
       (180, 'SM', 'San Marino', 1, NULL, '0', 0),
       (181, 'ST', 'Sao Tome and Principe', 1, NULL, '0', 0),
       (182, 'SA', 'Saudi Arabia', 1, NULL, '0', 0),
       (183, 'SN', 'Senegal', 1, NULL, '0', 0),
       (184, 'RS', 'Serbia', 1, NULL, '0', 0),
       (185, 'SC', 'Seychelles', 1, NULL, '0', 0),
       (186, 'SL', 'Sierra Leone', 1, NULL, '0', 0),
       (187, 'SG', 'Singapore', 1, NULL, '0', 0),
       (188, 'SK', 'Slovakia', 1, NULL, '0', 0),
       (189, 'SI', 'Slovenia', 1, NULL, '0', 0),
       (190, 'SB', 'Solomon Islands', 1, NULL, '0', 0),
       (191, 'SO', 'Somalia', 1, NULL, '0', 0),
       (192, 'ZA', 'South Africa', 1, NULL, '0', 0),
       (193, 'ES', 'Spain', 1, NULL, '0', 0),
       (194, 'LK', 'Sri Lanka', 1, NULL, '0', 0),
       (195, 'SH', 'St. Helena', 1, NULL, '0', 0),
       (196, 'KN', 'St. Kitts and Nevis', 1, NULL, '0', 0),
       (197, 'PM', 'St. Pierre and Miquelon', 1, NULL, '0', 0),
       (198, 'VC', 'St. Vincent and the Grenadines', 1, NULL, '0', 0),
       (199, 'SD', 'Sudan', 1, NULL, '0', 0),
       (200, 'SR', 'Suriname', 1, NULL, '0', 0),
       (201, 'SJ', 'Svalbard and Jan Mayen Islands', 1, NULL, '0', 0),
       (202, 'SZ', 'Swaziland', 1, NULL, '0', 0),
       (203, 'SE', 'Sweden', 1, NULL, '0', 0),
       (204, 'CH', 'Switzerland', 1, NULL, '0', 0),
       (205, 'SY', 'Syrian Arab Republic', 1, NULL, '0', 0),
       (206, 'TW', 'Taiwan', 1, NULL, '0', 0),
       (207, 'TJ', 'Tajikistan', 1, NULL, '0', 0),
       (208, 'TZ', 'Tanzania, United Republic of', 1, NULL, '0', 0),
       (209, 'TH', 'Thailand', 1, NULL, '0', 0),
       (210, 'TG', 'Togo', 1, NULL, '0', 0),
       (211, 'TK', 'Tokelau', 1, NULL, '0', 0),
       (212, 'TO', 'Tonga', 1, NULL, '0', 0),
       (213, 'TT', 'Trinidad and Tobago', 1, NULL, '0', 0),
       (214, 'TN', 'Tunisia', 1, NULL, '0', 0),
       (215, 'TR', 'Turkey', 1, NULL, '0', 0),
       (216, 'TM', 'Turkmenistan', 1, NULL, '0', 0),
       (217, 'TC', 'Turks and Caicos Islands', 1, NULL, '0', 0),
       (218, 'TV', 'Tuvalu', 1, NULL, '0', 0),
       (219, 'UG', 'Uganda', 1, NULL, '0', 0),
       (220, 'UA', 'Ukraine', 1, NULL, '0', 0),
       (221, 'AE', 'United Arab Emirates', 1, NULL, '0', 0),
       (222, 'GB', 'United Kingdom (GB)', 1, NULL, '24', 999),
       (224, 'US', 'United States', 1, NULL, '8', 998),
       (225, 'VI', 'United States Virgin Islands', 1, NULL, '0', 0),
       (226, 'UY', 'Uruguay', 1, NULL, '0', 0),
       (227, 'UZ', 'Uzbekistan', 1, NULL, '0', 0),
       (228, 'VU', 'Vanuatu', 1, NULL, '0', 0),
       (229, 'VA', 'Vatican City State', 1, NULL, '0', 0),
       (230, 'VE', 'Venezuela', 1, NULL, '0', 0),
       (231, 'VN', 'Vietnam', 1, NULL, '0', 0),
       (232, 'WF', 'Wallis And Futuna Islands', 1, NULL, '0', 0),
       (233, 'EH', 'Western Sahara', 1, NULL, '0', 0),
       (234, 'YE', 'Yemen', 1, NULL, '0', 0),
       (235, 'ZR', 'Zaire', 1, NULL, '0', 0),
       (236, 'ZM', 'Zambia', 1, NULL, '0', 0),
       (237, 'ZW', 'Zimbabwe', 1, NULL, '0', 0);

--
-- Table structure for table `coupons`
--
DROP TABLE IF EXISTS `coupons`;
CREATE TABLE IF NOT EXISTS `coupons` (
  `id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `code` varchar(100) NOT NULL,
  `discount` varchar(4) NOT NULL DEFAULT '0',
  `type` enum ('p','a') NOT NULL DEFAULT 'p',
  `membership_id` varchar(50) NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `faq`
--
DROP TABLE IF EXISTS `faq`;
CREATE TABLE IF NOT EXISTS `faq` (
  `id` smallint(3) UNSIGNED NOT NULL AUTO_INCREMENT,
  `question` varchar(150) DEFAULT NULL,
  `answer` text,
  `sorting` smallint(3) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `faq`
--
INSERT INTO `faq` (`id`, `question`, `answer`, `sorting`)
VALUES (1, 'Do you offer any sort of warranty?',
        '<p>We can help with your financing plan, we can offer some tips and tricks. Drive off with this dream car of yours regardless of your credit history.</p>',
        5),
       (7, 'What causes brake pulsation?',
        '<p>We can help with your financing plan, we can offer some tips and tricks. Drive off with this dream car of yours regardless of your credit history.</p>',
        0),
       (8, 'Why is it important to rotate tires?',
        '<p>We can help with your financing plan, we can offer some tips and tricks. Drive off with this dream car of yours regardless of your credit history.</p>',
        0),
       (2, 'When should I get my oil changed?',
        '<p>\r\n	We can help with your financing plan, we can offer some tips and tricks. Drive off with this dream car of yours regardless of your credit history.</p>',
        4),
       (3, 'How do I check my tire pressure?',
        '<p>We can help with your financing plan, we can offer some tips and tricks. Drive off with this dream car of yours regardless of your credit history.</p>',
        1),
       (4, 'How often should I rotate my tires?',
        '<p>\r\n	We can help with your financing plan, we can offer some tips and tricks. Drive off with this dream car of yours regardless of your credit history.</p>',
        2),
       (5, 'What is Auto Detailing?',
        '<p>We can help with your financing plan, we can offer some tips and tricks. Drive off with this dream car of yours regardless of your credit history.</p>',
        3),
       (6, 'Is it urgent to fix an oil leak?',
        '<p>We can help with your financing plan, we can offer some tips and tricks. Drive off with this dream car of yours regardless of your credit history.</p>',
        6);

--
-- Table structure for table `features`
--
DROP TABLE IF EXISTS `features`;
CREATE TABLE IF NOT EXISTS `features` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `sorting` int(11) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `features`
--
INSERT INTO `features` (`id`, `name`, `sorting`)
VALUES (1, 'Air Conditioning', 5),
       (2, 'Cassette Player', 22),
       (3, 'CD Player', 23),
       (4, 'Leather Seats', 24),
       (5, 'Navigation System', 25),
       (6, 'Power Door Locks', 26),
       (7, 'Power Drivers Seat', 27),
       (8, 'Power Windows', 28),
       (9, 'Stability Control', 29),
       (10, 'Power Sunroof', 30),
       (11, 'Traction Control', 31),
       (12, 'Tire Pressure Monitoring System (TPMS)', 32),
       (13, 'Automatic climate control', 33),
       (14, 'Rear air conditioning', 34),
       (15, 'Side-step running boards', 35),
       (16, 'Antilock Brake System', 21),
       (17, 'Electric Mirrors', 20),
       (18, 'DVD Player', 6),
       (19, 'Remote Starter', 7),
       (20, 'Anti-Theft System', 8),
       (21, 'Heated Seat', 9),
       (22, 'Power Passenger Seat', 10),
       (23, 'Power Mirrors', 11),
       (24, 'Leather Steering Wheel', 12),
       (25, 'Digital Info Center', 13),
       (26, 'Rear Defogger', 14),
       (27, 'Fog Lights', 15),
       (28, 'Intermittent Wipers', 16),
       (29, 'Leather Interior Surface', 17),
       (30, 'Side Airbags', 18),
       (31, 'Security System', 19),
       (32, 'All wheel drive', 36),
       (33, 'Backup camera', 2),
       (34, 'Blind-spot warning', 1),
       (35, 'Rear-spot warning', 3),
       (36, 'Forward-collision warning', 4);

--
-- Table structure for table `fuel`
--
DROP TABLE IF EXISTS `fuel`;
CREATE TABLE IF NOT EXISTS `fuel` (
  `id` int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `fuel`
--
INSERT INTO `fuel` (`id`, `name`)
VALUES (1, 'Biodiesel'),
       (2, 'CNG'),
       (3, 'Diesel'),
       (4, 'Electric'),
       (5, 'Ethanol-FFV'),
       (6, 'Gasoline'),
       (7, 'Hybrid-Electric'),
       (8, 'Steam');

--
-- Table structure for table `gallery`
--
DROP TABLE IF EXISTS `gallery`;
CREATE TABLE IF NOT EXISTS `gallery` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `listing_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `title` varchar(100) DEFAULT NULL,
  `photo` varchar(200) DEFAULT NULL,
  `sorting` int(11) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_listing_id` (`listing_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;


--
-- Table structure for table `gateways`
--
DROP TABLE IF EXISTS `gateways`;
CREATE TABLE IF NOT EXISTS `gateways` (
  `id` tinyint(2) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `displayname` varchar(200) NOT NULL,
  `dir` varchar(200) NOT NULL,
  `live` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `extra_txt` varchar(200) NOT NULL,
  `extra_txt2` varchar(200) NOT NULL,
  `extra_txt3` varchar(200) DEFAULT NULL,
  `extra` varchar(200) NOT NULL,
  `extra2` varchar(200) NOT NULL,
  `extra3` varchar(200) DEFAULT NULL,
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `gateways`
--
INSERT INTO `gateways` (`id`, `name`, `displayname`, `dir`, `live`, `extra_txt`, `extra_txt2`, `extra_txt3`, `extra`, `extra2`, `extra3`, `active`)
VALUES (1, 'paypal', 'PayPal', 'paypal', 0, 'Paypal Email Address', 'Currency Code', 'Not in Use',
        'you@mail.com', 'CAD', '', 1),
       (3, 'razorpay', 'RazorPay', 'razorpay', 0, 'Api Key', 'Currency Code', 'Secret Key', 'rzp_test_',
        'INR', 'Y2Legi', 1),
       (4, 'stripe', 'Stripe', 'stripe', 0, 'Secret Key', 'Currency Code', 'Publishable Key',
        'sk_test_', 'CAD', 'pk_test_', 1),
       (5, 'payfast', 'PayFast', 'payfast', 0, 'Merchant ID', 'Merchant Key', 'PassPhrase', '500', '46f0',
        '', 1),
       (6, 'skrill', 'Skrill', 'skrill', 0, 'Skrill Email Address', 'Currency Code', 'Secret Passphrase', '', 'EUR',
        'mypassphrase', 1);

--
-- Table structure for table `listings`
--
DROP TABLE IF EXISTS `listings`;
CREATE TABLE IF NOT EXISTS `listings` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `idx` int(6) UNSIGNED NOT NULL DEFAULT '0',
  `title` varchar(120) DEFAULT NULL,
  `nice_title` varchar(120) DEFAULT NULL,
  `slug` varchar(120) DEFAULT NULL,
  `location` int(1) UNSIGNED NOT NULL DEFAULT '0',
  `stock_id` varchar(150) NOT NULL,
  `vin` varchar(150) NOT NULL,
  `make_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `model_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `year` year(4) NOT NULL,
  `vcondition` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `category` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `mileage` mediumint(6) UNSIGNED DEFAULT '0',
  `torque` varchar(150) DEFAULT NULL,
  `thumb` varchar(60) DEFAULT NULL,
  `file` varchar(60) DEFAULT NULL,
  `price` decimal(12, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `price_sale` decimal(12, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `color_e` varchar(40) NOT NULL,
  `color_i` varchar(40) NOT NULL,
  `doors` varchar(10) NOT NULL,
  `fuel` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `drive_train` varchar(60) DEFAULT NULL,
  `engine` varchar(60) NOT NULL,
  `transmission` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `top_speed` varchar(40) DEFAULT NULL,
  `horse_power` varchar(40) DEFAULT NULL,
  `towing_capacity` varchar(40) DEFAULT NULL,
  `features` blob,
  `gallery` blob,
  `body` text NOT NULL,
  `notes` text,
  `featured` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `hits` int(8) UNSIGNED NOT NULL DEFAULT '0',
  `sold` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `is_owner` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `rejected` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` text,
  `metadesc` text,
  `soldexpire` datetime DEFAULT NULL,
  `expire` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_models` (`make_id`, `model_id`, `location`, `vcondition`, `category`, `fuel`, `transmission`, `user_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `listings_info`
--
DROP TABLE IF EXISTS `listings_info`;
CREATE TABLE IF NOT EXISTS `listings_info` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `listing_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `make_name` varchar(100) NOT NULL,
  `make_slug` varchar(100) NOT NULL,
  `model_name` varchar(100) NOT NULL,
  `location_slug` varchar(100) NOT NULL,
  `location_name` blob,
  `condition_name` varchar(50) NOT NULL,
  `category_name` varchar(100) NOT NULL,
  `category_slug` varchar(100) NOT NULL,
  `fuel_name` varchar(50) DEFAULT NULL,
  `trans_name` varchar(50) DEFAULT NULL,
  `color_name` varchar(20) DEFAULT NULL,
  `feature_name` blob,
  `price` decimal(12, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `year` year(4) DEFAULT NULL,
  `mileage` int(4) UNSIGNED NOT NULL DEFAULT '0',
  `special` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `lstatus` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_listing_id` (`listing_id`),
  KEY `idx_user_id` (`user_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `locations`
--
DROP TABLE IF EXISTS `locations`;
CREATE TABLE IF NOT EXISTS `locations` (
  `id` int(4) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `name_slug` varchar(100) NOT NULL,
  `user_id` int(11) UNSIGNED NOT NULL,
  `ltype` enum ('owner','user') NOT NULL DEFAULT 'user',
  `email` varchar(100) DEFAULT NULL,
  `logo` varchar(50) DEFAULT NULL,
  `address` varchar(150) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `zip` varchar(20) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `url` varchar(100) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `fax` varchar(20) DEFAULT NULL,
  `zoom` tinyint(1) UNSIGNED NOT NULL DEFAULT '14',
  `lat` decimal(9, 6) NOT NULL DEFAULT '0.000000',
  `lng` decimal(9, 6) NOT NULL DEFAULT '0.000000',
  `cars` smallint(11) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_slug` (`name_slug`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `makes`
--
DROP TABLE IF EXISTS `makes`;
CREATE TABLE IF NOT EXISTS `makes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(120) NOT NULL,
  `name_slug` varchar(120) NOT NULL,
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `makes`
--
INSERT INTO `makes` (`id`, `name`, `name_slug`)
VALUES (1, 'ABT', 'abt'),
       (2, 'AC Schnitzer', 'ac-schnitzer'),
       (3, 'Acura', 'acura'),
       (4, 'Alfa Romeo', 'alfa-romeo'),
       (5, 'Alpina', 'alpina'),
       (6, 'Arrinera', 'arrinera'),
       (7, 'Artega', 'artega'),
       (8, 'Ascari', 'ascari'),
       (9, 'Aston Martin', 'aston-martin'),
       (10, 'Audi', 'audi'),
       (11, 'BMW', 'bmw'),
       (12, 'Bentley', 'bentley'),
       (13, 'Bertone', 'bertone'),
       (14, 'Brabus', 'brabus'),
       (15, 'Breckland', 'breckland'),
       (16, 'Bugatti', 'bugatti'),
       (17, 'Buick', 'buick'),
       (18, 'Cadillac', 'cadillac'),
       (19, 'Caparo', 'caparo'),
       (20, 'Carlsson', 'carlsson'),
       (21, 'Caterham', 'caterham'),
       (22, 'Chevrolet', 'chevrolet'),
       (23, 'Chrysler', 'chrysler'),
       (24, 'Citroen', 'citroen'),
       (25, 'Covini', 'covini'),
       (26, 'Dacia', 'dacia'),
       (27, 'Daewoo', 'daewoo'),
       (28, 'Daihatsu', 'daihatsu'),
       (29, 'Daimler', 'daimler'),
       (30, 'De Tomaso', 'de-tomaso'),
       (31, 'Devon', 'devon'),
       (32, 'Dodge', 'dodge'),
       (33, 'Donkervoort', 'donkervoort'),
       (34, 'EDAG', 'edag'),
       (35, 'Edo', 'edo'),
       (36, 'Elfin', 'elfin'),
       (37, 'Eterniti', 'eterniti'),
       (38, 'FM Auto', 'fm-auto'),
       (39, 'FPV', 'fpv'),
       (40, 'Farbio', 'farbio'),
       (41, 'Ferrari', 'ferrari'),
       (42, 'Fiat', 'fiat'),
       (43, 'Fisker', 'fisker'),
       (44, 'Ford', 'ford'),
       (45, 'GM', 'gm'),
       (46, 'GMC', 'gmc'),
       (47, 'GTA', 'gta'),
       (48, 'Gordon Murray', 'gordon-murray'),
       (49, 'Gumpert', 'gumpert'),
       (50, 'HSV', 'hsv'),
       (51, 'Hamann', 'hamann'),
       (52, 'Hennessey', 'hennessey'),
       (53, 'Holden', 'holden'),
       (54, 'Honda', 'honda'),
       (55, 'Hummer', 'hummer'),
       (56, 'Hyundai', 'hyundai'),
       (57, 'Infiniti', 'infiniti'),
       (58, 'Isuzu', 'isuzu'),
       (59, 'Italdesign', 'italdesign'),
       (60, 'Iveco', 'iveco'),
       (61, 'Jaguar', 'jaguar'),
       (62, 'Jeep', 'jeep'),
       (63, 'KTM', 'ktm'),
       (64, 'Kia', 'kia'),
       (65, 'Kleemann', 'kleemann'),
       (66, 'Koenigsegg', 'koenigsegg'),
       (67, 'LCC', 'lcc'),
       (68, 'Lada', 'lada'),
       (69, 'Lamborghini', 'lamborghini'),
       (70, 'Lancia', 'lancia'),
       (71, 'Land Rover', 'land-rover'),
       (72, 'Leblanc', 'leblanc'),
       (73, 'Lexus', 'lexus'),
       (74, 'Lincoln', 'lincoln'),
       (75, 'Lobini', 'lobini'),
       (76, 'Loremo', 'loremo'),
       (77, 'Lotus', 'lotus'),
       (78, 'MG', 'mg'),
       (79, 'Mansory', 'mansory'),
       (80, 'Marcos', 'marcos'),
       (81, 'Maserati', 'maserati'),
       (82, 'Maybach', 'maybach'),
       (83, 'Mazda', 'mazda'),
       (84, 'Mazel', 'mazel'),
       (85, 'McLaren', 'mclaren'),
       (86, 'Mercedes-Benz', 'mercedes-benz'),
       (87, 'Mercury', 'mercury'),
       (88, 'Mindset', 'mindset'),
       (89, 'Mini', 'mini'),
       (90, 'Mitsubishi', 'mitsubishi'),
       (91, 'Mitsuoka', 'mitsuoka'),
       (92, 'Morgan', 'morgan'),
       (93, 'Nismo', 'nismo'),
       (94, 'Nissan', 'nissan'),
       (95, 'Noble', 'noble'),
       (96, 'ORCA', 'orca'),
       (97, 'Oldsmobile', 'oldsmobile'),
       (98, 'Opel', 'opel'),
       (99, 'PGO', 'pgo'),
       (100, 'Pagani', 'pagani'),
       (101, 'Panoz', 'panoz'),
       (102, 'Peugeot', 'peugeot'),
       (103, 'Pininfarina', 'pininfarina'),
       (104, 'Plymouth', 'plymouth'),
       (105, 'Pontiac', 'pontiac'),
       (106, 'Porsche', 'porsche'),
       (107, 'Proton', 'proton'),
       (108, 'Renault', 'renault'),
       (109, 'Rinspeed', 'rinspeed'),
       (110, 'Rolls-Royce', 'rolls-royce'),
       (111, 'Rover', 'rover'),
       (112, 'Saab', 'saab'),
       (113, 'Saleen', 'saleen'),
       (114, 'Saturn', 'saturn'),
       (115, 'Scion', 'scion'),
       (116, 'Seat', 'seat'),
       (117, 'Singer', 'singer'),
       (118, 'Skoda', 'skoda'),
       (119, 'Smart', 'smart'),
       (120, 'Spada', 'spada'),
       (121, 'Spyker', 'spyker'),
       (122, 'SsangYong', 'ssangyong'),
       (123, 'Startech', 'startech'),
       (124, 'Stola', 'stola'),
       (125, 'Strosek', 'strosek'),
       (126, 'StudioTorino', 'studiotorino'),
       (127, 'Subaru', 'subaru'),
       (128, 'Suzuki', 'suzuki'),
       (129, 'TVR', 'tvr'),
       (130, 'TechArt', 'techart'),
       (131, 'Tesla', 'tesla'),
       (132, 'Think', 'think'),
       (133, 'Toyota', 'toyota'),
       (134, 'Tramontana', 'tramontana'),
       (135, 'Valmet', 'valmet'),
       (136, 'Vauxhall', 'vauxhall'),
       (137, 'Venturi', 'venturi'),
       (138, 'Volkswagen', 'volkswagen'),
       (139, 'Volvo', 'volvo'),
       (140, 'Wald', 'wald'),
       (141, 'Wiesmann', 'wiesmann'),
       (142, 'Yes', 'yes'),
       (143, 'Zagato', 'zagato'),
       (144, 'Zenvo', 'zenvo');

--
-- Table structure for table `members`
--
DROP TABLE IF EXISTS `members`;
CREATE TABLE IF NOT EXISTS `members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(32) NOT NULL,
  `membership_id` int(11) NOT NULL DEFAULT '0',
  `membership_expire` varchar(32) DEFAULT NULL,
  `email` varchar(70) DEFAULT NULL,
  `fname` varchar(32) NOT NULL,
  `lname` varchar(32) NOT NULL,
  `company` varchar(100) DEFAULT NULL,
  `avatar` varchar(60) DEFAULT NULL,
  `country` varchar(2) DEFAULT NULL,
  `address` varchar(150) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(30) DEFAULT NULL,
  `zip` varchar(20) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1 = Dealer, 0= Member',
  `usertype` varchar(10) NOT NULL DEFAULT 'member',
  `url` varchar(150) DEFAULT NULL,
  `hash` varchar(70) NOT NULL,
  `token` varchar(40) NOT NULL DEFAULT '0',
  `last_active` datetime DEFAULT NULL,
  `lastip` varchar(48) DEFAULT NULL,
  `listings` smallint(11) NOT NULL DEFAULT '0',
  `about` text,
  `comments` text,
  `userlevel` tinyint(1) DEFAULT '1',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` enum ('y','n','b','t') NOT NULL DEFAULT 'y',
  PRIMARY KEY (`id`),
  KEY `b_country` (`country`),
  KEY `status` (`active`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `memberships`
--
DROP TABLE IF EXISTS `memberships`;
CREATE TABLE IF NOT EXISTS `memberships` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `description` text NOT NULL,
  `price` decimal(12, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `days` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `period` varchar(1) NOT NULL DEFAULT 'D',
  `featured` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `listings` smallint(1) UNSIGNED NOT NULL DEFAULT '1',
  `private` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `thumb` varchar(40) DEFAULT NULL,
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `memberships`
--
INSERT INTO `memberships` (`id`, `title`, `description`, `price`, `days`, `period`, `featured`, `listings`, `private`, `thumb`, `active`)
VALUES (1, 'Basic', 'This is 7 days basic package...', '0.00', 7, 'D', 0, 1, 0, 'bronze.svg', 1),
       (2, 'Gold', 'This is 30 days Gold package', '29.99', 1, 'M', 1, 10, 0, 'silver.svg', 1),
       (3, 'Silver', 'Premium one week listing package', '19.99', 1, 'W', 1, 3, 0, 'gold.svg', 1),
       (4, 'Platinum', 'This is Platinum 50, full package', '1299.99', 1, 'Y', 1, 50, 0, 'platinum.svg', 1);

--
-- Table structure for table `membership_history`
--
DROP TABLE IF EXISTS `membership_history`;
CREATE TABLE IF NOT EXISTS `membership_history` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `membership_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `activated` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `expire` timestamp NULL DEFAULT NULL,
  `recurring` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '0 = expired, 1 = active',
  PRIMARY KEY (`id`),
  KEY `idx_transaction` (`transaction_id`),
  KEY `idx_user` (`user_id`),
  KEY `idx_membership` (`membership_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;


--
-- Table structure for table `menus`
--
DROP TABLE IF EXISTS `menus`;
CREATE TABLE IF NOT EXISTS `menus` (
  `id` tinyint(2) UNSIGNED NOT NULL AUTO_INCREMENT,
  `page_id` tinyint(2) UNSIGNED NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `slug` varchar(100) DEFAULT NULL,
  `content_type` varchar(20) NOT NULL,
  `link` varchar(200) DEFAULT NULL,
  `target` varchar(10) NOT NULL DEFAULT '_self',
  `sorting` tinyint(2) UNSIGNED NOT NULL DEFAULT '0',
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `content_id` (`page_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `menus`
--
INSERT INTO `menus` (`id`, `page_id`, `name`, `slug`, `content_type`, `link`, `target`, `sorting`, `active`)
VALUES (1, 1, 'Home', 'home', 'page', '', '_blank', 1, 0),
       (2, 4, 'Contact Us', 'contact', 'page', NULL, '_blank', 3, 1),
       (3, 2, 'About Us', 'about', 'page', NULL, '_blank', 2, 1),
       (4, 3, 'F.A.Q.', 'faq', 'page', NULL, '_blank', 4, 1),
       (5, 0, 'Ext', 'ext', 'web', 'https://wojoscripts.com', '_blank', 5, 0);

--
-- Table structure for table `models`
--
DROP TABLE IF EXISTS `models`;
CREATE TABLE IF NOT EXISTS `models` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `make_id` int(11) DEFAULT '0',
  `name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `make` (`make_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `models`
--
INSERT INTO `models` (`id`, `make_id`, `name`)
VALUES (1, 1, 'Audi R8'),
       (2, 1, 'Audi AS5'),
       (3, 1, 'Audi TT-R'),
       (4, 1, 'Audi TT'),
       (5, 1, 'Audi Q7'),
       (6, 1, 'Audi Allroad Quattro'),
       (7, 1, 'VW Polo'),
       (8, 1, 'VW Passat'),
       (9, 1, 'VW Golf GTI'),
       (10, 1, 'VW Golf'),
       (11, 1, 'Audi AS6 Avant'),
       (12, 1, 'Audi AS4 Avant'),
       (13, 1, 'Audi AS4'),
       (14, 1, 'Audi AS3'),
       (15, 1, 'Audi AS6'),
       (16, 1, 'Audi AS400'),
       (17, 1, 'Audi AS3 Sportback'),
       (18, 1, 'VW Touran'),
       (19, 1, 'VW Touareg'),
       (20, 1, 'VW Sporting Van T5'),
       (21, 1, 'VW New Beetle Cabriolet'),
       (22, 1, 'Audi RS6 Avant'),
       (23, 1, 'Audi AS8'),
       (24, 1, 'Audi AS4 Cabriolet'),
       (25, 1, 'Skoda Superb'),
       (26, 1, 'Skoda Fabia'),
       (27, 1, 'Seat Leon'),
       (28, 1, 'Audi allroad quattro'),
       (29, 1, 'Audi TT Sport Roadster'),
       (30, 1, 'Audi TT Sport'),
       (31, 1, 'Audi TT-Limited Wide Body'),
       (32, 1, 'Audi TT-Limited II'),
       (33, 1, 'Audi TT-Limited'),
       (34, 2, 'ACS5 5Series E39'),
       (35, 2, 'ACS5 Sport S Concept'),
       (36, 2, '99d Concept'),
       (37, 2, 'AC Schnitzer BMW X6 M'),
       (38, 2, 'AC Schnitzer BMW X1'),
       (39, 2, 'BMW X6 Falcon'),
       (40, 2, 'BMW X5 Falcon'),
       (41, 2, 'BMW M3 Cabrio'),
       (42, 2, 'ACS1 1-Series Cabrio'),
       (43, 2, 'Mini Cooper R56'),
       (44, 2, 'GP3.10 Concept'),
       (45, 2, 'BMW Z4 Profile Concept'),
       (46, 2, 'ACS4 Z4 Sport Coupe'),
       (47, 2, 'ACS4 Z4 M Roadster'),
       (48, 2, 'ACS3 Sport BMW M3'),
       (49, 2, 'ACS3 3-Series E93 Cabrio'),
       (50, 2, 'ACS3 3-Series E92 Coupe'),
       (51, 2, 'ACS1 BMW 1-Series Coupe'),
       (52, 2, 'Tension Street Version'),
       (53, 2, 'ACS7 7Series E65'),
       (54, 2, 'ACS6 Sport M6'),
       (55, 2, 'X5 E53'),
       (56, 2, 'Tension M6 Concept'),
       (57, 2, 'ACS5 Sport M5 E60'),
       (58, 2, 'ACS3 3Series E91 Touring'),
       (59, 2, 'ACS3 3Series E90'),
       (60, 2, 'ACS1 1Series E87'),
       (61, 2, 'Mini Cooper Covertible'),
       (62, 2, 'Mini CooperS'),
       (63, 2, 'Mini'),
       (64, 2, 'ACS6 6Series E64 Convertible'),
       (65, 2, 'ACS6 6Series E63 Coupe'),
       (66, 2, 'ACS5 5Series E61 Touring'),
       (67, 2, 'ACS5 5Series E60'),
       (68, 2, 'ACS3 X3'),
       (69, 2, 'ACS3 3Series E46 Coupe'),
       (70, 2, 'ACS3 3Series E46 Convertible'),
       (71, 2, 'Topster'),
       (72, 2, 'ACS4 Z4'),
       (73, 2, 'ACS3 3Series E46 M3 Sport'),
       (74, 2, 'X5 E53'),
       (75, 2, 'ACS7 7Series E65'),
       (76, 2, 'ACS3 3Series E46 Touring'),
       (77, 2, 'ACS3 3Series E46 Compact'),
       (78, 2, 'ACS3 3Series E46'),
       (79, 2, 'X-Road'),
       (80, 2, 'ACS5 5Series E39 Touring'),
       (81, 2, 'ACS5 5Series E39 M5'),
       (82, 3, '3.2 CL Type-S'),
       (83, 3, '3.2 TL'),
       (84, 3, 'Advanced Sedan Concept'),
       (85, 3, 'Advanced Sports Car Concept'),
       (86, 3, 'ILX'),
       (87, 3, 'ILX Concept'),
       (88, 3, 'Integra'),
       (89, 3, 'MDX'),
       (90, 3, 'MD-X Concept'),
       (91, 3, 'NSX'),
       (92, 3, 'NSX Concept'),
       (93, 3, 'NS-X Prototype'),
       (94, 3, 'NSX sketches'),
       (95, 3, 'NSX-T'),
       (96, 3, 'RDX'),
       (97, 3, 'RDX Concept'),
       (98, 3, 'RDX Prototype'),
       (99, 3, 'RL'),
       (100, 3, 'RL ASPEC Concept'),
       (101, 3, 'RL Prototype'),
       (102, 3, 'RL with ASPEC Performance Package'),
       (103, 3, 'RLX Concept'),
       (104, 3, 'RSX'),
       (105, 3, 'RSX A-Spec Concept'),
       (106, 3, 'RSX Type-S'),
       (107, 3, 'TL'),
       (108, 3, 'TL 25 Hours of Thunderhill'),
       (109, 3, 'TL ASPEC Concept'),
       (110, 3, 'TL Type-S'),
       (111, 3, 'TL with ASPEC Performance Package'),
       (112, 3, 'TSX'),
       (113, 3, 'TSX A-Spec Concept'),
       (114, 3, 'TSX Sedan'),
       (115, 3, 'TSX Sport Wagon'),
       (116, 3, 'TSX V6'),
       (117, 3, 'ZDX'),
       (118, 3, 'ZDX Concept'),
       (119, 4, 'Disco Volante Touring Concept'),
       (120, 4, 'TZ3 Stradale'),
       (121, 4, 'Giulietta'),
       (122, 4, '4C Concept'),
       (123, 4, 'TZ3 Corsa'),
       (124, 4, 'Pandion Concept'),
       (125, 4, 'MiTo Quadrifoglio Verde'),
       (126, 4, 'MiTo 1.4 MultiAir'),
       (127, 4, '2uettottanta Concept'),
       (128, 4, '159 1750 TBi'),
       (129, 4, 'MiTo UK Version'),
       (130, 4, 'MiTo GTA Concept'),
       (131, 4, 'Mi.To'),
       (132, 4, 'Brera S'),
       (133, 4, '8C Spider'),
       (134, 4, '159 Sportwagon'),
       (135, 4, '159'),
       (136, 4, 'GT Q2'),
       (137, 4, '8c Competizione'),
       (138, 4, '147 Q2'),
       (139, 4, '147 Murphy and Nye'),
       (140, 4, '147 CnC'),
       (141, 4, 'Spider UK Version'),
       (142, 4, 'Spider'),
       (143, 4, '159 Sportwagon'),
       (144, 4, 'Brera UK Version'),
       (145, 4, 'Brera'),
       (146, 4, '159'),
       (147, 4, 'Visconti Concept ItalDesign'),
       (148, 4, '8C Competizione'),
       (149, 4, '166'),
       (150, 4, '156 GTA Autodelta'),
       (151, 4, '156 Crosswagon Q4'),
       (152, 4, '156 Crosswagon'),
       (153, 4, '147 5door'),
       (154, 4, '147 3door'),
       (155, 4, 'Spider'),
       (156, 4, 'Kamal Concept'),
       (157, 4, 'GTV'),
       (158, 4, 'GT'),
       (159, 4, '156 Sportwagon 2.0 JTD'),
       (160, 4, '156 GTA Autodelta'),
       (161, 4, '156 2.4 JTD'),
       (162, 4, '147 TI'),
       (163, 4, '147 JTD 16V'),
       (164, 4, '147 GTA'),
       (165, 4, '147'),
       (166, 4, '166'),
       (167, 4, '156'),
       (168, 4, '146'),
       (169, 4, '145'),
       (170, 4, 'Nuvola Concept'),
       (171, 4, '155 2.5 V6 TI DTM'),
       (172, 4, '155'),
       (173, 4, '164 Proteo Concept'),
       (174, 4, 'Spider'),
       (175, 4, 'RZ'),
       (176, 4, '75 1.8i Turbo'),
       (177, 4, '75'),
       (178, 4, '75 1.8i Turbo TCC'),
       (179, 4, '164'),
       (180, 4, '75 1.8i Turbo Evoluzione'),
       (181, 4, '33 1.5 4x4'),
       (182, 4, 'Spider'),
       (183, 4, 'Giulietta 2.0 Turbodelta'),
       (184, 4, 'Arna'),
       (185, 4, 'Alfasud Sprint Quadrifoglio Verde'),
       (186, 4, 'Alfasud Sprint Grand Prix'),
       (187, 4, 'Alfa 6'),
       (188, 4, '33 1.5 Giardinetta 4x4'),
       (189, 4, 'Alfetta 2.0'),
       (190, 4, '182 T Formula 1'),
       (191, 4, 'Alfetta GTV 6 2.5i'),
       (192, 4, 'Alfasud Sprint 1.5 Veloce'),
       (193, 4, '2.0i TS Formula 3'),
       (194, 4, 'Brabham Formula 1'),
       (195, 4, 'Alfetta GTV 2.0'),
       (196, 4, 'Alfasud 1.2'),
       (197, 4, '2000 Berlina'),
       (198, 4, 'Montreal'),
       (199, 4, 'Giulia Coupe GT Junior Z'),
       (200, 4, 'Giulia Coupe 1300 GTA Junior'),
       (201, 4, 'Spider'),
       (202, 4, 'Giulia Coupe 1300 GT Junior'),
       (203, 4, 'Giulia Berlina'),
       (204, 4, '2600 Spider'),
       (205, 4, 'Giulietta Sprint'),
       (206, 4, 'Giulietta SZ'),
       (207, 4, 'Giulietta Sprint'),
       (208, 4, 'Giulietta Sprint'),
       (209, 4, 'Giulietta Spider'),
       (210, 4, 'Giulietta Berlina'),
       (211, 4, '750 Competizione'),
       (212, 4, 'Giulietta Sprint'),
       (213, 4, '2000 Sport Spider'),
       (214, 4, 'C 52 Disco Volante 2000 Spider'),
       (215, 4, 'Tipo 159 Alfetta'),
       (216, 4, '1900'),
       (217, 4, '158'),
       (218, 4, '6C 2300 Villa DEste'),
       (219, 4, '412'),
       (220, 4, 'Tipo 158 Alfetta'),
       (221, 4, '6C 2300 Mille Miglia'),
       (222, 4, '8C 2300'),
       (223, 4, '6C 1500 Sport'),
       (224, 4, 'P2'),
       (225, 4, 'RM Sport'),
       (226, 4, 'RL'),
       (227, 5, 'B7'),
       (228, 5, 'B6 Bi-Turbo Coupe'),
       (229, 5, 'B6 Bi-Turbo Convertible'),
       (230, 5, 'B3 GT3'),
       (231, 5, 'B5 Bi-Turbo Touring'),
       (232, 5, 'B5 Bi-Turbo'),
       (233, 5, 'B7 Bi-Turbo Allrad'),
       (234, 5, 'B7 Bi-Turbo'),
       (235, 5, 'D3 Bi-Turbo Coupe'),
       (236, 5, 'B3 Bi-Turbo'),
       (237, 5, 'D3'),
       (238, 5, 'B6 Cabrio'),
       (239, 5, 'B6'),
       (240, 5, 'B5'),
       (241, 6, 'Arrinera Supercar'),
       (242, 7, 'GT'),
       (243, 8, 'A10'),
       (244, 9, 'AM 310 Vanquish'),
       (245, 9, 'AMR1'),
       (246, 9, 'AMV8 Concept Car'),
       (247, 9, 'Bulldog Concept Car'),
       (248, 9, 'Coal Scuttle'),
       (249, 9, 'Cygnet'),
       (250, 9, 'Cygnet Concept'),
       (251, 9, 'DB AR1'),
       (252, 9, 'DB Mark III'),
       (253, 9, 'DB1'),
       (254, 9, 'DB2'),
       (255, 9, 'DB3'),
       (256, 9, 'DB3S'),
       (257, 9, 'DB4'),
       (258, 9, 'DB4 GT'),
       (259, 9, 'DB4 GT Zagato'),
       (260, 9, 'DB5'),
       (261, 9, 'DB6'),
       (262, 9, 'DB6 Volante'),
       (263, 9, 'DB6 Volante SWB'),
       (264, 9, 'DB7'),
       (265, 9, 'DB7 GT'),
       (266, 9, 'DB7 Vantage'),
       (267, 9, 'DB7 Vantage Volante'),
       (268, 9, 'DB7 Vantage Zagato'),
       (269, 9, 'DB7 Volante'),
       (270, 9, 'DB9'),
       (271, 9, 'DB9 LM'),
       (272, 9, 'DB9 Volante'),
       (273, 9, 'DB9 Volante'),
       (274, 9, 'DB9 Volante'),
       (275, 9, 'DBR1'),
       (276, 9, 'DBR4'),
       (277, 9, 'DBR9'),
       (278, 9, 'DBR9 Prototype'),
       (279, 9, 'DBRS9'),
       (280, 9, 'DBS'),
       (281, 9, 'DBS Carbon Edition'),
       (282, 9, 'DBS Infa Red'),
       (283, 9, 'DBS Lightning Silver'),
       (284, 9, 'DBS Racing Green'),
       (285, 9, 'DBS Volante'),
       (286, 9, 'DBSC Touring'),
       (287, 9, 'Lagonda'),
       (288, 9, 'Lagonda Concept'),
       (289, 9, 'Lagonda M45 Tourer'),
       (290, 9, 'Lagonda V12 Rapide'),
       (291, 9, 'Lagonda Vignale Concept Car'),
       (292, 9, 'One-77'),
       (293, 9, 'Project Vantage Concept Car'),
       (294, 9, 'Rapide'),
       (295, 9, 'Rapide Concept'),
       (296, 9, 'V12 Vanquish'),
       (297, 9, 'V12 Vantage'),
       (298, 9, 'V12 Vantage Roadster'),
       (299, 9, 'V12 Vantage RS Concept'),
       (300, 9, 'V12 Zagato'),
       (301, 9, 'V12 Zagato Concept'),
       (302, 9, 'V12 Zagato Racecar'),
       (303, 9, 'V8'),
       (304, 9, 'V8 Coupe'),
       (305, 9, 'V8 Vantage'),
       (306, 9, 'V8 Vantage Le Mans'),
       (307, 9, 'V8 Vantage N24'),
       (308, 9, 'V8 Vantage N400'),
       (309, 9, 'V8 Vantage N420'),
       (310, 9, 'V8 Vantage N420 Roadster'),
       (311, 9, 'V8 Vantage Roadster'),
       (312, 9, 'V8 Vantage Roadster'),
       (313, 9, 'V8 Vantage S'),
       (314, 9, 'V8 Vantage S Roadster'),
       (315, 9, 'V8 Vantage Volante'),
       (316, 9, 'V8 Vantage Volante LWB'),
       (317, 9, 'V8 Volante'),
       (318, 9, 'V8 Zagato'),
       (319, 9, 'V8 Zagato Volante'),
       (320, 9, 'Vanquish S V12'),
       (321, 9, 'Vantage GT3'),
       (322, 9, 'Vantage GT4'),
       (323, 9, 'Vantage GT4'),
       (324, 9, 'Virage'),
       (325, 9, 'Virage Volante'),
       (326, 9, 'Zagato Vanquish Roadster Concept'),
       (327, 10, 'S3'),
       (328, 10, '90'),
       (329, 10, '100'),
       (330, 10, '200'),
       (331, 10, '100 Avant'),
       (332, 10, '100 Avant quattro'),
       (333, 10, '200 Avant'),
       (334, 10, '80 Avant'),
       (335, 10, '90 quattro'),
       (336, 10, 'A1'),
       (337, 10, 'A1 amplified'),
       (338, 10, 'A1 clubsport quattro Concept'),
       (339, 10, 'A1 e-tron Concept'),
       (340, 10, 'A1 quattro'),
       (341, 10, 'A1 Sportback'),
       (342, 10, 'A1 Sportback Concept'),
       (343, 10, 'A2'),
       (344, 10, 'A2 Concept'),
       (345, 10, 'A3'),
       (346, 10, 'A3 2.0 TDI 3-door'),
       (347, 10, 'A3 2.0T'),
       (348, 10, 'A3 3.2 V6 3-door'),
       (349, 10, 'A3 3-door'),
       (350, 10, 'A3 5-door'),
       (351, 10, 'A3 Cabriolet'),
       (352, 10, 'A3 Concept'),
       (353, 10, 'A3 e-tron Concept'),
       (354, 10, 'A3 Sportback'),
       (355, 10, 'A3 Sportback quattro'),
       (356, 10, 'A3 Sportback S-line'),
       (357, 10, 'A3 TDI clubsport quattro Concept'),
       (358, 10, 'A3 US Version'),
       (359, 10, 'A4'),
       (360, 10, 'A4 2.0T'),
       (361, 10, 'A4 3.0 TDI quattro'),
       (362, 10, 'A4 3.2 quattro'),
       (363, 10, 'A4 allroad quattro'),
       (364, 10, 'A4 Avant'),
       (365, 10, 'A4 Avant 3.2 quattro'),
       (366, 10, 'A4 Cabriolet'),
       (367, 10, 'A4 Cabriolet 1.8 T'),
       (368, 10, 'A4 Cabriolet 1.9 TDI'),
       (369, 10, 'A4 Cabriolet 2.4'),
       (370, 10, 'A4 Cabriolet 3.0'),
       (371, 10, 'A4 DTM Edition'),
       (372, 10, 'A4 TDI Concept e'),
       (373, 10, 'A4 US Version'),
       (374, 10, 'A5'),
       (375, 10, 'A5 3.0 TDI quattro'),
       (376, 10, 'A5 Cabriolet'),
       (377, 10, 'A5 Coupe'),
       (378, 10, 'A5 DTM'),
       (379, 10, 'A5 Sportback'),
       (380, 10, 'A6'),
       (381, 10, 'A6 3.0 TDI quattro'),
       (382, 10, 'A6 3.2'),
       (383, 10, 'A6 4.2 quattro'),
       (384, 10, 'A6 4.2 quattro Sline'),
       (385, 10, 'A6 allroad quattro'),
       (386, 10, 'A6 Avant'),
       (387, 10, 'A6 Hybrid'),
       (388, 10, 'A6 L e-tron Concept'),
       (389, 10, 'A6L'),
       (390, 10, 'A7 Sportback'),
       (391, 10, 'A8'),
       (392, 10, 'A8 3.0 TDI quattro'),
       (393, 10, 'A8 3.2 FSI quattro'),
       (394, 10, 'A8 3.3 TDI quattro'),
       (395, 10, 'A8 3.7 quattro'),
       (396, 10, 'A8 4.0 TDI quattro'),
       (397, 10, 'A8 4.2'),
       (398, 10, 'A8 4.2 quattro'),
       (399, 10, 'A8 4.2 TDI quattro'),
       (400, 10, 'A8 Hybrid'),
       (401, 10, 'A8 Hybrid Concept'),
       (402, 10, 'A8 L'),
       (403, 10, 'A8 L 3.0 quattro'),
       (404, 10, 'A8 L 4.2'),
       (405, 10, 'A8 L 4.2 quattro'),
       (406, 10, 'A8 L 6.0 quattro'),
       (407, 10, 'A8 L 6.0 W12 quattro'),
       (408, 10, 'A8 L Hybrid'),
       (409, 10, 'A8 L Security'),
       (410, 10, 'A8 L W12'),
       (411, 10, 'A8 Security'),
       (412, 10, 'A8L 4.2 TDI quattro'),
       (413, 10, 'A8L W12 quattro'),
       (414, 10, 'allroad quattro'),
       (415, 10, 'allroad quattro 2.5 TDI'),
       (416, 10, 'allroad quattro 2.7T'),
       (417, 10, 'allroad quattro 4.2'),
       (418, 10, 'Allroad quattro Concept'),
       (419, 10, 'allroad quattro V6 2.7T'),
       (420, 10, 'allroad quattro V8 4.2'),
       (421, 10, 'Avantissimo Concept'),
       (422, 10, 'Avus quattro Concept'),
       (423, 10, 'Cabriolet'),
       (424, 10, 'Coupe'),
       (425, 10, 'Coupe GT'),
       (426, 10, 'Cross Cabriolet quattro Concept'),
       (427, 10, 'Cross Coupe quattro Concept'),
       (428, 10, 'Crosslane Coupe Concept'),
       (429, 10, 'e-bike Worthersee Concept'),
       (430, 10, 'e-tron Concept'),
       (431, 10, 'e-tron Spyder Concept'),
       (432, 10, 'Imperator'),
       (433, 10, 'Le Mans quattro Concept'),
       (434, 10, 'metroproject quattro Concept'),
       (435, 10, 'Nuvolari quattro Concept'),
       (436, 10, 'Pikes Peake quattro Concept'),
       (437, 10, 'Q3'),
       (438, 10, 'Q3 Jinlong Yufeng Concept'),
       (439, 10, 'Q5'),
       (440, 10, 'Q5 Custom Concept'),
       (441, 10, 'Q5 Hybrid quattro'),
       (442, 10, 'Q7'),
       (443, 10, 'Q7 Hybrid Concept'),
       (444, 10, 'Q7 V12 TDI'),
       (445, 10, 'Q7 V12 TDI Concept'),
       (446, 10, 'quattro'),
       (447, 10, 'quattro Concept'),
       (448, 10, 'quattro Spyder Concept'),
       (449, 10, 'R18'),
       (450, 10, 'R8'),
       (451, 10, 'R8 Exclusive Selection'),
       (452, 10, 'R8 GT'),
       (453, 10, 'R8 GT Spyder'),
       (454, 10, 'R8 GT3'),
       (455, 10, 'R8 Spyder 4.2 FSI quattro'),
       (456, 10, 'R8 Spyder 5.2 FSI quattro'),
       (457, 10, 'R8 TDI Le Mans Concept'),
       (458, 10, 'R8 V10'),
       (459, 10, 'R8 V10 5.2 FSI quattro'),
       (460, 10, 'R8 V10 plus'),
       (461, 10, 'R8 V10 Spyder'),
       (462, 10, 'R8 V12 TDI Concept'),
       (463, 10, 'R8R'),
       (464, 10, 'Roadjet Concept'),
       (465, 10, 'Rosemeyer Concept'),
       (466, 10, 'RS 4 Avant'),
       (467, 10, 'RS 4 Cabriolet'),
       (468, 10, 'RS Q3 Concept'),
       (469, 10, 'RS2 Avant'),
       (470, 10, 'RS3 Sportback'),
       (471, 10, 'RS4'),
       (472, 10, 'RS4 Avant'),
       (473, 10, 'RS4 Cabriolet'),
       (474, 10, 'RS5'),
       (475, 10, 'RS5 Cabriolet'),
       (476, 10, 'RS6'),
       (477, 10, 'RS6 Avant'),
       (478, 10, 'RS6 Avant UK Version'),
       (479, 10, 'RS6 plus'),
       (480, 10, 'RS6 Sedan'),
       (481, 10, 'RSQ Concept'),
       (482, 10, 'S3'),
       (483, 10, 'S3 Sportback'),
       (484, 10, 'S4'),
       (485, 10, 'S4 Avant'),
       (486, 10, 'S4 Cabriolet'),
       (487, 10, 'S5'),
       (488, 10, 'S5 Sportback'),
       (489, 10, 'S6'),
       (490, 10, 'S6 Avant'),
       (491, 10, 'S7 Sportback'),
       (492, 10, 'S8'),
       (493, 10, 'Shooting Brake Concept'),
       (494, 10, 'Sport quattro'),
       (495, 10, 'Sport quattro S1'),
       (496, 10, 'Sportback Concept'),
       (497, 10, 'SQ5 TDI'),
       (498, 10, 'Steppenwolf Concept'),
       (499, 10, 'TT 3.2 DSG quattro'),
       (500, 10, 'TT clubsport quattro Concept'),
       (501, 10, 'TT Coupe'),
       (502, 10, 'TT Coupe 1.8T'),
       (503, 10, 'TT Coupe 3.2'),
       (504, 10, 'TT Coupe Concept'),
       (505, 10, 'TT Coupe S-line'),
       (506, 10, 'TT GT4 Concept'),
       (507, 10, 'TT quattro sport'),
       (508, 10, 'TT Roadster'),
       (509, 10, 'TT Roadster 1.8T'),
       (510, 10, 'TT Roadster 2.0 TFSI'),
       (511, 10, 'TT Roadster 3.2'),
       (512, 10, 'TT Roadster 3.2 quattro'),
       (513, 10, 'TT Roadster Hardtop'),
       (514, 10, 'TT RS'),
       (515, 10, 'TT RS plus'),
       (516, 10, 'TT RS Roadster'),
       (517, 10, 'TTS Concept'),
       (518, 10, 'TTS Coupe'),
       (519, 10, 'TTS Roadster'),
       (520, 10, 'Union Type C'),
       (521, 10, 'Urban Concept'),
       (522, 10, 'Urban Spyder Concept'),
       (523, 10, 'V8'),
       (524, 10, 'V8L quattro'),
       (525, 11, '120d'),
       (526, 11, '120i'),
       (527, 11, '120i UK Version'),
       (528, 11, '128i Convertible'),
       (529, 11, '130i'),
       (530, 11, '130i M-Package'),
       (531, 11, '135i Convertible'),
       (532, 11, '135i Coupe'),
       (533, 11, '1-Series'),
       (534, 11, '1-Series 3-door'),
       (535, 11, '1-Series 5-door'),
       (536, 11, '1-Series Cabrio'),
       (537, 11, '1-Series Convertible'),
       (538, 11, '1-Series Convertible UK Version'),
       (539, 11, '1-Series Coupe'),
       (540, 11, '1-Series M Coupe'),
       (541, 11, '5 ActiveHybrid'),
       (542, 11, '3 ActiveHybrid'),
       (543, 11, '1-Series M Coupe MotoGP Safety Car'),
       (544, 11, '1-Series M Coupe UK Version'),
       (545, 11, '1-Series M Coupe US Version'),
       (546, 11, '1-Series Range'),
       (547, 11, '1-Series Sport Line'),
       (548, 11, '1-Series tii Concept'),
       (549, 11, '1-Series Urban Line'),
       (550, 11, '320Cd Convertible'),
       (551, 11, '320d'),
       (552, 11, '320d EfficientDynamics'),
       (553, 11, '320d Touring'),
       (554, 11, '320si'),
       (555, 11, '320si E90 WTCC'),
       (556, 11, '325i Touring'),
       (557, 11, '325ti Compact'),
       (558, 11, '328 Hommage Concept'),
       (559, 11, '330Cd Coupe'),
       (560, 11, '330Ci Convertible'),
       (561, 11, '330Ci Coupe'),
       (562, 11, '330i'),
       (563, 11, '330i M-Package'),
       (564, 11, '335d BluePerformance'),
       (565, 11, '335i Convertible'),
       (566, 11, '335i Coupe'),
       (567, 11, '335is Coupe'),
       (568, 11, '3-Series'),
       (569, 11, '3-Series Compact'),
       (570, 11, '3-Series Convertible'),
       (571, 11, '3-Series Coupe'),
       (572, 11, 'M3 Frozen Gray'),
       (573, 11, '3-Series Long Wheelbase'),
       (574, 11, '3-Series Touring'),
       (575, 11, '5-Series Touring'),
       (576, 11, '3-Series Touring UK Version'),
       (577, 11, '3-Series UK Version'),
       (578, 11, '5 Series'),
       (579, 11, '530d'),
       (580, 11, '530d Touring'),
       (581, 11, '530i'),
       (582, 11, '530Li'),
       (583, 11, '530xi'),
       (584, 11, '530xi Touring'),
       (585, 11, '545i Touring'),
       (586, 11, '5-Series'),
       (587, 11, '5-Series ActiveHybrid Concept'),
       (588, 11, '5-Series Gran Turismo'),
       (589, 11, '5-Series Gran Turismo Concept'),
       (590, 11, '5-Series Long-Wheelbase'),
       (591, 11, '5-Series Security'),
       (592, 11, '630i'),
       (593, 11, '640d Coupe'),
       (594, 11, '640d xDrive Coupe'),
       (595, 11, '640i Gran Coupe'),
       (596, 11, '7-Series High Security'),
       (597, 11, '645Ci Convertible'),
       (598, 11, '650i Convertible'),
       (599, 11, '6-Series Convertible'),
       (600, 11, '6-Series Coupe'),
       (601, 11, '6-Series Coupe Concept'),
       (602, 11, '6-Series Gran Coupe'),
       (603, 11, '6-Series Gran Coupe UK Version'),
       (604, 11, '7 ActiveHybrid'),
       (605, 11, '730d'),
       (606, 11, '750i'),
       (607, 11, '750Li'),
       (608, 11, '750Li with Shadow Line'),
       (609, 11, '760Li'),
       (610, 11, '760Li E66'),
       (611, 11, '7-Series'),
       (612, 11, '7-Series ActiveHybrid Concept'),
       (613, 11, '7-Series UK Version'),
       (614, 11, 'Active Tourer Concept'),
       (615, 11, 'ActiveE Concept'),
       (616, 11, 'Art Car Collection'),
       (617, 11, 'Concept CS'),
       (618, 11, 'Concept M5'),
       (619, 11, 'ConnectedDrive Concept'),
       (620, 11, 'Coupe Range'),
       (621, 11, 'EfficientDynamics Concept'),
       (622, 11, 'GINA Light Visionary Model Concept'),
       (623, 11, 'Gran Coupe Concept'),
       (624, 11, 'H2R'),
       (625, 11, 'M-Zero Concept'),
       (626, 11, 'H2R Hydrogen Racecar'),
       (627, 11, 'Hydrogen 7'),
       (628, 11, 'i3 Concept'),
       (629, 11, 'i8 Concept'),
       (630, 11, 'i8 Spyder Concept'),
       (631, 11, '635d Coupe'),
       (632, 11, 'M1 Concept'),
       (633, 11, 'M135i'),
       (634, 11, 'M135i Concept'),
       (635, 11, 'M3'),
       (636, 11, 'M3 Concept'),
       (637, 11, 'M3 Convertible'),
       (638, 11, 'M3 Convertible UK Version'),
       (639, 11, 'M3 Coupe'),
       (640, 11, 'M3 Coupe UK Version'),
       (641, 11, 'M3 Coupe US-Version'),
       (642, 11, 'M3 CRT'),
       (643, 11, 'M3 CSL'),
       (644, 11, 'M3 GTS'),
       (645, 11, 'M3 Pickup Concept'),
       (646, 11, 'M3 Race Version'),
       (647, 11, 'M3 Saloon UK Version'),
       (648, 11, 'M3 Sedan'),
       (649, 11, 'M3 Sedan US-Version'),
       (650, 11, 'M5'),
       (651, 11, 'M5 Concept'),
       (652, 11, 'M5 Touring'),
       (653, 11, 'M5 UK Version'),
       (654, 11, 'M5 US-Version'),
       (655, 11, 'M550d xDrive'),
       (656, 11, 'M550d xDrive Touring'),
       (657, 11, 'M6'),
       (658, 11, 'M6 Cabrio'),
       (659, 11, 'M6 Convertible'),
       (660, 11, 'Z4 Coupe'),
       (661, 11, 'M6 Convertible Neiman Marcus'),
       (662, 11, 'M6 Coupe'),
       (663, 11, '7 Series High Security'),
       (664, 11, 'M6 Coupe US-Version'),
       (665, 11, 'Mille Miglia Coupe Concept'),
       (666, 11, 'Scooter C Concept'),
       (667, 11, 'X1'),
       (668, 11, 'X1 Concept'),
       (669, 11, 'X1 xDrive28i'),
       (670, 11, 'X3'),
       (671, 11, 'X3 2.0d'),
       (672, 11, 'X3 3.0i'),
       (673, 11, 'X3 EfficientDynamics Concept'),
       (674, 11, 'X3 Limited Sport Edition'),
       (675, 11, 'X3 xDrive20d'),
       (676, 11, 'X3 xDrive35i'),
       (677, 11, 'X5'),
       (678, 11, 'X5 3.0d'),
       (679, 11, 'X5 4.4i'),
       (680, 11, 'X5 4.8i'),
       (681, 11, 'X5 4.8is'),
       (682, 11, 'X5 M'),
       (683, 11, 'X5 M50d'),
       (684, 11, 'X5 M-Package'),
       (685, 11, 'X5 Security'),
       (686, 11, 'X5 Security Plus'),
       (687, 11, 'X5 xDrive35d BluePerformance'),
       (688, 11, 'X6'),
       (689, 11, 'X6 ActiveHybrid'),
       (690, 11, 'X6 ActiveHybrid Concept'),
       (691, 11, 'X6 Concept'),
       (692, 11, 'X6 M'),
       (693, 11, 'X6 M50d'),
       (694, 11, 'X6 UK Version'),
       (695, 11, '645Ci'),
       (696, 11, 'Z4'),
       (697, 11, 'Z4 2.5i'),
       (698, 11, 'Z4 Coupe Concept'),
       (699, 11, 'Z4 GT3'),
       (700, 11, '325Ci Coupe'),
       (701, 11, 'Z4 M Coupe'),
       (702, 11, '318Ci Convertible'),
       (703, 11, 'Z4 M Coupe UK version'),
       (704, 11, 'Z4 M Roadster'),
       (705, 11, 'Z4 Roadster'),
       (706, 11, 'Z4 UK Version'),
       (707, 11, 'Zagato Coupe Concept'),
       (708, 11, 'Zagato Roadster Concept'),
       (709, 11, 'xActivity Concept'),
       (710, 11, 'X5 4.6is'),
       (711, 11, 'CS1 Concept'),
       (712, 11, '7 Series'),
       (713, 11, '760i'),
       (714, 11, '760Li Yachtline Concept'),
       (715, 11, '740d'),
       (716, 11, 'Z8'),
       (717, 11, 'Z18 Concept'),
       (718, 11, 'X Coupe Concept'),
       (719, 11, 'L7'),
       (720, 11, '740iL'),
       (721, 11, '740i'),
       (722, 11, '540i Protection'),
       (723, 11, '540i M Sportpaket'),
       (724, 11, '525i'),
       (725, 11, 'Z9 Convertible Concept'),
       (726, 11, '7 Series Protection'),
       (727, 11, '750iL'),
       (728, 11, 'Z9 Gran Turismo Concept'),
       (729, 11, 'M Roadster'),
       (730, 11, 'M Coupe'),
       (731, 11, 'Z07 Concept'),
       (732, 11, 'Z3'),
       (733, 11, '3 Series Coupe'),
       (734, 11, '328i'),
       (735, 11, 'Just 4-2 Concept'),
       (736, 11, 'Z13 Concept'),
       (737, 11, 'M3 GT'),
       (738, 11, 'M3 Cabriolet'),
       (739, 11, '3 Series'),
       (740, 11, '325i'),
       (741, 11, '8 Series'),
       (742, 11, 'Z1'),
       (743, 11, 'M3 Evolution'),
       (744, 11, 'M 635 CSi'),
       (745, 11, '325i Cabrio'),
       (746, 11, 'F1 Turbo BT 52'),
       (747, 11, '524td'),
       (748, 11, 'M 535i'),
       (749, 11, '745i'),
       (750, 11, 'M1'),
       (751, 11, 'M1 Procar'),
       (752, 11, '635CSi'),
       (753, 11, '316'),
       (754, 11, '630CS'),
       (755, 11, '3.3Li'),
       (756, 11, '2002 turbo'),
       (757, 11, 'Turbo'),
       (758, 11, '3.0 CSi'),
       (759, 11, '3.0 CSL'),
       (760, 11, '2800 CS'),
       (761, 11, '2002'),
       (762, 11, '1600-2'),
       (763, 11, '02-Series'),
       (764, 11, '2000 CS'),
       (765, 11, '3200 Coupe CS'),
       (766, 11, '1500'),
       (767, 11, '503 Coupe'),
       (768, 11, '503 Cabriolet'),
       (769, 11, 'Isetta'),
       (770, 11, '507'),
       (771, 11, 'Roadster'),
       (772, 11, '502 V8'),
       (773, 11, '502 Coupe'),
       (774, 11, '501'),
       (775, 11, '328 Kamm Coupe'),
       (776, 11, '335'),
       (777, 11, '328 Touring Coupe'),
       (778, 11, '327 Coupe'),
       (779, 11, '328'),
       (780, 11, '326 Cabriolet'),
       (781, 11, '319-1 Roadster'),
       (782, 11, '315-1 Roadster'),
       (783, 11, '303 Limousine'),
       (784, 11, '320 PS Tourer'),
       (785, 11, '315 PS DA 2'),
       (786, 12, 'Arnage'),
       (787, 12, 'Continental GT V8'),
       (788, 12, 'Arnage Blue Train Series'),
       (789, 12, 'Arnage Drophead Coupe'),
       (790, 12, 'Mulsanne Diamond Jubilee'),
       (791, 12, 'Arnage Final Series'),
       (792, 12, 'Arnage Limousine'),
       (793, 12, 'Arnage R'),
       (794, 12, 'Arnage Red Label'),
       (795, 12, 'Arnage RL'),
       (796, 12, 'Mulsanne'),
       (797, 12, 'Arnage T'),
       (798, 12, 'Azure'),
       (799, 12, 'Azure Final Series'),
       (800, 12, 'Azure T'),
       (801, 12, 'Brooklands'),
       (802, 12, 'Continental Flying Spur'),
       (803, 12, 'Continental Flying Spur Series 51'),
       (804, 12, 'Continental Flying Spur Speed'),
       (805, 12, 'Continental Flying Star'),
       (806, 12, 'Continental GT'),
       (807, 12, 'Continental GTC'),
       (808, 12, 'Continental GT Prototype'),
       (809, 12, 'Continental GT Speed'),
       (810, 12, 'Continental GT Speed new'),
       (811, 12, 'Continental GT3 Concept'),
       (812, 12, 'Continental GTC Speed'),
       (813, 12, 'Continental GTC V8'),
       (814, 12, 'Continental R'),
       (815, 12, 'Continental Supersports'),
       (816, 12, 'Continental Supersports Convertible'),
       (817, 12, 'Continental T'),
       (818, 12, 'Embiricos'),
       (819, 12, 'EXP 9 F Concept'),
       (820, 12, 'EXP Speed 8'),
       (821, 12, 'GTZ Zagato Concept'),
       (822, 12, 'Mulsanne Mulliner'),
       (823, 12, 'R-Type'),
       (824, 12, 'S1 Continental'),
       (825, 12, 'State Limousine'),
       (826, 12, 'S1'),
       (827, 12, 'T1'),
       (828, 12, 'T2'),
       (829, 12, '3-Series'),
       (830, 12, '3-Series Compact'),
       (831, 12, '3-Series Convertible'),
       (832, 12, '3-Series Coupe'),
       (833, 12, 'M3 Frozen Gray'),
       (834, 12, '3-Series Long Wheelbase'),
       (835, 12, '3-Series Touring'),
       (836, 12, '5-Series Touring'),
       (837, 12, '3-Series Touring UK Version'),
       (838, 12, '3-Series UK Version'),
       (839, 12, '5 Series'),
       (840, 12, '530d'),
       (841, 12, '530d Touring'),
       (842, 12, '530i'),
       (843, 12, '530Li'),
       (844, 12, '530xi'),
       (845, 12, '530xi Touring'),
       (846, 12, '545i Touring'),
       (847, 12, '5-Series'),
       (848, 12, '5-Series ActiveHybrid Concept'),
       (849, 12, '5-Series Gran Turismo'),
       (850, 12, '5-Series Gran Turismo Concept'),
       (851, 12, '5-Series Long-Wheelbase'),
       (852, 12, '5-Series Security'),
       (853, 12, '630i'),
       (854, 12, '640d Coupe'),
       (855, 12, '640d xDrive Coupe'),
       (856, 12, '640i Gran Coupe'),
       (857, 12, '7-Series High Security'),
       (858, 12, '645Ci Convertible'),
       (859, 12, '650i Convertible'),
       (860, 12, '6-Series Convertible'),
       (861, 12, '6-Series Coupe'),
       (862, 12, '6-Series Coupe Concept'),
       (863, 12, '6-Series Gran Coupe'),
       (864, 12, '6-Series Gran Coupe UK Version'),
       (865, 12, '7 ActiveHybrid'),
       (866, 12, '730d'),
       (867, 12, '750i'),
       (868, 12, '750Li'),
       (869, 12, '750Li with Shadow Line'),
       (870, 12, '760Li'),
       (871, 12, '760Li E66'),
       (872, 12, '7-Series'),
       (873, 12, '7-Series ActiveHybrid Concept'),
       (874, 12, '7-Series UK Version'),
       (875, 12, 'Active Tourer Concept'),
       (876, 12, 'ActiveE Concept'),
       (877, 12, 'Art Car Collection'),
       (878, 12, 'Concept CS'),
       (879, 12, 'Concept M5'),
       (880, 12, 'ConnectedDrive Concept'),
       (881, 12, 'Coupe Range'),
       (882, 12, 'EfficientDynamics Concept'),
       (883, 12, 'GINA Light Visionary Model Concept'),
       (884, 12, 'Gran Coupe Concept'),
       (885, 12, 'H2R'),
       (886, 12, 'M-Zero Concept'),
       (887, 12, 'H2R Hydrogen Racecar'),
       (888, 12, 'Hydrogen 7'),
       (889, 12, 'i3 Concept'),
       (890, 12, 'i8 Concept'),
       (891, 12, 'i8 Spyder Concept'),
       (892, 12, '635d Coupe'),
       (893, 12, 'M1 Concept'),
       (894, 12, 'M135i'),
       (895, 12, 'M135i Concept'),
       (896, 12, 'M3'),
       (897, 12, 'M3 Concept'),
       (898, 12, 'M3 Convertible'),
       (899, 12, 'M3 Convertible UK Version'),
       (900, 12, 'M3 Coupe'),
       (901, 12, 'M3 Coupe UK Version'),
       (902, 12, 'M3 Coupe US-Version'),
       (903, 12, 'M3 CRT'),
       (904, 12, 'M3 CSL'),
       (905, 12, 'M3 GTS'),
       (906, 12, 'M3 Pickup Concept'),
       (907, 12, 'M3 Race Version'),
       (908, 12, 'M3 Saloon UK Version'),
       (909, 12, 'M3 Sedan'),
       (910, 12, 'M3 Sedan US-Version'),
       (911, 12, 'M5'),
       (912, 12, 'M5 Concept'),
       (913, 12, 'M5 Touring'),
       (914, 12, 'M5 UK Version'),
       (915, 12, 'M5 US-Version'),
       (916, 12, 'M550d xDrive'),
       (917, 12, 'M550d xDrive Touring'),
       (918, 12, 'M6'),
       (919, 12, 'M6 Cabrio'),
       (920, 12, 'M6 Convertible'),
       (921, 12, 'Z4 Coupe'),
       (922, 12, 'M6 Convertible Neiman Marcus'),
       (923, 12, 'M6 Coupe'),
       (924, 12, '7 Series High Security'),
       (925, 12, 'M6 Coupe US-Version'),
       (926, 12, 'Mille Miglia Coupe Concept'),
       (927, 12, 'Scooter C Concept'),
       (928, 12, 'X1'),
       (929, 12, 'X1 Concept'),
       (930, 12, 'X1 xDrive28i'),
       (931, 12, 'X3'),
       (932, 12, 'X3 2.0d'),
       (933, 12, 'X3 3.0i'),
       (934, 12, 'X3 EfficientDynamics Concept'),
       (935, 12, 'X3 Limited Sport Edition'),
       (936, 12, 'X3 xDrive20d'),
       (937, 12, 'X3 xDrive35i'),
       (938, 12, 'X5'),
       (939, 12, 'X5 3.0d'),
       (940, 12, 'X5 4.4i'),
       (941, 12, 'X5 4.8i'),
       (942, 12, 'X5 4.8is'),
       (943, 12, 'X5 M'),
       (944, 12, 'X5 M50d'),
       (945, 12, 'X5 M-Package'),
       (946, 12, 'X5 Security'),
       (947, 12, 'X5 Security Plus'),
       (948, 12, 'X5 xDrive35d BluePerformance'),
       (949, 12, 'X6'),
       (950, 12, 'X6 ActiveHybrid'),
       (951, 12, 'X6 ActiveHybrid Concept'),
       (952, 12, 'X6 Concept'),
       (953, 12, 'X6 M'),
       (954, 12, 'X6 M50d'),
       (955, 12, 'X6 UK Version'),
       (956, 12, '645Ci'),
       (957, 12, 'Z4'),
       (958, 12, 'Z4 2.5i'),
       (959, 12, 'Z4 Coupe Concept'),
       (960, 12, 'Z4 GT3'),
       (961, 12, '325Ci Coupe'),
       (962, 12, 'Z4 M Coupe'),
       (963, 12, '318Ci Convertible'),
       (964, 12, 'Z4 M Coupe UK version'),
       (965, 12, 'Z4 M Roadster'),
       (966, 12, 'Z4 Roadster'),
       (967, 12, 'Z4 UK Version'),
       (968, 12, 'Zagato Coupe Concept'),
       (969, 12, 'Zagato Roadster Concept'),
       (970, 12, 'xActivity Concept'),
       (971, 12, 'X5 4.6is'),
       (972, 12, 'CS1 Concept'),
       (973, 12, '7 Series'),
       (974, 12, '760i'),
       (975, 12, '760Li Yachtline Concept'),
       (976, 12, '740d'),
       (977, 12, 'Z8'),
       (978, 12, 'Z18 Concept'),
       (979, 12, 'X Coupe Concept'),
       (980, 12, 'L7'),
       (981, 12, '740iL'),
       (982, 12, '740i'),
       (983, 12, '540i Protection'),
       (984, 12, '540i M Sportpaket'),
       (985, 12, '525i'),
       (986, 12, 'Z9 Convertible Concept'),
       (987, 12, '7 Series Protection'),
       (988, 12, '750iL'),
       (989, 12, 'Z9 Gran Turismo Concept'),
       (990, 12, 'M Roadster'),
       (991, 12, 'M Coupe'),
       (992, 12, 'Z07 Concept'),
       (993, 12, 'Z3'),
       (994, 12, '3 Series Coupe'),
       (995, 12, '328i'),
       (996, 12, 'Just 4-2 Concept'),
       (997, 12, 'Z13 Concept'),
       (998, 12, 'M3 GT'),
       (999, 12, 'M3 Cabriolet'),
       (1000, 12, '3 Series'),
       (1001, 12, '325i'),
       (1002, 12, '8 Series'),
       (1003, 12, 'Z1'),
       (1004, 12, 'M3 Evolution'),
       (1005, 12, 'M 635 CSi'),
       (1006, 12, '325i Cabrio'),
       (1007, 12, 'F1 Turbo BT 52'),
       (1008, 12, '524td'),
       (1009, 12, 'M 535i'),
       (1010, 12, '745i'),
       (1011, 12, 'M1'),
       (1012, 12, 'M1 Procar'),
       (1013, 12, '635CSi'),
       (1014, 12, '316'),
       (1015, 12, '630CS'),
       (1016, 12, '3.3Li'),
       (1017, 12, '2002 turbo'),
       (1018, 12, 'Turbo'),
       (1019, 12, '3.0 CSi'),
       (1020, 12, '3.0 CSL'),
       (1021, 12, '2800 CS'),
       (1022, 12, '2002'),
       (1023, 12, '1600-2'),
       (1024, 12, '02-Series'),
       (1025, 12, '2000 CS'),
       (1026, 12, '3200 Coupe CS'),
       (1027, 12, '1500'),
       (1028, 12, '503 Coupe'),
       (1029, 12, '503 Cabriolet'),
       (1030, 12, 'Isetta'),
       (1031, 12, '507'),
       (1032, 12, 'Roadster'),
       (1033, 12, '502 V8'),
       (1034, 12, '502 Coupe'),
       (1035, 12, '501'),
       (1036, 12, '328 Kamm Coupe'),
       (1037, 12, '335'),
       (1038, 12, '328 Touring Coupe'),
       (1039, 12, '327 Coupe'),
       (1040, 12, '328'),
       (1041, 12, '326 Cabriolet'),
       (1042, 12, '319-1 Roadster'),
       (1043, 12, '315-1 Roadster'),
       (1044, 12, '303 Limousine'),
       (1045, 12, '320 PS Tourer'),
       (1046, 12, '315 PS DA 2'),
       (1047, 13, 'B99 GT Concept'),
       (1048, 13, 'B99 Concept'),
       (1049, 14, '800 Coupe'),
       (1050, 14, 'Bullit'),
       (1051, 14, 'Bullit Black Arrow'),
       (1052, 14, 'Bullit Coupe 800'),
       (1053, 14, 'E V12'),
       (1054, 14, 'E V12 Cabriolet'),
       (1055, 14, 'Mercedes Benz GLK V12'),
       (1056, 14, 'Mercedes-Benz A-Class'),
       (1057, 14, 'Mercedes-Benz B-Class'),
       (1058, 14, 'Mercedes-Benz C V8 Sports Coupe'),
       (1059, 14, 'Mercedes-Benz C-Class'),
       (1060, 14, 'Mercedes-Benz C-Class Sportcoupe'),
       (1061, 14, '700 Biturbo'),
       (1062, 14, 'Mercedes-Benz C-Class Wagon'),
       (1063, 14, 'Mercedes-Benz CLS'),
       (1064, 14, 'E V12 Coupe'),
       (1065, 14, 'Mercedes-Benz E-Class Cabriolet'),
       (1066, 14, 'B63 S'),
       (1067, 14, 'Mercedes-Benz E-Class Coupe'),
       (1068, 14, 'Mercedes-Benz G-Class V12 S Biturbo'),
       (1069, 14, 'Mercedes-Benz GLK-Class'),
       (1070, 14, 'Mercedes-Benz M-Class'),
       (1071, 14, 'Ultimate 112'),
       (1072, 14, 'Mercedes-Benz R-Class'),
       (1073, 14, 'Mercedes-Benz SLR Roadster'),
       (1074, 14, 'Mercedes-Benz S-Class'),
       (1075, 14, 'Mercedes-Benz SL65 AMG Black Series'),
       (1076, 14, 'Mercedes-Benz SL-Class'),
       (1077, 14, 'Mercedes-Benz SLK'),
       (1078, 14, 'Mercedes-Benz CL Coupe'),
       (1079, 14, 'Mercedes-Benz CLS B63 S'),
       (1080, 14, 'Mercedes-Benz SLK-Class'),
       (1081, 14, 'Mercedes-Benz SLS AMG'),
       (1082, 14, 'Mercedes-Benz SLS AMG Roadster'),
       (1083, 14, 'Mercedes-Benz SLS AMG Widestar'),
       (1084, 14, 'Mercedes-Benz Viano V8'),
       (1085, 14, 'Rocket'),
       (1086, 14, 'Rocket 800'),
       (1087, 14, 'Rocket Police Car'),
       (1088, 14, 'Smart fortwo'),
       (1089, 14, 'Mercedes-Benz SLR'),
       (1090, 14, 'smart fortwo electric drive'),
       (1091, 14, 'SV12 R'),
       (1092, 14, 'SV12 R Biturbo 800'),
       (1093, 14, 'SV12 S Biturbo Coupe'),
       (1094, 14, 'SV12 S Biturbo Roadster'),
       (1095, 14, 'Tesla Roadster'),
       (1096, 14, 'Ultimate 101'),
       (1097, 14, 'Ultimate 120'),
       (1098, 14, 'Smart Roadster Coupe V6 biturbo'),
       (1099, 14, 'Smart Roadster'),
       (1100, 14, 'SV 12 Bi-Turbo Roadster'),
       (1101, 14, 'Mercedes-Benz Viano'),
       (1102, 14, 'Mercedes-Benz G V12 Biturbo'),
       (1103, 14, 'Mercedes-Benz G-Class'),
       (1104, 14, 'Mercedes-Benz E V12 Concept'),
       (1105, 14, 'Mercedes-Benz E-Class'),
       (1106, 14, 'Mercedes-Benz CLK K8'),
       (1107, 14, 'Mercedes-Benz CLK'),
       (1108, 14, 'Mercedes-Benz CL'),
       (1109, 14, 'Mercedes-Benz Vaneo'),
       (1110, 14, 'Mercedes-Benz K8'),
       (1111, 14, 'Maybach'),
       (1112, 15, 'Beira'),
       (1113, 16, 'Veyron Grand Sport Vitesse'),
       (1114, 16, 'Veyron Super Sport'),
       (1115, 16, 'Veyron Grand Sport LOr Blanc'),
       (1116, 16, 'Veyron Grand Sport Sang Bleu'),
       (1117, 16, 'Veyron Grand Sport'),
       (1118, 16, 'Veyron Fbg par Hermes'),
       (1119, 16, 'Veyron Centenaire'),
       (1120, 16, 'Veyron Bleu Centenaire'),
       (1121, 16, 'Veyron'),
       (1122, 16, 'Galibier Concept'),
       (1123, 16, 'Veyron Sang Noir'),
       (1124, 16, 'Veyron Fbg par Hermes'),
       (1125, 16, 'Veyron Pur Sang'),
       (1126, 16, 'EB 164 Veyron'),
       (1127, 17, '2-2 Bengal Roadster Concept'),
       (1128, 17, 'Blackhawk Concept'),
       (1129, 17, 'Centurion Concept'),
       (1130, 17, 'Century'),
       (1131, 17, 'Cielo Concept'),
       (1132, 17, 'Enclave'),
       (1133, 17, 'Enclave Concept'),
       (1134, 17, 'Encore'),
       (1135, 17, 'Envision Concept'),
       (1136, 17, 'GL8'),
       (1137, 17, 'Business Concept'),
       (1138, 17, 'Invicta Concept'),
       (1139, 17, 'Jay Lenos Roadmaster'),
       (1140, 17, 'LaCrosse'),
       (1141, 17, 'LaCrosse CSX'),
       (1142, 17, 'LaCrosse CXS'),
       (1143, 17, 'LaCrosse GL Concept'),
       (1144, 17, 'LaCrosse Super'),
       (1145, 17, 'LeSabre'),
       (1146, 17, 'LeSabre Celebration Edition'),
       (1147, 17, 'LeSabre Custom'),
       (1148, 17, 'LeSabre Limited'),
       (1149, 17, 'Lucerne CXS'),
       (1150, 17, 'Lucerne Super'),
       (1151, 17, 'Park Avenue'),
       (1152, 17, 'Park Avenue Ultra'),
       (1153, 17, 'Rainier'),
       (1154, 17, 'Rainier CXL'),
       (1155, 17, 'Regal'),
       (1156, 17, 'Regal Abboud GS'),
       (1157, 17, 'Regal Cielo Concept'),
       (1158, 17, 'Regal GNX Show Car'),
       (1159, 17, 'Regal GS'),
       (1160, 17, 'Regal GS Concept'),
       (1161, 17, 'Rendezvous'),
       (1162, 17, 'Rendezvous CX'),
       (1163, 17, 'Rendezvous CXL'),
       (1164, 17, 'Rendezvous Ultra'),
       (1165, 17, 'Riviera'),
       (1166, 17, 'Riviera Concept Coupe'),
       (1167, 17, 'Roadmaster'),
       (1168, 17, 'Royaum'),
       (1169, 17, 'Signia Concept'),
       (1170, 17, 'Skylark'),
       (1171, 17, 'Wildcat Concept'),
       (1172, 17, 'Silver Arrow Concept'),
       (1173, 17, 'Super Convertible'),
       (1174, 17, 'Super Estate Wagon'),
       (1175, 17, 'Super Riviera Coupe'),
       (1176, 17, 'Super Riviera Sedan'),
       (1177, 17, 'Terraza'),
       (1178, 17, 'Terraza CXL'),
       (1179, 17, 'Velite Concept'),
       (1180, 17, 'Verano'),
       (1181, 17, 'Verano Turbo'),
       (1182, 17, 'XP2000 Concept'),
       (1183, 17, 'XP-300 Concept'),
       (1184, 17, 'YJob Concept'),
       (1185, 17, 'Model C'),
       (1186, 18, 'Aera Concept'),
       (1187, 18, 'ATS'),
       (1188, 18, 'BLS'),
       (1189, 18, 'BLS Show Car'),
       (1190, 18, 'CTS Coupe'),
       (1191, 18, 'BLS Wagon'),
       (1192, 18, 'Ciel Concept'),
       (1193, 18, 'Converj Concept'),
       (1194, 18, 'CTS'),
       (1195, 18, 'CTS Euro'),
       (1196, 18, 'CTS Sport Wagon'),
       (1197, 18, 'CTSV'),
       (1198, 18, 'CTS-V Black Diamond Edition'),
       (1199, 18, 'Escalade Hybrid'),
       (1200, 18, 'CTS-V Coupe'),
       (1201, 18, 'CTS-V'),
       (1202, 18, 'CTS-V Coupe Race Car'),
       (1203, 18, 'CTS-V Euro'),
       (1204, 18, 'CTSV Race Car'),
       (1205, 18, 'CTS Coupe Concept'),
       (1206, 18, 'CTS-V Sport Wagon'),
       (1207, 18, 'CTSV with Accessories'),
       (1208, 18, 'DeVille'),
       (1209, 18, 'DeVille Armored'),
       (1210, 18, 'DeVille DTS'),
       (1211, 18, 'DeVille Presidential Limousine'),
       (1212, 18, 'Escalade ESV'),
       (1213, 18, 'Escalade'),
       (1214, 18, 'BLS Sport'),
       (1215, 18, 'XLR Star Black Limited Edition'),
       (1216, 18, 'Escalade ESV Executive Edition'),
       (1217, 18, 'Escalade ESVe Limousine'),
       (1218, 18, 'DTS Limousine'),
       (1219, 18, 'DTS'),
       (1220, 18, 'Escalade ESV Platinum'),
       (1221, 18, 'Escalade European Version'),
       (1222, 18, 'Escalade EXT'),
       (1223, 18, 'Escalade Platinum'),
       (1224, 18, 'SRX Euro'),
       (1225, 18, 'Presidential Limousine'),
       (1226, 18, 'Provoq Concept'),
       (1227, 18, 'Seville'),
       (1228, 18, 'Seville SLS'),
       (1229, 18, 'XLR'),
       (1230, 18, 'Seville STS'),
       (1231, 18, 'Sixteen Concept'),
       (1232, 18, 'SLS'),
       (1233, 18, 'SRX'),
       (1234, 18, 'SRX European Version'),
       (1235, 18, 'STS'),
       (1236, 18, 'STS Euro'),
       (1237, 18, 'STS SAE 100'),
       (1238, 18, 'STSV'),
       (1239, 18, 'Urban Luxury Concept'),
       (1240, 18, 'Vizon Concept'),
       (1241, 18, 'XLR Euro'),
       (1242, 18, 'Cien Concept'),
       (1243, 18, 'XLRV'),
       (1244, 18, 'Eldorado'),
       (1245, 18, 'XTS'),
       (1246, 18, 'XTS Platinum Concept'),
       (1247, 18, 'Imaj Concept'),
       (1248, 18, 'Eldorado ETC'),
       (1249, 18, 'Evoq Concept'),
       (1250, 18, 'Allante'),
       (1251, 18, 'Voyage Concept'),
       (1252, 18, 'Eldorado Convertible'),
       (1253, 18, 'Cyclone Concept'),
       (1254, 18, 'El Camino Concept'),
       (1255, 18, 'Le Mans Concept'),
       (1256, 18, 'DeVille Coupe'),
       (1257, 18, 'Coach 2-Door'),
       (1258, 18, 'LaSalle'),
       (1259, 19, 'T1'),
       (1260, 20, 'Mercedes-Benz S-Class'),
       (1261, 20, 'Mercedes-Benz M-Class'),
       (1262, 20, 'Mercedes-Benz B-Class'),
       (1263, 20, 'Mercedes-Benz SLK'),
       (1264, 20, 'Mercedes-Benz CLS'),
       (1265, 20, 'Mercedes-Benz A-Class'),
       (1266, 20, 'Mercedes-Benz E-Class'),
       (1267, 20, 'Mercedes-Benz SL'),
       (1268, 20, 'Mercedes-Benz CLK RS'),
       (1269, 20, 'Mercedes-Benz CLK'),
       (1270, 20, 'Mercedes-Benz C-Class'),
       (1271, 20, 'Mercedes-Benz S-Class'),
       (1272, 21, 'R600 Superlight'),
       (1273, 21, 'Seven Roadsport 125 Monaco'),
       (1274, 21, 'R500'),
       (1275, 22, '34 Coupe E85 Concept'),
       (1276, 22, 'Aerovette'),
       (1277, 22, 'Agile'),
       (1278, 22, 'Astra 2.0 Flexpower Comfort'),
       (1279, 22, 'Astra 2.0 Flexpower Elegance'),
       (1280, 22, 'Astra 2.0 Flexpower Elite'),
       (1281, 22, 'Astra GSi 2.0 16V'),
       (1282, 22, 'Astro'),
       (1283, 22, 'Avalanche'),
       (1284, 22, 'Avalanche LTZ'),
       (1285, 22, 'Aveo'),
       (1286, 22, 'Aveo LS 4 Door'),
       (1287, 22, 'Aveo LS 5 Door'),
       (1288, 22, 'Aveo RS Concept'),
       (1289, 22, 'Aveo Sedan'),
       (1290, 22, 'Aveo5'),
       (1291, 22, 'Beat Concept'),
       (1292, 22, 'Bel Air Concept'),
       (1293, 22, 'Blazer'),
       (1294, 22, 'Borrego Concept'),
       (1295, 22, 'Camaro'),
       (1296, 22, 'Camaro 1LE'),
       (1297, 22, 'Camaro 45th Anniversary Edition'),
       (1298, 22, 'Camaro Black Concept'),
       (1299, 22, 'Camaro Concept'),
       (1300, 22, 'Camaro Convertible'),
       (1301, 22, 'Camaro Convertible Concept'),
       (1302, 22, 'Camaro Convertible EU Version'),
       (1303, 22, 'Camaro Convertible Neiman Marcus'),
       (1304, 22, 'Camaro COPO'),
       (1305, 22, 'Camaro Coupe'),
       (1306, 22, 'Camaro EU Version'),
       (1307, 22, 'Camaro GS Racecar Concept'),
       (1308, 22, 'Camaro Hot Wheels Edition new'),
       (1309, 22, 'Camaro LS7 Concept'),
       (1310, 22, 'Camaro Red Flash Concept'),
       (1311, 22, 'Camaro SS'),
       (1312, 22, 'Camaro SS Convertible Indy 500 Pace Car'),
       (1313, 22, 'Camaro SS Indy 500 Pace Car'),
       (1314, 22, 'Camaro SSX Concept'),
       (1315, 22, 'Camaro Transformers'),
       (1316, 22, 'Camaro ZL1'),
       (1317, 22, 'Camaro ZL1 Convertible'),
       (1318, 22, 'Caprice Police Patrol Vehicle'),
       (1319, 22, 'Captiva'),
       (1320, 22, 'Captiva Sport'),
       (1321, 22, 'Cavalier'),
       (1322, 22, 'Cavalier Coupe'),
       (1323, 22, 'Cavalier Drag'),
       (1324, 22, 'Cavalier LS'),
       (1325, 22, 'Cavalier LS Sedan'),
       (1326, 22, 'Cavalier Super Sport'),
       (1327, 22, 'Cavalier Turbo Sport'),
       (1328, 22, 'Cavalier Xtreme'),
       (1329, 22, 'Cavalier Z24R'),
       (1330, 22, 'Celta'),
       (1331, 22, 'Chevelle'),
       (1332, 22, 'Cheyenne Concept'),
       (1333, 22, 'Cobalt'),
       (1334, 22, 'Cobalt LT'),
       (1335, 22, 'Cobalt Sedan'),
       (1336, 22, 'Cobalt SS'),
       (1337, 22, 'Cobalt SS Supercharged Coupe'),
       (1338, 22, 'Code 130R Concept'),
       (1339, 22, 'Colorado'),
       (1340, 22, 'Colorado Concept'),
       (1341, 22, 'Colorado Cruz'),
       (1342, 22, 'Colorado Extended Cab'),
       (1343, 22, 'Colorado LS Crew Cab'),
       (1344, 22, 'Colorado LS Extended Cab'),
       (1345, 22, 'Colorado LS Regular Cab'),
       (1346, 22, 'Colorado LS Z71 Crew Cab'),
       (1347, 22, 'Colorado LS Z71 Extended Cab'),
       (1348, 22, 'Colorado Rally Concept'),
       (1349, 22, 'Colorado Regular Cab'),
       (1350, 22, 'Corvette'),
       (1351, 22, 'Corvette 427 Convertible'),
       (1352, 22, 'Corvette Bondurant'),
       (1353, 22, 'Corvette C1'),
       (1354, 22, 'Corvette C2'),
       (1355, 22, 'Corvette C3'),
       (1356, 22, 'Corvette C4'),
       (1357, 22, 'Corvette C5'),
       (1358, 22, 'Corvette C5-R'),
       (1359, 22, 'Corvette C6'),
       (1360, 22, 'Corvette C6R Race Car'),
       (1361, 22, 'Corvette CERV III Concept'),
       (1362, 22, 'Corvette Daytona Racecar'),
       (1363, 22, 'Corvette Grand Sport'),
       (1364, 22, 'Corvette GT1'),
       (1365, 22, 'Corvette Indy 500 Pace Car'),
       (1366, 22, 'Corvette Indy Concept Car'),
       (1367, 22, 'Corvette Mako Shark Concept'),
       (1368, 22, 'Corvette Manta Ray Concept'),
       (1369, 22, 'Corvette Sting Ray III Concept'),
       (1370, 22, 'Corvette Z06'),
       (1371, 22, 'Corvette Z06 Carbon Limited Edition'),
       (1372, 22, 'Corvette Z06 Centennial Edition'),
       (1373, 22, 'Corvette Z06 Commemorative Edition'),
       (1374, 22, 'Corvette Z06 Daytona 500 Pace Car'),
       (1375, 22, 'Corvette Z06X Concept'),
       (1376, 22, 'Corvette ZR1'),
       (1377, 22, 'Cruze'),
       (1378, 22, 'Cruze Hatchback'),
       (1379, 22, 'Cruze Station Wagon'),
       (1380, 22, 'Cruze WTCC'),
       (1381, 22, 'Electric S-10 Concept'),
       (1382, 22, 'Epica'),
       (1383, 22, 'Equinox'),
       (1384, 22, 'Equinox Sport'),
       (1385, 22, 'Express'),
       (1386, 22, 'GPiX Concept'),
       (1387, 22, 'Groove Concept'),
       (1388, 22, 'HHR LT'),
       (1389, 22, 'HHR Panel'),
       (1390, 22, 'HHR SS'),
       (1391, 22, 'Impala'),
       (1392, 22, 'Impala LS'),
       (1393, 22, 'Impala Police Package'),
       (1394, 22, 'Impala Police Vehicle'),
       (1395, 22, 'Impala Sedan'),
       (1396, 22, 'Impala SS'),
       (1397, 22, 'Impala Super Sport'),
       (1398, 22, 'Jay Lenos Corvette C6RS E85'),
       (1399, 22, 'Journey Concept'),
       (1400, 22, 'K5 Concept'),
       (1401, 22, 'Kodiak'),
       (1402, 22, 'Kodiak C4500'),
       (1403, 22, 'Lumina'),
       (1404, 22, 'Lumina SS'),
       (1405, 22, 'Malibu'),
       (1406, 22, 'Malibu ECO'),
       (1407, 22, 'Malibu LT'),
       (1408, 22, 'Malibu LTZ'),
       (1409, 22, 'Malibu Maxx'),
       (1410, 22, 'Malibu Maxx SS'),
       (1411, 22, 'Malibu Sedan'),
       (1412, 22, 'Malibu SS'),
       (1413, 22, 'Malibu XTC'),
       (1414, 22, 'Matiz'),
       (1415, 22, 'Matiz M3X Concept'),
       (1416, 22, 'Miray Concept'),
       (1417, 22, 'Monte Carlo'),
       (1418, 22, 'Monte Carlo Brickyard Pace Car'),
       (1419, 22, 'Monte Carlo Dale Earnhardt Edition'),
       (1420, 22, 'Monte Carlo High Sport'),
       (1421, 22, 'Monte Carlo Looney Tunes'),
       (1422, 22, 'Monte Carlo SS'),
       (1423, 22, 'Nomad'),
       (1424, 22, 'Nomad Concept'),
       (1425, 22, 'Nubira Station Wagon WTCC R'),
       (1426, 22, 'Onix new'),
       (1427, 22, 'Orlando'),
       (1428, 22, 'Orlando Concept'),
       (1429, 22, 'S-10'),
       (1430, 22, 'S3X Concept'),
       (1431, 22, 'Sail'),
       (1432, 22, 'Sequel Concept'),
       (1433, 22, 'Silverado'),
       (1434, 22, 'Silverado 2500 HD LTZ Extended Cab'),
       (1435, 22, 'Silverado 3500 HD LTZ Crew Cab'),
       (1436, 22, 'Silverado Crew Cab'),
       (1437, 22, 'Silverado Extended Cab'),
       (1438, 22, 'Silverado HD'),
       (1439, 22, 'Silverado Hybrid'),
       (1440, 22, 'Silverado Hydrogen Military Vehicle'),
       (1441, 22, 'Silverado Intimidator SS'),
       (1442, 22, 'Silverado Regular Cab'),
       (1443, 22, 'Silverado SS'),
       (1444, 22, 'Silverado SS Pace Truck'),
       (1445, 22, 'Silverado Z71 Extended Cab'),
       (1446, 22, 'SOCAL SSR Bonneville Salt Flats'),
       (1447, 22, 'Sonic'),
       (1448, 22, 'Sonic RS'),
       (1449, 22, 'Sonic Sedan'),
       (1450, 22, 'Spark'),
       (1451, 22, 'SS Concept'),
       (1452, 22, 'SSR'),
       (1453, 22, 'SSR Concept'),
       (1454, 22, 'SSR Hot Rod Power Tour Concept'),
       (1455, 22, 'SSR Indy 500 Pace Vehicle'),
       (1456, 22, 'Stingray Concept'),
       (1457, 22, 'Stingray Racer Concept'),
       (1458, 22, 'Suburban'),
       (1459, 22, 'Suburban LTZ'),
       (1460, 22, 'Tahoe'),
       (1461, 22, 'Tracker'),
       (1462, 22, 'Tracker Turbo'),
       (1463, 22, 'Trailblazer'),
       (1464, 22, 'TrailBlazer Concept'),
       (1465, 22, 'TrailBlazer SS'),
       (1466, 22, 'TrailBlazer Vortec'),
       (1467, 22, 'Traverse'),
       (1468, 22, 'Trax'),
       (1469, 22, 'Trax Concept'),
       (1470, 22, 'Tru 140S Concept'),
       (1471, 22, 'Uplander'),
       (1472, 22, 'Venture'),
       (1473, 22, 'Volt'),
       (1474, 22, 'Volt Concept'),
       (1475, 22, 'Volt MPV5 Concept'),
       (1476, 22, 'West Coast Customs HHR'),
       (1477, 22, 'WTCC Ultra Concept'),
       (1478, 22, 'YGM1 Concept'),
       (1479, 22, 'ZR2 Shark Concept'),
       (1480, 23, '200'),
       (1481, 23, '300'),
       (1482, 23, '200 Convertible'),
       (1483, 23, '200 S'),
       (1484, 23, '200C EV Concept'),
       (1485, 23, '300 HEMI C Convertible Concept'),
       (1486, 23, '300 Luxury Series'),
       (1487, 23, '300 SRT8'),
       (1488, 23, '300C'),
       (1489, 23, '300C Concept'),
       (1490, 23, '300C Heritage Edition'),
       (1491, 23, '300C SRT UK Version'),
       (1492, 23, '300C SRT8'),
       (1493, 23, '300C SRT8 Touring'),
       (1494, 23, '300C Touring'),
       (1495, 23, '300C Touring Concept'),
       (1496, 23, '300C Touring SRT UK Version'),
       (1497, 23, '300C Touring UK Version'),
       (1498, 23, '300C UK Version'),
       (1499, 23, '300M'),
       (1500, 23, 'Airflite Concept'),
       (1501, 23, 'Akino Concept'),
       (1502, 23, 'Aspen'),
       (1503, 23, 'Atlantic Concept'),
       (1504, 23, 'California Cruiser Concept'),
       (1505, 23, 'Chronos Concept'),
       (1506, 23, 'Citadel Concept'),
       (1507, 23, 'Crossfire'),
       (1508, 23, 'Crossfire Concept'),
       (1509, 23, 'Crossfire Roadster'),
       (1510, 23, 'Crossfire Roadster UK Version'),
       (1511, 23, 'Crossfire SRT6'),
       (1512, 23, 'Crossfire SRT6 Roadster'),
       (1513, 23, 'Crossfire UK Version'),
       (1514, 23, 'Delta'),
       (1515, 23, 'ecoVoyager Concept'),
       (1516, 23, 'EV Concept'),
       (1517, 23, 'Firepower Concept'),
       (1518, 23, 'GEM Peapod'),
       (1519, 23, 'GT Cruiser Concept'),
       (1520, 23, 'Imperial Concept'),
       (1521, 23, 'Java Concept'),
       (1522, 23, 'ME FourTwelve Concept'),
       (1523, 23, 'Nassau Concept'),
       (1524, 23, 'Pacifica'),
       (1525, 23, 'Pacifica Concept'),
       (1526, 23, 'Panel Cruiser Concept'),
       (1527, 23, 'Pronto Cruizer Concept'),
       (1528, 23, 'PT Cruiser'),
       (1529, 23, 'PT Cruiser Convertible'),
       (1530, 23, 'PT Street Cruiser Pacific Coast Highway'),
       (1531, 23, 'Sebring'),
       (1532, 23, 'Sebring Convertible'),
       (1533, 23, 'Sebring UK Version'),
       (1534, 23, 'Thunderbolt Concept'),
       (1535, 23, 'Town and Country'),
       (1536, 23, 'Ypsilon'),
       (1537, 24, '2CV 6 Charleston'),
       (1538, 24, '2CV Berline'),
       (1539, 24, '2CV Spcial'),
       (1540, 24, '2CV Spot'),
       (1541, 24, 'Berlingo Multispace'),
       (1542, 24, 'C1'),
       (1543, 24, 'C1 3door'),
       (1544, 24, 'C1 5door'),
       (1545, 24, 'C2'),
       (1546, 24, 'C3'),
       (1547, 24, 'C3 Picasso'),
       (1548, 24, 'C3 Pluriel'),
       (1549, 24, 'C3 Pluriel Charleston'),
       (1550, 24, 'C3 Pluriel HDi 70'),
       (1551, 24, 'C3 VTR'),
       (1552, 24, 'C3 X-TR'),
       (1553, 24, 'C4'),
       (1554, 24, 'C4 Aircross'),
       (1555, 24, 'C4 Coupe'),
       (1556, 24, 'C4 Coupe Enterprise'),
       (1557, 24, 'C4 Coupe with Panoramic Sunroof'),
       (1558, 24, 'C4 L'),
       (1559, 24, 'C4 notchback'),
       (1560, 24, 'C4 Picasso'),
       (1561, 24, 'C4 Sedan'),
       (1562, 24, 'C4 Sport Concept'),
       (1563, 24, 'C4 WRC HYmotion4 Concept'),
       (1564, 24, 'C5'),
       (1565, 24, 'C5 Airscape Concept'),
       (1566, 24, 'C5 Break'),
       (1567, 24, 'C5 Estate'),
       (1568, 24, 'C6'),
       (1569, 24, 'C8 Exclusive'),
       (1570, 24, 'C-Airdream Concept'),
       (1571, 24, 'CAirlounge Concept'),
       (1572, 24, 'C-Airplay Concept'),
       (1573, 24, 'C-Buggy Concept'),
       (1574, 24, 'C-Cactus Concept'),
       (1575, 24, 'C-Crosser'),
       (1576, 24, 'C-Crosser Concept'),
       (1577, 24, 'C-Elysee'),
       (1578, 24, 'C-Metisse Concept'),
       (1579, 24, 'Cruise Crosser Concept'),
       (1580, 24, 'C-SportLounge Concept Car'),
       (1581, 24, 'C-Zero'),
       (1582, 24, 'DS 19'),
       (1583, 24, 'DS 19 Cabrio'),
       (1584, 24, 'DS 21'),
       (1585, 24, 'DS 21 Berline'),
       (1586, 24, 'DS 21 Cabrio'),
       (1587, 24, 'DS 23 Break'),
       (1588, 24, 'DS 23 IE'),
       (1589, 24, 'DS High Rider Concept'),
       (1590, 24, 'DS Inside Concept'),
       (1591, 24, 'DS3'),
       (1592, 24, 'DS3 Cabrio'),
       (1593, 24, 'DS3 R3'),
       (1594, 24, 'DS3 Racing'),
       (1595, 24, 'DS4'),
       (1596, 24, 'DS4 Racing Concept'),
       (1597, 24, 'DS5'),
       (1598, 24, 'GQ Concept'),
       (1599, 24, 'Grand C4 Picasso'),
       (1600, 24, 'GT Concept'),
       (1601, 24, 'Hypnos Concept'),
       (1602, 24, 'Lacoste Concept'),
       (1603, 24, 'Metropolis Concept'),
       (1604, 24, 'Numero 9 Concept'),
       (1605, 24, 'REVOLTe Concept'),
       (1606, 24, 'SM'),
       (1607, 24, 'SM Automat'),
       (1608, 24, 'SM Presidential'),
       (1609, 24, 'Survolt Concept'),
       (1610, 24, 'Traction Avant 11B Cabrio'),
       (1611, 24, 'Tubik Concept'),
       (1612, 24, 'Xsara Picasso'),
       (1613, 25, 'C6W Spider'),
       (1614, 25, 'C6W'),
       (1615, 25, 'T40'),
       (1616, 25, 'B24'),
       (1617, 26, 'Dokker'),
       (1618, 26, 'Dokker Van'),
       (1619, 26, 'Duster Trophee Andros'),
       (1620, 26, 'Lodgy'),
       (1621, 26, 'Logan'),
       (1622, 26, 'Duster'),
       (1623, 26, 'Logan 1.4 MPI'),
       (1624, 26, 'Logan 1.6 MPI'),
       (1625, 26, 'Logan MCV'),
       (1626, 26, 'Logan Pickup'),
       (1627, 26, 'Duster Concept'),
       (1628, 26, 'Logan Steppe Concept'),
       (1629, 26, 'Logan Van'),
       (1630, 26, 'Sandero'),
       (1631, 26, 'Sandero Stepway'),
       (1632, 27, 'Matiz Creative'),
       (1633, 27, 'L4X'),
       (1634, 27, 'Nubira Station Wagon CDX'),
       (1635, 27, 'Lacetti SX'),
       (1636, 27, 'Lacetti CDX'),
       (1637, 28, 'ai Concept'),
       (1638, 28, 'Charade'),
       (1639, 28, 'Compagno Berlina 800'),
       (1640, 28, 'Copen'),
       (1641, 28, 'Cuore'),
       (1642, 28, 'Extol Compact Van'),
       (1643, 28, 'Fourtrak'),
       (1644, 28, 'Grand Move'),
       (1645, 28, 'Hijet'),
       (1646, 28, 'Materia'),
       (1647, 28, 'Max Concept'),
       (1648, 28, 'Move'),
       (1649, 28, 'PICO Concept'),
       (1650, 28, 'Sirion'),
       (1651, 28, 'Sportrak'),
       (1652, 28, 'Terios'),
       (1653, 28, 'Terios Kiri'),
       (1654, 28, 'Terios Sport'),
       (1655, 28, 'UFE2 Concept'),
       (1656, 28, 'YRV'),
       (1657, 28, 'YRV Turbo 130'),
       (1658, 29, 'Super Eight'),
       (1659, 30, 'Deauville Concept'),
       (1660, 31, 'GTX'),
       (1661, 32, 'Airflow Tanker Truck'),
       (1662, 32, 'Avenger'),
       (1663, 32, 'Avenger Concept'),
       (1664, 32, 'Avenger NASCAR Race Car'),
       (1665, 32, 'Avenger RT'),
       (1666, 32, 'Aviat Concept'),
       (1667, 32, 'Big Red Truck Concept'),
       (1668, 32, 'Caliber'),
       (1669, 32, 'Caliber Concept'),
       (1670, 32, 'Caliber SRT4'),
       (1671, 32, 'Caravan'),
       (1672, 32, 'Caravan RT Concept'),
       (1673, 32, 'Caravan SXT'),
       (1674, 32, 'Challenger Concept'),
       (1675, 32, 'Challenger Mopar'),
       (1676, 32, 'Challenger Rallye Redline'),
       (1677, 32, 'Challenger RT'),
       (1678, 32, 'Challenger SRT10 Concept'),
       (1679, 32, 'Challenger SRT8'),
       (1680, 32, 'Challenger SRT8 392'),
       (1681, 32, 'Challenger SRT8 392 Yellow Jacket'),
       (1682, 32, 'Challenger SRT8 Silver'),
       (1683, 32, 'Challenger TA'),
       (1684, 32, 'Challenger Targa Concept'),
       (1685, 32, 'Challenger V10 Mopar Drag Pak'),
       (1686, 32, 'Charger'),
       (1687, 32, 'Charger Daytona'),
       (1688, 32, 'Charger Daytona RT'),
       (1689, 32, 'Charger Mopar'),
       (1690, 32, 'Charger Police Vehicle'),
       (1691, 32, 'Charger Pursuit'),
       (1692, 32, 'Charger Race Car'),
       (1693, 32, 'Charger RT'),
       (1694, 32, 'Charger RT Concept Vehicle'),
       (1695, 32, 'Charger SRT8'),
       (1696, 32, 'Charger SRT8 Super Bee'),
       (1697, 32, 'Charger SXT'),
       (1698, 32, 'Circuit EV'),
       (1699, 32, 'Coronet Police Vehicle'),
       (1700, 32, 'Dakota'),
       (1701, 32, 'Dakota Club Cab'),
       (1702, 32, 'Dakota NHRA Pro Stock Truck'),
       (1703, 32, 'Dakota Quad Cab'),
       (1704, 32, 'Dakota RT'),
       (1705, 32, 'Dakota Sport V8 Concept'),
       (1706, 32, 'Dart'),
       (1707, 32, 'Daytona RT Concept'),
       (1708, 32, 'Demon Roadster Concept'),
       (1709, 32, 'Durango'),
       (1710, 32, 'Durango 4x4 Sport'),
       (1711, 32, 'Durango Limited'),
       (1712, 32, 'Durango RT'),
       (1713, 32, 'Durango SLT'),
       (1714, 32, 'Epic Concept'),
       (1715, 32, 'ESX3 Concept'),
       (1716, 32, 'EV Concept'),
       (1717, 32, 'Grand Caravan'),
       (1718, 32, 'Grand Caravan ES'),
       (1719, 32, 'Grand Caravan RT'),
       (1720, 32, 'Hornet Concept'),
       (1721, 32, 'Hot Wheels Quad Cab Concept'),
       (1722, 32, 'Intrepid Concept'),
       (1723, 32, 'Intrepid ESX2 Concept'),
       (1724, 32, 'Journey'),
       (1725, 32, 'Kahuna Concept'),
       (1726, 32, 'LRT Concept'),
       (1727, 32, 'M80 Concept'),
       (1728, 32, 'Magnum Police Vehicle'),
       (1729, 32, 'Magnum RT'),
       (1730, 32, 'Magnum SRT8'),
       (1731, 32, 'Magnum SRT8 Concept'),
       (1732, 32, 'Magnum SXT'),
       (1733, 32, 'Maxx Concept'),
       (1734, 32, 'Neon'),
       (1735, 32, 'Neon Concept'),
       (1736, 32, 'Neon RT'),
       (1737, 32, 'Neon Sedan'),
       (1738, 32, 'Neon Sport Coupe'),
       (1739, 32, 'Neon SRT Concept'),
       (1740, 32, 'Nitro Concept'),
       (1741, 32, 'Nitro RT'),
       (1742, 32, 'Nitro SLT'),
       (1743, 32, 'Power Wagon Concept'),
       (1744, 32, 'PowerBox Concept'),
       (1745, 32, 'Ram'),
       (1746, 32, 'Ram 1500'),
       (1747, 32, 'Ram 1500 Off-Road'),
       (1748, 32, 'Ram 1500 Sport'),
       (1749, 32, 'Ram 1500 with Optional HEMI Power'),
       (1750, 32, 'Ram 3500'),
       (1751, 32, 'Ram Diesel Hybrid Electric Vehicle HEV'),
       (1752, 32, 'Ram Heavy Duty'),
       (1753, 32, 'Ram Heavy Duty Cummins 600'),
       (1754, 32, 'Ram Laramie Limited'),
       (1755, 32, 'Ram Laramie Longhorn'),
       (1756, 32, 'Ram Long-Hauler Concept'),
       (1757, 32, 'Ram Mega Cab'),
       (1758, 32, 'Ram NASCAR Craftsman Truck Series'),
       (1759, 32, 'Ram Outdoorsman'),
       (1760, 32, 'Ram Power Wagon'),
       (1761, 32, 'Ram Quad Cab'),
       (1762, 32, 'Ram SRT10'),
       (1763, 32, 'Ram T-Rex Concept'),
       (1764, 32, 'Ram Van'),
       (1765, 32, 'Ram VTS Concept'),
       (1766, 32, 'Ram Wagon'),
       (1767, 32, 'Rampage Concept'),
       (1768, 32, 'Razor Concept'),
       (1769, 32, 'Sidewinder Concept'),
       (1770, 32, 'Sling Shot Concept'),
       (1771, 32, 'SRT Viper GTS'),
       (1772, 32, 'SRT Viper GTS Launch Edition'),
       (1773, 32, 'SRT Viper GTS-R'),
       (1774, 32, 'SRT4'),
       (1775, 32, 'Stratus'),
       (1776, 32, 'Stratus Coupe'),
       (1777, 32, 'Stratus RT Coupe'),
       (1778, 32, 'Stratus Sedan'),
       (1779, 32, 'Stratus Turbo'),
       (1780, 32, 'Super8 Concept'),
       (1781, 32, 'Super8 Hemi Concept'),
       (1782, 32, 'Tomahawk Concept'),
       (1783, 32, 'Venom Concept'),
       (1784, 32, 'Viper'),
       (1785, 32, 'Viper ACR'),
       (1786, 32, 'Viper Competition Coupe'),
       (1787, 32, 'Viper GT2'),
       (1788, 32, 'Viper GTS'),
       (1789, 32, 'Viper GTS Coupe'),
       (1790, 32, 'Viper GTS-R'),
       (1791, 32, 'Viper RT'),
       (1792, 32, 'Viper RT10'),
       (1793, 32, 'Viper RT10 Concept Vehicle'),
       (1794, 32, 'Viper RT10 Roadster'),
       (1795, 32, 'Viper SRT10'),
       (1796, 32, 'Viper SRT10 ACR'),
       (1797, 32, 'Viper SRT10 ACR-X'),
       (1798, 32, 'Viper SRT10 Coupe'),
       (1799, 32, 'Viper SRT10 Roadster'),
       (1800, 32, 'ZEO Concept'),
       (1801, 33, 'D8 GT'),
       (1802, 33, 'D8'),
       (1803, 34, 'Light Car Concept'),
       (1804, 34, 'LUV Concept'),
       (1805, 34, 'Pontiac Solstice Hard Top Concept'),
       (1806, 34, 'Biwak Concep'),
       (1807, 34, 'Showcar'),
       (1808, 34, 'Show Car No 8'),
       (1809, 34, 'genX Concept'),
       (1810, 34, 'Keinath GTC Coupe'),
       (1811, 34, 'Cinema 7D'),
       (1812, 35, 'Aston Martin DBS'),
       (1813, 35, 'Bentley Continental GT Speed'),
       (1814, 35, 'Ferrari 575 Maranello'),
       (1815, 35, 'Ferrari California'),
       (1816, 35, 'Ferrari Enzo XX Evolution'),
       (1817, 35, 'Ferrari FXX'),
       (1818, 35, 'Ford GT'),
       (1819, 35, 'Koenigsegg CCR'),
       (1820, 35, 'Lamborghini Gallardo'),
       (1821, 35, 'Lamborghini Gallardo Spyder'),
       (1822, 35, 'Lamborghini Gallardo Superleggera'),
       (1823, 35, 'Lamborghini Murcielago LP640 Nardo'),
       (1824, 35, 'Lamborghini Murcielago LP710 Audigier'),
       (1825, 35, 'Lamborghini Murcielago LP750'),
       (1826, 35, 'Maserati MC12 XX'),
       (1827, 35, 'Mercedes-Benz C63 AMG'),
       (1828, 35, 'Porsche 996 GT2 R'),
       (1829, 35, 'Porsche 996 GT2 RS'),
       (1830, 35, 'Porsche 996 Turbo Red-Black'),
       (1831, 35, 'Porsche Cayenne Turbo'),
       (1832, 36, 'Streamliner MS8'),
       (1833, 36, 'Clubman MS8'),
       (1834, 37, 'Artemis'),
       (1835, 37, 'Hemera Concept'),
       (1836, 38, 'Evantra'),
       (1837, 38, 'Vulca S'),
       (1838, 38, 'Antas V8 GT'),
       (1839, 39, 'BF MkII Force 6'),
       (1840, 39, 'BF MkII Force 8'),
       (1841, 39, 'BF MkII GT'),
       (1842, 39, 'BF MkII GT-P'),
       (1843, 39, 'BF MkII Pursuit'),
       (1844, 39, 'BF MkII Super Pursuit'),
       (1845, 39, 'Cobra Ute'),
       (1846, 39, 'F6 R-Spec Typhoon'),
       (1847, 39, 'F6X'),
       (1848, 39, 'Falcon F6'),
       (1849, 39, 'Falcon F6 Ute'),
       (1850, 39, 'GT'),
       (1851, 39, 'GT 40th Anniversary'),
       (1852, 39, 'GT Cobra'),
       (1853, 39, 'GT-E'),
       (1854, 39, 'GT-P'),
       (1855, 39, 'Super Pursuit'),
       (1856, 40, 'GTS'),
       (1857, 41, '288 GTO'),
       (1858, 41, '360 Challenge Stradale'),
       (1859, 41, '360 Modena'),
       (1860, 41, '360 Modena Challenge'),
       (1861, 41, '360 Spider'),
       (1862, 41, '360GTC Fiorano'),
       (1863, 41, '430 Scuderia');
INSERT INTO `models` (`id`, `make_id`, `name`)
VALUES (1864, 41, '456M GT'),
       (1865, 41, '456M GT Scaglietti'),
       (1866, 41, '458 Challenge'),
       (1867, 41, '458 Italia'),
       (1868, 41, '458 Italia China 20th Anniversary'),
       (1869, 41, '458 Italia Grand Am'),
       (1870, 41, '458 Spider'),
       (1871, 41, '512 TR'),
       (1872, 41, '550 Barchetta Pininfarina'),
       (1873, 41, '550 Maranello'),
       (1874, 41, '575 GTC Evoluzione'),
       (1875, 41, '575 GTZ Zagato'),
       (1876, 41, '575GTC'),
       (1877, 41, '575M Maranello'),
       (1878, 41, '575M Superamerica'),
       (1879, 41, '599 GTB Fiorano'),
       (1880, 41, '599 GTB Fiorano China'),
       (1881, 41, '599 GTB Fiorano HGTE'),
       (1882, 41, '599 GTB Fiorano One-to-One'),
       (1883, 41, '599 GTB HY-KERS Concept'),
       (1884, 41, '599 GTO'),
       (1885, 41, '599 SA Aperta'),
       (1886, 41, '599XX'),
       (1887, 41, '612 Scaglietti'),
       (1888, 41, '612 Scaglietti One-to-One'),
       (1889, 41, '612 Scaglietti Wallpaper'),
       (1890, 41, 'California'),
       (1891, 41, 'Design Competition'),
       (1892, 41, 'Enzo'),
       (1893, 41, 'F12berlinetta'),
       (1894, 41, 'F2005'),
       (1895, 41, 'F40'),
       (1896, 41, 'F430'),
       (1897, 41, 'F430 Challenge'),
       (1898, 41, 'F430 Spider'),
       (1899, 41, 'F50'),
       (1900, 41, 'FF'),
       (1901, 41, 'FF Blue'),
       (1902, 41, 'FF Silver'),
       (1903, 41, 'FXX'),
       (1904, 41, 'FXX Evolution'),
       (1905, 41, 'P540 Superfast Aperta'),
       (1906, 41, 'Scuderia Spider 16M'),
       (1907, 41, 'SP12 EC'),
       (1908, 42, '125'),
       (1909, 42, '126'),
       (1910, 42, '127'),
       (1911, 42, '128'),
       (1912, 42, '500'),
       (1913, 42, '505'),
       (1914, 42, '510'),
       (1915, 42, '520'),
       (1916, 42, '525'),
       (1917, 42, '600'),
       (1918, 42, '1400'),
       (1919, 42, '1500'),
       (1920, 42, '1800'),
       (1921, 42, '110 HP'),
       (1922, 42, '1100 D'),
       (1923, 42, '1100 D Station Wagon'),
       (1924, 42, '1100 E'),
       (1925, 42, '1100 R Station Wagon'),
       (1926, 42, '12 HP'),
       (1927, 42, '1200 Granluce Berlina'),
       (1928, 42, '12-15 HP Zero'),
       (1929, 42, '124 Familiare'),
       (1930, 42, '124 Saloon'),
       (1931, 42, '124 Special'),
       (1932, 42, '124 Sport Spider'),
       (1933, 42, '125 Special'),
       (1934, 42, '127 Diesel'),
       (1935, 42, '127 Panorama'),
       (1936, 42, '128 Rally'),
       (1937, 42, '130 2800 Limousine'),
       (1938, 42, '130 HP Grand Prix de France Corsa'),
       (1939, 42, '131 Abarth Rally'),
       (1940, 42, '131 Mirafiori'),
       (1941, 42, '131 Racing'),
       (1942, 42, '131 Supermirafiori'),
       (1943, 42, '132 1600 GL'),
       (1944, 42, '132 Diesel'),
       (1945, 42, '132 GLS 1800'),
       (1946, 42, '1400 Cabriolet'),
       (1947, 42, '1500 L'),
       (1948, 42, '1500 S Cabriolet'),
       (1949, 42, '15-25 HP Brevetti Tipo 2'),
       (1950, 42, '16-20 HP'),
       (1951, 42, '18-24 HP'),
       (1952, 42, '20-30 HP'),
       (1953, 42, '2300 Saloon'),
       (1954, 42, '2300 Station Wagon'),
       (1955, 42, '24 HP Corsa'),
       (1956, 42, '2800 Berlina'),
       (1957, 42, '28-40 HP Corsa Targa Florio'),
       (1958, 42, '3 1-2 HP'),
       (1959, 42, '30-45 HP Tipo 4'),
       (1960, 42, '500 Abarth'),
       (1961, 42, '500 Abarth Assetto Corse'),
       (1962, 42, '500 Abarth esseesse'),
       (1963, 42, '500 Abarth R3T'),
       (1964, 42, '500 Barbie Concept'),
       (1965, 42, '500 Coupe Zagato Concept'),
       (1966, 42, '500 Sport'),
       (1967, 42, '500C'),
       (1968, 42, '500C Abarth'),
       (1969, 42, '500C Abarth esseesse'),
       (1970, 42, '500L'),
       (1971, 42, '501 S Torpedo Sport'),
       (1972, 42, '501 Saloon'),
       (1973, 42, '501 SS'),
       (1974, 42, '507 Touring'),
       (1975, 42, '508 Balilla 3 Marce'),
       (1976, 42, '508 Balilla Sport'),
       (1977, 42, '508 C Balilla 1100'),
       (1978, 42, '512 Torpedo'),
       (1979, 42, '514 Saloon'),
       (1980, 42, '518 Ardita 2000'),
       (1981, 42, '519 S'),
       (1982, 42, '521 C'),
       (1983, 42, '522 C'),
       (1984, 42, '525 Touring'),
       (1985, 42, '527 Ardita 2500'),
       (1986, 42, '600 50th'),
       (1987, 42, '695 Abarth Maserati Edition'),
       (1988, 42, '695 Abarth Tributo Ferrari'),
       (1989, 42, '75 HP Corsa'),
       (1990, 42, '801-402 Corsa'),
       (1991, 42, '804-404 Corsa'),
       (1992, 42, '805-405 Corsa'),
       (1993, 42, '806 Corsa'),
       (1994, 42, '850 Special'),
       (1995, 42, '850 Spider'),
       (1996, 42, '8V'),
       (1997, 42, '900 E Panorama'),
       (1998, 42, 'Albea'),
       (1999, 42, 'Argenta'),
       (2000, 42, 'Barchetta'),
       (2001, 42, 'Barchetta First Class of Alviero Martini'),
       (2002, 42, 'Bravo'),
       (2003, 42, 'Bravo 1.6 Multijet 16v'),
       (2004, 42, 'Brevetti'),
       (2005, 42, 'Campagnola'),
       (2006, 42, 'Campagnola A'),
       (2007, 42, 'Cinquecento Elettra'),
       (2008, 42, 'Cinquecento Sporting 1.1i'),
       (2009, 42, 'Croma'),
       (2010, 42, 'Dino Spider'),
       (2011, 42, 'Doblo'),
       (2012, 42, 'Doblo Cargo'),
       (2013, 42, 'Fiacre'),
       (2014, 42, 'Fiorino'),
       (2015, 42, 'Fiorino Qubo'),
       (2016, 42, 'Freemont'),
       (2017, 42, 'Freemont AWD'),
       (2018, 42, 'Grande Punto'),
       (2019, 42, 'Grande Punto Abarth'),
       (2020, 42, 'Grande Punto Abarth Preview'),
       (2021, 42, 'Grande Punto Abarth S2000'),
       (2022, 42, 'Grande Punto Natural Power'),
       (2023, 42, 'Idea'),
       (2024, 42, 'Idea 1.4 16v Emotion'),
       (2025, 42, 'Idea 1.9 Multijet Dynamic'),
       (2026, 42, 'Idea 5terre Concept'),
       (2027, 42, 'Linea'),
       (2028, 42, 'Marrakech Concept'),
       (2029, 42, 'Mefistofele Eldridge Record'),
       (2030, 42, 'Multipla'),
       (2031, 42, 'Oltre Concept'),
       (2032, 42, 'Palio'),
       (2033, 42, 'Palio Weekend'),
       (2034, 42, 'Panda'),
       (2035, 42, 'Panda 100HP'),
       (2036, 42, 'Panda 4x4'),
       (2037, 42, 'Panda 4x4 1.3 Multijet'),
       (2038, 42, 'Panda Actual'),
       (2039, 42, 'Panda Alessi'),
       (2040, 42, 'Panda Cross'),
       (2041, 42, 'Panda Dynamic'),
       (2042, 42, 'Panda Elettra'),
       (2043, 42, 'Panda Emotion'),
       (2044, 42, 'Panda Multi Eco Concept'),
       (2045, 42, 'Panda Trekking'),
       (2046, 42, 'Panda UK Version'),
       (2047, 42, 'Portofino Concept'),
       (2048, 42, 'Punto'),
       (2049, 42, 'Punto Active'),
       (2050, 42, 'Punto Dynamic'),
       (2051, 42, 'Punto Evo'),
       (2052, 42, 'Punto Evo Abarth'),
       (2053, 42, 'Punto Evo Abarth esseesse'),
       (2054, 42, 'Punto Natural Power'),
       (2055, 42, 'Punto Rally'),
       (2056, 42, 'Punto Sporting'),
       (2057, 42, 'Regata 100 Weekend'),
       (2058, 42, 'Regata 75'),
       (2059, 42, 'Ritmo'),
       (2060, 42, 'Ritmo S 85 Cabrio Bertone'),
       (2061, 42, 'Ritmo Supercabrio'),
       (2062, 42, 'S.57-14B Corsa'),
       (2063, 42, 'S.74 Corsa'),
       (2064, 42, 'S.76 300 HP Record'),
       (2065, 42, 'Sedici'),
       (2066, 42, 'Seicento'),
       (2067, 42, 'Simba Concept'),
       (2068, 42, 'Stilo'),
       (2069, 42, 'Stilo Abarth'),
       (2070, 42, 'Stilo Active'),
       (2071, 42, 'Stilo Dynamic'),
       (2072, 42, 'Stilo M.Y. 1.9 Multijet 5door'),
       (2073, 42, 'Stilo Multi Wagon'),
       (2074, 42, 'Stilo Multi Wagon Actual'),
       (2075, 42, 'Stilo Multi Wagon Dynamic'),
       (2076, 42, 'Strada'),
       (2077, 42, 'Strada Malibu'),
       (2078, 42, 'Taunus Corsa'),
       (2079, 42, 'Tempra SW'),
       (2080, 42, 'Tipo'),
       (2081, 42, 'Tipo 3 TER'),
       (2082, 42, 'Topolino 500'),
       (2083, 42, 'Topolino 500 B'),
       (2084, 42, 'Topolino 500 C'),
       (2085, 42, 'Trepiuno Concept'),
       (2086, 42, 'Turbina Concept'),
       (2087, 42, 'Ulysse'),
       (2088, 42, 'Ulysse 2.0 JTD'),
       (2089, 42, 'Ulysse Emotion 2.0 16v'),
       (2090, 42, 'Uno'),
       (2091, 42, 'Uno Cabrio Concept'),
       (2092, 42, 'Viaggio'),
       (2093, 42, 'X1-9'),
       (2094, 43, 'Karma'),
       (2095, 43, 'Karma S Concept'),
       (2096, 43, 'Karma Prototype'),
       (2097, 43, 'Tramonto'),
       (2098, 43, 'Latigo CS'),
       (2099, 44, '4-Trac Concept'),
       (2100, 44, 'Airstream Concept'),
       (2101, 44, 'AU Falcon XR6 VCT'),
       (2102, 44, 'BA Fairlane G220 MkII'),
       (2103, 44, 'BA Fairlane Ghia MkII'),
       (2104, 44, 'BA Falcon RTV Ute'),
       (2105, 44, 'BA Falcon XR6 Turbo'),
       (2106, 44, 'BA Falcon XR8'),
       (2107, 44, 'BA MkII Falcon Ute'),
       (2108, 44, 'BA MkII Falcon XR8'),
       (2109, 44, 'BF Falcon XR8 Ute'),
       (2110, 44, 'BF MkII Falcon XR8'),
       (2111, 44, 'B-MAX'),
       (2112, 44, 'B-MAX Concept'),
       (2113, 44, 'Bronco Concept'),
       (2114, 44, 'C-MAX'),
       (2115, 44, 'C-MAX Energi'),
       (2116, 44, 'C-MAX Hybrid'),
       (2117, 44, 'Contour'),
       (2118, 44, 'Cougar'),
       (2119, 44, 'Crown Victoria'),
       (2120, 44, 'Crown Victoria LX'),
       (2121, 44, 'EB II Falcon GT'),
       (2122, 44, 'EcoSport'),
       (2123, 44, 'Edge'),
       (2124, 44, 'Edge Sport'),
       (2125, 44, 'EL Falcon GT'),
       (2126, 44, 'Equator Concept'),
       (2127, 44, 'Escape'),
       (2128, 44, 'Escape Hybrid'),
       (2129, 44, 'Escape Limited'),
       (2130, 44, 'Escort ZX2'),
       (2131, 44, 'E-Series'),
       (2132, 44, 'Evos Concept'),
       (2133, 44, 'Excursion'),
       (2134, 44, 'Expedition'),
       (2135, 44, 'Explorer'),
       (2136, 44, 'Explorer America Concept'),
       (2137, 44, 'Explorer Sport'),
       (2138, 44, 'Explorer Sport Trac'),
       (2139, 44, 'Explorer Sport Trac Concept'),
       (2140, 44, 'F-150'),
       (2141, 44, 'F-150 Foose Edition'),
       (2142, 44, 'F-150 FX4'),
       (2143, 44, 'F150 Harley Davidson'),
       (2144, 44, 'F-150 Harley Davidson'),
       (2145, 44, 'F-150 Harley-Davidson'),
       (2146, 44, 'F-150 Platinum'),
       (2147, 44, 'F-150 SFE'),
       (2148, 44, 'F-150 SVT Lightning'),
       (2149, 44, 'F-150 SVT Raptor R'),
       (2150, 44, 'F-150 SVT Raptor SuperCrew'),
       (2151, 44, 'F-250 Super Chief Concept'),
       (2152, 44, 'F-250 Super Duty'),
       (2153, 44, 'F-350'),
       (2154, 44, 'F-350 Super Duty'),
       (2155, 44, 'F-450 Harley-Davidson'),
       (2156, 44, 'F-450 Super Duty'),
       (2157, 44, 'Fairlane Concept'),
       (2158, 44, 'Falcon Havoc'),
       (2159, 44, 'Falcon XR8'),
       (2160, 44, 'FG Falcon G6'),
       (2161, 44, 'FG Falcon G6E'),
       (2162, 44, 'FG Falcon G6E Turbo'),
       (2163, 44, 'FG Falcon Ute'),
       (2164, 44, 'FG Falcon Ute R6'),
       (2165, 44, 'FG Falcon Ute XR6'),
       (2166, 44, 'FG Falcon Ute XR6 Turbo'),
       (2167, 44, 'FG Falcon Ute XR8'),
       (2168, 44, 'FG Falcon XR6'),
       (2169, 44, 'FG Falcon XR6 Turbo'),
       (2170, 44, 'FG Falcon XR8'),
       (2171, 44, 'FG Falcon XT'),
       (2172, 44, 'Fiesta'),
       (2173, 44, 'Fiesta 5-door'),
       (2174, 44, 'Fiesta ECOnetic'),
       (2175, 44, 'Fiesta RS WRC'),
       (2176, 44, 'Fiesta S'),
       (2177, 44, 'Fiesta Sedan'),
       (2178, 44, 'Fiesta ST'),
       (2179, 44, 'Fiesta ST Concept'),
       (2180, 44, 'Five Hundred'),
       (2181, 44, 'Five Hundred Limited'),
       (2182, 44, 'Flex'),
       (2183, 44, 'Focus'),
       (2184, 44, 'Focus 3door European Version'),
       (2185, 44, 'Focus 4door Concept'),
       (2186, 44, 'Focus 5-door'),
       (2187, 44, 'Focus CMax'),
       (2188, 44, 'Focus CMax Concept'),
       (2189, 44, 'Focus Coupe-Cabriolet'),
       (2190, 44, 'Focus ECOnetic'),
       (2191, 44, 'Focus Electric'),
       (2192, 44, 'Focus Estate'),
       (2193, 44, 'Focus European Version'),
       (2194, 44, 'Focus FR200'),
       (2195, 44, 'Focus Race Car Concept'),
       (2196, 44, 'Focus RS'),
       (2197, 44, 'Focus RS500'),
       (2198, 44, 'Focus RS8 with Cammer Engine'),
       (2199, 44, 'Focus Sedan'),
       (2200, 44, 'Focus ST'),
       (2201, 44, 'Focus ST500'),
       (2202, 44, 'Focus ST-R'),
       (2203, 44, 'Focus TDCi 5door European Version'),
       (2204, 44, 'Focus Touring Car'),
       (2205, 44, 'Focus Vignale Concept'),
       (2206, 44, 'Focus X Road'),
       (2207, 44, 'Focus Zetec S'),
       (2208, 44, 'Formula'),
       (2209, 44, 'FR100 Panel Truck with Cammer Engine'),
       (2210, 44, 'Freestar'),
       (2211, 44, 'Freestyle'),
       (2212, 44, 'Freestyle Limited'),
       (2213, 44, 'F-Series Cabelas FX4'),
       (2214, 44, 'Fusion'),
       (2215, 44, 'Fusion Energi'),
       (2216, 44, 'Fusion EUR'),
       (2217, 44, 'Fusion Hybrid'),
       (2218, 44, 'Fusion NASCAR'),
       (2219, 44, 'Fusion SES V6'),
       (2220, 44, 'Galaxy'),
       (2221, 44, 'Grand C-MAX'),
       (2222, 44, 'GT'),
       (2223, 44, 'GT Heritage Limited-Edition'),
       (2224, 44, 'GT40'),
       (2225, 44, 'GT40 Concept'),
       (2226, 44, 'GT90 Concept'),
       (2227, 44, 'GTX1 Roadster'),
       (2228, 44, 'Interceptor Concept'),
       (2229, 44, 'iosis Concept'),
       (2230, 44, 'iosis MAX Concept'),
       (2231, 44, 'iosis X Concept'),
       (2232, 44, 'Ka'),
       (2233, 44, 'King Ranch F150 SuperCrew'),
       (2234, 44, 'Kuga'),
       (2235, 44, 'Kuga UK Version'),
       (2236, 44, 'Mad Max Concept'),
       (2237, 44, 'Mondeo'),
       (2238, 44, 'Mondeo 5-door'),
       (2239, 44, 'Mondeo Concept'),
       (2240, 44, 'Mondeo Estate'),
       (2241, 44, 'Mondeo ST TDCi'),
       (2242, 44, 'Mondeo ST220'),
       (2243, 44, 'Mondeo ST220 Estate'),
       (2244, 44, 'Mondeo Titanium TDCi'),
       (2245, 44, 'Mondeo Titanium V6'),
       (2246, 44, 'Mondeo Wagon'),
       (2247, 44, 'Mondeo Wagon Concept'),
       (2248, 44, 'Mustang'),
       (2249, 44, 'Mustang 35th Anniversary'),
       (2250, 44, 'Mustang 40th Anniversary'),
       (2251, 44, 'Mustang 428 Cobra Jet'),
       (2252, 44, 'Mustang at SEMA 2004'),
       (2253, 44, 'Mustang AV-X10'),
       (2254, 44, 'Mustang Boss 302'),
       (2255, 44, 'Mustang Boss 302 Laguna Seca'),
       (2256, 44, 'Mustang Boss 302R'),
       (2257, 44, 'Mustang Boss 351'),
       (2258, 44, 'Mustang Boss 429'),
       (2259, 44, 'Mustang Bullitt'),
       (2260, 44, 'Mustang Bullitt Concept'),
       (2261, 44, 'Mustang Bullitt Fastback'),
       (2262, 44, 'Mustang Bullitt GT'),
       (2263, 44, 'Mustang Cobra'),
       (2264, 44, 'Mustang Cobra II'),
       (2265, 44, 'Mustang Cobra Indy Pace Car'),
       (2266, 44, 'Mustang Cobra Jet'),
       (2267, 44, 'Mustang Cobra Racecar'),
       (2268, 44, 'Mustang Convertible'),
       (2269, 44, 'Mustang DUB Edition'),
       (2270, 44, 'Mustang Fastback with Cammer Engine'),
       (2271, 44, 'Mustang FR500'),
       (2272, 44, 'Mustang FR500C'),
       (2273, 44, 'Mustang FR500CJ Cobra Jet'),
       (2274, 44, 'Mustang Giugiaro Concept'),
       (2275, 44, 'Mustang Glass Roof'),
       (2276, 44, 'Mustang GT'),
       (2277, 44, 'Mustang GT California Special'),
       (2278, 44, 'Mustang GT Centennial Edition'),
       (2279, 44, 'Mustang GT Convertible'),
       (2280, 44, 'Mustang GT Convertible Concept'),
       (2281, 44, 'Mustang GT Coupe Concept'),
       (2282, 44, 'Mustang GTP'),
       (2283, 44, 'Mustang GTR 40th Anniversary Concept'),
       (2284, 44, 'Mustang High Country Special'),
       (2285, 44, 'Mustang II Cobra II'),
       (2286, 44, 'Mustang II King Cobra'),
       (2287, 44, 'Mustang K-Code'),
       (2288, 44, 'Mustang Mach 1'),
       (2289, 44, 'Mustang Mach 1 Concept'),
       (2290, 44, 'Mustang Mach 2 Concept'),
       (2291, 44, 'Mustang Mach III'),
       (2292, 44, 'Mustang Miller'),
       (2293, 44, 'Mustang NHRA'),
       (2294, 44, 'Mustang Pony'),
       (2295, 44, 'Mustang Q-Code'),
       (2296, 44, 'Mustang Race Car'),
       (2297, 44, 'Mustang Racecar Prototype'),
       (2298, 44, 'Mustang Roadster Concept Car'),
       (2299, 44, 'Mustang Shelby GT'),
       (2300, 44, 'Mustang Shelby GT Convertible'),
       (2301, 44, 'Mustang Shelby GT350'),
       (2302, 44, 'Mustang Shelby GT-350H'),
       (2303, 44, 'Mustang Shelby GT500'),
       (2304, 44, 'Mustang Shelby GT500 Cobra'),
       (2305, 44, 'Mustang Shelby GT500 Convertible'),
       (2306, 44, 'Mustang Shelby GT500 KR'),
       (2307, 44, 'Mustang Shelby GT500 Red Stripe'),
       (2308, 44, 'Mustang Shelby GT500KR'),
       (2309, 44, 'Mustang Shelby GT500KR KITT'),
       (2310, 44, 'Mustang Shelby GT-H'),
       (2311, 44, 'Mustang Shelby GT-H Convertible'),
       (2312, 44, 'Mustang SVO'),
       (2313, 44, 'Mustang SVT Cobra'),
       (2314, 44, 'Mustang SVT Cobra 10th Anniversary'),
       (2315, 44, 'Mustang SVT Cobra Convertible'),
       (2316, 44, 'Mustang SVT Cobra R'),
       (2317, 44, 'Mustang T-5'),
       (2318, 44, 'Mustang Turbo GT350'),
       (2319, 44, 'Mustang V6'),
       (2320, 44, 'Mustang V6 Pony'),
       (2321, 44, 'Mustang Warriors In Pink'),
       (2322, 44, 'Police Interceptor Concept'),
       (2323, 44, 'Police Interceptor Utility Vehicle'),
       (2324, 44, 'Probe'),
       (2325, 44, 'Puma'),
       (2326, 44, 'R5 Concept'),
       (2327, 44, 'R7 Concept'),
       (2328, 44, 'Ranger'),
       (2329, 44, 'Ranger Max Concept'),
       (2330, 44, 'Ranger Wildtrak'),
       (2331, 44, 'Reflex Concept'),
       (2332, 44, 'Shelby Cobra Concept'),
       (2333, 44, 'Shelby GR1 Concept'),
       (2334, 44, 'Shelby SVT Cobra GT500 Mustang Show Car'),
       (2335, 44, 'S-MAX'),
       (2336, 44, 'Start Concept'),
       (2337, 44, 'Stealth Police Interceptor Concept'),
       (2338, 44, 'SteetKa UK Winter Edition with Hard Top'),
       (2339, 44, 'Super Duty'),
       (2340, 44, 'SVT Contour'),
       (2341, 44, 'SVT Explorer Sport Trac Adrenalin'),
       (2342, 44, 'SVT Focus'),
       (2343, 44, 'SVT Mustang Cobra MystiChrome'),
       (2344, 44, 'SYNus Concept'),
       (2345, 44, 'Taurus'),
       (2346, 44, 'Taurus SHO'),
       (2347, 44, 'Taurus X'),
       (2348, 44, 'Territory'),
       (2349, 44, 'Thunderbird'),
       (2350, 44, 'Thunderbird FAB 1 Concept'),
       (2351, 44, 'Thunderbird Neiman Marcus'),
       (2352, 44, 'Tourneo Custom'),
       (2353, 44, 'Tourneo Custom Concept'),
       (2354, 44, 'Transit Connect'),
       (2355, 44, 'Transit Connect Electric'),
       (2356, 44, 'Transit Connect Taxi'),
       (2357, 44, 'Transit Custom'),
       (2358, 44, 'Vertrek Concept'),
       (2359, 44, 'Verve 5-door Concept'),
       (2360, 44, 'Verve Concept'),
       (2361, 44, 'Verve Sedan Concept'),
       (2362, 44, 'Visos Concept'),
       (2363, 44, 'Windstar'),
       (2364, 44, 'XA Falcon GT'),
       (2365, 45, 'EN-V Concept'),
       (2366, 45, 'PUMA Concept'),
       (2367, 45, 'HydroGen4 Concept'),
       (2368, 45, 'Sequel Concept'),
       (2369, 45, 'HyWire Concept'),
       (2370, 46, 'Acadia'),
       (2371, 46, 'Denali XT Concept'),
       (2372, 46, 'Envoy Denali'),
       (2373, 46, 'Envoy XL Denali'),
       (2374, 46, 'Granite Concept'),
       (2375, 46, 'Graphyte Concept'),
       (2376, 46, 'Sierra'),
       (2377, 46, 'Sierra 2500 HD SLT Extended Cab'),
       (2378, 46, 'Sierra 3500 HD SLT Crew Cab'),
       (2379, 46, 'Sierra All Terrain HD Concept'),
       (2380, 46, 'Sierra Classic'),
       (2381, 46, 'Sierra Denali'),
       (2382, 46, 'Sierra Denali 1500 Crew Cab'),
       (2383, 46, 'Sierra Hybrid Crew Cab'),
       (2384, 46, 'Terrain'),
       (2385, 46, 'Terrain Denali'),
       (2386, 46, 'Yukon'),
       (2387, 46, 'Yukon Denali'),
       (2388, 46, 'Yukon Hybrid'),
       (2389, 46, 'Yukon XL'),
       (2390, 47, 'Spano'),
       (2391, 48, 'Teewave AR.1 Concept'),
       (2392, 48, 'T.25 Concept'),
       (2393, 49, 'Tornante by Touring'),
       (2394, 49, 'Apollo'),
       (2395, 50, 'ClubSport R8 Tourer'),
       (2396, 50, 'E Series Clubsport R8'),
       (2397, 50, 'E Series Grange'),
       (2398, 50, 'E Series GTS'),
       (2399, 50, 'E3 ClubSport R8'),
       (2400, 50, 'E3 ClubSport R8 Tourer'),
       (2401, 50, 'E3 GTS'),
       (2402, 50, 'E3 Maloo R8'),
       (2403, 50, 'E3 Senator'),
       (2404, 50, 'Grange WM3'),
       (2405, 50, 'GTS 25th Anniversary'),
       (2406, 50, 'GTS 40 Years Edition'),
       (2407, 50, 'Senator Signature'),
       (2408, 50, 'Senator Signature SV08'),
       (2409, 50, 'VXR'),
       (2410, 50, 'W427'),
       (2411, 50, 'W427 Concept'),
       (2412, 50, 'Z Series Maloo'),
       (2413, 51, 'Aston Martin V8 Vantage'),
       (2414, 51, 'BMW 1er'),
       (2415, 51, 'BMW 3er Cabrio'),
       (2416, 51, 'BMW 3er E90'),
       (2417, 51, 'BMW 3-Series Coupe Thunder'),
       (2418, 51, 'BMW 5er E60 545i'),
       (2419, 51, 'BMW 5er Touring E61'),
       (2420, 51, 'BMW 5-Series F10'),
       (2421, 51, 'BMW 5-Series F10 M-Technik'),
       (2422, 51, 'BMW 5-Series GT'),
       (2423, 51, 'BMW 6er Coupe 645Ci'),
       (2424, 51, 'BMW 6-Series'),
       (2425, 51, 'BMW 7er'),
       (2426, 51, 'BMW M3 Las Vegas Wings'),
       (2427, 51, 'BMW M5 Widebody Race Edition'),
       (2428, 51, 'BMW M6 Widebody'),
       (2429, 51, 'BMW X3 HM 3.3'),
       (2430, 51, 'BMW X5 E70'),
       (2431, 51, 'BMW X5 Flash'),
       (2432, 51, 'BMW X6'),
       (2433, 51, 'BMW Z4'),
       (2434, 51, 'BMW Z4 M Coupe'),
       (2435, 51, 'BMW Z4 M Roadster'),
       (2436, 51, 'Conqueror II'),
       (2437, 51, 'Ferrari 360'),
       (2438, 51, 'Ferrari 599 GTB Fiorano'),
       (2439, 51, 'Ferrari F430'),
       (2440, 51, 'Ferrari F430 Black Miracle'),
       (2441, 51, 'Ferrari F430 Spider'),
       (2442, 51, 'Fiat 500 Sportivo'),
       (2443, 51, 'Flash Evo M'),
       (2444, 51, 'Guardian'),
       (2445, 51, 'Hawk'),
       (2446, 51, 'Imperator'),
       (2447, 51, 'Lamborghini Gallardo'),
       (2448, 51, 'Lamborghini Gallardo Spyder'),
       (2449, 51, 'Lamborghini Gallardo Victory'),
       (2450, 51, 'Mercedes-Benz M-Klasse'),
       (2451, 51, 'Mercedes-Benz SL-Klasse'),
       (2452, 51, 'Mercedes-Benz SLR Volcano'),
       (2453, 51, 'Mercedes-Benz SLS AMG'),
       (2454, 51, 'Mini'),
       (2455, 51, 'Porsche 911 GT3 San Diego Express'),
       (2456, 51, 'Porsche 911 Turbo Stallion'),
       (2457, 51, 'Porsche 996 Turbo'),
       (2458, 51, 'Porsche 997'),
       (2459, 51, 'Porsche Cayenne'),
       (2460, 51, 'Porsche Cayenne 958'),
       (2461, 51, 'Porsche Cayenne Cyclone'),
       (2462, 51, 'Range Rover HM 5.2'),
       (2463, 51, 'Tycoon Evo M'),
       (2464, 51, 'Victory II'),
       (2465, 52, 'Venom GT'),
       (2466, 53, 'Astra CD 5door'),
       (2467, 53, 'Astra CDX 5door'),
       (2468, 53, 'Astra CDXi 5door'),
       (2469, 53, 'Astra Convertible'),
       (2470, 53, 'Astra SRi Turbo'),
       (2471, 53, 'Astra Wagon'),
       (2472, 53, 'Captiva'),
       (2473, 53, 'Captiva CX'),
       (2474, 53, 'Captiva LX'),
       (2475, 53, 'Captiva MaXX'),
       (2476, 53, 'Captiva SX'),
       (2477, 53, 'Colorado'),
       (2478, 53, 'Coupe 60 Concept'),
       (2479, 53, 'Coupe Concept'),
       (2480, 53, 'Cross 8 Concept'),
       (2481, 53, 'Cruze'),
       (2482, 53, 'ECOmmodore Concept'),
       (2483, 53, 'Efijy Concept'),
       (2484, 53, 'HFV6 Rodeo'),
       (2485, 53, 'HRT 427 Concept'),
       (2486, 53, 'VZ Ute SS'),
       (2487, 53, 'HSV Avalanche'),
       (2488, 53, 'HSV Avalanche XUV'),
       (2489, 53, 'HSV Coupe 4'),
       (2490, 53, 'HSV Maloo Ute Concept'),
       (2491, 53, 'Hurricane Concept'),
       (2492, 53, 'Jack8 Concept'),
       (2493, 53, 'JF Viva Hatch'),
       (2494, 53, 'JF Viva Sedan'),
       (2495, 53, 'JF Viva Wagon'),
       (2496, 53, 'Monaro CV8-Z'),
       (2497, 53, 'Sandman Concept'),
       (2498, 53, 'SST Concept'),
       (2499, 53, 'SST Stepside Custom Pickup Concept'),
       (2500, 53, 'SSX Concept'),
       (2501, 53, 'Tigra'),
       (2502, 53, 'TK Barina Hatch 3-door'),
       (2503, 53, 'TK Barina Hatch 5-door'),
       (2504, 53, 'TK Barina Sedan'),
       (2505, 53, 'Torana GTR-X Concept'),
       (2506, 53, 'Torana TT36 Hatch Concept'),
       (2507, 53, 'Utester Concept'),
       (2508, 53, 'VE Commodore Berlina'),
       (2509, 53, 'VE Commodore Calais'),
       (2510, 53, 'VE Commodore Calais V'),
       (2511, 53, 'VE Commodore Omega'),
       (2512, 53, 'VE Commodore Sportwagon'),
       (2513, 53, 'VE Commodore SS'),
       (2514, 53, 'VE Commodore SS-V'),
       (2515, 53, 'VE Commodore SV6'),
       (2516, 53, 'VE II Commodore Calais V'),
       (2517, 53, 'Astra 3-door'),
       (2518, 53, 'VE II Commodore Caprice V'),
       (2519, 53, 'VE II Commodore Omega'),
       (2520, 53, 'VE II Commodore Sportwagon Berlina'),
       (2521, 53, 'VE II Commodore Sportwagon Calais V'),
       (2522, 53, 'VE II Commodore Sportwagon SS'),
       (2523, 53, 'VE II Commodore Sportwagon SSV'),
       (2524, 53, 'VE II Commodore Sportwagon SV6'),
       (2525, 53, 'VE II Commodore SSV'),
       (2526, 53, 'VE II Commodore SV6'),
       (2527, 53, 'VE II Ute SSV'),
       (2528, 53, 'VE II Ute SV6'),
       (2529, 53, 'VE Ute SS V'),
       (2530, 53, 'VE Ute SV6'),
       (2531, 53, 'Vectra'),
       (2532, 53, 'Volt'),
       (2533, 53, 'VY Commodore Acclaim'),
       (2534, 53, 'VY Commodore Executive'),
       (2535, 53, 'VY Commodore S'),
       (2536, 53, 'VY Commodore SS'),
       (2537, 53, 'VZ Adventra'),
       (2538, 53, 'VZ Commodore Calais'),
       (2539, 53, 'VZ Commodore SS-Z'),
       (2540, 53, 'VZ Commodore SV6'),
       (2541, 53, 'VZ Commodore SV8'),
       (2542, 53, 'VZ Crewman'),
       (2543, 53, 'VZ Crewman Cross 8'),
       (2544, 53, 'VZ Crewman SS'),
       (2545, 53, 'VZ Monaro'),
       (2546, 53, 'VZ One Tonner'),
       (2547, 53, 'VZ One Tonner Cross 6'),
       (2548, 53, 'VZ Ute'),
       (2549, 53, 'VZ Ute SS-Z'),
       (2550, 53, 'WL Caprice'),
       (2551, 53, 'WL Statesman International'),
       (2552, 53, 'WM Caprice'),
       (2553, 53, 'WM Statesman'),
       (2554, 54, '3R-C Concept'),
       (2555, 54, 'AandL Racing S2000'),
       (2556, 54, 'Accord'),
       (2557, 54, 'Accord Concept'),
       (2558, 54, 'Accord Coupe'),
       (2559, 54, 'Accord Coupe Concept'),
       (2560, 54, 'Civic Si Coupe'),
       (2561, 54, 'Accord Coupe EX-L'),
       (2562, 54, 'Accord Crosstour'),
       (2563, 54, 'Accord EU Version'),
       (2564, 54, 'Accord EuroR'),
       (2565, 54, 'Accord EX Sedan'),
       (2566, 54, 'Accord EX-L Sedan'),
       (2567, 54, 'Accord EX-L V6 Coupe'),
       (2568, 54, 'Accord EX-L V6 Sedan'),
       (2569, 54, 'Accord Hatchback'),
       (2570, 54, 'Accord HB'),
       (2571, 54, 'Accord HF-S Concept'),
       (2572, 54, 'Accord Hybrid'),
       (2573, 54, 'Accord iCTDi European Version'),
       (2574, 54, 'Accord PHEV'),
       (2575, 54, 'Accord SE'),
       (2576, 54, 'Accord Sedan'),
       (2577, 54, 'Accord Sedan 2.0E European Version'),
       (2578, 54, 'Accord Sedan 2.4 European Version'),
       (2579, 54, 'Accord Sedan 2.4EL European Version'),
       (2580, 54, 'Accord Sedan 2.4S European Version'),
       (2581, 54, 'Accord Sedan 2.4T European Version'),
       (2582, 54, 'Accord Sedan 2.4TL European Version'),
       (2583, 54, 'Accord Sedan EX-L'),
       (2584, 54, 'Accord Tourer'),
       (2585, 54, 'Accord Tourer Concept'),
       (2586, 54, 'Accord Type S'),
       (2587, 54, 'Accord Wagon'),
       (2588, 54, 'Accord Wagon 2.4T European Version'),
       (2589, 54, 'Accord Wagon 2.4T Exclusive Package European Version'),
       (2590, 54, 'Accord Wagon 2.4T Sport Package European Version'),
       (2591, 54, 'AC-X Concept'),
       (2592, 54, 'ASM Concept'),
       (2593, 54, 'AZ600'),
       (2594, 54, 'Brio Concept'),
       (2595, 54, 'C Concept'),
       (2596, 54, 'City'),
       (2597, 54, 'Civic'),
       (2598, 54, 'Civic Concept'),
       (2599, 54, 'Civic Coupe'),
       (2600, 54, 'Civic CRX'),
       (2601, 54, 'Civic CRX Si'),
       (2602, 54, 'Civic CVCC'),
       (2603, 54, 'Civic Del Sol'),
       (2604, 54, 'Accord LX-P Sedan'),
       (2605, 54, 'Civic Del Sol Si'),
       (2606, 54, 'Civic EUR'),
       (2607, 54, 'Civic EU-Version'),
       (2608, 54, 'Civic Hatchback'),
       (2609, 54, 'Civic HF'),
       (2610, 54, 'Civic Hybrid'),
       (2611, 54, 'Civic Mugen Si Sedan'),
       (2612, 54, 'Civic Mugen Si Sedan Prototype'),
       (2613, 54, 'Civic Sedan'),
       (2614, 54, 'Civic Si'),
       (2615, 54, 'Civic Si Concept'),
       (2616, 54, 'Civic Si Hatchback'),
       (2617, 54, 'Civic Si Racecar'),
       (2618, 54, 'Civic Si Sedan'),
       (2619, 54, 'Civic Si Sedan Concept'),
       (2620, 54, 'Civic Si Sport Concept'),
       (2621, 54, 'Civic Type R'),
       (2622, 54, 'Civic Type R Concept'),
       (2623, 54, 'Civic Type R Mugen 2.2'),
       (2624, 54, 'Civic Type R Sedan'),
       (2625, 54, 'Civic Type S'),
       (2626, 54, 'Civic Wagon'),
       (2627, 54, 'Crosstour'),
       (2628, 54, 'Crosstour Concept'),
       (2629, 54, 'CR-V'),
       (2630, 54, 'CR-V Concept'),
       (2631, 54, 'CR-V Euro Specs'),
       (2632, 54, 'CRV EX'),
       (2633, 54, 'CRV SE'),
       (2634, 54, 'CR-V US-Version'),
       (2635, 54, 'CR-Z'),
       (2636, 54, 'CR-Z Concept'),
       (2637, 54, 'CR-Z Mugen Concept'),
       (2638, 54, 'CR-Z Mugen RR Concept'),
       (2639, 54, 'Element'),
       (2640, 54, 'Element Concept'),
       (2641, 54, 'Element DX'),
       (2642, 54, 'Element EX'),
       (2643, 54, 'Element EX-P'),
       (2644, 54, 'Element SC'),
       (2645, 54, 'Element SC Prototype'),
       (2646, 54, 'EV Plus'),
       (2647, 54, 'EV-Ster Concept'),
       (2648, 54, 'FC Sport Concept'),
       (2649, 54, 'FCX'),
       (2650, 54, 'FCX Clarity'),
       (2651, 54, 'FCX Concept'),
       (2652, 54, 'Fit'),
       (2653, 54, 'Fit EV'),
       (2654, 54, 'Fit EV Concept'),
       (2655, 54, 'Fit Sport'),
       (2656, 54, 'FRV'),
       (2657, 54, 'HSC Concept'),
       (2658, 54, 'HSV-010 GT'),
       (2659, 54, 'IMAS Concept'),
       (2660, 54, 'Insight'),
       (2661, 54, 'Insight Concept'),
       (2662, 54, 'Insight EU Version'),
       (2663, 54, 'Insight Sports Modulo Concept'),
       (2664, 54, 'Jazz'),
       (2665, 54, 'Jazz Hybrid'),
       (2666, 54, 'KIWAMI Concept'),
       (2667, 54, 'Legend'),
       (2668, 54, 'MDX'),
       (2669, 54, 'Model X Concept'),
       (2670, 54, 'Mugen Civic Si'),
       (2671, 54, 'N600'),
       (2672, 54, 'New Small Concept'),
       (2673, 54, 'NSX'),
       (2674, 54, 'NSX Concept'),
       (2675, 54, 'NSXR Concept'),
       (2676, 54, 'Odyssey'),
       (2677, 54, 'Odyssey Absolute Japanese Version'),
       (2678, 54, 'Odyssey Concept'),
       (2679, 54, 'Odyssey EX'),
       (2680, 54, 'Odyssey L Type Japanese Version'),
       (2681, 54, 'Odyssey M Type Japanese Version'),
       (2682, 54, 'Odyssey S Type Japanese Version'),
       (2683, 54, 'Odyssey Touring'),
       (2684, 54, 'OSM Concept'),
       (2685, 54, 'Passport'),
       (2686, 54, 'Pilot'),
       (2687, 54, 'Pilot EX'),
       (2688, 54, 'Pilot EX-L 4WD'),
       (2689, 54, 'Pilot LX'),
       (2690, 54, 'Pilot Prototype'),
       (2691, 54, 'P-NUT Concept'),
       (2692, 54, 'Prelude'),
       (2693, 54, 'Prelude Si'),
       (2694, 54, 'Prelude Type SH'),
       (2695, 54, 'Prelude VTEC'),
       (2696, 54, 'Pro Drag Civic Si Concept'),
       (2697, 54, 'PUYO Concept'),
       (2698, 54, 'REMIX Concept'),
       (2699, 54, 'Ridgeline'),
       (2700, 54, 'Ridgeline All-Terrain Concept'),
       (2701, 54, 'Ridgeline RTL'),
       (2702, 54, 'Ridgeline RTS'),
       (2703, 54, 'Ridgeline Sport'),
       (2704, 54, 'Ridgeline Street Sport Concept'),
       (2705, 54, 'S Concept'),
       (2706, 54, 'S2000'),
       (2707, 54, 'S2000 CR'),
       (2708, 54, 'S2000 CR Concept'),
       (2709, 54, 'S2000 Type S'),
       (2710, 54, 'S2000 Ultimate Edition'),
       (2711, 54, 'S600'),
       (2712, 54, 'Skydeck Concept'),
       (2713, 54, 'Small Hybrid Sports Concept'),
       (2714, 54, 'Step Bus Concept'),
       (2715, 54, 'SUT Concept'),
       (2716, 55, 'Bike'),
       (2717, 55, 'H1'),
       (2718, 55, 'H1 10th Anniversary Edition'),
       (2719, 55, 'H1 Alpha Concept'),
       (2720, 55, 'H2'),
       (2721, 55, 'H2 SUT Dirt Sport Concept'),
       (2722, 55, 'H2 SUV'),
       (2723, 55, 'H2 SUV Concept'),
       (2724, 55, 'H2 with GM Accessories'),
       (2725, 55, 'H2H Hydrogen Concept'),
       (2726, 55, 'H3 Wagon Concept'),
       (2727, 55, 'H3R Off Road Concept'),
       (2728, 55, 'H3T Alpha'),
       (2729, 55, 'H3T Concept'),
       (2730, 55, 'H3X'),
       (2731, 55, 'Humvee Military Vehicle'),
       (2732, 55, 'HX Concept'),
       (2733, 56, 'Accent'),
       (2734, 56, 'Accent'),
       (2735, 56, 'Arnejs Concept'),
       (2736, 56, 'i20'),
       (2737, 56, 'Veloster Turbo'),
       (2738, 56, 'Santa Fe Sport'),
       (2739, 56, 'Azera'),
       (2740, 56, 'Blue2 Concept'),
       (2741, 56, 'Langdong'),
       (2742, 56, 'HB20X new'),
       (2743, 56, 'HB20'),
       (2744, 56, 'Genesis Coupe'),
       (2745, 56, 'Elantra GT'),
       (2746, 56, 'Elantra Coupe'),
       (2747, 56, 'i40 Wagon'),
       (2748, 56, 'Clix Concept'),
       (2749, 56, 'Curb Concept'),
       (2750, 56, 'i-ioniq Concept'),
       (2751, 56, 'E-Cubed Concept'),
       (2752, 56, 'Elantra'),
       (2753, 56, 'Elantra Blue'),
       (2754, 56, 'Entourage'),
       (2755, 56, 'Equus'),
       (2756, 56, 'Equus Limousine'),
       (2757, 56, 'Genesis'),
       (2758, 56, 'Veloster Rally Car'),
       (2759, 56, 'Genesis Coupe Concept'),
       (2760, 56, 'HCD 6 Concept'),
       (2761, 56, 'HCD10 Hellion Concept'),
       (2762, 56, 'HED 1 Concept'),
       (2763, 56, 'HED-5 i-Mode Concept'),
       (2764, 56, 'Hexa Space Concept'),
       (2765, 56, 'i10'),
       (2766, 56, 'Avante'),
       (2767, 56, 'i-flow Concept'),
       (2768, 56, 'Tucson'),
       (2769, 56, 'Santa Fe US-Version'),
       (2770, 56, 'Santa Fe'),
       (2771, 56, 'RB Concept'),
       (2772, 56, 'i20 3-door'),
       (2773, 56, 'i20 Blue'),
       (2774, 56, 'i30'),
       (2775, 56, 'i30 3-door'),
       (2776, 56, 'i30 Estate'),
       (2777, 56, 'i30 Wagon'),
       (2778, 56, 'i40'),
       (2779, 56, 'i40 Tourer UK Version'),
       (2780, 56, 'i800'),
       (2781, 56, 'Elantra Touring'),
       (2782, 56, 'Blue-Will Concept'),
       (2783, 56, 'i-Blue Concept'),
       (2784, 56, 'ix20'),
       (2785, 56, 'ix35'),
       (2786, 56, 'ix55'),
       (2787, 56, 'ix-Metro Concept'),
       (2788, 56, 'ix-onic Concept'),
       (2789, 56, 'Matrix'),
       (2790, 56, 'NEOS Concept'),
       (2791, 56, 'Nuvis Concept'),
       (2792, 56, 'Portico Concept'),
       (2793, 56, 'QarmaQ Concept'),
       (2794, 56, 'Genesis Concept'),
       (2795, 56, 'Coupe'),
       (2796, 56, 'Sonata V6'),
       (2797, 56, 'HCD9 Concept'),
       (2798, 56, 'Santa Fe Blue Hybrid Concept'),
       (2799, 56, 'Getz'),
       (2800, 56, 'Santa Fe EU-Version'),
       (2801, 56, 'Accent SR'),
       (2802, 56, 'Tucson V6'),
       (2803, 56, 'Sonata'),
       (2804, 56, 'Sonata 2.0T'),
       (2805, 56, 'Sonata Hybrid'),
       (2806, 56, 'Terracan'),
       (2807, 56, 'Tiburon Coupe'),
       (2808, 56, 'Grandeur'),
       (2809, 56, 'HCD8 Concept'),
       (2810, 56, 'Trajet'),
       (2811, 56, 'Veloster'),
       (2812, 56, 'Atos Prime'),
       (2813, 56, 'CCS Concept'),
       (2814, 56, 'HCD 7 Concept'),
       (2815, 56, 'Veloster Concept'),
       (2816, 56, 'Veracruz'),
       (2817, 56, 'Verna'),
       (2818, 57, 'Coupe Concept'),
       (2819, 57, 'Emerg-E Concept'),
       (2820, 57, 'Essence Concept'),
       (2821, 57, 'Etherea Concept'),
       (2822, 57, 'EX Concept'),
       (2823, 57, 'EX30d'),
       (2824, 57, 'EX35'),
       (2825, 57, 'EX37'),
       (2826, 57, 'FX'),
       (2827, 57, 'FX Limited Edition'),
       (2828, 57, 'FX Sebastian Vettel Concept'),
       (2829, 57, 'FX Vettel Edition new'),
       (2830, 57, 'FX35'),
       (2831, 57, 'FX37'),
       (2832, 57, 'FX45'),
       (2833, 57, 'FX50'),
       (2834, 57, 'G35'),
       (2835, 57, 'G37'),
       (2836, 57, 'G35 Sedan'),
       (2837, 57, 'G35 Sport Coupe'),
       (2838, 57, 'G37 Convertible'),
       (2839, 57, 'QX56'),
       (2840, 57, 'G37 Coupe'),
       (2841, 57, 'G37 Sedan'),
       (2842, 57, 'I35'),
       (2843, 57, 'IPL G Cabrio Concept'),
       (2844, 57, 'IPL G Convertible'),
       (2845, 57, 'IPL G Coupe'),
       (2846, 57, 'M45'),
       (2847, 57, 'JX'),
       (2848, 57, 'JX Concept'),
       (2849, 57, 'LE Concept'),
       (2850, 57, 'M'),
       (2851, 57, 'M35'),
       (2852, 57, 'M35h'),
       (2853, 57, 'Kuraza Concept'),
       (2854, 57, 'G35 Sport Sedan'),
       (2855, 57, 'M35h GT'),
       (2856, 57, 'M35x'),
       (2857, 57, 'M45 Concept'),
       (2858, 57, 'M45s'),
       (2859, 57, 'M45x'),
       (2860, 57, 'Q45'),
       (2861, 57, 'QX'),
       (2862, 57, 'QX4'),
       (2863, 57, 'Triant Concept'),
       (2864, 58, 'Ascender'),
       (2865, 58, 'Axiom XST Concept'),
       (2866, 58, 'Axiom XSR Concept'),
       (2867, 58, 'Axiom XSF Concept'),
       (2868, 58, 'GBX Concept'),
       (2869, 58, 'Zen Concept'),
       (2870, 58, 'Rodeo 3.0 Denver'),
       (2871, 59, 'Brivido Concept'),
       (2872, 59, 'Tex Concept'),
       (2873, 59, 'Go Concept'),
       (2874, 59, 'Emas Country Concept'),
       (2875, 59, 'Emas Concept'),
       (2876, 59, 'Emas3 Concept'),
       (2877, 59, 'Giugiaro Quaranta Concep'),
       (2878, 60, 'Campagnola'),
       (2879, 60, 'Massif'),
       (2880, 61, 'Advanced Lightweight Coupe Concept'),
       (2881, 61, 'C-X16 Concept'),
       (2882, 61, 'C-X75 Concept'),
       (2883, 61, 'C-XF Concept'),
       (2884, 61, 'E-Type Speedster'),
       (2885, 61, 'F-Type'),
       (2886, 61, 'R-Coupe Concept'),
       (2887, 61, 'RD6 Concept'),
       (2888, 61, 'S-Type'),
       (2889, 61, 'SType 2.7D'),
       (2890, 61, 'SType R'),
       (2891, 61, 'SType V8'),
       (2892, 61, 'Super V8'),
       (2893, 61, 'XKR Speed'),
       (2894, 61, 'XF'),
       (2895, 61, 'XKR'),
       (2896, 61, 'XJ Sentinel'),
       (2897, 61, 'XF Black Pack'),
       (2898, 61, 'XF Sportbrake'),
       (2899, 61, 'XFR'),
       (2900, 61, 'XJ75 Platinum Concept'),
       (2901, 61, 'XJ'),
       (2902, 61, 'XFR Speed'),
       (2903, 61, 'XKR-S'),
       (2904, 61, 'XJ 2.7 Diesel'),
       (2905, 61, 'XJ Sport Pack'),
       (2906, 61, 'XJ Ultimate'),
       (2907, 61, 'XJ8 L'),
       (2908, 61, 'XJ8 Vanden Plas'),
       (2909, 61, 'XJR Portfolio'),
       (2910, 61, 'XK'),
       (2911, 61, 'XK Artisan SE'),
       (2912, 61, 'XK Convertible'),
       (2913, 61, 'XK8 Convertible'),
       (2914, 61, 'XKR 175'),
       (2915, 61, 'XKR 75'),
       (2916, 61, 'XKR Convertible'),
       (2917, 61, 'XJ Super V8'),
       (2918, 61, 'XKR Coupe'),
       (2919, 61, 'XKR Portfolio'),
       (2920, 61, 'XType 3.0'),
       (2921, 61, 'XType 2.5'),
       (2922, 61, 'XKR-S Convertible'),
       (2923, 61, 'Concept Eight'),
       (2924, 61, 'Bonspeed XType'),
       (2925, 61, 'X-Type'),
       (2926, 61, 'X-Type Estate'),
       (2927, 61, 'F-Type Concept'),
       (2928, 61, 'XK180 Concept'),
       (2929, 61, 'XJS'),
       (2930, 61, 'XJ220'),
       (2931, 61, 'XJR-9'),
       (2932, 61, 'XJ220 Concept'),
       (2933, 61, 'XJ-S'),
       (2934, 61, 'E-Type'),
       (2935, 61, 'XJ6'),
       (2936, 61, 'XJ13'),
       (2937, 61, 'Mark 2'),
       (2938, 61, 'XK SS'),
       (2939, 61, 'XK140'),
       (2940, 61, 'D-Type'),
       (2941, 61, 'C-Type'),
       (2942, 61, 'XK120'),
       (2943, 61, 'SS 100'),
       (2944, 62, 'Cherokee'),
       (2945, 62, 'Cherokee Renegade'),
       (2946, 62, 'Cherokee UK Version'),
       (2947, 62, 'CJ-7 Renegade'),
       (2948, 62, 'Comanche'),
       (2949, 62, 'Commander UK Version'),
       (2950, 62, 'Compass'),
       (2951, 62, 'Compass Concept'),
       (2952, 62, 'Grand Cherokee UK Version'),
       (2953, 62, 'Compass UK Version'),
       (2954, 62, 'Wrangler Unlimited EV'),
       (2955, 62, 'EV Concept'),
       (2956, 62, 'FC-170'),
       (2957, 62, 'Gladiator'),
       (2958, 62, 'Renegade Concept'),
       (2959, 62, 'Grand Cherokee'),
       (2960, 62, 'Grand Cherokee Concept'),
       (2961, 62, 'Grand Cherokee S-Limited UK Version'),
       (2962, 62, 'Grand Cherokee Overland UK Version'),
       (2963, 62, 'Grand Cherokee SRT8'),
       (2964, 62, 'Grand Cherokee SRT-8 UK Version'),
       (2965, 62, 'Grand Cherokee Trailhawk'),
       (2966, 62, 'Wrangler Rubicon'),
       (2967, 62, 'Hurricane Concept'),
       (2968, 62, 'Jeepster Commando Convertible'),
       (2969, 62, 'Liberty'),
       (2970, 62, 'Liberty Arctic'),
       (2971, 62, 'Commander 4x4 Limited 5.7 HEMI'),
       (2972, 62, 'Wrangler UK Version'),
       (2973, 62, 'Liberty CRD Limited'),
       (2974, 62, 'Liberty Renegade 3.7'),
       (2975, 62, 'Patriot'),
       (2976, 62, 'Grand Cherokee 5.7 Limited'),
       (2977, 62, 'Gladiator Concept'),
       (2978, 62, 'Patriot Back Country Concept'),
       (2979, 62, 'Patriot Concept'),
       (2980, 62, 'Patriot EV'),
       (2981, 62, 'Patriot UK Version'),
       (2982, 62, 'Treo Concept'),
       (2983, 62, 'Rescue Concept'),
       (2984, 62, 'Scrambler CJ-8'),
       (2985, 62, 'Trailhawk Concept'),
       (2986, 62, 'Wagoneer'),
       (2987, 62, 'Wagoneer Limited'),
       (2988, 62, 'Willys2 Concept'),
       (2989, 62, 'Wrangler'),
       (2990, 62, 'Wrangler Arctic'),
       (2991, 62, 'Wrangler Call of Duty Black Ops'),
       (2992, 62, 'Wrangler Call of Duty MW3'),
       (2993, 62, 'Wrangler Dragon Concept'),
       (2994, 62, 'Wrangler Freedom Edition'),
       (2995, 62, 'Wrangler Mojave'),
       (2996, 62, 'Wrangler Unlimited'),
       (2997, 62, 'Wrangler Unlimited Altitude'),
       (2998, 62, 'Wrangler Unlimited Moab'),
       (2999, 62, 'Wrangler Unlimited UK Version'),
       (3000, 62, 'M-38 A1'),
       (3001, 62, 'Dispatcher'),
       (3002, 62, 'CJ-5'),
       (3003, 62, '4WD 1-Ton Pickup Truck'),
       (3004, 62, 'CJ-3B'),
       (3005, 62, 'M-38'),
       (3006, 62, 'Jeepster'),
       (3007, 62, 'Pickup Truck'),
       (3008, 62, 'Station Wagon'),
       (3009, 62, 'Panel Delivery'),
       (3010, 62, 'CJ-2A'),
       (3011, 62, 'Willys MB'),
       (3012, 62, 'Willys MA'),
       (3013, 62, 'Willys Quad'),
       (3014, 63, 'X-Bow Race'),
       (3015, 63, 'X-Bow'),
       (3016, 64, 'Amanti'),
       (3017, 64, 'Cerato'),
       (3018, 64, 'Borrego'),
       (3019, 64, 'Cadenza'),
       (3020, 64, 'K9'),
       (3021, 64, 'Ceed SW'),
       (3022, 64, 'Ceed'),
       (3023, 64, 'Carens'),
       (3024, 64, 'cee-d'),
       (3025, 64, 'Ceed Sporty Wagon'),
       (3026, 64, 'eco ceed Concept'),
       (3027, 64, 'Rio'),
       (3028, 64, 'ex cee-d Cabrio Concept'),
       (3029, 64, 'Forte'),
       (3030, 64, 'Picanto 3-door'),
       (3031, 64, 'Forte 5-door'),
       (3032, 64, 'Forte Koup'),
       (3033, 64, 'Grand VQ-R'),
       (3034, 64, 'GT Concept'),
       (3035, 64, 'K2'),
       (3036, 64, 'KCD1 Slice Concept'),
       (3037, 64, 'KCV4 Mojave Concept'),
       (3038, 64, 'Kee Concept'),
       (3039, 64, 'KND-4 Concept'),
       (3040, 64, 'KOUP Concept'),
       (3041, 64, 'KV7 Concept'),
       (3042, 64, 'Naimo Concept'),
       (3043, 64, 'No3 Concept'),
       (3044, 64, 'Opirus'),
       (3045, 64, 'Optima'),
       (3046, 64, 'Venga'),
       (3047, 64, 'Soul'),
       (3048, 64, 'Sorento'),
       (3049, 64, 'Ray Plug-In Hybrid Concept'),
       (3050, 64, 'Optima Hybrid'),
       (3051, 64, 'Picanto'),
       (3052, 64, 'POP Concept'),
       (3053, 64, 'Pro Ceed'),
       (3054, 64, 'Pro-cee-d'),
       (3055, 64, 'Magentis'),
       (3056, 64, 'Ray'),
       (3057, 64, 'Ray EV'),
       (3058, 64, 'Rio 3-door'),
       (3059, 64, 'Rio Sedan'),
       (3060, 64, 'Rio5'),
       (3061, 64, 'Rondo'),
       (3062, 64, 'Rondo SX Concept'),
       (3063, 64, 'Sedona'),
       (3064, 64, 'Kue Concept'),
       (3065, 64, 'Sorento EU-Version'),
       (3066, 64, 'Sportage'),
       (3067, 64, 'Spectra5'),
       (3068, 64, 'Soul Burner Concept'),
       (3069, 64, 'Soul Concept'),
       (3070, 64, 'Soulster Concept'),
       (3071, 64, 'Spectra'),
       (3072, 64, 'Multi-S Concept'),
       (3073, 64, 'Sportage SX'),
       (3074, 64, 'Sports Coupe Concept'),
       (3075, 64, 'Trackster Concept'),
       (3076, 64, 'Venga EV Concept'),
       (3077, 64, 'VG Concept'),
       (3078, 65, 'Mercedes-Benz C 20K'),
       (3079, 65, 'Mercedes-Benz C 55K S8'),
       (3080, 65, 'Mercedes-Benz CL 60'),
       (3081, 65, 'Mercedes-Benz CLK 55K'),
       (3082, 65, 'Mercedes-Benz CLS 50K S8'),
       (3083, 65, 'Mercedes-Benz E 50K CC'),
       (3084, 65, 'Mercedes-Benz E 55 K3'),
       (3085, 65, 'Mercedes-Benz S 60'),
       (3086, 65, 'Mercedes-Benz SL 50K S8'),
       (3087, 65, 'Mercedes-Benz SL Xtreme'),
       (3088, 65, 'Mercedes-Benz SLK 20K'),
       (3089, 65, 'Mercedes-Benz SLK 55K S8'),
       (3090, 66, 'Agera R'),
       (3091, 66, 'Agera'),
       (3092, 66, 'CCXR Trevita'),
       (3093, 66, 'Quant Concept'),
       (3094, 66, 'CCXR Edition'),
       (3095, 66, 'CCX'),
       (3096, 66, 'CCR'),
       (3097, 67, 'Lightning GT'),
       (3098, 67, 'Lightning GT Concept'),
       (3099, 68, 'XRay Concept'),
       (3100, 68, 'C Concept'),
       (3101, 69, '350 GTS Spider'),
       (3102, 69, '350 GTV'),
       (3103, 69, '400 GT'),
       (3104, 69, 'Aventador J Concept'),
       (3105, 69, 'Aventador LP700-4'),
       (3106, 69, 'Concept S'),
       (3107, 69, 'Countach 25th Anniversary'),
       (3108, 69, 'Countach Quattrovalvole'),
       (3109, 69, 'Diablo GTR'),
       (3110, 69, 'Diablo Iota'),
       (3111, 69, 'Gallardo LP560-4 Bicolore'),
       (3112, 69, 'Diablo Roadster'),
       (3113, 69, 'Diablo SE'),
       (3114, 69, 'Diablo SVR'),
       (3115, 69, 'Diablo VT'),
       (3116, 69, 'Estoque Concept'),
       (3117, 69, 'Gallardo LP550-2'),
       (3118, 69, 'Gallardo LP550-2 Spyder'),
       (3119, 69, 'Gallardo LP560-4'),
       (3120, 69, 'Gallardo LP560-4 Polizia'),
       (3121, 69, 'Gallardo LP560-4 Spyder'),
       (3122, 69, 'Gallardo LP560-4 Super Trofeo'),
       (3123, 69, 'Gallardo LP570-4 Blancpain'),
       (3124, 69, 'Gallardo LP570-4 Edizione Tecnica'),
       (3125, 69, 'Gallardo LP570-4 Spyder Performante'),
       (3126, 69, 'Gallardo LP570-4 Super Trofeo Stradale'),
       (3127, 69, 'Gallardo LP570-4 Superleggera'),
       (3128, 69, 'Gallardo Nera'),
       (3129, 69, 'Gallardo Police Car'),
       (3130, 69, 'Gallardo SE'),
       (3131, 69, 'Gallardo Spyder'),
       (3132, 69, 'Gallardo Superleggera'),
       (3133, 69, 'Jalpa'),
       (3134, 69, 'Jarama'),
       (3135, 69, 'Murcielago 40th Anniversary Edition'),
       (3136, 69, 'Gallardo'),
       (3137, 69, 'LM'),
       (3138, 69, 'Miura Concept'),
       (3139, 69, 'Murcielago'),
       (3140, 69, 'Diablo 6.0'),
       (3141, 69, 'Miura Roadster'),
       (3142, 69, 'Miura SV'),
       (3143, 69, 'Diablo SV'),
       (3144, 69, 'Murcielago Barchetta Concept'),
       (3145, 69, 'Murcielago LP640'),
       (3146, 69, 'Murcielago LP640 Roadster'),
       (3147, 69, 'Murcielago LP640 Versace'),
       (3148, 69, 'Diablo'),
       (3149, 69, 'Murcielago LP650-4 Roadster'),
       (3150, 69, 'Murcielago LP670-4 SuperVeloce'),
       (3151, 69, 'Murcielago LP670-4 SV China Edition'),
       (3152, 69, 'Murcielago RGT'),
       (3153, 69, 'Murcielago Roadster'),
       (3154, 69, 'Murcielago Sketch'),
       (3155, 69, 'Countach LP 400'),
       (3156, 69, 'Urraco'),
       (3157, 69, 'Reventon'),
       (3158, 69, 'Miura Jota'),
       (3159, 69, 'Reventon Roadster'),
       (3160, 69, 'Islero'),
       (3161, 69, 'Espada'),
       (3162, 69, 'Sesto Elemento Concept'),
       (3163, 69, 'Silhouette'),
       (3164, 69, '350 GT'),
       (3165, 69, 'Urus Concept'),
       (3166, 70, '2000 Coupe'),
       (3167, 70, 'Autobianchi A112'),
       (3168, 70, 'Beta'),
       (3169, 70, 'Beta HP Executive'),
       (3170, 70, 'Beta HPE'),
       (3171, 70, 'Beta Montecarlo'),
       (3172, 70, 'Beta Spider'),
       (3173, 70, 'Beta Trevi 2.0 VX'),
       (3174, 70, 'Dedra'),
       (3175, 70, 'Dedra SW'),
       (3176, 70, 'Delta'),
       (3177, 70, 'Delta 1.6 HF Turbo'),
       (3178, 70, 'Delta 1.8 Di Turbo Jet'),
       (3179, 70, 'Delta HF 4WD'),
       (3180, 70, 'Musa'),
       (3181, 70, 'Delta HPE Concept'),
       (3182, 70, 'Delta Integrale'),
       (3183, 70, 'Delta S4'),
       (3184, 70, 'Delta S4 Gruppo B'),
       (3185, 70, 'Flavia'),
       (3186, 70, 'Fulvia'),
       (3187, 70, 'Fulvia Coupe'),
       (3188, 70, 'Gamma Berlina'),
       (3189, 70, 'Granturismo Concept'),
       (3190, 70, 'Granturismo Stilnovo Concept'),
       (3191, 70, 'Lancia ECV Prototype'),
       (3192, 70, 'LC1 Gruppo 6'),
       (3193, 70, 'LC2 Gruppo C'),
       (3194, 70, 'Lybra Executive'),
       (3195, 70, 'Lybra Intensa'),
       (3196, 70, 'MomoDesign Urban Bike'),
       (3197, 70, 'Montecarlo Turbo Gruppo 5'),
       (3198, 70, 'Phedra'),
       (3199, 70, 'Phedra Promenade'),
       (3200, 70, 'Phedra Unique Edition'),
       (3201, 70, 'Prisma'),
       (3202, 70, 'Rally 037'),
       (3203, 70, 'Rally 037 Gruppo B'),
       (3204, 70, 'Stratos'),
       (3205, 70, 'Stratos Concept'),
       (3206, 70, 'Stratos Rally Version'),
       (3207, 70, 'Thema'),
       (3208, 70, 'Thesis'),
       (3209, 70, 'Thesis 2.4 20v JTD'),
       (3210, 70, 'Thesis Promenade'),
       (3211, 70, 'Voyager'),
       (3212, 70, 'Y'),
       (3213, 70, 'Y10'),
       (3214, 70, 'Ypsilon'),
       (3215, 70, 'Ypsilon 1.3 Multijet'),
       (3216, 70, 'Ypsilon BKini'),
       (3217, 70, 'Ypsilon DFN'),
       (3218, 70, 'Ypsilon MomoDesign'),
       (3219, 70, 'Ypsilon Sport Concept car'),
       (3220, 70, 'Ypsilon Sport MomoDesign'),
       (3221, 70, 'Ypsilon Versus'),
       (3222, 70, 'Flaminia 2.8'),
       (3223, 70, 'Flavia Sport 1500'),
       (3224, 70, 'Flavia 1.5'),
       (3225, 70, 'Flaminia Convertible'),
       (3226, 70, 'Appia'),
       (3227, 70, 'Aurelia B 24'),
       (3228, 70, 'Appia C10'),
       (3229, 70, 'D50 Formula 1'),
       (3230, 70, 'Aurelia B24 Spider'),
       (3231, 70, 'Aurelia B12'),
       (3232, 70, 'D24 Spider Sport'),
       (3233, 70, 'Aurelia B20 GT'),
       (3234, 70, 'Aurelia B10'),
       (3235, 70, 'Ardea'),
       (3236, 70, 'Aprilia Cabriolet'),
       (3237, 70, 'Aprilia'),
       (3238, 70, 'Aprilia 238'),
       (3239, 70, 'Artena'),
       (3240, 70, 'Augusta 231'),
       (3241, 70, 'Astura Double Phaeton'),
       (3242, 70, 'Astura 233'),
       (3243, 70, 'Astura 230'),
       (3244, 70, 'Artena 228'),
       (3245, 70, 'Lambda'),
       (3246, 70, 'Dilambda 227'),
       (3247, 70, 'Theta 35HP'),
       (3248, 70, 'Gamma 20HP'),
       (3249, 70, 'Alpha 12HP'),
       (3250, 71, 'DC100 Concept'),
       (3251, 71, 'DC100 Sport Concept'),
       (3252, 71, 'Freelander 2'),
       (3253, 71, 'Defender'),
       (3254, 71, 'Defender SVX'),
       (3255, 71, 'Defender X-Tech'),
       (3256, 71, 'Range Rover Evoque Convertible Concept'),
       (3257, 71, 'Discovery 3'),
       (3258, 71, 'Discovery 4'),
       (3259, 71, 'Range Rover'),
       (3260, 71, 'Freelander'),
       (3261, 71, 'Freelander 2 Sport'),
       (3262, 71, 'Discovery 4 Armoured'),
       (3263, 71, 'Freelander 2 TD4 e'),
       (3264, 71, 'Freelander Callaway'),
       (3265, 71, 'Freelander SE3'),
       (3266, 71, 'Freelander Td4 3door'),
       (3267, 71, 'Freelander Td4 5door'),
       (3268, 71, 'Land e Concept'),
       (3269, 71, 'LR2'),
       (3270, 71, 'LR2 HSE'),
       (3271, 71, 'LR3'),
       (3272, 71, 'LRX Concept'),
       (3273, 71, 'LRX Geneva Concept'),
       (3274, 71, 'Range e Concept'),
       (3275, 71, 'Range Rover Autobiography'),
       (3276, 71, 'Range Rover Autobiography Black'),
       (3277, 71, 'Range Rover Autobiography Ultimate Edition'),
       (3278, 71, 'Range Rover Evoque'),
       (3279, 71, 'Range Rover Evoque 5-door'),
       (3280, 71, 'Range Rover Evoque Victoria Beckham'),
       (3281, 71, 'Range Rover Sport'),
       (3282, 71, 'Range Rover Sport Autobiography'),
       (3283, 71, 'Range Rover Sport Diesel'),
       (3284, 71, 'Range Stormer Concept'),
       (3285, 71, 'Supercharged Range Rover'),
       (3286, 72, 'Mirabeau'),
       (3287, 73, 'CT 200h'),
       (3288, 73, 'ES 350'),
       (3289, 73, 'ES330'),
       (3290, 73, 'ES330 Sport Design'),
       (3291, 73, 'ES350'),
       (3292, 73, 'GS 250'),
       (3293, 73, 'GS 350'),
       (3294, 73, 'GS 450h'),
       (3295, 73, 'GS 450h F Sport'),
       (3296, 73, 'GS 460'),
       (3297, 73, 'GS 350 F Sport'),
       (3298, 73, 'ES 300h'),
       (3299, 73, 'GS300'),
       (3300, 73, 'GS430'),
       (3301, 73, 'GX 460'),
       (3302, 73, 'GX 470'),
       (3303, 73, 'GX470'),
       (3304, 73, 'HS 250h'),
       (3305, 73, 'IS 350'),
       (3306, 73, 'IS 350 F Sport'),
       (3307, 73, 'IS250C'),
       (3308, 73, 'IS300 SportDesign Edition'),
       (3309, 73, 'IS350'),
       (3310, 73, 'RX 350'),
       (3311, 73, 'LS 600h'),
       (3312, 73, 'LS 460 Sport'),
       (3313, 73, 'LS 460 L'),
       (3314, 73, 'IS Convertible'),
       (3315, 73, 'IS430 Project'),
       (3316, 73, 'IS-F'),
       (3317, 73, 'IS-F EU Version'),
       (3318, 73, 'LFA'),
       (3319, 73, 'LFA Concept'),
       (3320, 73, 'LFA Nurburgring Package'),
       (3321, 73, 'LF-A Roadster Concept'),
       (3322, 73, 'LS 600h L'),
       (3323, 73, 'LS600h L Pebble Beach Edition'),
       (3324, 73, 'LS460 AWD'),
       (3325, 73, 'LFC Concept'),
       (3326, 73, 'LF-CC Concept'),
       (3327, 73, 'LF-Ch Concept'),
       (3328, 73, 'LF-Gh Concept'),
       (3329, 73, 'LF-LC Blue Concept'),
       (3330, 73, 'LF-LC Concept'),
       (3331, 73, 'LF-Xh Concept'),
       (3332, 73, 'LS 460'),
       (3333, 73, 'LS 460 F Sport'),
       (3334, 73, 'LS 460L'),
       (3335, 73, 'LF-A Concept'),
       (3336, 73, 'LS 600h L Landaulet'),
       (3337, 73, 'LS430'),
       (3338, 73, 'LS430 European Version'),
       (3339, 73, 'LX 570'),
       (3340, 73, 'IS250 European Version'),
       (3341, 73, 'LX470'),
       (3342, 73, 'Minority Report Sports Car'),
       (3343, 73, 'RX 350 F Sport'),
       (3344, 73, 'RX 450h'),
       (3345, 73, 'RX 450h F Sport'),
       (3346, 73, 'RX330'),
       (3347, 73, 'RX330 Thundercloud'),
       (3348, 73, 'RX400h'),
       (3349, 73, 'SC 430'),
       (3350, 73, 'SC430'),
       (3351, 73, 'SC430 Pebble Beach Edition'),
       (3352, 73, 'SC430 Pace Car'),
       (3353, 73, 'Sport Coupe Concept'),
       (3354, 74, 'Aviator'),
       (3355, 74, 'Aviator Concept'),
       (3356, 74, 'C Concept'),
       (3357, 74, 'Continental Concept'),
       (3358, 74, 'Mark LT'),
       (3359, 74, 'Mark X Concept'),
       (3360, 74, 'MK9 Concept'),
       (3361, 74, 'MKR Concept'),
       (3362, 74, 'MKS'),
       (3363, 74, 'MKT'),
       (3364, 74, 'MKZ'),
       (3365, 74, 'MKX'),
       (3366, 74, 'MKT Concept'),
       (3367, 74, 'MKS Concept'),
       (3368, 74, 'MKZ Concept'),
       (3369, 74, 'MKZ Hybrid'),
       (3370, 74, 'Navigator'),
       (3371, 74, 'Town Car'),
       (3372, 74, 'Navicross Concept'),
       (3373, 74, 'Town Car Cartier'),
       (3374, 74, 'Town Car Cartier L'),
       (3375, 74, 'Zephyr'),
       (3376, 75, 'H1'),
       (3377, 76, 'LS Concept'),
       (3378, 77, '2-Eleven'),
       (3379, 77, 'Circuit Car'),
       (3380, 77, 'Eco Elise'),
       (3381, 77, 'Elan'),
       (3382, 77, 'Elan Concept'),
       (3383, 77, 'Elise'),
       (3384, 77, 'Elise 160'),
       (3385, 77, 'Elise Club Racer'),
       (3386, 77, 'Elise Concept'),
       (3387, 77, 'Elise R'),
       (3388, 77, 'Elise S'),
       (3389, 77, 'Elise SC'),
       (3390, 77, 'Elise SC Clark Type 25'),
       (3391, 77, 'Elise Type 49'),
       (3392, 77, 'Elite'),
       (3393, 77, 'Elite Concept'),
       (3394, 77, 'Esprit Concept'),
       (3395, 77, 'Esprit Turbo'),
       (3396, 77, 'Esprit V8'),
       (3397, 77, 'Eterne Concept'),
       (3398, 77, 'Europa'),
       (3399, 77, 'Europa Diamond Edition'),
       (3400, 77, 'Europa S'),
       (3401, 77, 'Europa SE'),
       (3402, 77, 'Evora'),
       (3403, 77, 'Evora 414E Hybrid Concept'),
       (3404, 77, 'Evora Carbon Concept'),
       (3405, 77, 'Evora GTE'),
       (3406, 77, 'Evora GX Racecar'),
       (3407, 77, 'Evora S'),
       (3408, 77, 'Evora Type 124 Endurance Racecar'),
       (3409, 77, 'Exige'),
       (3410, 77, 'Exige 265E Concept'),
       (3411, 77, 'Exige Cup 260'),
       (3412, 77, 'Exige S'),
       (3413, 77, 'Exige S 240'),
       (3414, 77, 'Exige S Roadster'),
       (3415, 77, 'Exige S Type 72'),
       (3416, 77, 'Exige Sprint'),
       (3417, 77, 'Hot Wheels Concept'),
       (3418, 77, 'Ice Vehicle Concept'),
       (3419, 78, 'Icon Concept'),
       (3420, 78, '6'),
       (3421, 78, 'Zero Concept'),
       (3422, 78, 'TF'),
       (3423, 78, 'TF LE500'),
       (3424, 78, 'XPower SVR'),
       (3425, 78, 'GT Concept'),
       (3426, 78, 'TF Cool Blue SE'),
       (3427, 78, 'TF 160'),
       (3428, 78, 'XPower SV Concept'),
       (3429, 79, 'Lamborghini Aventador'),
       (3430, 79, 'Porsche Panamera'),
       (3431, 79, 'Maserati GranTurismo'),
       (3432, 79, 'Bugatti Veyron Linea Vincero dOro'),
       (3433, 79, 'Vitesse Rose'),
       (3434, 79, 'Cyrus'),
       (3435, 79, 'Chopster'),
       (3436, 79, 'Bugatti Veyron Linea Vincero'),
       (3437, 79, 'Stallone'),
       (3438, 79, 'Renovatio'),
       (3439, 79, 'Le Mansory Convertible'),
       (3440, 79, 'Bel Air'),
       (3441, 79, 'Rolls Royce Conquistador'),
       (3442, 79, 'Le Mansory'),
       (3443, 79, 'Bentley Continental GTC'),
       (3444, 79, 'Bentley Continental Flying Spur'),
       (3445, 79, 'Aston Martin Vantage V8'),
       (3446, 79, 'Bentley Continental GT'),
       (3447, 79, 'Aston Martin Vanquish S'),
       (3448, 79, 'Aston Martin DB9 Volante'),
       (3449, 80, 'TSO GT2'),
       (3450, 80, 'TSO Convertible'),
       (3451, 81, 'Coupe'),
       (3452, 81, 'GranCabrio MC'),
       (3453, 81, 'GranCabrio Sport'),
       (3454, 81, 'GranSport'),
       (3455, 81, 'GranCabrio Fendi'),
       (3456, 81, 'Quattroporte Sport GT S MC Sport Line'),
       (3457, 81, 'Quattroporte Sport GT S Awards Edition'),
       (3458, 81, 'GranCabrio'),
       (3459, 81, 'Quattroporte Sport GT S'),
       (3460, 81, 'GranSport MC Victory'),
       (3461, 81, 'GranSport Spyder'),
       (3462, 81, 'GranTurismo S'),
       (3463, 81, 'GranTurismo'),
       (3464, 81, 'GranTurismo MC Concept'),
       (3465, 81, 'GranTurismo MC Stradale'),
       (3466, 81, 'GranTurismo S Automatic'),
       (3467, 81, 'GranTurismo Sport'),
       (3468, 81, 'GS Zagato'),
       (3469, 81, 'Kubang'),
       (3470, 81, 'Kubang Concept Car'),
       (3471, 81, 'MC12'),
       (3472, 81, 'Spyder'),
       (3473, 81, 'MC12 Corsa'),
       (3474, 81, 'MCC Prototype'),
       (3475, 81, 'Quattroporte'),
       (3476, 81, 'Quattroporte Executive GT'),
       (3477, 81, 'Quattroporte Neiman Marcus'),
       (3478, 81, 'Quattroporte Sport GT'),
       (3479, 81, 'Spyder 90th Anniversary'),
       (3480, 81, 'Spyder Vintage package'),
       (3481, 81, 'Trofeo'),
       (3482, 81, 'Trofeo Light'),
       (3483, 82, '62 S'),
       (3484, 82, 'Zeppelin'),
       (3485, 82, 'Xenatec Coupe'),
       (3486, 82, 'Landaulet'),
       (3487, 82, 'Landaulet Concept'),
       (3488, 82, '62 S'),
       (3489, 82, 'Exelero'),
       (3490, 82, '57S Special'),
       (3491, 82, '62'),
       (3492, 82, '57'),
       (3493, 83, '2'),
       (3494, 83, '3 S'),
       (3495, 83, '3'),
       (3496, 83, '6 Sedan'),
       (3497, 83, '5'),
       (3498, 83, '6'),
       (3499, 83, '323'),
       (3500, 83, '2 3-Door'),
       (3501, 83, '3 5door'),
       (3502, 83, '3 Facelift'),
       (3503, 83, '3 i-stop'),
       (3504, 83, '3 MPS'),
       (3505, 83, '3 Sedan'),
       (3506, 83, '323F'),
       (3507, 83, '5 European Version'),
       (3508, 83, '6 AWD'),
       (3509, 83, '6 Facelift'),
       (3510, 83, '6 MPS'),
       (3511, 83, '6 MPS Concept'),
       (3512, 83, '6 SAP'),
       (3513, 83, 'MX-5 Superlight Concept'),
       (3514, 83, '6 Sport'),
       (3515, 83, '6 Wagon'),
       (3516, 83, '6 US-spec'),
       (3517, 83, '6 SAP Wagon'),
       (3518, 83, '6 Wagon Facelift'),
       (3519, 83, 'Atenza'),
       (3520, 83, 'Atenza Sport Wagon'),
       (3521, 83, 'Kiyora Concept'),
       (3522, 83, 'Kazamai Concept'),
       (3523, 83, 'Furai Concept'),
       (3524, 83, '6 Hatchback'),
       (3525, 83, '2 Sedan'),
       (3526, 83, 'Taiki Concept'),
       (3527, 83, 'Ryuga Concept'),
       (3528, 83, 'Hakaze Concept'),
       (3529, 83, 'CX-9'),
       (3530, 83, 'CX-7'),
       (3531, 83, 'B2500'),
       (3532, 83, 'BT-50'),
       (3533, 83, 'CX-5'),
       (3534, 83, 'CX9'),
       (3535, 83, 'Demio'),
       (3536, 83, 'Demio Stardust Pink Limited Edition'),
       (3537, 83, 'Ibuki Concept'),
       (3538, 83, 'Kabura Concept'),
       (3539, 83, 'Kusabi Concept'),
       (3540, 83, 'MazdaSpeed MX5'),
       (3541, 83, 'Minagi Concept'),
       (3542, 83, 'MPV ES'),
       (3543, 83, 'MPV European Version'),
       (3544, 83, 'MX Sport Runabout Concept'),
       (3545, 83, 'MX Sport Tourer Concept'),
       (3546, 83, 'MX Sportif Concept'),
       (3547, 83, 'MX5'),
       (3548, 83, 'MX-5'),
       (3549, 83, 'MX-5 GT Concept'),
       (3550, 83, 'MX-5 GT Race Car'),
       (3551, 83, 'MX-5 Kuro'),
       (3552, 83, 'MX-5 Miata Roadster'),
       (3553, 83, 'MX-5 Miata Special Edition'),
       (3554, 83, 'MX-5 MPS Concept'),
       (3555, 83, 'MX-5 Niseko'),
       (3556, 83, 'MX-5 Roadster Coupe'),
       (3557, 83, 'MX-5 Spyder Concept'),
       (3558, 83, 'MXCrossport Concept'),
       (3559, 83, 'MXFlexa Concept'),
       (3560, 83, 'MXMicro Sport Concept'),
       (3561, 83, 'Nagare Concept'),
       (3562, 83, 'Premacy'),
       (3563, 83, 'Roadster'),
       (3564, 83, 'RX7'),
       (3565, 83, 'RX-8'),
       (3566, 83, 'RX-8 Concept'),
       (3567, 83, 'RX-8 Dingo Art'),
       (3568, 83, 'RX-8 Hydrogen Concept'),
       (3569, 83, 'RX8 XMen'),
       (3570, 83, 'Sassou Concept'),
       (3571, 83, 'Senku Concept'),
       (3572, 83, 'Shinari Concept'),
       (3573, 83, 'Takeri Concept'),
       (3574, 83, 'Tribute'),
       (3575, 83, 'Tribute Hybrid-Electric Vehicle'),
       (3576, 83, 'Washu Concept'),
       (3577, 83, 'Xedos 9'),
       (3578, 84, 'Identity i1'),
       (3579, 85, 'MP4-12C Spider'),
       (3580, 85, 'MP4-12C'),
       (3581, 85, 'X-1 Concept'),
       (3582, 85, 'P1 Concept'),
       (3583, 85, '12C Can-Am Edition Concept'),
       (3584, 85, 'MP4-12C GT3'),
       (3585, 85, 'MP4-12C'),
       (3586, 85, 'F1 GTR'),
       (3587, 85, 'F1'),
       (3588, 85, 'M6GT'),
       (3589, 86, '150'),
       (3590, 86, '170'),
       (3591, 86, '190'),
       (3592, 86, 'SL65 AMG'),
       (3593, 86, '220'),
       (3594, 86, '230'),
       (3595, 86, '320'),
       (3596, 86, '190 SL Roadster'),
       (3597, 86, '190E'),
       (3598, 86, '220 a'),
       (3599, 86, '220SE'),
       (3600, 86, '230 SL Roadster'),
       (3601, 86, 'G63 AMG'),
       (3602, 86, 'G-Class'),
       (3603, 86, '240 D 3.0'),
       (3604, 86, 'Citan'),
       (3605, 86, 'CLS Shooting Brake'),
       (3606, 86, '250C'),
       (3607, 86, '260D'),
       (3608, 86, '280 E'),
       (3609, 86, '280 SE 3.5 Cabriolet'),
       (3610, 86, '280 SE 3.5 Coupe'),
       (3611, 86, 'SLK350'),
       (3612, 86, '300 CE 6.3 AMG'),
       (3613, 86, '300 S'),
       (3614, 86, '300 SEL 6.3 AMG'),
       (3615, 86, 'M-Class'),
       (3616, 86, '300 SL'),
       (3617, 86, '300 SL Gullwing'),
       (3618, 86, '300 SLR'),
       (3619, 86, '300CD Turbodiesel'),
       (3620, 86, 'CLS550'),
       (3621, 86, 'CLS350 CDI'),
       (3622, 86, '300d'),
       (3623, 86, '300D Turbodiesel'),
       (3624, 86, '300SD Turbodiesel'),
       (3625, 86, '450 SEL 6.9'),
       (3626, 86, '500 K'),
       (3627, 86, '500E'),
       (3628, 86, 'C-Class UK Version'),
       (3629, 86, 'C-Class Estate'),
       (3630, 86, '540 K Luxury Roadster'),
       (3631, 86, 'C-Class'),
       (3632, 86, '600 Pullman Limousine'),
       (3633, 86, 'B-Class'),
       (3634, 86, '770 Grand Mercedes Cabriolet'),
       (3635, 86, 'A 200 Turbo'),
       (3636, 86, 'A170 Classic 5door'),
       (3637, 86, 'A180 CDI 3door'),
       (3638, 86, 'A200 Avantgarde 3door'),
       (3639, 86, 'A200 CDI Avantgarde 5door'),
       (3640, 86, 'SLS AMG GT3'),
       (3641, 86, 'A200 Elegance 5door'),
       (3642, 86, 'SL550 Night Edition'),
       (3643, 86, 'S63 AMG'),
       (3644, 86, 'AClass'),
       (3645, 86, 'R-Class'),
       (3646, 86, 'A-Class'),
       (3647, 86, 'GL-Class Grand Edition'),
       (3648, 86, 'A-Class Concept'),
       (3649, 86, 'A-Class Coupe'),
       (3650, 86, 'A-Class E-CELL'),
       (3651, 86, 'Auto 2000 Concept'),
       (3652, 86, 'B150'),
       (3653, 86, 'B200 CDI'),
       (3654, 86, 'B200 Turbo'),
       (3655, 86, 'B-Class Electric Drive Concept'),
       (3656, 86, 'B-Class F-Cell'),
       (3657, 86, 'Biome Concept'),
       (3658, 86, 'Bionic Concept Car'),
       (3659, 86, 'C63 AMG DTM Safety Car'),
       (3660, 86, 'Bluetec Hybrid Concept'),
       (3661, 86, 'B55 Concept'),
       (3662, 86, 'B-Class E-CELL Plus Concept'),
       (3663, 86, 'BlueZero Concept'),
       (3664, 86, 'BlueZero E-Cell Plus Concept'),
       (3665, 86, 'C 111-II Concept'),
       (3666, 86, 'C112 Concept'),
       (3667, 86, 'C200 CGI Estate Elegance'),
       (3668, 86, 'C220 CDI Avantgarde');
INSERT INTO `models` (`id`, `make_id`, `name`)
VALUES (3669, 86, 'C320 Sport Coupe'),
       (3670, 86, 'C55 AMG'),
       (3671, 86, 'C63 AMG'),
       (3672, 86, 'C63 AMG Coupe'),
       (3673, 86, 'C63 AMG Coupe Black Series'),
       (3674, 86, 'C63 AMG Coupe Black Series DTM Safety Car'),
       (3675, 86, 'C63 AMG Estate'),
       (3676, 86, 'C63 AMG Estate F1 Medical Car'),
       (3677, 86, 'CClass'),
       (3678, 86, 'E63 AMG Estate'),
       (3679, 86, 'C-Class Coupe'),
       (3680, 86, 'C-Class DR 520'),
       (3681, 86, 'C-Class DTM AMG'),
       (3682, 86, 'CL 500'),
       (3683, 86, 'CL 600'),
       (3684, 86, 'E-Class AMG Sports Package'),
       (3685, 86, 'CL 63 AMG'),
       (3686, 86, 'CL Coupe'),
       (3687, 86, 'CL500'),
       (3688, 86, 'CL55 AMG'),
       (3689, 86, 'CL55 AMG F1 Limited Edition'),
       (3690, 86, 'CL55 AMG F1 Safety Car'),
       (3691, 86, 'CL600'),
       (3692, 86, 'CL63 AMG'),
       (3693, 86, 'CL65 AMG'),
       (3694, 86, 'CL65 AMG UK Version'),
       (3695, 86, 'CLC'),
       (3696, 86, 'CL-Class'),
       (3697, 86, 'CL-Class AMG Sports Package'),
       (3698, 86, 'CL-Class AMG styling'),
       (3699, 86, 'CLK 63 AMG'),
       (3700, 86, 'CLK 63 AMG Cabriolet'),
       (3701, 86, 'CLK Cabriolet'),
       (3702, 86, 'CLK Coupe'),
       (3703, 86, 'CLK designo by Giorgio Armani'),
       (3704, 86, 'CLK DTM AMG'),
       (3705, 86, 'CLK DTM AMG Cabriolet'),
       (3706, 86, 'CLK GTR'),
       (3707, 86, 'CLK320 Cabriolet'),
       (3708, 86, 'CLK320 CDI Cabriolet Avantgarde'),
       (3709, 86, 'CLK320 Coupe'),
       (3710, 86, 'CLK350'),
       (3711, 86, 'CLK430 Cabriolet'),
       (3712, 86, 'CLK430 Coupe'),
       (3713, 86, 'CLK55 AMG'),
       (3714, 86, 'CLK55 AMG F1 Safety Car'),
       (3715, 86, 'CLK55 Cabriolet AMG'),
       (3716, 86, 'CLK63 AMG Black Series'),
       (3717, 86, 'CLS 280'),
       (3718, 86, 'CLS 350 CGI'),
       (3719, 86, 'CLS 63 AMG'),
       (3720, 86, 'CLS Grand Edition'),
       (3721, 86, 'CLS500'),
       (3722, 86, 'CLS63 AMG'),
       (3723, 86, 'CLS63 AMG Shooting Brake'),
       (3724, 86, 'CLS63 AMG US Version'),
       (3725, 86, 'CLS-Class'),
       (3726, 86, 'Compact Sports Tourer Vision B Concept'),
       (3727, 86, 'Direct Hybrid Concept'),
       (3728, 86, 'E 63 AMG'),
       (3729, 86, 'E 63 AMG Estate'),
       (3730, 86, 'E200 Kompressor Estate Classic'),
       (3731, 86, 'E300 BlueTEC Hybrid new'),
       (3732, 86, 'E320'),
       (3733, 86, 'E320 CDI Estate Elegance'),
       (3734, 86, 'E320 Estate Avantgarde'),
       (3735, 86, 'E320 Wagon'),
       (3736, 86, 'E350'),
       (3737, 86, 'E350 4Matic Wagon'),
       (3738, 86, 'E350 Cabriolet'),
       (3739, 86, 'E350 Coupe'),
       (3740, 86, 'E350 Estate'),
       (3741, 86, 'E350 with Sports Equipment'),
       (3742, 86, 'E55 AMG'),
       (3743, 86, 'E550'),
       (3744, 86, 'E550 Cabriolet'),
       (3745, 86, 'E550 Coupe'),
       (3746, 86, 'E63 AMG'),
       (3747, 86, 'E63 AMG Wagon'),
       (3748, 86, 'E-Class'),
       (3749, 86, 'E-Class 4Matic'),
       (3750, 86, 'E-Class Cabriolet'),
       (3751, 86, 'E-Class Cabriolet UK Version'),
       (3752, 86, 'E-Class Coupe'),
       (3753, 86, 'E-Class Coupe UK Version'),
       (3754, 86, 'E-Class Estate'),
       (3755, 86, 'E-Class Estate AMG Sports Package'),
       (3756, 86, 'E-Class Executive'),
       (3757, 86, 'E-Class L'),
       (3758, 86, 'F 100 Concept'),
       (3759, 86, 'F 200 Concept'),
       (3760, 86, 'F 300 Concept'),
       (3761, 86, 'F 400 Carving Concept'),
       (3762, 86, 'F 500 Concept'),
       (3763, 86, 'F 600 Hygenius Concept'),
       (3764, 86, 'F125 Concept'),
       (3765, 86, 'F500 Mind Concept'),
       (3766, 86, 'F700 Concept'),
       (3767, 86, 'F800 Style Concept'),
       (3768, 86, 'Fascination Concept'),
       (3769, 86, 'F-Cell Roadster Concept'),
       (3770, 86, 'G55 AMG'),
       (3771, 86, 'G55 AMG Kompressor'),
       (3772, 86, 'G-Class BA3 Final Edition'),
       (3773, 86, 'G-Class Edition Select'),
       (3774, 86, 'G-Class UK Version'),
       (3775, 86, 'GL 420 CDI'),
       (3776, 86, 'GL450'),
       (3777, 86, 'GL550'),
       (3778, 86, 'GL63 AMG'),
       (3779, 86, 'GL-Class'),
       (3780, 86, 'GLK 350 4MATIC'),
       (3781, 86, 'GLK Freeside Concept'),
       (3782, 86, 'GLK Townside Concept'),
       (3783, 86, 'GLK350 4Matic'),
       (3784, 86, 'GLK-Class'),
       (3785, 86, 'Grand Sports Tourer Vision R Concept'),
       (3786, 86, 'ML 63 AMG'),
       (3787, 86, 'ML320'),
       (3788, 86, 'ML350'),
       (3789, 86, 'ML430'),
       (3790, 86, 'ML450 Hybrid'),
       (3791, 86, 'ML500'),
       (3792, 86, 'ML55 AMG'),
       (3793, 86, 'ML63 AMG'),
       (3794, 86, 'ML63 AMG 10th Anniversary'),
       (3795, 86, 'ML63 AMG Performance Studio'),
       (3796, 86, 'Ocean Drive Concept'),
       (3797, 86, 'R 63 AMG'),
       (3798, 86, 'R500'),
       (3799, 86, 'R-Class AMG Styling'),
       (3800, 86, 'S 500 4MATIC'),
       (3801, 86, 'S 600 Guard'),
       (3802, 86, 'S 600 Guard Pullman'),
       (3803, 86, 'S 63 AMG'),
       (3804, 86, 'S320 CDI BlueEfficiency'),
       (3805, 86, 'S400 BlueHYBRID'),
       (3806, 86, 'S500 4MATIC'),
       (3807, 86, 'S500 Plug-in Hybrid Concept'),
       (3808, 86, 'S550'),
       (3809, 86, 'S600 Pullman Guard'),
       (3810, 86, 'S600 Pullman Limousine W140'),
       (3811, 86, 'S65 AMG'),
       (3812, 86, 'S-Class'),
       (3813, 86, 'S-Class AMG Sports Package'),
       (3814, 86, 'S-Class Coupe'),
       (3815, 86, 'S-Class Pullman Limousine W220'),
       (3816, 86, 'S-Class UK Version'),
       (3817, 86, 'S-Class W126'),
       (3818, 86, 'Shooting Break Concept'),
       (3819, 86, 'Silver Arrow Concept'),
       (3820, 86, 'SL 350'),
       (3821, 86, 'SL 500'),
       (3822, 86, 'SL 55 AMG'),
       (3823, 86, 'SL 600'),
       (3824, 86, 'SL 63 AMG Edition IWC'),
       (3825, 86, 'SL 63 AMG F1 Safety Car'),
       (3826, 86, 'SL 65 AMG'),
       (3827, 86, 'SL350'),
       (3828, 86, 'SL350 Mille Miglia Edition'),
       (3829, 86, 'SL500'),
       (3830, 86, 'SL55 AMG'),
       (3831, 86, 'SL55 AMG F1 Safety Car'),
       (3832, 86, 'SL55 AMG with Performance Package'),
       (3833, 86, 'SL550'),
       (3834, 86, 'SL600'),
       (3835, 86, 'SL63 AMG'),
       (3836, 86, 'SL63 AMG F1 Safety Car'),
       (3837, 86, 'SL65 AMG Black Series'),
       (3838, 86, 'SL73 AMG'),
       (3839, 86, 'SL-Class'),
       (3840, 86, 'SL-Class Sports Package'),
       (3841, 86, 'SLK 2LOOK Edition'),
       (3842, 86, 'SLK 55 AMG'),
       (3843, 86, 'SLK 55 AMG Black Series'),
       (3844, 86, 'SLK 55 AMG SS'),
       (3845, 86, 'SLK Edition 10'),
       (3846, 86, 'SLK Final Edition'),
       (3847, 86, 'SLK Prototype'),
       (3848, 86, 'SLK Roadster'),
       (3849, 86, 'SLK200 Kompressor'),
       (3850, 86, 'SLK250 CDI'),
       (3851, 86, 'SLK32 AMG'),
       (3852, 86, 'SLK320'),
       (3853, 86, 'SLK55 AMG'),
       (3854, 86, 'SLK55 AMG F1 Safety Car'),
       (3855, 86, 'SLKClass'),
       (3856, 86, 'SLK-Class'),
       (3857, 86, 'SLKClass Special Edition'),
       (3858, 86, 'SLR 722 Edition'),
       (3859, 86, 'SLR McLaren'),
       (3860, 86, 'SLR McLaren Roadster'),
       (3861, 86, 'SLR McLaren Roadster 722 S'),
       (3862, 86, 'SLR Stirling Moss'),
       (3863, 86, 'SLS AMG'),
       (3864, 86, 'SLS AMG Coupe Electric Drive'),
       (3865, 86, 'SLS AMG E-Cell Concept'),
       (3866, 86, 'SLS AMG F1 Safety Car'),
       (3867, 86, 'SLS AMG GT'),
       (3868, 86, 'SLS AMG GT F1 Safety Car'),
       (3869, 86, 'SLS AMG GT3 45th Anniversary new'),
       (3870, 86, 'SLS AMG Roadster'),
       (3871, 86, 'SLS AMG UK Version'),
       (3872, 86, 'SLS AMG US Version'),
       (3873, 86, 'Style Coupe Concept'),
       (3874, 86, 'Type S'),
       (3875, 86, 'Viano'),
       (3876, 86, 'Vision C 220 Bluetec Concept'),
       (3877, 86, 'Vision CLS Concept'),
       (3878, 86, 'Vision GLK Bluetec Hybrid Concept'),
       (3879, 86, 'Vision Grand Sports Tourer Concept'),
       (3880, 86, 'Vision GST Concept'),
       (3881, 86, 'Vision R 63 AMG'),
       (3882, 86, 'Vision SLA Concept'),
       (3883, 86, 'Vision SLR Concept'),
       (3884, 86, 'Vision SLR Roadster Concept'),
       (3885, 86, 'Vito'),
       (3886, 86, 'Vito E-Cell'),
       (3887, 87, 'Cougar C2'),
       (3888, 87, 'Cougar Zn'),
       (3889, 87, 'Marauder'),
       (3890, 87, 'Marauder Concept'),
       (3891, 87, 'Marauder Convertible Concept'),
       (3892, 87, 'Mariner Hybrid'),
       (3893, 87, 'Messenger Concept'),
       (3894, 87, 'Meta One Concept'),
       (3895, 87, 'Milan'),
       (3896, 87, 'Milan Hybrid'),
       (3897, 87, 'Milan Premier V6'),
       (3898, 87, 'Montego'),
       (3899, 87, 'Monterey Advance Trac'),
       (3900, 87, 'Mountaineer'),
       (3901, 87, 'Sable'),
       (3902, 88, 'E-Motion Concept'),
       (3903, 89, 'Baker Street'),
       (3904, 89, 'Bayswater'),
       (3905, 89, 'Beachcomber Concept'),
       (3906, 89, 'Countryman John Cooper Works'),
       (3907, 89, 'Clubman'),
       (3908, 89, 'Clubman John Cooper Works'),
       (3909, 89, 'Clubvan'),
       (3910, 89, 'Clubvan Concept'),
       (3911, 89, 'Concept Detroit'),
       (3912, 89, 'Concept Frankfurt'),
       (3913, 89, 'Concept Geneva'),
       (3914, 89, 'Concept Tokyo'),
       (3915, 89, 'Convertible Highgate'),
       (3916, 89, 'Cooper'),
       (3917, 89, 'Cooper Convertible'),
       (3918, 89, 'Cooper D'),
       (3919, 89, 'Cooper D Clubman'),
       (3920, 89, 'Cooper John Cooper Works'),
       (3921, 89, 'Cooper S'),
       (3922, 89, 'Cooper S Cabrio'),
       (3923, 89, 'Cooper S Convertible'),
       (3924, 89, 'Cooper S John Cooper Challenge'),
       (3925, 89, 'Cooper S John Cooper Works'),
       (3926, 89, 'Cooper S John Cooper Works GP Tuning Kit'),
       (3927, 89, 'Cooper S John Cooper Works Tuning Kit'),
       (3928, 89, 'Cooper S John Cooper Works with Aerodynamic Kit'),
       (3929, 89, 'Countryman'),
       (3930, 89, 'Coupe'),
       (3931, 89, 'Coupe Concept'),
       (3932, 89, 'Crossover Concept'),
       (3933, 89, 'E'),
       (3934, 89, 'John Cooper Works Challenge'),
       (3935, 89, 'John Cooper Works Convertible'),
       (3936, 89, 'John Cooper Works Coupe Endurance'),
       (3937, 89, 'John Cooper Works GP'),
       (3938, 89, 'Knightsbridge'),
       (3939, 89, 'One'),
       (3940, 89, 'One Clubman'),
       (3941, 89, 'One D'),
       (3942, 89, 'Paceman'),
       (3943, 89, 'Paceman Concept'),
       (3944, 89, 'Roadster'),
       (3945, 89, 'Roadster Concept'),
       (3946, 89, 'Rocketman Concept'),
       (3947, 89, 'Scooter E Concept'),
       (3948, 89, 'Seven'),
       (3949, 89, 'Versace Cabrio'),
       (3950, 89, 'WRC'),
       (3951, 89, 'XXL'),
       (3952, 90, 'ASX'),
       (3953, 90, 'Colt 5-door'),
       (3954, 90, 'Colt CZ3'),
       (3955, 90, 'Colt CZC'),
       (3956, 90, 'Colt CZC Turbo'),
       (3957, 90, 'Colt CZT'),
       (3958, 90, 'Concept-cX'),
       (3959, 90, 'Concept-ZT'),
       (3960, 90, 'CUV'),
       (3961, 90, 'Eclipse GT'),
       (3962, 90, 'Eclipse Spyder'),
       (3963, 90, 'Eclipse Spyder GT'),
       (3964, 90, 'Endeavor SE'),
       (3965, 90, 'Outlander GT Concept'),
       (3966, 90, 'Lancer Sportback Ralliart'),
       (3967, 90, 'Galant'),
       (3968, 90, 'Lancer Ralliart'),
       (3969, 90, 'Galant Fortis Ralliart'),
       (3970, 90, 'Galant Ralliart'),
       (3971, 90, 'i MiEV Concept'),
       (3972, 90, 'i MiEV Sport Air Concept'),
       (3973, 90, 'Colt'),
       (3974, 90, 'Racing Lancer'),
       (3975, 90, 'i-MiEV'),
       (3976, 90, 'i-MiEV US Version'),
       (3977, 90, 'L200 Club Cab'),
       (3978, 90, 'L200 Double Cab'),
       (3979, 90, 'L200 Single Cab'),
       (3980, 90, 'Lancer'),
       (3981, 90, 'Lancer ES'),
       (3982, 90, 'Lancer Evolution MR'),
       (3983, 90, 'Lancer Evolution X'),
       (3984, 90, 'Lancer Evolution X FQ-400'),
       (3985, 90, 'Lancer Sportback'),
       (3986, 90, 'Outlander'),
       (3987, 90, 'Outlander ES'),
       (3988, 90, 'Outlander GT'),
       (3989, 90, 'Outlander SE'),
       (3990, 90, 'Outlander Sport'),
       (3991, 90, 'Outlander Urban'),
       (3992, 90, 'Pajero European Specs'),
       (3993, 90, 'Pajero Evolution'),
       (3994, 90, 'Prototype X Concept'),
       (3995, 90, 'Prototype-S Concept'),
       (3996, 90, 'PX-MiEV Concept'),
       (3997, 90, 'RA Concept'),
       (3998, 90, 'Eclipse GS'),
       (3999, 90, 'Raider DuroCross'),
       (4000, 90, 'Raider LS'),
       (4001, 90, 'Raider XLS'),
       (4002, 90, 'Raider XLS V8'),
       (4003, 90, 'RVR'),
       (4004, 90, 'Shogun'),
       (4005, 90, 'Raider DuroCross V8'),
       (4006, 90, 'Outlander Concept'),
       (4007, 90, 'Lancer Evolution IX SE'),
       (4008, 90, 'Galant GTS'),
       (4009, 90, 'Evolander Concept'),
       (4010, 90, 'Endeavor LTD'),
       (4011, 90, 'Eclipse GT V6'),
       (4012, 90, 'Concept-CT'),
       (4013, 90, 'Street Raider Concept'),
       (4014, 90, 'Montero GLS 5door European Version'),
       (4015, 90, 'Montero GLS 3door European Version'),
       (4016, 90, 'Montero'),
       (4017, 90, 'Lancer Evolution Wagon GT'),
       (4018, 90, 'Lancer Evolution VIII MR'),
       (4019, 90, 'Lancer Evolution IX'),
       (4020, 90, 'Eclipse Ralliart Concept'),
       (4021, 90, 'Concept-X'),
       (4022, 90, 'Concept-Sportback'),
       (4023, 90, 'Colt Diesel'),
       (4024, 90, 'Sport Truck Concept'),
       (4025, 90, 'Outlander Turbo European Version'),
       (4026, 90, 'Montero Sport'),
       (4027, 90, 'Lancer Sportback LS'),
       (4028, 90, 'Lancer Evolution VIII European Version'),
       (4029, 90, 'Lancer Evolution RS'),
       (4030, 90, 'Grandis European Version'),
       (4031, 90, 'Galant Ralliart Concept'),
       (4032, 90, 'Endeavor Ralliart Concept'),
       (4033, 90, 'Endeavor'),
       (4034, 90, 'Eclipse ConceptE'),
       (4035, 90, 'Diamante'),
       (4036, 90, 'i Concept'),
       (4037, 90, 'Outlander European Version'),
       (4038, 90, 'Lancer Evolution'),
       (4039, 90, 'Eclipse'),
       (4040, 91, 'Galue 204'),
       (4041, 91, 'Viewt'),
       (4042, 91, 'Ryoga'),
       (4043, 91, 'Orochi Concept'),
       (4044, 91, 'Galue II'),
       (4045, 91, 'Nouera'),
       (4046, 91, 'New Galue'),
       (4047, 91, 'Micro Car'),
       (4048, 91, 'Le-Seyde'),
       (4049, 91, 'Le-Seyde Convertible Concept'),
       (4050, 91, 'TX-I'),
       (4051, 91, 'Zero'),
       (4052, 91, 'Yuga'),
       (4053, 91, 'Galue'),
       (4054, 91, 'Viewt'),
       (4055, 91, 'Type F'),
       (4056, 91, 'Ray'),
       (4057, 92, 'Plus 8'),
       (4058, 92, 'Roadster'),
       (4059, 92, 'Plus E Concept'),
       (4060, 92, 'Plus 4'),
       (4061, 92, 'EvaGT'),
       (4062, 92, 'Aero Coupe'),
       (4063, 92, '4-4'),
       (4064, 92, '3 Wheeler'),
       (4065, 92, '4-4 75th Anniversary'),
       (4066, 92, 'SuperSports Junior'),
       (4067, 92, 'Aero SuperSports'),
       (4068, 92, 'LifeCar Concept'),
       (4069, 92, 'Aero 8'),
       (4070, 92, '70th Anniversary'),
       (4071, 92, '4-Seater'),
       (4072, 92, 'Aeromax'),
       (4073, 92, 'Aero 8'),
       (4074, 92, 'plus 4'),
       (4075, 92, 'Roadster 3.0 V6'),
       (4076, 93, 'Nissan 370Z'),
       (4077, 93, 'Nissan Skyline R34 GTR Z Tune'),
       (4078, 93, 'Nissan Frontier King Cab'),
       (4079, 93, 'Nissan Frontier Crew Cab'),
       (4080, 93, 'Police Nissan 350Z'),
       (4081, 93, 'Nissan Titan Concept'),
       (4082, 93, 'Nissan Sentra'),
       (4083, 93, 'Nissan Altima S-Tune'),
       (4084, 93, 'Nissan Altima R-Tune'),
       (4085, 93, 'Nissan 350Z Drift Car'),
       (4086, 93, 'Nissan 350Z'),
       (4087, 94, '350Z'),
       (4088, 94, '370Z'),
       (4089, 94, '370Z GT Edition'),
       (4090, 94, '370Z Roadster'),
       (4091, 94, 'Almera'),
       (4092, 94, 'Altima'),
       (4093, 94, 'Altima Coupe'),
       (4094, 94, 'TeRRA Concept'),
       (4095, 94, 'Altima Hybrid'),
       (4096, 94, 'Altima Sedan'),
       (4097, 94, 'Bevel Concept'),
       (4098, 94, 'Cube'),
       (4099, 94, 'Denki Cube Concept'),
       (4100, 94, 'Ellure Concept'),
       (4101, 94, 'e-NV200 Concept'),
       (4102, 94, 'Extrem Concept'),
       (4103, 94, 'Forum Concept'),
       (4104, 94, 'Frontier'),
       (4105, 94, 'Invitation Concept'),
       (4106, 94, 'GT-R'),
       (4107, 94, 'GT-R Egoist'),
       (4108, 94, 'GT-R GT500 Race car'),
       (4109, 94, 'GT-R SpecV'),
       (4110, 94, 'GT-R Track Pack'),
       (4111, 94, 'Hi-Cross Concept'),
       (4112, 94, 'Juke'),
       (4113, 94, 'Juke Ministry of Sound'),
       (4114, 94, 'Juke Nismo'),
       (4115, 94, 'Juke Nismo Concept'),
       (4116, 94, 'Juke Shiro'),
       (4117, 94, 'Juke-R Concept'),
       (4118, 94, 'Land Glider Concept'),
       (4119, 94, 'LEAF'),
       (4120, 94, 'Leaf Nismo RC Concept'),
       (4121, 94, 'Maxima'),
       (4122, 94, 'Esflow Concept'),
       (4123, 94, 'Micra'),
       (4124, 94, 'Micra Colour Plus'),
       (4125, 94, 'Micra DIG-S'),
       (4126, 94, 'Micra ELLE'),
       (4127, 94, 'Murano'),
       (4128, 94, 'Murano CrossCabriolet'),
       (4129, 94, 'Navara'),
       (4130, 94, 'Note'),
       (4131, 94, 'Nuvu Concept'),
       (4132, 94, 'NV200'),
       (4133, 94, 'NV200 Taxi'),
       (4134, 94, '370Z Black Edition'),
       (4135, 94, 'NV2500 Concept'),
       (4136, 94, 'Qazana Concept'),
       (4137, 94, 'Qashqai+2'),
       (4138, 94, 'Pathfinder'),
       (4139, 94, 'Pathfinder Concept'),
       (4140, 94, 'Patrol'),
       (4141, 94, 'Pickup'),
       (4142, 94, 'Pivo 2 Concept'),
       (4143, 94, 'Pivo 3 Concept'),
       (4144, 94, 'Pixo'),
       (4145, 94, 'Primera'),
       (4146, 94, 'Qashqai'),
       (4147, 94, 'Quest'),
       (4148, 94, 'Rogue'),
       (4149, 94, 'Versa Sedan'),
       (4150, 94, 'Versa Hatchback'),
       (4151, 94, 'Round Box Concept'),
       (4152, 94, 'Sentra'),
       (4153, 94, 'Sentra SE-R'),
       (4154, 94, 'NV200 Concept'),
       (4155, 94, 'Mixim Concept'),
       (4156, 94, 'Sport Concept'),
       (4157, 94, 'Intima Concept'),
       (4158, 94, 'Sunny'),
       (4159, 94, 'Sylphy Concept'),
       (4160, 94, 'Terrano'),
       (4161, 94, 'Tiida'),
       (4162, 94, 'Terranaut Concept'),
       (4163, 94, 'Townpod Concept'),
       (4164, 94, 'Urge Concept'),
       (4165, 94, 'Xterra'),
       (4166, 94, 'X-Trail'),
       (4167, 94, 'Pivo Concept'),
       (4168, 94, 'Zaroot Concept'),
       (4169, 94, 'Zaroot Concept 2'),
       (4170, 94, 'Pathfinder EUR'),
       (4171, 94, 'Micra C+C'),
       (4172, 94, 'Micra 160SR'),
       (4173, 94, 'Lafesta'),
       (4174, 94, 'GT-R PROTO Concept'),
       (4175, 94, 'Foria Concept'),
       (4176, 94, 'Amenio Concept'),
       (4177, 94, 'Altima SER'),
       (4178, 94, 'Almera Tino'),
       (4179, 94, 'AZEAL Concept'),
       (4180, 94, '350Z Roadster EUR'),
       (4181, 94, '350Z EUR'),
       (4182, 94, '350Z 35th Anniversary'),
       (4183, 94, 'Tone Concept'),
       (4184, 94, 'Titan'),
       (4185, 94, 'Qashqai Concept'),
       (4186, 94, 'Pathfinder Armada SE'),
       (4187, 94, 'Pathfinder Armada'),
       (4188, 94, 'Fuga 350GT'),
       (4189, 94, 'Fairlady Z Roadster'),
       (4190, 94, 'Actic Concept'),
       (4191, 94, '350Z Roadster'),
       (4192, 94, 'Teana'),
       (4193, 94, 'Skyline'),
       (4194, 94, 'Jikoo Concept'),
       (4195, 94, 'Fuga Concept'),
       (4196, 94, 'Effis Concept'),
       (4197, 94, 'Dunehawk Concept'),
       (4198, 94, '350Z'),
       (4199, 94, 'Yanya Concept'),
       (4200, 94, 'XTrail S'),
       (4201, 94, 'XTrail GT'),
       (4202, 94, 'XTrail'),
       (4203, 94, 'Quest Concept'),
       (4204, 94, 'Micra C+C Concept'),
       (4205, 94, 'Beeline Concept'),
       (4206, 94, 'GT-R Concept'),
       (4207, 94, 'Chappo Concept'),
       (4208, 94, 'Skyline GT-R V-spec II'),
       (4209, 94, 'Fusion Concept'),
       (4210, 94, '240Z'),
       (4211, 95, 'M600'),
       (4212, 95, 'M15'),
       (4213, 95, 'M400'),
       (4214, 95, 'M14'),
       (4215, 95, 'M12 GTO 3R'),
       (4216, 96, 'C113 Prototype'),
       (4217, 97, '442'),
       (4218, 97, 'Aerotech Concept'),
       (4219, 97, 'Intrigue'),
       (4220, 97, 'Bravada Indy Pace Car'),
       (4221, 97, 'Alero'),
       (4222, 97, 'Alero GL'),
       (4223, 97, 'Alero Concept'),
       (4224, 97, 'Alero OSV'),
       (4225, 97, 'Aurora'),
       (4226, 97, 'Aurora Indy Pace Car'),
       (4227, 97, 'Intrigue OSV'),
       (4228, 97, 'Bravada'),
       (4229, 97, 'Cutlass'),
       (4230, 97, 'Cutlass S'),
       (4231, 97, 'Profile Concept'),
       (4232, 97, 'Recon Concept'),
       (4233, 97, 'Silhouette'),
       (4234, 97, 'Silhouette OSV'),
       (4235, 98, 'Adam'),
       (4236, 98, 'Agila'),
       (4237, 98, 'Ampera'),
       (4238, 98, 'Antara'),
       (4239, 98, 'Antara GTC Concept'),
       (4240, 98, 'Astra'),
       (4241, 98, 'Astra GTC'),
       (4242, 98, 'Astra GTC with Panoramic Roof'),
       (4243, 98, 'Astra High Performance Concept'),
       (4244, 98, 'Astra OPC'),
       (4245, 98, 'Astra Sedan'),
       (4246, 98, 'Astra Sports Tourer'),
       (4247, 98, 'Astra Station Wagon'),
       (4248, 98, 'Astra TwinTop'),
       (4249, 98, 'Cascada'),
       (4250, 98, 'Combo'),
       (4251, 98, 'Concept M'),
       (4252, 98, 'Corsa'),
       (4253, 98, 'Corsa 5-door'),
       (4254, 98, 'Corsa GSi'),
       (4255, 98, 'Corsa Hybrid Concept'),
       (4256, 98, 'Corsa OPC'),
       (4257, 98, 'Corsa OPC Nurburgring Edition'),
       (4258, 98, 'CorsaVan Concept'),
       (4259, 98, 'Eco Speedster Concept'),
       (4260, 98, 'Flextreme Concept'),
       (4261, 98, 'Flextreme GT-E Concept'),
       (4262, 98, 'GT'),
       (4263, 98, 'GTC Concept'),
       (4264, 98, 'GTC Geneva Concept'),
       (4265, 98, 'GTC Paris Concept'),
       (4266, 98, 'GTW Geneve Concept'),
       (4267, 98, 'Insignia'),
       (4268, 98, 'Insignia Concept'),
       (4269, 98, 'Insignia Hatchback'),
       (4270, 98, 'Insignia OPC'),
       (4271, 98, 'Insignia OPC Sports Tourer'),
       (4272, 98, 'Insignia Sports Tourer'),
       (4273, 98, 'Kadett Roadster'),
       (4274, 98, 'Kapitan'),
       (4275, 98, 'Meriva'),
       (4276, 98, 'Meriva Concept'),
       (4277, 98, 'Meriva OPC'),
       (4278, 98, 'Mokka'),
       (4279, 98, 'RAK e Concept'),
       (4280, 98, 'Signum'),
       (4281, 98, 'Signum 3.0 DTI'),
       (4282, 98, 'Signum 3.2 V6'),
       (4283, 98, 'Signum V6 CDTI'),
       (4284, 98, 'Speedster Turbo'),
       (4285, 98, 'Tigra Twin Top 1.8'),
       (4286, 98, 'TRIXX Concept'),
       (4287, 98, 'Vectra'),
       (4288, 98, 'Vectra Caravan'),
       (4289, 98, 'Vectra Caravan OPC'),
       (4290, 98, 'Vectra GTS'),
       (4291, 98, 'Vectra OPC'),
       (4292, 98, 'Vectra OPC Twin Turbo'),
       (4293, 98, 'Zafira'),
       (4294, 98, 'Zafira CNG'),
       (4295, 98, 'Zafira OPC'),
       (4296, 98, 'Zafira Tourer'),
       (4297, 98, 'Zafira Tourer Concept'),
       (4298, 99, 'Speedster II'),
       (4299, 99, 'Hemera'),
       (4300, 99, 'Cevennes Ultimate Black'),
       (4301, 99, 'Roadster'),
       (4302, 99, 'Hemera'),
       (4303, 99, 'Cevennes'),
       (4304, 100, 'Huayra'),
       (4305, 100, 'Zonda Tricolore'),
       (4306, 100, 'Zonda Cinque Roadster'),
       (4307, 100, 'Zonda R'),
       (4308, 100, 'Zonda Cinque'),
       (4309, 100, 'Zonda R'),
       (4310, 100, 'Zonda Roadster F'),
       (4311, 100, 'Zonda F'),
       (4312, 100, 'Zonda C12-S Roadster'),
       (4313, 101, 'Esperante Jan Magnussen Edition'),
       (4314, 102, '107'),
       (4315, 102, '107'),
       (4316, 102, '206'),
       (4317, 102, '207'),
       (4318, 102, '301'),
       (4319, 102, '208'),
       (4320, 102, '107 3-door'),
       (4321, 102, '307'),
       (4322, 102, 'RCZ R Concept'),
       (4323, 102, 'Onyx Concept'),
       (4324, 102, '308'),
       (4325, 102, '407'),
       (4326, 102, '3008 HYbrid4'),
       (4327, 102, '408'),
       (4328, 102, '208 GTi Concept'),
       (4329, 102, '508'),
       (4330, 102, '607'),
       (4331, 102, 'SXC Concept'),
       (4332, 102, '807'),
       (4333, 102, 'Hoggar'),
       (4334, 102, '1007'),
       (4335, 102, '3008'),
       (4336, 102, '508 China'),
       (4337, 102, '4007'),
       (4338, 102, '4008'),
       (4339, 102, '308 GTi'),
       (4340, 102, 'SR1 Concept'),
       (4341, 102, '5008'),
       (4342, 102, '1007 D-Day Concept'),
       (4343, 102, '1007 RC Concept'),
       (4344, 102, '2008 Concept'),
       (4345, 102, '407 Coupe'),
       (4346, 102, '206 CC'),
       (4347, 102, '206 HDi'),
       (4348, 102, '206 Plus'),
       (4349, 102, '206 Sedan'),
       (4350, 102, '206 SW'),
       (4351, 102, 'Ion Concept'),
       (4352, 102, '206 SW Concept'),
       (4353, 102, '206 SW HDi'),
       (4354, 102, '207 CC'),
       (4355, 102, '207 epure Concept'),
       (4356, 102, '207 RC'),
       (4357, 102, '207 Serie 64'),
       (4358, 102, '207 Spider Concept'),
       (4359, 102, '207 SW'),
       (4360, 102, '207 SW Outdoor Concept'),
       (4361, 102, '908HY'),
       (4362, 102, '207 SW RC'),
       (4363, 102, '208 GTi'),
       (4364, 102, '208 R5 Rally car'),
       (4365, 102, '208 XY Concept'),
       (4366, 102, '20Cup Concept'),
       (4367, 102, '307 Cameleo Concept'),
       (4368, 102, '307 CC'),
       (4369, 102, '307 CC Hybride HDi Concept'),
       (4370, 102, '307 Sedan 2.0'),
       (4371, 102, '307 SW'),
       (4372, 102, '307 SW Concept'),
       (4373, 102, '307CC Concept'),
       (4374, 102, '308 CC'),
       (4375, 102, '308 GT THP 175'),
       (4376, 102, '308 RC Z Concept'),
       (4377, 102, '308 SW'),
       (4378, 102, '308 SW Prologue Concept'),
       (4379, 102, '4002 Concept'),
       (4380, 102, '207 RCup Concept'),
       (4381, 102, '4007 Holland and Holland Concept'),
       (4382, 102, '406 CC'),
       (4383, 102, '406 Coupe'),
       (4384, 102, '406 Estate'),
       (4385, 102, '406 Rapier'),
       (4386, 102, '406 Sedan'),
       (4387, 102, '407 Elixir Concept'),
       (4388, 102, '407 Prologue Concept'),
       (4389, 102, '407 Silhouette Concept'),
       (4390, 102, '407 SW'),
       (4391, 102, '5 Concept'),
       (4392, 102, '508 RXH'),
       (4393, 102, '508 SW'),
       (4394, 102, '607 Feline Concept'),
       (4395, 102, '607 Paladine Concept'),
       (4396, 102, '607 Pescarolo Concept'),
       (4397, 102, '807 Grand Tourisme Concept'),
       (4398, 102, '907 Concept'),
       (4399, 102, '908 RC Concept'),
       (4400, 102, '908 V12 HDi DPFS'),
       (4401, 102, 'BB1 Concept'),
       (4402, 102, 'Bipper Tepee'),
       (4403, 102, 'EX1 Concept'),
       (4404, 102, 'Flux Concept'),
       (4405, 102, 'Hoggar Concept'),
       (4406, 102, 'HR1 Concept'),
       (4407, 102, 'HX1 Concept'),
       (4408, 102, 'HYbrid3 Evolution Concept'),
       (4409, 102, 'HYmotion3 Compressor Concept'),
       (4410, 102, 'iOn'),
       (4411, 102, 'Moonster Concept'),
       (4412, 102, 'Moovie Concept'),
       (4413, 102, 'Prologue HYmotion4 Concept'),
       (4414, 102, 'Promethee Concept'),
       (4415, 102, 'Quark Concept'),
       (4416, 102, 'RC Concept'),
       (4417, 102, 'RCZ'),
       (4418, 102, 'RCZ Coupe'),
       (4419, 102, 'RD Concept'),
       (4420, 102, 'Sesame Concept'),
       (4421, 102, 'Urban Crossover Concept'),
       (4422, 103, 'Cambiano'),
       (4423, 103, 'Nido EV'),
       (4424, 103, 'B0'),
       (4425, 103, 'Sintesi Concept'),
       (4426, 103, 'Rolls-Royce Hyperion'),
       (4427, 103, 'Ferrari P4-5'),
       (4428, 103, 'Enjoy'),
       (4429, 104, 'Hemi Barracuda'),
       (4430, 105, 'Aztek'),
       (4431, 105, 'Aztek Rally'),
       (4432, 105, 'Banshee'),
       (4433, 105, 'Bonneville'),
       (4434, 105, 'Bonneville GXP'),
       (4435, 105, 'G6 Convertible'),
       (4436, 105, 'Firebird'),
       (4437, 105, 'G8 GT Show Car'),
       (4438, 105, 'G3'),
       (4439, 105, 'G6'),
       (4440, 105, 'G6 Concept'),
       (4441, 105, 'G6 Coupe'),
       (4442, 105, 'Solstice'),
       (4443, 105, 'G6 GT'),
       (4444, 105, 'G6 GTP Convertible'),
       (4445, 105, 'G6 GTP Coupe'),
       (4446, 105, 'G6 GXP Show Car'),
       (4447, 105, 'G8 GT'),
       (4448, 105, 'G8 GXP'),
       (4449, 105, 'G8 Sport Truck'),
       (4450, 105, 'Grand Am GT Coupe'),
       (4451, 105, 'Grand Am GXP'),
       (4452, 105, 'Grand Prix'),
       (4453, 105, 'Grand Prix G-Force Concept'),
       (4454, 105, 'Grand Prix GTP'),
       (4455, 105, 'Grand Prix GXP'),
       (4456, 105, 'GTO'),
       (4457, 105, 'Grand Am SE Sedan'),
       (4458, 105, 'GTO 5.7'),
       (4459, 105, 'GTO Concept'),
       (4460, 105, 'Montana'),
       (4461, 105, 'Firebird Trans Am Edition'),
       (4462, 105, 'Montana SV6'),
       (4463, 105, 'Sunfire HO'),
       (4464, 105, 'Montana Thunder'),
       (4465, 105, 'Rageous Concept'),
       (4466, 105, 'REV Concept'),
       (4467, 105, 'Grand Am'),
       (4468, 105, 'Solstice Concept'),
       (4469, 105, 'Aztek SRV'),
       (4470, 105, 'Solstice Coupe'),
       (4471, 105, 'Piranha Concept'),
       (4472, 105, 'Solstice GXP'),
       (4473, 105, 'Solstice SD-290 Concept'),
       (4474, 105, 'Stinger'),
       (4475, 105, 'Sunfire'),
       (4476, 105, 'Sunfire Accessorized'),
       (4477, 105, 'Sunfire American Tuner'),
       (4478, 105, 'Sunfire Coupe'),
       (4479, 105, 'Sunfire GXP'),
       (4480, 105, 'Torrent'),
       (4481, 105, 'Vibe'),
       (4482, 105, 'Vibe GT'),
       (4483, 106, '356'),
       (4484, 106, '901'),
       (4485, 106, '959'),
       (4486, 106, '356 No 1'),
       (4487, 106, '550 Spyder'),
       (4488, 106, '911 Black Edition'),
       (4489, 106, '911 Carrera'),
       (4490, 106, '911 Carrera 2 Cabrio'),
       (4491, 106, '911 Carrera 4'),
       (4492, 106, '911 Carrera 4 Cabriolet'),
       (4493, 106, '911 Carrera 4 Coupe'),
       (4494, 106, '911 Carrera 4 GTS'),
       (4495, 106, '911 Carrera 4S'),
       (4496, 106, '911 Carrera 4S Cabriolet'),
       (4497, 106, '911 Carrera 4S Coupe'),
       (4498, 106, '911 Carrera Cabriolet'),
       (4499, 106, '911 Carrera Coupe'),
       (4500, 106, '911 Carrera GTS'),
       (4501, 106, '911 Carrera GTS Cabriolet'),
       (4502, 106, '911 Carrera RS'),
       (4503, 106, '911 Carrera S'),
       (4504, 106, '911 Carrera S Cabriolet'),
       (4505, 106, '911 Carrera S Coupe'),
       (4506, 106, '911 GT2'),
       (4507, 106, '911 GT2 RS'),
       (4508, 106, '911 GT3'),
       (4509, 106, '911 GT3 Cup'),
       (4510, 106, '911 GT3 R'),
       (4511, 106, '911 GT3 R Hybrid'),
       (4512, 106, '911 GT3 R Hybrid 2.0'),
       (4513, 106, '911 GT3 RS'),
       (4514, 106, '911 GT3 RS 4.0'),
       (4515, 106, '911 GT3 RSR'),
       (4516, 106, '911 Speedster'),
       (4517, 106, '911 Sport Classic'),
       (4518, 106, '911 Targa'),
       (4519, 106, '911 Targa 4'),
       (4520, 106, '911 Targa 4S'),
       (4521, 106, '911 Turbo'),
       (4522, 106, '911 Turbo Cabriolet'),
       (4523, 106, '911 Turbo Coupe'),
       (4524, 106, '911 Turbo S'),
       (4525, 106, '911 Turbo S Cabriolet'),
       (4526, 106, '918 RSR Concept'),
       (4527, 106, '918 Spyder Concept'),
       (4528, 106, '918 Spyder Prototype'),
       (4529, 106, '930 Turbo'),
       (4530, 106, '964 Speedster'),
       (4531, 106, '968 Cabriolet'),
       (4532, 106, '968 Sport'),
       (4533, 106, 'Boxster'),
       (4534, 106, 'Boxster RS 60 Spyder'),
       (4535, 106, 'Boxster S'),
       (4536, 106, 'Boxster S Black Edition'),
       (4537, 106, 'Boxster Spyder'),
       (4538, 106, 'Carrera GT'),
       (4539, 106, 'Cayenne'),
       (4540, 106, 'Cayenne Diesel'),
       (4541, 106, 'Cayenne GTS'),
       (4542, 106, 'Cayenne Hybrid'),
       (4543, 106, 'Cayenne S'),
       (4544, 106, 'Cayenne S Diesel'),
       (4545, 106, 'Cayenne S Hybrid'),
       (4546, 106, 'Cayenne S Titanium'),
       (4547, 106, 'Cayenne S Transsyberia'),
       (4548, 106, 'Cayenne Turbo'),
       (4549, 106, 'Cayenne Turbo S'),
       (4550, 106, 'Cayman'),
       (4551, 106, 'Cayman R'),
       (4552, 106, 'Cayman S'),
       (4553, 106, 'Cayman S Black Edition'),
       (4554, 106, 'Cayman S Design Edition 1'),
       (4555, 106, 'Cayman S Sport'),
       (4556, 106, 'GT3 RSR'),
       (4557, 106, 'Panamera'),
       (4558, 106, 'Panamera Diesel'),
       (4559, 106, 'Panamera GTS'),
       (4560, 106, 'Panamera Platinum Edition'),
       (4561, 106, 'Panamera S Hybrid'),
       (4562, 106, 'Panamera Sport Turismo Concept'),
       (4563, 106, 'Panamera Turbo S'),
       (4564, 107, 'Savvy'),
       (4565, 107, 'Satria Neo'),
       (4566, 107, 'GEN-2 Persona'),
       (4567, 107, 'GEN-2'),
       (4568, 107, 'Impian'),
       (4569, 107, 'GEN-2'),
       (4570, 108, 'ZOE'),
       (4571, 108, '6'),
       (4572, 108, '8'),
       (4573, 108, '16'),
       (4574, 108, '10 Automatic'),
       (4575, 108, '11 TSE Electronic'),
       (4576, 108, 'Twingo'),
       (4577, 108, 'Megane RS Trophy'),
       (4578, 108, 'Koleos'),
       (4579, 108, 'Alpine A 110-50 Concept'),
       (4580, 108, 'Wind'),
       (4581, 108, 'R-Space Concept'),
       (4582, 108, '11 Turbo'),
       (4583, 108, '12 TL'),
       (4584, 108, 'Megane GT'),
       (4585, 108, '12 TL Wagon'),
       (4586, 108, 'Megane Estate GT'),
       (4587, 108, 'Megane Coupe GT Line'),
       (4588, 108, 'Megane Coupe GT'),
       (4589, 108, 'Megane Coupe-Cabriolet'),
       (4590, 108, 'Latitude'),
       (4591, 108, '14 L'),
       (4592, 108, 'Laguna'),
       (4593, 108, '14 TL'),
       (4594, 108, '14 TS'),
       (4595, 108, 'Scenic'),
       (4596, 108, '15 GTL'),
       (4597, 108, 'Megane Estate'),
       (4598, 108, 'Grand Scenic'),
       (4599, 108, '15 TL'),
       (4600, 108, 'DeZir Concept'),
       (4601, 108, 'Clio RS'),
       (4602, 108, '16 TX'),
       (4603, 108, 'Zoe ZE Concept'),
       (4604, 108, 'Twizy ZE Concept'),
       (4605, 108, 'Twingo RS'),
       (4606, 108, 'Symbol'),
       (4607, 108, '17 TS'),
       (4608, 108, 'Megane Trophy'),
       (4609, 108, 'Megane R26.R'),
       (4610, 108, '18 GTD 4X4 Wagon'),
       (4611, 108, '18 GTL'),
       (4612, 108, '18 TL Type 2'),
       (4613, 108, '18 TL Wagon'),
       (4614, 108, '18 Turbo'),
       (4615, 108, 'Kangoo ZE Concept'),
       (4616, 108, '19 16S 3-door'),
       (4617, 108, '19 Chamade Prima'),
       (4618, 108, 'Clio'),
       (4619, 108, 'ZE Concept'),
       (4620, 108, '19 Convertible 16S'),
       (4621, 108, '19 TS Europa'),
       (4622, 108, 'Sand-up Concept'),
       (4623, 108, 'Ondelios Concept'),
       (4624, 108, 'Megane Coupe Concept'),
       (4625, 108, '20 TL'),
       (4626, 108, 'Kangoo'),
       (4627, 108, '20 Turbo Diesel'),
       (4628, 108, '20 TX'),
       (4629, 108, '21 2.0 Turbo Quadra 4-door'),
       (4630, 108, '21 Turbo D'),
       (4631, 108, 'Laguna Coupe Concept'),
       (4632, 108, 'Kangoo Compact Concept'),
       (4633, 108, '25 V6 Injection'),
       (4634, 108, '25 V6 Turbo'),
       (4635, 108, '30 TS'),
       (4636, 108, '30 TX'),
       (4637, 108, '4 Clan'),
       (4638, 108, 'Koleos Concept'),
       (4639, 108, '4 CV'),
       (4640, 108, 'Clio Sport'),
       (4641, 108, '4 CV Luxe'),
       (4642, 108, 'Altica Concept'),
       (4643, 108, '4 CV Sport'),
       (4644, 108, 'Vel Satis'),
       (4645, 108, 'Modus Initiale'),
       (4646, 108, 'Laguna GT Estate'),
       (4647, 108, 'Egeus Concept Car'),
       (4648, 108, '4 GTL'),
       (4649, 108, 'Clio III 3door'),
       (4650, 108, 'Wind Concept'),
       (4651, 108, '4 Luxe'),
       (4652, 108, '4 Parisienne'),
       (4653, 108, 'Megane RS 5-door'),
       (4654, 108, '4 Van'),
       (4655, 108, '5 Alpine'),
       (4656, 108, '5 GT Turbo'),
       (4657, 108, '5 GTL 5-door'),
       (4658, 108, '5 TL'),
       (4659, 108, '5 Turbo'),
       (4660, 108, '6 L'),
       (4661, 108, '8 Gordini 1300'),
       (4662, 108, '8 Major'),
       (4663, 108, 'Megane II Hatch'),
       (4664, 108, 'Megane II Estate'),
       (4665, 108, 'Megane II CoupeCabriolet 2.0 Dynmaique Version'),
       (4666, 108, 'Megane II CoupeCabriolet 1.6 Privilege Version'),
       (4667, 108, 'Megane II CoupeCabriolet'),
       (4668, 108, 'Clio V6 Sport'),
       (4669, 108, 'Be Bop SUV Concept'),
       (4670, 108, 'Be Bop Sport Concept'),
       (4671, 108, '8 S'),
       (4672, 108, '9 GT'),
       (4673, 108, 'Espace IV 2.2 dCi'),
       (4674, 108, 'Ellypse Concept'),
       (4675, 108, 'Avantime'),
       (4676, 108, 'Talisman Concept'),
       (4677, 108, 'Vel Satis 3.5 V6 Initiale'),
       (4678, 108, 'Modus Concept'),
       (4679, 108, 'Laguna Initiale 3.0 V6 24V'),
       (4680, 108, '9 GTL'),
       (4681, 108, '9 Turbo'),
       (4682, 108, '9 TXE'),
       (4683, 108, 'Alpine A 110'),
       (4684, 108, 'Scenic RX4'),
       (4685, 108, 'Megane Hatchback'),
       (4686, 108, 'Megane Convertible'),
       (4687, 108, 'Alpine A 310 V6 Group 4'),
       (4688, 108, 'Captur Concept'),
       (4689, 108, 'Vel Satis Concept'),
       (4690, 108, 'Clio 1.5 dCi'),
       (4691, 108, 'Clio 1.6 16V'),
       (4692, 108, 'Clio 1.7 RT 5-door'),
       (4693, 108, 'Clio Campus'),
       (4694, 108, 'Clio Estate'),
       (4695, 108, 'Fiftie Concept'),
       (4696, 108, 'Initiale Concept'),
       (4697, 108, 'Espace'),
       (4698, 108, 'Argos Concept'),
       (4699, 108, '19 Baccara 5-door'),
       (4700, 108, 'Clio Grand Tour Concept'),
       (4701, 108, 'Clio III 5door'),
       (4702, 108, 'Alpine A 610'),
       (4703, 108, 'Clio RS 200'),
       (4704, 108, 'Clio RS Concept'),
       (4705, 108, 'Clio RS Luxe'),
       (4706, 108, 'Clio S'),
       (4707, 108, 'Clio Sport 2.0 16V'),
       (4708, 108, 'Dauphine'),
       (4709, 108, 'Espace 2.2 dCI 16V'),
       (4710, 108, 'Espace Initiale 2.2 dCI 16V'),
       (4711, 108, 'Espace Quadra'),
       (4712, 108, 'Floride'),
       (4713, 108, 'Fluence'),
       (4714, 108, 'Fluence Concept'),
       (4715, 108, 'Fluence ZE Concept'),
       (4716, 108, 'Fregate'),
       (4717, 108, 'Frendzy Concept'),
       (4718, 108, 'Fuego'),
       (4719, 108, 'Fuego Turbo'),
       (4720, 108, 'Grand Espace IV 3.0 dCi'),
       (4721, 108, 'Grand Modus'),
       (4722, 108, 'Kangoo be bop'),
       (4723, 108, 'Laguna 2.0 T'),
       (4724, 108, 'Laguna Concept'),
       (4725, 108, 'Laguna Coupe'),
       (4726, 108, 'Laguna Estate'),
       (4727, 108, 'Laguna Estate 1.9 dCI'),
       (4728, 108, 'Laguna GT'),
       (4729, 108, 'Laguna Nevada RXE 1.6 16V'),
       (4730, 108, 'Ludo Concept'),
       (4731, 108, 'Megane'),
       (4732, 108, 'Megane Concept'),
       (4733, 108, 'Megane Coupe'),
       (4734, 108, 'Megane Estate GT Line'),
       (4735, 108, 'Megane GT Line'),
       (4736, 108, 'Megane II Saloon'),
       (4737, 108, 'Megane II Sport Hatch'),
       (4738, 108, 'Megane RS'),
       (4739, 108, 'Megane RS 3-door'),
       (4740, 108, 'Megane RS N4'),
       (4741, 108, 'Modus'),
       (4742, 108, 'Nepta Concept'),
       (4743, 108, 'Pangea Concept'),
       (4744, 108, 'Racoon Concept'),
       (4745, 108, 'Safrane'),
       (4746, 108, 'Sandero'),
       (4747, 108, 'Scenic Concept'),
       (4748, 108, 'Scenic Conquest'),
       (4749, 108, 'Scenic II'),
       (4750, 108, 'Scenic RXI 2.0'),
       (4751, 108, 'Talisman'),
       (4752, 108, 'Thalia'),
       (4753, 108, 'Twingo Concept'),
       (4754, 108, 'Twingo Oasis'),
       (4755, 108, 'Z17 Concept'),
       (4756, 108, 'ZO Concept'),
       (4757, 109, 'Advantige R one Concept'),
       (4758, 109, 'BamBoo Concept'),
       (4759, 109, 'Chopster'),
       (4760, 109, 'Dock-Go Concept'),
       (4761, 109, 'Dodge Viper Veleno Concept'),
       (4762, 109, 'E2'),
       (4763, 109, 'E-Go Rocket Concept'),
       (4764, 109, 'Mono Ego Concept'),
       (4765, 109, 'Porsche 997 Turbo Le Mans 600'),
       (4766, 109, 'Porsche Bedouin 996 Turbo'),
       (4767, 109, 'Porsche Imola Cayman 987'),
       (4768, 109, 'Porsche Indy 4S 997'),
       (4769, 109, 'Porsche Indy 997 Carrera S'),
       (4770, 109, 'Presto Concept'),
       (4771, 109, 'Roadster Concept'),
       (4772, 109, 'Senso Concept'),
       (4773, 109, 'Splash Concept'),
       (4774, 109, 'sQuba Concept'),
       (4775, 109, 'Tatooo.com Concept'),
       (4776, 109, 'UC Concept'),
       (4777, 109, 'X-Trem Concept'),
       (4778, 109, 'Yello Talbo Concept'),
       (4779, 109, 'zaZen Concept'),
       (4780, 110, '100EX Centenary Concept'),
       (4781, 110, '100EX Experimental Centenary Car'),
       (4782, 110, '101EX'),
       (4783, 110, 'Phantom'),
       (4784, 110, '101EX Concept'),
       (4785, 110, '102EX Electric Concept'),
       (4786, 110, '200EX Concept'),
       (4787, 110, 'Centenary Phantom'),
       (4788, 110, 'Ghost'),
       (4789, 110, 'Ghost Extended Wheelbase'),
       (4790, 110, 'Ghost Six Senses Concept'),
       (4791, 110, 'Phantom Coupe'),
       (4792, 110, 'Phantom Drophead Coupe'),
       (4793, 110, 'Phantom Extetnded Wheelbase'),
       (4794, 110, 'Phantom GCC Limited Edition'),
       (4795, 110, 'Phantom in Madrid'),
       (4796, 110, 'Phantom Naples Winter Wine Festival Auction'),
       (4797, 110, 'Phantom Silver'),
       (4798, 110, 'Phantom Tungsten'),
       (4799, 110, 'Phantom with Extended Wheelbase'),
       (4800, 110, 'RR4'),
       (4801, 111, '75 V8'),
       (4802, 111, '25'),
       (4803, 111, '45'),
       (4804, 111, '75'),
       (4805, 111, '100'),
       (4806, 111, '200'),
       (4807, 111, '600'),
       (4808, 111, '800'),
       (4809, 111, '75 Coupe Concept'),
       (4810, 111, '75 Limousine'),
       (4811, 111, '75 Tourer'),
       (4812, 111, '75 Vanden Plas'),
       (4813, 111, 'CityRover'),
       (4814, 111, 'Streetwise'),
       (4815, 111, 'TCV Concept'),
       (4816, 112, '9-5 SportWagon'),
       (4817, 112, '9-4X'),
       (4818, 112, '90'),
       (4819, 112, '92'),
       (4820, 112, '93'),
       (4821, 112, '95'),
       (4822, 112, '96'),
       (4823, 112, '99'),
       (4824, 112, '900'),
       (4825, 112, '9000'),
       (4826, 112, '9-3'),
       (4827, 112, '900 Convertible'),
       (4828, 112, '900 Coupe'),
       (4829, 112, '900 Turbo 16S'),
       (4830, 112, '9-2X'),
       (4831, 112, '9-3 Aero'),
       (4832, 112, '9-3 Aero Convertible'),
       (4833, 112, '9-3 Aero Coupe'),
       (4834, 112, '93 Convertible'),
       (4835, 112, '9-3 Convertible'),
       (4836, 112, '9-3 Convertible 20 Years Edition'),
       (4837, 112, '9-3 Convertible BioPower'),
       (4838, 112, '9-3 Coupe'),
       (4839, 112, '9-3 ePower Concept'),
       (4840, 112, '9-3 Sport Sedan'),
       (4841, 112, '93 SportCombi'),
       (4842, 112, '9-3 SportCombi'),
       (4843, 112, '93 SportHatch Concept'),
       (4844, 112, '9-3 SportSedan Aero'),
       (4845, 112, '9-3X'),
       (4846, 112, '9-3X Concept Car'),
       (4847, 112, '9-4X BioPower Concept'),
       (4848, 112, '95 Aero'),
       (4849, 112, '95 Aero Sedan'),
       (4850, 112, '95 Aero Wagon'),
       (4851, 112, '9-5 Estate BioPower'),
       (4852, 112, '9-5 Saloon BioPower'),
       (4853, 112, '9-5 Sedan'),
       (4854, 112, '9-5 SportCombi'),
       (4855, 112, '9-5 SportWagon'),
       (4856, 112, '97X'),
       (4857, 112, '9-7X'),
       (4858, 112, '9-7X Aero'),
       (4859, 112, '9-X Air BioHybrid Concept'),
       (4860, 112, '9-X BioHybrid Concept'),
       (4861, 112, '9X Concept Car'),
       (4862, 112, 'Aero X Concept'),
       (4863, 112, 'BioPower 100 Concept'),
       (4864, 112, 'EV-1 Concept Car'),
       (4865, 112, 'PhoeniX Concept'),
       (4866, 112, 'Sonett I'),
       (4867, 112, 'Sonett II'),
       (4868, 112, 'Sonett III'),
       (4869, 112, 'Turbo X'),
       (4870, 112, 'UrSaab'),
       (4871, 113, 'Ford Mustang S281 Speedster'),
       (4872, 113, 'Ford Mustang S281 Scenic Roof'),
       (4873, 113, 'Ford Mustang 302 Parnelli Jones'),
       (4874, 113, 'Ford F-150 S331 Sport Truck'),
       (4875, 113, 'S7 Twin Turbo'),
       (4876, 113, 'Ford Mustang S281 Supercharged'),
       (4877, 113, 'Ford Mustang S281 Extreme'),
       (4878, 113, 'Ford Mustang S281 3 Valve'),
       (4879, 113, 'Ford Focus S121 N2O'),
       (4880, 113, 'S7'),
       (4881, 114, 'Vue'),
       (4882, 114, 'Flextreme Concept'),
       (4883, 114, 'Astra 5-door'),
       (4884, 114, 'Astra'),
       (4885, 114, 'Sky Red Line'),
       (4886, 114, 'Sky'),
       (4887, 114, 'Outlook'),
       (4888, 114, 'Vue Red Line'),
       (4889, 114, 'Relay'),
       (4890, 114, 'Ion Red Line'),
       (4891, 114, 'Aura Concept'),
       (4892, 114, 'CV1 Concept'),
       (4893, 115, 'FR-S'),
       (4894, 115, '5 Axis Widebody DJ xB'),
       (4895, 115, 'FR-S Concept'),
       (4896, 115, 'FR-S Race car'),
       (4897, 115, 'FUSE Concept'),
       (4898, 115, 'Hako Coupe Concept'),
       (4899, 115, 'iQ'),
       (4900, 115, 'iQ Concept'),
       (4901, 115, 't2B Concept'),
       (4902, 115, 'tC'),
       (4903, 115, 'tC Release Series 1.0'),
       (4904, 115, 'tC RS 2.0'),
       (4905, 115, 'tC RS 3.0'),
       (4906, 115, 'tC Sport Coupe'),
       (4907, 115, 'TRDEquipped xA'),
       (4908, 115, 'TRDEquipped xA Release Series 1.0'),
       (4909, 115, 'TRDEquipped xB'),
       (4910, 115, 'xA Release Series 1.0'),
       (4911, 115, 'xB'),
       (4912, 115, 'xB RS 4.0'),
       (4913, 115, 'xB RS 5.0'),
       (4914, 115, 'xD'),
       (4915, 116, 'Alhambra'),
       (4916, 116, 'Alhambra 4WD'),
       (4917, 116, 'Alhambra TDI'),
       (4918, 116, 'Altea'),
       (4919, 116, 'Altea 1.6'),
       (4920, 116, 'Altea Concept'),
       (4921, 116, 'Altea FR'),
       (4922, 116, 'Altea FR Prototype'),
       (4923, 116, 'Altea Freetrack'),
       (4924, 116, 'Altea Freetrack Concept'),
       (4925, 116, 'Altea TDI'),
       (4926, 116, 'Altea XL'),
       (4927, 116, 'Arosa'),
       (4928, 116, 'Bocanegra SportCoupe Concept'),
       (4929, 116, 'Bolero 330 BT Concept'),
       (4930, 116, 'Cordoba'),
       (4931, 116, 'Cupra GT Concept'),
       (4932, 116, 'Exeo'),
       (4933, 116, 'Exeo ST'),
       (4934, 116, 'Formula Concept'),
       (4935, 116, 'IBE Concept'),
       (4936, 116, 'IBE Paris Concept'),
       (4937, 116, 'Ibiza'),
       (4938, 116, 'Ibiza 1.4 TDI'),
       (4939, 116, 'Ibiza 2.0'),
       (4940, 116, 'Ibiza Bocanegra'),
       (4941, 116, 'Ibiza Cupra'),
       (4942, 116, 'Ibiza Cupra 1.9 TDI'),
       (4943, 116, 'Ibiza Cupra Concept'),
       (4944, 116, 'Ibiza Ecomotive'),
       (4945, 116, 'Ibiza FR'),
       (4946, 116, 'Ibiza FR TDI'),
       (4947, 116, 'Ibiza FR TDI SC'),
       (4948, 116, 'Ibiza IBZ Concept'),
       (4949, 116, 'Ibiza SportCoupe'),
       (4950, 116, 'Ibiza ST'),
       (4951, 116, 'Ibiza Vaillante Concept'),
       (4952, 116, 'IBL Concept'),
       (4953, 116, 'IBX Concept'),
       (4954, 116, 'Leon'),
       (4955, 116, 'Leon 1.9 TDI'),
       (4956, 116, 'Leon Cupra'),
       (4957, 116, 'Leon Cupra R'),
       (4958, 116, 'Leon Ecomotive'),
       (4959, 116, 'Leon FR'),
       (4960, 116, 'Leon FR Supercopa'),
       (4961, 116, 'Leon Linea R'),
       (4962, 116, 'Leon Prototype'),
       (4963, 116, 'Leon Sport FR'),
       (4964, 116, 'Leon WTCC'),
       (4965, 116, 'Mii'),
       (4966, 116, 'Mii Vibora Negra'),
       (4967, 116, 'Salsa Concept'),
       (4968, 116, 'Salsa Emocion Concept'),
       (4969, 116, 'Tango Concept'),
       (4970, 116, 'Toledo'),
       (4971, 116, 'Toledo Concept'),
       (4972, 116, 'Toledo Prototype'),
       (4973, 116, 'Tribu Concept'),
       (4974, 117, '911'),
       (4975, 118, 'Citigo'),
       (4976, 118, 'Citigo 5-door'),
       (4977, 118, 'Design Concept'),
       (4978, 118, 'Fabia'),
       (4979, 118, 'Roomster'),
       (4980, 118, 'Fabia Combi'),
       (4981, 118, 'Fabia Combi RS'),
       (4982, 118, 'Fabia Combi Scout'),
       (4983, 118, 'Fabia Combi Scout Concept'),
       (4984, 118, 'Fabia GreenLine'),
       (4985, 118, 'Superb Combi 4x4'),
       (4986, 118, 'Fabia Paris Concept'),
       (4987, 118, 'Fabia RS'),
       (4988, 118, 'Fabia Scout'),
       (4989, 118, 'Fabia Sedan'),
       (4990, 118, 'Superb GreenLine'),
       (4991, 118, 'Superb'),
       (4992, 118, 'Fabia Sketches'),
       (4993, 118, 'Fabia Super 2000'),
       (4994, 118, 'Fabia WRC 05'),
       (4995, 118, 'Felicia'),
       (4996, 118, 'Fabia Combi GreenLine'),
       (4997, 118, 'Roomster Scout'),
       (4998, 118, 'Felicia Combi'),
       (4999, 118, 'Felicia Fun'),
       (5000, 118, 'Felicia Pickup'),
       (5001, 118, 'Joyster Concept'),
       (5002, 118, 'MissionL Concept'),
       (5003, 118, 'Octavia'),
       (5004, 118, 'Yeti Concept'),
       (5005, 118, 'Octavia Combi 4x4'),
       (5006, 118, 'Octavia Business'),
       (5007, 118, 'Octavia Combi'),
       (5008, 118, 'Octavia Combi L and K'),
       (5009, 118, 'Octavia Combi RS'),
       (5010, 118, 'Octavia Design'),
       (5011, 118, 'Octavia Green E Line Concept'),
       (5012, 118, 'Octavia L and K'),
       (5013, 118, 'Tudor Concept'),
       (5014, 118, 'Octavia RS'),
       (5015, 118, 'Fabia Praktik'),
       (5016, 118, 'Octavia RS Combi'),
       (5017, 118, 'Octavia RS WRC Limited Edition'),
       (5018, 118, 'Octavia Scout'),
       (5019, 118, 'Octavia SLX'),
       (5020, 118, 'Octavia TAXI'),
       (5021, 118, 'Rapid'),
       (5022, 118, 'Roomster Concept'),
       (5023, 118, 'Octavia Elongated L and K'),
       (5024, 118, 'Superb 4x4'),
       (5025, 118, 'Superb Combi'),
       (5026, 118, 'Superb Design'),
       (5027, 118, 'Yeti'),
       (5028, 118, 'Yeti 2 Concept'),
       (5029, 118, 'Yeti 4x4'),
       (5030, 119, 'Crosstown Showcar'),
       (5031, 119, 'eScooter Concept'),
       (5032, 119, 'forfour'),
       (5033, 119, 'forfun2'),
       (5034, 119, 'forspeed Concept'),
       (5035, 119, 'forstars Concept'),
       (5036, 119, 'fortwo'),
       (5037, 119, 'fortwo cabrio'),
       (5038, 119, 'fortwo cdi'),
       (5039, 119, 'fortwo coupe'),
       (5040, 119, 'fortwo edition red'),
       (5041, 119, 'fortwo electric drive'),
       (5042, 119, 'fortwo EV Concept'),
       (5043, 119, 'fortwo sharpred'),
       (5044, 119, 'for-us Concept'),
       (5045, 119, 'forvision Concept'),
       (5046, 119, 'Roadster'),
       (5047, 119, 'Roadster Coupe'),
       (5048, 120, 'Codatronca Monza'),
       (5049, 121, 'C8 Aileron Spyder'),
       (5050, 121, 'C8 Laviolette LM85'),
       (5051, 121, 'C8 Aileron'),
       (5052, 121, 'C12 Zagato'),
       (5053, 121, 'D12 Peking to Paris'),
       (5054, 121, 'C8 Laviolette'),
       (5055, 121, 'C12 LaTurbie'),
       (5056, 121, 'Aeroblade'),
       (5057, 121, 'C8 Spyder'),
       (5058, 121, 'C8 Double 12 S Spyder'),
       (5059, 121, 'C8 Double 12'),
       (5060, 122, 'Korando Sports'),
       (5061, 122, 'Actyon Sports'),
       (5062, 122, 'e-XIV Concept'),
       (5063, 122, 'XIV-2 Concept'),
       (5064, 122, 'XIV-1 Concept'),
       (5065, 122, 'SUT 1 Concept'),
       (5066, 122, 'Korando'),
       (5067, 122, 'KEV2 Concept'),
       (5068, 122, 'Rexton R-Line'),
       (5069, 122, 'C200 Concept'),
       (5070, 122, 'Actyon Sports'),
       (5071, 122, 'Actyon'),
       (5072, 122, 'Rexton'),
       (5073, 122, 'Musso Sports'),
       (5074, 122, 'Kyron'),
       (5075, 122, 'Rodius'),
       (5076, 123, 'Jeep Grand Cherokee'),
       (5077, 123, 'Chrysler Crossfire Roadster'),
       (5078, 123, 'Chrysler 300C'),
       (5079, 124, 'GTS Concept'),
       (5080, 125, 'Nissan 350Z'),
       (5081, 125, 'Porsche Cayenne'),
       (5082, 126, 'Maserati Cinqueporte'),
       (5083, 126, 'CoupeTorino'),
       (5084, 126, 'RKcoupe'),
       (5085, 126, 'RKspyder'),
       (5086, 127, '360'),
       (5087, 127, '1000'),
       (5088, 127, 'Alcyone'),
       (5089, 127, 'Alcyone SVX'),
       (5090, 127, 'B5-TPH Concept'),
       (5091, 127, 'B9 Tribeca'),
       (5092, 127, 'Baja Turbo'),
       (5093, 127, 'XV Concept'),
       (5094, 127, 'Outback'),
       (5095, 127, 'Impreza WRX STI'),
       (5096, 127, 'BRZ'),
       (5097, 127, 'Impreza STI Cosworth CS400'),
       (5098, 127, 'BRZ STI Concept'),
       (5099, 127, 'Domingo'),
       (5100, 127, 'Advanced Tourer Concept'),
       (5101, 127, 'Exiga'),
       (5102, 127, 'Exiga Concept'),
       (5103, 127, 'Legacy Tourer'),
       (5104, 127, 'Forester'),
       (5105, 127, 'Forester Cross Sports'),
       (5106, 127, 'Forester STI'),
       (5107, 127, 'G3X Justy 1.5L AWD Plus'),
       (5108, 127, 'G4e Concept'),
       (5109, 127, 'Hybrid Tourer Concept'),
       (5110, 127, 'Impreza'),
       (5111, 127, 'Impreza 5-door'),
       (5112, 127, 'Impreza Concept'),
       (5113, 127, 'Impreza Japanese Version'),
       (5114, 127, 'Impreza R205'),
       (5115, 127, 'Impreza Sedan WRX'),
       (5116, 127, 'Impreza Sports Wagon'),
       (5117, 127, 'Impreza WRC Prototype'),
       (5118, 127, 'Impreza WRX'),
       (5119, 127, 'Impreza WRX 300'),
       (5120, 127, 'Impreza WRX 4-Door'),
       (5121, 127, 'Impreza WRX STI 20th Anniversary'),
       (5122, 127, 'Impreza WRX STI Carbon Concept'),
       (5123, 127, 'Impreza WRX STI Special Edition'),
       (5124, 127, 'Impreza XV'),
       (5125, 127, 'Justy'),
       (5126, 127, 'Legacy'),
       (5127, 127, 'Legacy 2.5 GT spec B'),
       (5128, 127, 'Legacy 3.0 R'),
       (5129, 127, 'Legacy Concept'),
       (5130, 127, 'Legacy Sedan'),
       (5131, 127, 'Legacy Station Wagon'),
       (5132, 127, 'Legacy Wagon JDM'),
       (5133, 127, 'Leone'),
       (5134, 127, 'Outback 3.0 R'),
       (5135, 127, 'Pleo'),
       (5136, 127, 'R1'),
       (5137, 127, 'R-2'),
       (5138, 127, 'Traviq'),
       (5139, 127, 'Tribeca'),
       (5140, 127, 'VIVIO'),
       (5141, 127, 'WRC Concept'),
       (5142, 127, 'XV'),
       (5143, 127, 'XV Crosstrek'),
       (5144, 128, 'Alto'),
       (5145, 128, 'A-Star Concept'),
       (5146, 128, 'Equator RMZ-4 Concept'),
       (5147, 128, 'G70 Concept'),
       (5148, 128, 'Grand Vitara'),
       (5149, 128, 'Grand Vitara 3-door'),
       (5150, 128, 'Grand Vitara V6'),
       (5151, 128, 'Kizashi'),
       (5152, 128, 'Kizashi 2 Concept'),
       (5153, 128, 'Kizashi 3 Concept'),
       (5154, 128, 'Kizashi Apex Concept'),
       (5155, 128, 'Kizashi Concept'),
       (5156, 128, 'Kizashi EcoCharge Concept'),
       (5157, 128, 'Kizashi Sport'),
       (5158, 128, 'S-Cross Concept'),
       (5159, 128, 'Splash'),
       (5160, 128, 'Swift'),
       (5161, 128, 'Equator Quay Concept'),
       (5162, 128, 'Equator Quad Concept'),
       (5163, 128, 'Swift Rally Car'),
       (5164, 128, 'Swift S Concept'),
       (5165, 128, 'Swift Sport'),
       (5166, 128, 'SX4'),
       (5167, 128, 'SX4 Sedan'),
       (5168, 128, 'Swift VVT'),
       (5169, 128, 'SXForce Concept'),
       (5170, 128, 'XL7'),
       (5171, 129, 'Tuscan Convertible'),
       (5172, 129, 'Tuscan'),
       (5173, 129, 'Sagaris'),
       (5174, 129, 'T350C'),
       (5175, 129, 'V8S'),
       (5176, 129, 'Chimaera'),
       (5177, 129, 'S4C'),
       (5178, 129, 'Griffith 500'),
       (5179, 129, 'Cerbera'),
       (5180, 130, 'Concept One'),
       (5181, 130, 'Porsche 911 Aerokit I'),
       (5182, 130, 'Porsche 911 Cabrio Aerokit I'),
       (5183, 130, 'Porsche 911 Carrera'),
       (5184, 130, 'Porsche 911 Carrera 4 997'),
       (5185, 130, 'Porsche 911 Turbo'),
       (5186, 130, 'Porsche 911 Turbo 997'),
       (5187, 130, 'Porsche 911 Turbo Aerokit II'),
       (5188, 130, 'Porsche 911 Turbo Cabriolet'),
       (5189, 130, 'Porsche 911 Turbo GTstreet Cabrio'),
       (5190, 130, 'Porsche 911 Turbo GTstreet R'),
       (5191, 130, 'Porsche Boxster'),
       (5192, 130, 'Porsche Carrera GT'),
       (5193, 130, 'Porsche Cayenne'),
       (5194, 130, 'Porsche 911 GT2 GTstreet RS'),
       (5195, 130, 'Porsche 911 Turbo GTstreet'),
       (5196, 130, 'Porsche Cayenne Magnum'),
       (5197, 130, 'Porsche Cayman'),
       (5198, 130, 'Porsche Cayman S'),
       (5199, 130, 'Porsche Panamera'),
       (5200, 130, 'Porsche 911 Carrera S Police Car'),
       (5201, 130, 'Porsche Panamera Black Edition'),
       (5202, 130, 'GTsport'),
       (5203, 130, 'Porsche Panamera GrandGT'),
       (5204, 131, 'Roadster 2.5'),
       (5205, 131, 'Roadster UK-Version'),
       (5206, 131, 'Roadster TAG Heuer'),
       (5207, 131, 'Roadster Sport'),
       (5208, 131, 'Model S Concept'),
       (5209, 131, 'Roadster'),
       (5210, 132, 'city'),
       (5211, 133, '1X Concept'),
       (5212, 133, '4Runner'),
       (5213, 133, 'A-BAT Concept'),
       (5214, 133, 'Alessandro Volta Concept ItalDesign'),
       (5215, 133, 'Aurion'),
       (5216, 133, 'Prius Plus'),
       (5217, 133, 'Auris'),
       (5218, 133, 'Auris HSD Full Hybrid Concept'),
       (5219, 133, 'Auris Space Concept'),
       (5220, 133, 'Auris Touring Sports'),
       (5221, 133, 'Avalon'),
       (5222, 133, 'Avalon Limited'),
       (5223, 133, 'Avalon Touring'),
       (5224, 133, 'Avalon XLS'),
       (5225, 133, 'Avensis'),
       (5226, 133, 'Tacoma'),
       (5227, 133, 'Avensis Estate'),
       (5228, 133, 'NS4 Advanced Plug-in Hybrid Concept'),
       (5229, 133, 'Avensis Liftback'),
       (5230, 133, 'Avensis Sedan'),
       (5231, 133, 'Avensis Tourer'),
       (5232, 133, 'Avensis Wagon'),
       (5233, 133, 'Aygo'),
       (5234, 133, 'Aygo Crazy Concept'),
       (5235, 133, '86 GTS'),
       (5236, 133, 'Yaris HSD Concept'),
       (5237, 133, 'Sienna'),
       (5238, 133, 'Sequoia'),
       (5239, 133, 'RAV4'),
       (5240, 133, 'Prius C Concept'),
       (5241, 133, 'Matrix'),
       (5242, 133, 'Highlander Hybrid'),
       (5243, 133, 'Highlander'),
       (5244, 133, 'Fun Vii Concept'),
       (5245, 133, 'FT-86 II Concept'),
       (5246, 133, 'Corolla'),
       (5247, 133, 'Auris HSD'),
       (5248, 133, 'iQ3'),
       (5249, 133, 'Yaris'),
       (5250, 133, 'Verso'),
       (5251, 133, 'Tundra Regular Cab'),
       (5252, 133, 'Tundra CrewMax'),
       (5253, 133, 'Tundra'),
       (5254, 133, 'RAV4 EV Concept'),
       (5255, 133, 'Prius'),
       (5256, 133, 'Land Cruiser V8'),
       (5257, 133, 'Land Cruiser'),
       (5258, 133, 'FT-EV II Concept'),
       (5259, 133, 'FT-CH Concept'),
       (5260, 133, 'FT-86G Sports Concept'),
       (5261, 133, 'Camry'),
       (5262, 133, 'iQ'),
       (5263, 133, 'Yaris Sedan'),
       (5264, 133, 'Yaris 5-door'),
       (5265, 133, 'Yaris 3-door'),
       (5266, 133, 'Venza'),
       (5267, 133, 'Urban Cruiser'),
       (5268, 133, 'Aygo for Sport Concept'),
       (5269, 133, 'Camry AU Version'),
       (5270, 133, 'Camry CNG Hybrid Concept'),
       (5271, 133, 'Camry Daytona 500 Pace Car'),
       (5272, 133, 'Camry Hybrid'),
       (5273, 133, 'Camry SE'),
       (5274, 133, 'Camry Solara Convertible V6 SE'),
       (5275, 133, 'Camry Solara Coupe'),
       (5276, 133, 'Camry XLE'),
       (5277, 133, 'Celica'),
       (5278, 133, 'Celica GTS'),
       (5279, 133, 'Celica T Sport'),
       (5280, 133, 'Corolla Sedan'),
       (5281, 133, 'Corolla Verso D4D'),
       (5282, 133, 'Corolla Verso VVTi'),
       (5283, 133, 'Crown Hybrid Concept'),
       (5284, 133, 'CSandS Concept'),
       (5285, 133, 'Endo Concept'),
       (5286, 133, 'F3R Concept'),
       (5287, 133, 'FCV-R Concept'),
       (5288, 133, 'FINES FuelCell Concept'),
       (5289, 133, 'Fine-T Fuel Cell Hybrid Concept'),
       (5290, 133, 'FJ Cruiser'),
       (5291, 133, 'FJ Cruiser Concept'),
       (5292, 133, 'FT-86 Concept'),
       (5293, 133, 'FT-Bh Concept'),
       (5294, 133, 'FT-EV Concept'),
       (5295, 133, 'FT-HS Concept'),
       (5296, 133, 'FT-MV Concept'),
       (5297, 133, 'FTX Concept'),
       (5298, 133, 'GT 86'),
       (5299, 133, 'Hi-CT Concept'),
       (5300, 133, 'Hilux'),
       (5301, 133, 'Hilux High Power'),
       (5302, 133, 'Hybrid X Concept'),
       (5303, 133, 'iQ Concept'),
       (5304, 133, 'iQ EV'),
       (5305, 133, 'i-Real Concept'),
       (5306, 133, 'ist Concept'),
       (5307, 133, 'Land Cruiser 3d'),
       (5308, 133, 'Land Cruiser 5d'),
       (5309, 133, 'Land Cruiser Amazon'),
       (5310, 133, 'Motor Triathlon Race Car Concept'),
       (5311, 133, 'MR2'),
       (5312, 133, 'Prius C'),
       (5313, 133, 'Prius Plug-in Hybrid'),
       (5314, 133, 'Prius Plug-in Hybrid Concept'),
       (5315, 133, 'Prius V'),
       (5316, 133, 'RAV4 3door'),
       (5317, 133, 'RAV4 D4D'),
       (5318, 133, 'RAV4 EU Version'),
       (5319, 133, 'RAV4 EV'),
       (5320, 133, 'RAV4 Sports Concept'),
       (5321, 133, 'RAV4 X'),
       (5322, 133, 'RiN Concept'),
       (5323, 133, 'Supra'),
       (5324, 133, 'Tacoma XRunner'),
       (5325, 133, 'TRD Aurion'),
       (5326, 133, 'Tundra NASCAR Craftsman Series Truck'),
       (5327, 133, 'Verso-S'),
       (5328, 133, 'Yaris Cabrio Concept'),
       (5329, 133, 'Yaris Hybrid'),
       (5330, 133, 'Yaris T Sport'),
       (5331, 133, 'Yaris Trend'),
       (5332, 133, 'Yaris TS'),
       (5333, 133, 'Yaris TS Concept'),
       (5334, 133, 'Yaris Verso'),
       (5335, 134, 'R'),
       (5336, 134, 'Tramontanat'),
       (5337, 135, 'Thunderbird Glass Roof Concept'),
       (5338, 136, 'Adam'),
       (5339, 136, 'Agila'),
       (5340, 136, 'Antara'),
       (5341, 136, 'Astra'),
       (5342, 136, 'Ampera'),
       (5343, 136, 'Astra 5-door'),
       (5344, 136, 'Astra Convertible'),
       (5345, 136, 'Astra Coupe'),
       (5346, 136, 'Astra Coupe 888'),
       (5347, 136, 'Astra Estate'),
       (5348, 136, 'Astra GTC'),
       (5349, 136, 'Astra Sport Hatch'),
       (5350, 136, 'Insignia VXR Sports Tourer'),
       (5351, 136, 'Astra Sports Tourer'),
       (5352, 136, 'Astra TwinTop'),
       (5353, 136, 'Astra VXR'),
       (5354, 136, 'Corsa'),
       (5355, 136, 'VXR8 Bathurst S'),
       (5356, 136, 'Insignia'),
       (5357, 136, 'Corsa 3-door'),
       (5358, 136, 'Corsa 5-door'),
       (5359, 136, 'Corsa VXR'),
       (5360, 136, 'Corsa VXR Nurburgring Edition'),
       (5361, 136, 'GTC Paris Concept'),
       (5362, 136, 'Vectra Estate'),
       (5363, 136, 'Insignia Sports Tourer'),
       (5364, 136, 'Signum'),
       (5365, 136, 'Meriva VXR'),
       (5366, 136, 'Insignia VXR'),
       (5367, 136, 'Meriva'),
       (5368, 136, 'Astra Panoramic'),
       (5369, 136, 'Mokka'),
       (5370, 136, 'Monaro V8'),
       (5371, 136, 'Monaro VXR'),
       (5372, 136, 'Omega'),
       (5373, 136, 'Tigra'),
       (5374, 136, 'Union Jack VX220'),
       (5375, 136, 'Vectra'),
       (5376, 136, 'Vectra VXR'),
       (5377, 136, 'Vectra VXR Estate'),
       (5378, 136, 'VX Lightning Concept'),
       (5379, 136, 'VX220'),
       (5380, 136, 'VX220 Turbo'),
       (5381, 136, 'VXR220'),
       (5382, 136, 'VXR8'),
       (5383, 136, 'Zafira'),
       (5384, 136, 'Zafira Tourer'),
       (5385, 136, 'Frontera'),
       (5386, 136, 'Zafira Tourer Concept'),
       (5387, 136, 'Zafira VXR'),
       (5388, 137, 'Fetish'),
       (5389, 137, 'America'),
       (5390, 137, 'Volage Concept'),
       (5391, 137, 'Eclectic'),
       (5392, 137, 'Astrolab'),
       (5393, 138, '411'),
       (5394, 138, '1500'),
       (5395, 138, '1-Litre Car Concept'),
       (5396, 138, 'Scirocco GTS'),
       (5397, 138, 'AAC Concept'),
       (5398, 138, 'Amarok'),
       (5399, 138, 'Beetle'),
       (5400, 138, 'Beetle Convertible'),
       (5401, 138, 'Beetle Fender Edition'),
       (5402, 138, 'Beetle Last Edition'),
       (5403, 138, 'Beetle R-Line'),
       (5404, 138, 'Beetle TDI'),
       (5405, 138, 'Bora'),
       (5406, 138, 'Bora Variant'),
       (5407, 138, 'Buggy Up Concept'),
       (5408, 138, 'Caddy Cross'),
       (5409, 138, 'CC'),
       (5410, 138, 'Concept D'),
       (5411, 138, 'Concept R'),
       (5412, 138, 'Polo R WRC Street Concept'),
       (5413, 138, 'Polo R WRC Concept'),
       (5414, 138, 'Corrado SLC'),
       (5415, 138, 'Cross Coupe Concept'),
       (5416, 138, 'Cross Coupe TDI Concept'),
       (5417, 138, 'Cross Up Concept'),
       (5418, 138, 'CrossGolf'),
       (5419, 138, 'CrossPolo'),
       (5420, 138, 'Derby'),
       (5421, 138, 'E-Bugster Concept'),
       (5422, 138, 'E-Bugster Speedster Concept'),
       (5423, 138, 'Eos'),
       (5424, 138, 'eT Concept'),
       (5425, 138, 'e-Up Concept'),
       (5426, 138, 'Touran'),
       (5427, 138, 'Touareg'),
       (5428, 138, 'Sharan'),
       (5429, 138, 'Gol 2-door'),
       (5430, 138, 'Golf'),
       (5431, 138, 'Golf BlueMotion Concept'),
       (5432, 138, 'Phaeton'),
       (5433, 138, 'Golf Cabrio'),
       (5434, 138, 'Passat'),
       (5435, 138, 'Golf Cabriolet'),
       (5436, 138, 'Jetta EU Version'),
       (5437, 138, 'Golf Cabriolet Last Edition'),
       (5438, 138, 'Golf eGeneration'),
       (5439, 138, 'Golf GTI 25th Anniversary'),
       (5440, 138, 'Golf GTI Cabriolet'),
       (5441, 138, 'Golf GTI Cabriolet Concept'),
       (5442, 138, 'CrossTouran'),
       (5443, 138, 'Golf GTI Concept'),
       (5444, 138, 'Bulli Concept'),
       (5445, 138, 'Golf GTI Edition 35'),
       (5446, 138, 'Beetle R Concept'),
       (5447, 138, 'Golf GTI Pirelli'),
       (5448, 138, 'Golf I'),
       (5449, 138, 'Golf I GTI'),
       (5450, 138, 'Polo 3-Door'),
       (5451, 138, 'Polo'),
       (5452, 138, 'Golf II'),
       (5453, 138, 'Golf II GTI'),
       (5454, 138, 'Milano Taxi Concept'),
       (5455, 138, 'London Taxi Concept'),
       (5456, 138, 'Golf blue-e-motion Concept'),
       (5457, 138, 'Golf Variant'),
       (5458, 138, 'Golf R'),
       (5459, 138, 'Golf GTI US-Version'),
       (5460, 138, 'Golf GTI'),
       (5461, 138, 'Golf GTD'),
       (5462, 138, 'Berlin Taxi Concept'),
       (5463, 138, 'Up Lite Concept');
INSERT INTO `models` (`id`, `make_id`, `name`)
VALUES (5464, 138, 'Touareg North Sails'),
       (5465, 138, 'Scirocco'),
       (5466, 138, 'Routan'),
       (5467, 138, 'Polo BlueMotion Concept'),
       (5468, 138, 'Passat CC'),
       (5469, 138, 'L1 Concept'),
       (5470, 138, 'Golf Plus'),
       (5471, 138, 'Gol'),
       (5472, 138, 'BlueSport Concept'),
       (5473, 138, 'Touareg R50'),
       (5474, 138, 'Touareg BlueTDI'),
       (5475, 138, 'Tiguan R-Line'),
       (5476, 138, 'Tiguan Prototype'),
       (5477, 138, 'Tiguan'),
       (5478, 138, 'Scirocco Studie R Concept'),
       (5479, 138, 'Pickup Concept'),
       (5480, 138, 'Passat Variant BlueMotion'),
       (5481, 138, 'Passat CC Performance Concept'),
       (5482, 138, 'Golf BlueMotion'),
       (5483, 138, 'Up Concept'),
       (5484, 138, 'Space Up Concept'),
       (5485, 138, 'Space Up Blue Concept'),
       (5486, 138, 'Passat R36'),
       (5487, 138, 'Multivan Startline'),
       (5488, 138, 'Golf Variant RaVe 270 Concept'),
       (5489, 138, 'Golf GTI W12 650 Concept'),
       (5490, 138, 'Tiguan Concept'),
       (5491, 138, 'Thunder Bunny Concept'),
       (5492, 138, 'Rabbit'),
       (5493, 138, 'R GTI Concept'),
       (5494, 138, 'Polo GTI'),
       (5495, 138, 'Polo BlueMotion'),
       (5496, 138, 'Passat Variant'),
       (5497, 138, 'Neeza Concept'),
       (5498, 138, 'Jetta GLI'),
       (5499, 138, 'Jetta 2.5'),
       (5500, 138, 'Jetta'),
       (5501, 138, 'IROC Concept'),
       (5502, 138, 'Golf GTI Edition 30'),
       (5503, 138, 'Golf GT'),
       (5504, 138, 'GX3 Concept'),
       (5505, 138, 'Concept A'),
       (5506, 138, 'Touareg V6 TDI with Exclusive Equipment'),
       (5507, 138, 'Touareg V6 TDI'),
       (5508, 138, 'Touareg R GT'),
       (5509, 138, 'Touareg Expedition'),
       (5510, 138, 'Polo Fun'),
       (5511, 138, 'Passat R GT'),
       (5512, 138, 'New Beetle Ragster Concept'),
       (5513, 138, 'New Beetle'),
       (5514, 138, 'Jetta R GT'),
       (5515, 138, 'Golf Speed'),
       (5516, 138, 'Golf R32'),
       (5517, 138, 'Fox 1.6'),
       (5518, 138, 'Fox 1.4'),
       (5519, 138, 'Fox 1.2'),
       (5520, 138, 'Fox'),
       (5521, 138, 'EcoRacer Prototype'),
       (5522, 138, 'Touareg W12 Sport'),
       (5523, 138, 'Sharan Special'),
       (5524, 138, 'RaceTouareg'),
       (5525, 138, 'Phaeton with Long Wheelbase'),
       (5526, 138, 'Phaeton V8 4.2 4MOTION'),
       (5527, 138, 'New Beetle Cabriolet Dark Flint Limited Edition'),
       (5528, 138, 'Golf GTI 5-door'),
       (5529, 138, 'Concept T'),
       (5530, 138, 'Concept C'),
       (5531, 138, 'Tarek'),
       (5532, 138, 'Polo Sedan'),
       (5533, 138, 'Phaeton V10 TDI'),
       (5534, 138, 'New Beetle Sport Edition'),
       (5535, 138, 'Golf III'),
       (5536, 138, 'Golf III GTI'),
       (5537, 138, 'Golf III VR6'),
       (5538, 138, 'Golf IV'),
       (5539, 138, 'Golf IV GTI'),
       (5540, 138, 'Golf R Cabriolet Concept'),
       (5541, 138, 'Jetta Hybrid'),
       (5542, 138, 'K70'),
       (5543, 138, 'Lavida'),
       (5544, 138, 'Lupo'),
       (5545, 138, 'Lupo 3L TDI'),
       (5546, 138, 'Lupo GTI'),
       (5547, 138, 'Magellan Concept'),
       (5548, 138, 'Microbus Concept'),
       (5549, 138, 'New Beetle Cabriolet'),
       (5550, 138, 'New Beetle Dune Concept'),
       (5551, 138, 'New Beetle USA Version'),
       (5552, 138, 'New Compact Coupe Concept'),
       (5553, 138, 'NILS Concept'),
       (5554, 138, 'Noah'),
       (5555, 138, 'Passat Alltrack'),
       (5556, 138, 'Passat CC R-Line'),
       (5557, 138, 'Passat Estate'),
       (5558, 138, 'Passat US Version'),
       (5559, 138, 'Passat W8'),
       (5560, 138, 'Passat W8 Variant'),
       (5561, 138, 'Polo BlueGT'),
       (5562, 138, 'Polo Classic'),
       (5563, 138, 'Polo Saloon'),
       (5564, 138, 'Polo Variant'),
       (5565, 138, 'Race Touareg 3 Qatar Concept'),
       (5566, 138, 'Santana new'),
       (5567, 138, 'Scirocco R'),
       (5568, 138, 'Taigun Concept'),
       (5569, 138, 'Touareg Edition X'),
       (5570, 138, 'Up'),
       (5571, 138, 'Up 4-door'),
       (5572, 138, 'Vento'),
       (5573, 138, 'Vento VR6'),
       (5574, 138, 'W12 Concept'),
       (5575, 138, 'W12 Coupe Concept'),
       (5576, 138, 'XL1 Concept'),
       (5577, 139, '780'),
       (5578, 139, '3CC Concept'),
       (5579, 139, 'ACC 2 Concept'),
       (5580, 139, 'Air Motion Concept'),
       (5581, 139, 'C30'),
       (5582, 139, 'C30 BEV'),
       (5583, 139, 'C30 Design Concept'),
       (5584, 139, 'XC90'),
       (5585, 139, 'C30 DRIVe'),
       (5586, 139, 'C30 Heico Concept'),
       (5587, 139, 'C30 Polestar Concept'),
       (5588, 139, 'C70'),
       (5589, 139, 'C70 Convertible'),
       (5590, 139, 'C70 Coupe'),
       (5591, 139, 'Caresto C70'),
       (5592, 139, 'Caresto V8 Speedster Concept'),
       (5593, 139, 'Evolve S40 Concept'),
       (5594, 139, 'Heico C30 SEMA Concept'),
       (5595, 139, 'Heico S80 SEMA Concept'),
       (5596, 139, 'PCC 2 Concept'),
       (5597, 139, 'PV36 Carioca'),
       (5598, 139, 'ReCharge Concept'),
       (5599, 139, 'S40'),
       (5600, 139, 'S40 DRIVe'),
       (5601, 139, 'S60'),
       (5602, 139, 'S60 AWD'),
       (5603, 139, 'S60 Concept'),
       (5604, 139, 'S60 Polestar Concept'),
       (5605, 139, 'S60 R'),
       (5606, 139, 'S60 R-Design'),
       (5607, 139, 'S80'),
       (5608, 139, 'S80 Heico Concept'),
       (5609, 139, 'S80L'),
       (5610, 139, 'SCC Concept'),
       (5611, 139, 'T6 Roadster Concept'),
       (5612, 139, 'Universe Concept'),
       (5613, 139, 'XC90 Sport'),
       (5614, 139, 'V40'),
       (5615, 139, 'V40 Cross Country'),
       (5616, 139, 'V40 R-Design'),
       (5617, 139, 'V50'),
       (5618, 139, 'V50 DRIVe'),
       (5619, 139, 'V50 Romero Britto'),
       (5620, 139, 'V50 SV Concept'),
       (5621, 139, 'V60'),
       (5622, 139, 'V60 Plug-in Hybrid'),
       (5623, 139, 'V60 R-Design'),
       (5624, 139, 'V70'),
       (5625, 139, 'V70 Police car'),
       (5626, 139, 'V70 R'),
       (5627, 139, 'V70 R-Design'),
       (5628, 139, 'V70 XC'),
       (5629, 139, 'VCC Concept'),
       (5630, 139, 'XC60'),
       (5631, 139, 'XC60 Concept'),
       (5632, 139, 'XC60 Plug-in Hybrid Concept'),
       (5633, 139, 'XC60 R-Design'),
       (5634, 139, 'XC70'),
       (5635, 139, 'XC70 AT Concept'),
       (5636, 139, 'XC70 Surf Rescue Concept'),
       (5637, 139, 'XC90 Lego Replica'),
       (5638, 139, 'ACC Concept'),
       (5639, 139, 'XC90 PUV Concept'),
       (5640, 139, 'PCC Concept'),
       (5641, 139, 'XC90 Supercharged V8'),
       (5642, 139, 'XC90 V8 AWD'),
       (5643, 139, 'YCC Concept'),
       (5644, 139, 'You Concept'),
       (5645, 140, 'Bentley Continental Flying Spur'),
       (5646, 140, 'Bentley Continental GT'),
       (5647, 140, 'Bentley Continental GT Black Bison'),
       (5648, 140, 'Bentley Flying Spur Black Bison'),
       (5649, 140, 'BMW 3-Series'),
       (5650, 140, 'BMW 5-Series F10'),
       (5651, 140, 'BMW 7-Series F01 Black Bison'),
       (5652, 140, 'BMW M5'),
       (5653, 140, 'Infiniti G Sedan V36'),
       (5654, 140, 'Jaguar XJ X350'),
       (5655, 140, 'Land Rover Range Rover'),
       (5656, 140, 'Land Rover Range Rover Mk II'),
       (5657, 140, 'Mercedes-Benz R-Class W251'),
       (5658, 140, 'Lexus IS-F'),
       (5659, 140, 'Lexus IS'),
       (5660, 140, 'Nissan GT-R'),
       (5661, 140, 'Lexus LS'),
       (5662, 140, 'Lexus LS460'),
       (5663, 140, 'Lexus LS600h'),
       (5664, 140, 'Lexus LS600h Black Bison'),
       (5665, 140, 'Lexus LX570'),
       (5666, 140, 'Lexus RX'),
       (5667, 140, 'Maserati Quattroporte Black Bison'),
       (5668, 140, 'Mercedes-Benz C-Class'),
       (5669, 140, 'Mercedes-Benz C-Class Wagon'),
       (5670, 140, 'Mercedes-Benz CL-Class'),
       (5671, 140, 'Lexus SC'),
       (5672, 140, 'Lexus GS'),
       (5673, 140, 'Mercedes-Benz CL-Class Monster'),
       (5674, 140, 'Mercedes-Benz CL-Class W140'),
       (5675, 140, 'Mercedes-Benz CL-Class W215'),
       (5676, 140, 'Mercedes-Benz CLS-Class'),
       (5677, 140, 'Mercedes-Benz E-Class'),
       (5678, 140, 'BMW 7-Series'),
       (5679, 140, 'BMW 6-Series'),
       (5680, 140, 'Aston Martin DB7'),
       (5681, 140, 'Mercedes-Benz E-Class W212 Black Bison'),
       (5682, 140, 'Mercedes-Benz E-Class Wagon'),
       (5683, 140, 'Mercedes-Benz M-Class'),
       (5684, 140, 'Mercedes-Benz S-Class'),
       (5685, 140, 'Nissan March'),
       (5686, 140, 'Mercedes-Benz S-Class W220 Black Bison'),
       (5687, 140, 'Mercedes-Benz S-Class W140'),
       (5688, 140, 'Mercedes-Benz S-Class W220'),
       (5689, 140, 'Lamborghini Murcielago'),
       (5690, 140, 'Toyota Celsior'),
       (5691, 140, 'Mercedes-Benz S-Class W221'),
       (5692, 140, 'Mercedes-Benz S-Class W221 Black Bison'),
       (5693, 140, 'Mercedes-Benz SL-Class'),
       (5694, 140, 'Mercedes-Benz SL-Class R129'),
       (5695, 140, 'Mercedes-Benz SL-Class R230'),
       (5696, 140, 'Mercedes-Benz Viano'),
       (5697, 140, 'Mercedes-Benz Vito'),
       (5698, 140, 'Mercedes-Benz W124 E'),
       (5699, 140, 'Mercedes-Benz W124 TE'),
       (5700, 140, 'Nissan Z33'),
       (5701, 140, 'Rolls-Royce Phantom Black Bison'),
       (5702, 140, 'Toyota Alphard'),
       (5703, 140, 'Toyota Altezza'),
       (5704, 140, 'Mercedes-Benz W126 SEL'),
       (5705, 140, 'Mercedes-Benz W126 SEC'),
       (5706, 140, 'Toyota Land Cruiser'),
       (5707, 140, 'Toyota Vellfire'),
       (5708, 140, 'Mercedes-Benz W124 CE'),
       (5709, 140, 'Nissan Primera'),
       (5710, 141, 'Spyder Concept'),
       (5711, 141, 'Roadster MF5'),
       (5712, 141, 'GT MF5'),
       (5713, 141, 'Roadster'),
       (5714, 141, 'GT'),
       (5715, 142, 'Roadster 3.2'),
       (5716, 142, 'Roadster'),
       (5717, 142, 'Clubsport'),
       (5718, 143, 'Z-One'),
       (5719, 144, 'ST1');

--
-- Table structure for table `newsletter`
--

DROP TABLE IF EXISTS `newsletter`;
CREATE TABLE IF NOT EXISTS `newsletter` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(100) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `created` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
CREATE TABLE IF NOT EXISTS `pages` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `slug` varchar(50) NOT NULL,
  `body` longtext,
  `type` varchar(10) NOT NULL DEFAULT 'normal',
  `keywords` varchar(120) DEFAULT NULL,
  `description` text,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` int(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `pages`
--

INSERT INTO `pages` (`id`, `title`, `slug`, `body`, `type`, `keywords`, `description`, `created`, `active`)
VALUES (1, 'Why choose us?', 'welcome', '<div class=\"mb5 mt3\">\r\n  <h2 class=\"center aligned\">Why choose us?</h2>\r\n</div>\r\n<div class=\"row big gutters align center\">\r\n  <div class=\"columns screen-25 phone-100 center aligned\">\r\n    <figure class=\"wojo medium image mb4\"><img src=\"[SITEURL]/uploads/images/achievement.svg\" alt=\"achievement\" data-image=\"89ca64rbq12o\"></figure>\r\n    <h5>Wide range of brands</h5>\r\n    <p> We can help with your financing plan, we can offer some tips and tricks. Drive off with this dream car of yours regardless of your credit history. </p>\r\n  </div>\r\n  <div class=\"columns screen-25 phone-100 center aligned\">\r\n    <figure class=\"wojo medium image mb4\"><img src=\"[SITEURL]/uploads/images/trust.svg\" alt=\"trust\" data-image=\"kc4wywkzrypp\"></figure>\r\n    <h5>Trusted by our clients</h5>\r\n    <p> We can help with your financing plan, we can offer some tips and tricks. Drive off with this dream car of yours regardless of your credit history.</p>\r\n  </div>\r\n  <div class=\"columns screen-25 phone-100 center aligned\">\r\n    <figure class=\"wojo medium image mb4\"><img src=\"[SITEURL]/uploads/images/finance.svg\" alt=\"finance\" data-image=\"92ras99m5ugd\"></figure>\r\n    <h5>Fast & easy financing</h5>\r\n    <p> We can help with your financing plan, we can offer some tips and tricks. Drive off with this dream car of yours regardless of your credit history. </p>\r\n  </div>\r\n</div>', 'home', '', '', '2011-07-16 22:00:00', 1),
       (2, 'About Us', 'about', '<div class=\"row big gutters\">\r\n  <div class=\"columns mobile-100 phone-100\">\r\n    <p class=\"wojo medium demi text\">How the adventure ended will be seen anon. Aouda was anxious, though she said nothing.</p>\r\n    <p class=\"mb2\">As for Passepartout, he thought Mr. Fogg’s manoeuvre simply glorious. The captain had said “between eleven and twelve knots,” and the Henrietta confirmed his prediction. How the adventure ended will be seen anon. Aouda was anxious, though she said nothing. As for Passepartout, he thought Mr. Fogg’s manoeuvre simply glorious. The captain had said.</p>\r\n    <p class=\"wojo primary accent mb2\">During the first days, they went along smoothly enough. The sea was not very unpropitious, the wind seemed stationary in the north-east.</p>\r\n    <p>As for Passepartout, he thought Mr. Fogg’s manoeuvre simply glorious. The captain had said “between eleven and twelve knots,” and the Henrietta confirmed his prediction. How the adventure ended will be seen anon. Aouda was anxious, though she said nothing. As for Passepartout, he thought Mr. Fogg’s manoeuvre simply glorious. The captain had said.</p>\r\n  </div>\r\n  <div class=\"columns mobile-100 phone-100\">\r\n    <figure class=\"wojo rounded image\"><img src=\"[SITEURL]/uploads/images/office.jpg\" alt=\"Office\" data-image=\"pyqffmw4lhba\"></figure>\r\n  </div>\r\n</div>\r\n<div class=\"row gutters align middle\">\r\n  <div class=\"columns screen-40 tablet-50 mobile-100 phone-100\">\r\n    <div class=\"video vimeo\">\r\n      <iframe src=\"https://player.vimeo.com/video/169599296?color=949494&title=0&byline=0&portrait=0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>\r\n    </div>\r\n  </div>\r\n  <div class=\"columns screen-60 tablet-50 mobile-100 phone-100\">\r\n    <h3>Our Mission</h3>\r\n    <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.</p>\r\n    <div class=\"wojo space divider\"></div>\r\n    <div class=\"wojo list\">\r\n      <div class=\"item\"><i class=\"icon umbrella\"></i> Lorem Ipsum simply typesetting industry.</div>\r\n      <div class=\"item\"><i class=\"icon car\"></i> Cras aliquet venenatis sapien fringilla.</div>\r\n      <div class=\"item\"><i class=\"icon person\"></i> Another list item with animated icon.</div>\r\n      <div class=\"item\"><i class=\"icon heart\"></i> Duis luctus erat vel pharetra aliquet.</div>\r\n      <div class=\"item\"><i class=\"icon bag\"></i> Estnon commodo luctus lacinia odio elit.</div>\r\n      <div class=\"item\"><i class=\"icon bell\"></i> Quisque tristique ipsum accumsan convallis.</div>\r\n      <div class=\"item\"><i class=\"icon check\"></i> Ovel dolorem fugiat nulla pariatur.</div>\r\n    </div>\r\n  </div>\r\n</div>\r\n<div class=\"wojo huge space divider\"></div>\r\n<h3 class=\"center aligned\">Meet Our Team</h3>\r\n<div class=\"wojo huge space divider\"></div>\r\n<div class=\"row grid phone-1 mobile-2 tablet-4 screen-4 gutters\">\r\n  <div class=\"columns center aligned\">\r\n    <div class=\"wojo attached card\">\r\n      <p><img src=\"[SITEURL]/uploads/images/team_01.jpg\" class=\"wojo top rounded image\" data-image=\"9yukgfzggh1g\"></p>\r\n      <div class=\"vertical margin\">\r\n        <h4>Alex Delfonso</h4>\r\n        <p class=\"wojo dimmed text\">Co-Founder, CEO</p>\r\n      </div>\r\n      <p class=\"wojo small full padding text\">Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>\r\n      <div class=\"footer divided center aligned\">\r\n        <a class=\"wojo small icon primary inverted button\"><i class=\"icon facebook\"></i></a>\r\n        <a class=\"wojo small icon primary inverted button\"><i class=\"icon twitter\"></i></a>\r\n        <a class=\"wojo small icon primary inverted button\"><i class=\"icon instagram\"></i></a>\r\n      </div>\r\n    </div>\r\n  </div>\r\n  <div class=\"columns center aligned\">\r\n    <div class=\"wojo attached card\">\r\n      <p><img src=\"[SITEURL]/uploads/images/team_02.jpg\" class=\"wojo top rounded image\" data-image=\"wvb4jdlm7836\"></p>\r\n      <div class=\"vertical margin\">\r\n        <h4> Tim Morrison </h4>\r\n        <p class=\"wojo dimmed text\">Marketing Director</p>\r\n      </div>\r\n      <p class=\"wojo small full padding text\">Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>\r\n      <div class=\"footer divided center aligned\">\r\n        <a class=\"wojo small icon primary inverted button\"><i class=\"icon facebook\"></i></a>\r\n        <a class=\"wojo small icon primary inverted button\"><i class=\"icon twitter\"></i></a>\r\n        <a class=\"wojo small icon primary inverted button\"><i class=\"icon instagram\"></i></a>\r\n      </div>\r\n    </div>\r\n  </div>\r\n  <div class=\"columns center aligned\">\r\n    <div class=\"wojo attached card\">\r\n      <p><img src=\"[SITEURL]/uploads/images/team_03.jpg\" class=\"wojo top rounded image\" data-image=\"xhc44gc3l3qe\"></p>\r\n      <div class=\"vertical margin\">\r\n        <h4>Jane Falcone</h4>\r\n        <p class=\"wojo dimmed text\">Sales Director</p>\r\n      </div>\r\n      <p class=\"wojo small full padding text\">Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>\r\n      <div class=\"footer divided center aligned\">\r\n        <a class=\"wojo small icon primary inverted button\"><i class=\"icon facebook\"></i></a>\r\n        <a class=\"wojo small icon primary inverted button\"><i class=\"icon twitter\"></i></a>\r\n        <a class=\"wojo small icon primary inverted button\"><i class=\"icon instagram\"></i></a>\r\n      </div>\r\n    </div>\r\n  </div>\r\n  <div class=\"columns center aligned\">\r\n    <div class=\"wojo attached card\">\r\n      <p><img src=\"[SITEURL]/uploads/images/team_04.jpg\" class=\"wojo top rounded image\" data-image=\"1yorb892acew\"></p>\r\n      <div class=\"vertical margin\">\r\n        <h4>John Peterson</h4>\r\n        <p class=\"wojo dimmed text\">Brand Director</p>\r\n      </div>\r\n      <p class=\"wojo small full padding text\">Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>\r\n      <div class=\"footer divided center aligned\">\r\n        <a class=\"wojo small icon primary inverted button\"><i class=\"icon facebook\"></i></a>\r\n        <a class=\"wojo small icon primary inverted button\"><i class=\"icon twitter\"></i></a>\r\n        <a class=\"wojo small icon primary inverted button\"><i class=\"icon instagram\"></i></a>\r\n      </div>\r\n    </div>\r\n  </div>\r\n</div>', 'normal', '', '', '2012-11-03 23:00:00', 1),
       (3, 'F.A.Q.', 'faq', '<p>Here you can find most common questions regarding Car Dealer Pro</p>', 'faq', NULL, NULL, '2010-03-17 23:00:00', 1),
       (4, 'Contact Us', 'contact', '<p>\r\n	Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris congue  vehicula enim id condimentum. <br>\r\n	Integer at leo lobortis libero fermentum  cursus. Mauris nulla nibh, condimentum ac cursus ac, ullamcorper eu  orci. <br>\r\n	<br>\r\n	Quisque at vehicula ante. Pellentesque habitant  morbi tristique senectus et netus et malesuada fames ac turpis egestas.  Sed turpis felis, egestas vitae tincidunt nec, ullamcorper non nisi. Vivamus venenatis consectetur libero quis consequat. Vivamus ut lorem diam. Cras interdum sem sed risus dictum fringilla. Sed sagittis turpis ut nisi faucibus pellentesque. Nunc sit amet semper erat</p>', 'contact', NULL, NULL, '2010-03-01 23:00:00', 1),
       (5, 'Other page', 'other-page', '<p>\r\n	Sed eu lorem ut diam feugiat vulputate sed a enim. Aenean interdum, dui a  varius facilisis, metus est imperdiet justo, pharetra auctor ipsum  lorem non mauris. Mauris laoreet lectus lacus. Maecenas ut enim diam,  non malesuada sapien. Fusce ullamcorper pretium risus, eu volutpat dolor  dapibus sit amet\r\n</p>', 'normal', '', '', '2010-03-17 23:00:00', 1),
       (6, 'Privacy Policy', 'privacy-policy', '<div class=\"section\" style=\"padding:64px 0\">\r\n    <div class=\"wojo-grid\">\r\n      <div class=\"row align center\">\r\n<div class=\"columns screen-70 tablet-100 mobile-100 phone-100\">\r\n<div class=\"wojo fitted card\">\r\n  <div class=\"header relative wojo primary gradient\">\r\n<div class=\"big full padding\">\r\n<h1 class=\"wojo white semi text\">Privacy &amp; Policy</h1>\r\n<p class=\"wojo white dimmed text padding bottom\">Last modified: March 27, 2018</p>\r\n</div>\r\n<figure class=\"absolute\" style=\"bottom:0;left:0;width:100%;\">\r\n<svg preserveAspectRatio=\"none\" xmlns=\"http://www.w3.org/2000/svg\" width=\"100%\" height=\"140px\" style=\"margin-bottom:-32px\" viewBox=\"20 -20 300 100\"  xml:space=\"preserve\">\r\n  <path d=\"M30.913 43.944s42.911-34.464 87.51-14.191c77.31 35.14 113.304-1.952 146.638-4.729 48.654-4.056 69.94 16.218 69.94 16.218v54.396H30.913V43.944z\" class=\"wojo white fill\" opacity=\".4\"/>\r\n  <path d=\"M-35.667 44.628s42.91-34.463 87.51-14.191c77.31 35.141 113.304-1.952 146.639-4.729 48.653-4.055 69.939 16.218 69.939 16.218v54.396H-35.667V44.628z\" class=\"wojo white fill\" opacity=\".4\"/>\r\n  <path d=\"M-34.667 62.998s56-45.667 120.316-27.839C167.484 57.842 197 41.332 232.286 30.428c53.07-16.399 104.047 36.903 104.047 36.903l1.333 36.667-372-2.954-.333-38.046z\" class=\"wojo white fill\"/>\r\n</svg>\r\n</figure>\r\n  </div>\r\n  <div class=\"content\">\r\n<p>My Company (\"us\", \"we\", or \"our\") operates https://www.mysite.com  (the\r\n\"Site\"). This page informs you of our policies regarding the\r\ncollection, use and disclosure of Personal Information we receive from users of\r\nthe Site.</p>\r\n<p>We use your Personal Information only for providing and\r\nimproving the Site. By using the Site, you agree to the collection and use of\r\ninformation in accordance with this policy.<br>\r\n<br>\r\n</p>\r\n<p><b>Information\r\nCollection And Use</b></p>\r\n<p>While using our Site, we may ask you to provide us with\r\ncertain personally identifiable information that can be used to contact or\r\nidentify you. Personally identifiable information may include, but is not\r\nlimited to your name (\"Personal Information\").<br>\r\n<br>\r\n<br>\r\n</p>\r\n<p><b>Log Data</b></p>\r\n<p>Like many site operators, we collect information that your\r\nbrowser sends whenever you visit our Site (\"Log Data\").</p>\r\n<p>This Log Data may include information such as your\r\ncomputer\'s Internet Protocol (\"IP\") address, browser type, browser\r\nversion, the pages of our Site that you visit, the time and date of your visit,\r\nthe time spent on those pages and other statistics.</p>\r\n<p>In addition, we may use third party services such as Google\r\nAnalytics that collect, monitor and analyze this …<br>\r\n<br>\r\n<br>\r\n</p>\r\n<p><b>Communications</b></p>\r\n<p>We may use your Personal Information to contact you with\r\nnewsletters, marketing or promotional materials and other information that ...<br>\r\n<br>\r\n<br>\r\n</p>\r\n<p><b>Cookies</b></p>\r\n<p>Cookies are files with small amount of data, which may\r\ninclude an anonymous unique identifier. Cookies are sent to your browser from a\r\nweb site and stored on your computer\'s hard drive.</p>\r\n<p>Like many sites, we use \"cookies\" to collect\r\ninformation. You can instruct your browser to refuse all cookies or to indicate\r\nwhen a cookie is being sent. However, if you do not accept cookies, you may not\r\nbe able to use some portions of our Site.<br>\r\n<br>\r\n<br>\r\n</p>\r\n<p><b>Security</b></p>\r\n<p>The security of your Personal Information is important to\r\nus, but remember that no method of transmission over the Internet, or method of\r\nelectronic storage, is 100% secure. While we strive to use commercially\r\nacceptable means to protect your Personal Information, we cannot guarantee its\r\nabsolute security.<br>\r\n<br>\r\n<br>\r\n</p>\r\n<p><b>Changes To This\r\nPrivacy Policy</b></p>\r\n<p>This Privacy Policy is effective as of (October 20. 2017) and will remain in effect except\r\nwith respect to any changes in its provisions in the future, which will be in\r\neffect immediately after being posted on this page.</p>\r\n<p>We reserve the right to update or change our Privacy Policy\r\nat any time and you should check this Privacy Policy periodically. Your\r\ncontinued use of the Service after we post any modifications to the Privacy\r\nPolicy on this page will constitute your acknowledgment of the modifications\r\nand your consent to abide and be bound by the modified Privacy Policy.</p>\r\n<p>If we make any material changes to this Privacy Policy, we\r\nwill notify you either through the email address you have provided us, or by\r\nplacing a prominent notice on our website.<br>\r\n<br>\r\n<br>\r\n</p>\r\n<p><b>Contact Us</b></p>\r\n<p>If you have any questions about this Privacy Policy, please <a href=\"[SITEURL]/page/contact\">contact us.</a>\r\n</p>\r\n  </div>\r\n</div>\r\n</div>\r\n      </div>\r\n    </div>\r\n  </div>', 'privacy', NULL, NULL, '2022-12-17 23:00:00', 1);

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
CREATE TABLE IF NOT EXISTS `payments` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `txn_id` varchar(50) DEFAULT NULL,
  `membership_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `amount` decimal(10, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `tax` decimal(4, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `coupon` decimal(4, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `total` decimal(10, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `currency` varchar(4) DEFAULT NULL,
  `pp` varchar(20) DEFAULT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `muid` (`membership_id`, `user_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `privileges`
--

DROP TABLE IF EXISTS `privileges`;
CREATE TABLE IF NOT EXISTS `privileges` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL,
  `name` varchar(150) NOT NULL,
  `description` varchar(250) DEFAULT NULL,
  `mode` varchar(8) NOT NULL,
  `type` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
  ) ENGINE = MyISAM AUTO_INCREMENT = 33 DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `privileges`
--

INSERT INTO `privileges` (`id`, `code`, `name`, `description`, `mode`, `type`)
VALUES (1, 'add_menus', 'Add Menus', 'Add Menus on the site', 'add', 'Menus'),
       (2, 'edit_menus', 'Edit Menus', 'Edit Menus on the site', 'edit', 'Menus'),
       (3, 'delete_menus', 'Delete Menus', 'Delete Menus from the site', 'delete', 'Menus'),
       (4, 'add_pages', 'Add Pages', 'Add Pages on the site', 'add', 'Pages'),
       (5, 'edit_pages', 'Edit Pages', 'Edit Pages on the site', 'edit', 'Pages'),
       (6, 'delete_pages', 'Delete Pages', 'Delete Pages from the site', 'delete', 'Pages'),
       (8, 'add_members', 'Add Members', 'Add new member', 'add', 'Members'),
       (7, 'edit_members', 'Edit Members', 'Access edit properties for members section.', 'edit', 'Members'),
       (9, 'delete_members', 'Delete Members', 'Delete Members from the site', 'delete', 'Members'),
       (10, 'add_faq', 'Add F.A.Q.', 'Permission to add F.A.Q.', 'add', 'FAQ'),
       (11, 'edit_faq', 'Edit F.A.Q.', 'Edit Site F.A.Q.', 'edit', 'FAQ'),
       (12, 'delete_faq', 'Delete F.A.Q.', 'Delete F.A.Q.', 'delete', 'FAQ'),
       (13, 'manage_cats', 'Manage Categories', 'Permission to add/edit/delete categories', 'manage', 'Categories'),
       (14, 'manage_advert', 'Manage Adverts', 'Permission to edit/edit/delete site adverts', 'manage', 'News'),
       (15, 'manage_templates', 'Manage Email Templates', 'Permission to edit email templates', 'manage', 'Templates'),
       (16, 'edit_items', 'Edit Listings', 'Permission to edit existing listings', 'edit', 'Listings'),
       (17, 'delete_items', 'Delete Listings', 'Permission to delete existing listings', 'delete', 'Listings'),
       (18, 'manage_trans', 'Manage Transmissions', 'Permission to add/edit/delete transmissions types', 'manage', 'Transmissions'),
       (19, 'manage_conditions', 'Manage Conditions', 'Permission to add/edit/delete conditions', 'manage', 'Conditions'),
       (20, 'add_items', 'Add Listings', 'Permission to add listings', 'add', 'Listings'),
       (21, 'manage_features', 'Manage Features', 'Permission to add/edit/delete features', 'manage', 'Features'),
       (22, 'manage_makes', 'Manage Makes', 'Permission to add/edit/delete car makes', 'manage', 'Makes'),
       (23, 'manage_models', 'Manage Models', 'Permission to add/edit/delete car models', 'manage', 'Models'),
       (24, 'manage_fuel', 'Manage Fulel', 'Permission to add/edit/delete fuel types', 'manage', 'Fuel'),
       (25, 'manage_gallery', 'Manage Galleries', 'Permission to add/edit/delete gallery images', 'manage', 'Gallery'),
       (26, 'manage_upay', 'Manage User Payments', 'Permission to access user payment history', 'manage', 'Members'),
       (27, 'manage_coupons', 'Manage Discounts/Coupons', 'Permission to add/edit/delete discounts/coupons', 'manage', 'Coupons'),
       (28, 'manage_approval', 'Manage Approvals', 'Permission to approve/reject pending listings', 'approve', 'Listings'),
       (29, 'manage_slider', 'Manage Slider', 'Permission to add/edit/delete slider images', 'manage', 'Slider'),
       (30, 'manage_reviews', 'Manage Site Reviews', 'Permission to edit/delete site reviews', 'manage', 'Reviews');

--
-- Table structure for table `reviews`
--

DROP TABLE IF EXISTS `reviews`;
CREATE TABLE IF NOT EXISTS `reviews` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `twitter` varchar(50) DEFAULT NULL,
  `content` mediumtext,
  `created` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`user_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
CREATE TABLE IF NOT EXISTS `roles` (
  `id` smallint(4) NOT NULL AUTO_INCREMENT,
  `code` varchar(10) NOT NULL,
  `icon` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` (`id`, `code`, `icon`, `name`, `description`)
VALUES (1, 'owner', 'badge', 'Site Owner', 'Site Owner is the owner of the site, has all privileges and could not be removed.'),
       (2, 'staff', 'trophy', 'Staff', 'The \"Main Administrator\" user has top privileges like Site Owner and may be removed only by him.'),
       (3, 'manager', 'note', 'Manager', 'The \"Manager\" is required to assist the Main Admins, has different privileges and may be created by Site Owner or Main Admins.'),
       (4, 'editor', 'editor', 'Editor', 'The &#34;Editor&#34; is required to assist the Managers, has different privileges and may be created by Site Owner or Main Admins.');
--
-- Table structure for table `role_privileges`
--

DROP TABLE IF EXISTS `role_privileges`;
CREATE TABLE IF NOT EXISTS `role_privileges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rid` int(6) NOT NULL DEFAULT '0',
  `pid` int(6) NOT NULL DEFAULT '0',
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx` (`rid`, `pid`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `role_privileges`
--

INSERT INTO `role_privileges` (`id`, `rid`, `pid`, `active`)
VALUES (1, 1, 1, 1),
       (2, 2, 1, 1),
       (3, 3, 1, 1),
       (4, 4, 1, 1),
       (5, 1, 2, 1),
       (6, 2, 2, 1),
       (7, 3, 2, 1),
       (8, 4, 2, 1),
       (9, 1, 3, 1),
       (10, 2, 3, 1),
       (11, 3, 3, 1),
       (12, 4, 3, 1),
       (13, 1, 4, 1),
       (14, 2, 4, 1),
       (15, 3, 4, 1),
       (16, 4, 4, 0),
       (17, 1, 5, 1),
       (18, 2, 5, 1),
       (19, 3, 5, 1),
       (20, 4, 5, 0),
       (21, 1, 6, 1),
       (22, 2, 6, 1),
       (23, 3, 6, 1),
       (24, 4, 6, 0),
       (25, 1, 7, 1),
       (26, 2, 7, 1),
       (27, 3, 7, 1),
       (28, 4, 7, 0),
       (29, 1, 8, 1),
       (30, 2, 8, 1),
       (31, 3, 8, 0),
       (32, 4, 8, 1),
       (33, 1, 9, 1),
       (34, 2, 9, 1),
       (35, 3, 9, 1),
       (36, 4, 9, 0),
       (37, 1, 10, 1),
       (38, 2, 10, 1),
       (39, 3, 10, 1),
       (40, 4, 10, 0),
       (41, 1, 11, 1),
       (42, 2, 11, 1),
       (43, 3, 11, 1),
       (44, 4, 11, 0),
       (45, 1, 12, 1),
       (46, 2, 12, 1),
       (47, 3, 12, 0),
       (48, 4, 12, 1),
       (49, 1, 13, 1),
       (50, 2, 13, 1),
       (51, 3, 13, 0),
       (52, 4, 13, 1),
       (53, 1, 14, 1),
       (54, 2, 14, 1),
       (55, 3, 14, 1),
       (56, 4, 14, 0),
       (57, 1, 15, 1),
       (58, 2, 15, 1),
       (59, 3, 15, 1),
       (60, 4, 15, 0),
       (61, 1, 16, 1),
       (62, 2, 16, 1),
       (63, 3, 16, 1),
       (64, 4, 16, 0),
       (65, 1, 17, 1),
       (66, 2, 17, 1),
       (67, 3, 17, 1),
       (68, 4, 17, 0),
       (69, 1, 18, 1),
       (70, 2, 18, 1),
       (71, 3, 18, 1),
       (72, 4, 18, 0),
       (73, 1, 19, 1),
       (74, 2, 19, 1),
       (75, 3, 19, 1),
       (76, 4, 19, 0),
       (77, 1, 20, 1),
       (78, 2, 20, 1),
       (79, 3, 20, 0),
       (80, 4, 20, 1),
       (81, 1, 21, 1),
       (82, 2, 21, 1),
       (83, 3, 21, 1),
       (84, 4, 21, 0),
       (85, 1, 22, 1),
       (86, 2, 22, 1),
       (87, 3, 22, 1),
       (88, 4, 22, 0),
       (89, 1, 23, 1),
       (90, 2, 23, 1),
       (91, 3, 23, 1),
       (92, 4, 23, 0),
       (93, 1, 24, 1),
       (94, 2, 24, 1),
       (95, 3, 24, 1),
       (96, 4, 24, 0),
       (97, 1, 25, 1),
       (98, 2, 25, 1),
       (99, 3, 25, 1),
       (100, 4, 25, 0),
       (101, 1, 26, 1),
       (102, 2, 26, 1),
       (103, 3, 26, 1),
       (104, 4, 26, 0),
       (105, 1, 27, 1),
       (106, 2, 27, 1),
       (107, 3, 27, 1),
       (108, 4, 27, 0),
       (109, 1, 28, 1),
       (110, 2, 28, 1),
       (111, 3, 28, 1),
       (112, 4, 28, 0),
       (113, 1, 29, 1),
       (114, 2, 29, 1),
       (115, 3, 29, 1),
       (116, 4, 29, 0),
       (117, 1, 30, 1),
       (118, 2, 30, 1),
       (119, 3, 30, 1),
       (120, 4, 30, 0);

--
-- Table structure for table `settings`
--
DROP TABLE IF EXISTS `settings`;
CREATE TABLE IF NOT EXISTS `settings` (
  `id` tinyint(1) UNSIGNED NOT NULL,
  `company` varchar(75) NOT NULL,
  `site_dir` varchar(50) DEFAULT NULL,
  `site_email` varchar(100) NOT NULL,
  `address` varchar(150) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `zip` varchar(20) DEFAULT NULL,
  `country` varchar(70) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `fax` varchar(20) DEFAULT NULL,
  `logo` varchar(60) DEFAULT NULL,
  `plogo` varchar(60) DEFAULT NULL,
  `short_date` varchar(20) NOT NULL,
  `long_date` varchar(50) NOT NULL,
  `time_format` varchar(10) DEFAULT NULL,
  `calendar_date` varchar(30) NOT NULL DEFAULT 'dd-mm-yyyy',
  `dtz` varchar(200) NOT NULL,
  `lang` varchar(2) NOT NULL DEFAULT 'en',
  `weekstart` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `locale` varchar(100) DEFAULT NULL,
  `theme` varchar(30) DEFAULT NULL,
  `offline` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `offline_msg` text,
  `offline_d` varchar(10) DEFAULT '1972-01-01',
  `offline_t` varchar(8) DEFAULT '00:00:00',
  `perpage` tinyint(1) UNSIGNED NOT NULL DEFAULT '10',
  `sperpage` tinyint(1) UNSIGNED NOT NULL DEFAULT '30',
  `featured` tinyint(2) UNSIGNED NOT NULL DEFAULT '0',
  `number_sold` tinyint(1) UNSIGNED NOT NULL DEFAULT '10',
  `show_home` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `home_content` text,
  `show_slider` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `show_news` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `show_popular` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `show_reviews` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `show_brands` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `show_featured` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `listing_view` varchar(4) NOT NULL DEFAULT 'list',
  `autoapprove` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `enable_tax` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `sbackup` varchar(50) DEFAULT NULL,
  `currency` varchar(4) DEFAULT NULL,
  `eucookie` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `odometer` varchar(3) NOT NULL DEFAULT 'km',
  `notify_admin` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `notify_email` varchar(60) DEFAULT NULL,
  `pagesize` varchar(10) NOT NULL DEFAULT 'LETTER',
  `metakeys` text,
  `metadesc` text,
  `minprice` decimal(12, 2) UNSIGNED NOT NULL,
  `maxprice` decimal(12, 2) UNSIGNED NOT NULL,
  `minsprice` decimal(12, 2) UNSIGNED NOT NULL,
  `maxsprice` decimal(12, 2) UNSIGNED NOT NULL,
  `minyear` year(4) DEFAULT NULL,
  `maxyear` year(4) DEFAULT NULL,
  `minkm` int(4) UNSIGNED NOT NULL DEFAULT '0',
  `maxkm` int(4) UNSIGNED NOT NULL DEFAULT '0',
  `vinapi` varchar(100) DEFAULT NULL,
  `file_size` int(1) UNSIGNED NOT NULL DEFAULT '0',
  `thumb_w` smallint(2) UNSIGNED NOT NULL DEFAULT '400',
  `thumb_h` smallint(2) UNSIGNED NOT NULL DEFAULT '300',
  `inv_info` text,
  `inv_note` text,
  `analytics` varchar(20) DEFAULT NULL,
  `mapapi` varchar(80) DEFAULT NULL,
  `color` blob,
  `makes` blob,
  `trans_list` blob,
  `fuel_list` blob,
  `cond_list` blob,
  `cond_list_alt` tinyblob,
  `year_list` blob,
  `category_list` blob,
  `make_list` blob,
  `model_list` blob,
  `social_media` blob,
  `mailer` varchar(10) NOT NULL DEFAULT 'SMTP',
  `smtp_host` varchar(100) DEFAULT NULL,
  `smtp_user` varchar(50) DEFAULT NULL,
  `smtp_pass` varchar(50) DEFAULT NULL,
  `smtp_port` smallint(3) DEFAULT NULL,
  `sendmail` varchar(60) DEFAULT NULL,
  `is_ssl` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `wojon` varchar(50) DEFAULT NULL,
  `wojov` decimal(4, 2) UNSIGNED NOT NULL DEFAULT '1.00',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `settings`
--
INSERT INTO `settings` (`id`, `company`, `site_dir`, `site_email`, `address`, `city`, `state`, `zip`, `country`, `phone`, `fax`, `logo`, `plogo`, `short_date`, `long_date`, `time_format`, `calendar_date`, `dtz`, `lang`, `weekstart`, `locale`, `theme`, `offline`, `offline_msg`, `offline_d`, `offline_t`, `perpage`, `sperpage`, `featured`, `number_sold`, `show_home`, `home_content`, `show_slider`, `show_news`, `show_popular`, `show_reviews`, `show_brands`, `show_featured`, `listing_view`, `autoapprove`, `enable_tax`, `sbackup`, `currency`, `eucookie`, `odometer`, `notify_admin`, `notify_email`, `pagesize`, `metakeys`, `metadesc`, `minprice`, `maxprice`, `minsprice`, `maxsprice`, `minyear`, `maxyear`, `minkm`, `maxkm`, `vinapi`, `file_size`, `thumb_w`, `thumb_h`, `inv_info`, `inv_note`, `analytics`, `mapapi`, `color`, `makes`, `trans_list`, `fuel_list`, `cond_list`, `cond_list_alt`, `year_list`, `category_list`, `make_list`, `model_list`, `social_media`, `mailer`, `smtp_host`, `smtp_user`, `smtp_pass`, `smtp_port`, `sendmail`, `is_ssl`, `wojon`, `wojov`)
VALUES (1, 'Car Dealer Pro', '', 'webmaster@domain.com', '20 Main St', 'toronto', 'Ontario', 'M2Y 3L5', 'Canada', '+1 416 123-4768', '', 'logo.svg', 'print_logo.png', 'MM-dd-yyyy', 'MMMM dd, yyyy hh:mm a', 'hh:mm a', 'dd-mm-yyyy', 'America/Toronto', 'en', 1, 'en_CA', 'master', 0, '<p>Our website is under construction. We\'ll be here soon with our new awesome site, subscribe to be notified.</p>', '2023-08-08', '10:46', 12, 30, 50, 10, 1, '<div class=\"mb5 mt3\">\r\n  <h2 class=\"center aligned\">Why choose us?</h2>\r\n</div>\r\n<div class=\"row big gutters align center\">\r\n  <div class=\"columns screen-25 phone-100 center aligned\">\r\n    <figure class=\"wojo medium image mb4\"><img src=\"[SITEURL]/uploads/images/achievement.svg\" alt=\"achievement\" data-image=\"89ca64rbq12o\"></figure>\r\n    <h5>Wide range of brands</h5>\r\n    <p> We can help with your financing plan, we can offer some tips and tricks. Drive off with this dream car of yours regardless of your credit history. </p>\r\n  </div>\r\n  <div class=\"columns screen-25 phone-100 center aligned\">\r\n    <figure class=\"wojo medium image mb4\"><img src=\"[SITEURL]/uploads/images/trust.svg\" alt=\"trust\"></figure>\r\n    <h5>Trusted by our clients</h5>\r\n    <p> We can help with your financing plan, we can offer some tips and tricks. Drive off with this dream car of yours regardless of your credit history.</p>\r\n  </div>\r\n  <div class=\"columns screen-25 phone-100 center aligned\">\r\n    <figure class=\"wojo medium image mb4\"><img src=\"[SITEURL]/uploads/images/finance.svg\" alt=\"finance\"></figure>\r\n    <h5>Fast & easy financing</h5>\r\n    <p> We can help with your financing plan, we can offer some tips and tricks. Drive off with this dream car of yours regardless of your credit history. </p>\r\n  </div>\r\n</div>', 1, 1, 1, 1, 1, 1, 'list', 0, 0, '13-Apr-2020_12-28-19.sql', 'CAD', 0, 'km', 1, 'webmaster@domain.com', 'LETTER', 'Site wide Meta Keywords', 'Site wide Meta Description', '13500.00', '90000.00', '0.00', '85000.00', 2012, 2021, 1000, 152000, '', 6291456, 400, 300, '<p>VAT : 1334567890-1478</p>', '<p>TERMS & CONDITIONS<br>1. Interest may be levied on overdue accounts. <br>2. Goods sold are not returnable or refundable</p>', '0', '', 0x5b7b22636f6c6f725f65223a224265696765222c22746f74616c223a337d2c7b22636f6c6f725f65223a22426c61636b222c22746f74616c223a387d2c7b22636f6c6f725f65223a2247726179222c22746f74616c223a327d2c7b22636f6c6f725f65223a2253696c766572222c22746f74616c223a317d2c7b22636f6c6f725f65223a225768697465222c22746f74616c223a317d5d, 0x5b7b226d616b655f6e616d65223a2241756469222c22746f74616c223a337d2c7b226d616b655f6e616d65223a2242656e746c6579222c22746f74616c223a317d2c7b226d616b655f6e616d65223a22424d57222c22746f74616c223a337d2c7b226d616b655f6e616d65223a22436164696c6c6163222c22746f74616c223a327d2c7b226d616b655f6e616d65223a2243686576726f6c6574222c22746f74616c223a317d2c7b226d616b655f6e616d65223a2246657272617269222c22746f74616c223a317d2c7b226d616b655f6e616d65223a22466f7264222c22746f74616c223a317d2c7b226d616b655f6e616d65223a224d657263656465732d42656e7a222c22746f74616c223a327d2c7b226d616b655f6e616d65223a22506f7273636865222c22746f74616c223a317d5d, 0x5b7b226964223a312c226e616d65223a224175746f6d61746963227d2c7b226964223a322c226e616d65223a224d616e75616c227d2c7b226964223a332c226e616d65223a2254697074726f6e6963227d5d, 0x5b7b226964223a312c226e616d65223a2242696f64696573656c227d2c7b226964223a322c226e616d65223a22434e47227d2c7b226964223a332c226e616d65223a2244696573656c227d2c7b226964223a342c226e616d65223a22456c656374726963227d2c7b226964223a352c226e616d65223a22457468616e6f6c2d464656227d2c7b226964223a362c226e616d65223a224761736f6c696e65227d2c7b226964223a372c226e616d65223a224879627269642d456c656374726963227d2c7b226964223a382c226e616d65223a22537465616d227d5d, 0x5b7b22636f6e646974696f6e5f6e616d65223a224e6577222c22746f74616c223a337d2c7b22636f6e646974696f6e5f6e616d65223a2255736564222c22746f74616c223a31327d5d, 0x5b7b226964223a312c226e616d65223a224e6577227d2c7b226964223a322c226e616d65223a2255736564227d5d, 0x5b7b2279656172223a2232303132222c22746f74616c223a317d2c7b2279656172223a2232303135222c22746f74616c223a317d2c7b2279656172223a2232303136222c22746f74616c223a317d2c7b2279656172223a2232303138222c22746f74616c223a347d2c7b2279656172223a2232303139222c22746f74616c223a337d2c7b2279656172223a2232303230222c22746f74616c223a337d2c7b2279656172223a2232303231222c22746f74616c223a327d5d, 0x5b7b2263617465676f72795f6e616d65223a22436f757065222c22746f74616c223a327d2c7b2263617465676f72795f6e616d65223a224c757875727920436172222c22746f74616c223a317d2c7b2263617465676f72795f6e616d65223a22536564616e222c22746f74616c223a367d2c7b2263617465676f72795f6e616d65223a2253706f7274205574696c6974792056656869636c65222c22746f74616c223a337d2c7b2263617465676f72795f6e616d65223a2253706f72747320436172222c22746f74616c223a317d2c7b2263617465676f72795f6e616d65223a225761676f6e222c22746f74616c223a327d5d, 0x5b7b226964223a31302c226e616d65223a2241756469227d2c7b226964223a31312c226e616d65223a22424d57227d2c7b226964223a31322c226e616d65223a2242656e746c6579227d2c7b226964223a31382c226e616d65223a22436164696c6c6163227d2c7b226964223a32322c226e616d65223a2243686576726f6c6574227d2c7b226964223a34312c226e616d65223a2246657272617269227d2c7b226964223a34342c226e616d65223a22466f7264227d2c7b226964223a38332c226e616d65223a224d617a6461227d2c7b226964223a38362c226e616d65223a224d657263656465732d42656e7a227d2c7b226964223a3130362c226e616d65223a22506f7273636865227d2c7b226964223a3133392c226e616d65223a22566f6c766f227d5d, 0x5b7b226964223a3337332c226e616d65223a2241342055532056657273696f6e227d2c7b226964223a3339302c226e616d65223a2241372053706f72746261636b227d2c7b226964223a3339312c226e616d65223a224138227d2c7b226964223a3539392c226e616d65223a22362d53657269657320436f6e7665727469626c65227d2c7b226964223a3631332c226e616d65223a22372d53657269657320554b2056657273696f6e227d2c7b226964223a3734312c226e616d65223a223820536572696573227d2c7b226964223a3739362c226e616d65223a224d756c73616e6e65227d2c7b226964223a313231332c226e616d65223a22457363616c616465227d2c7b226964223a313234352c226e616d65223a22585453227d2c7b226964223a313239352c226e616d65223a2243616d61726f227d2c7b226964223a313837302c226e616d65223a2234353820537069646572227d2c7b226964223a323237302c226e616d65223a224d757374616e6720466173746261636b20776974682043616d6d657220456e67696e65227d2c7b226964223a333439342c226e616d65223a22332053227d2c7b226964223a333738342c226e616d65223a22474c4b2d436c617373227d2c7b226964223a333831322c226e616d65223a22532d436c617373227d2c7b226964223a343533392c226e616d65223a22436179656e6e65227d2c7b226964223a353630372c226e616d65223a22533830227d5d, 0x7b2266616365626f6f6b223a2266616365626f6f6b5f70616765222c2274776974746572223a22747769747465725f70616765227d, 'SMTP', '', '', '', 587, '/usr/sbin/sendmail -t -i', 0, '1.50', '3.00');

--
-- Table structure for table `slider`
--
DROP TABLE IF EXISTS `slider`;
CREATE TABLE IF NOT EXISTS `slider` (
  `id` int(4) UNSIGNED NOT NULL AUTO_INCREMENT,
  `thumb` varchar(60) DEFAULT NULL,
  `caption` varchar(100) DEFAULT NULL,
  `body` text,
  `url` varchar(150) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `sorting` int(4) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `stats`
--
DROP TABLE IF EXISTS `stats`;
CREATE TABLE IF NOT EXISTS `stats` (
  `id` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `visits` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `listing_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `created` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_listing_id` (`listing_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `transmissions`
--
DROP TABLE IF EXISTS `transmissions`;
CREATE TABLE IF NOT EXISTS `transmissions` (
  `id` int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `transmissions`
--
INSERT INTO `transmissions` (`id`, `name`)
VALUES (1, 'Automatic'),
       (2, 'Manual'),
       (3, 'Tiptronic');

--
-- Table structure for table `trash`
--
DROP TABLE IF EXISTS `trash`;
CREATE TABLE IF NOT EXISTS `trash` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type` varchar(15) DEFAULT NULL,
  `dataset` blob,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Indexes for table `listings`
--
ALTER TABLE `listings`
  ADD FULLTEXT KEY `idx_body` (`body`);
COMMIT;
